/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Stack;
import java.util.stream.Stream;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArithmeticSequence;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyRangeError;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArraySpecialized;
import org.jruby.specialized.RubyArrayTwoObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.Inspector;
import org.jruby.util.Pack;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Array"}, include={"Enumerable"}, overrides={RubyArrayOneObject.class, RubyArrayTwoObject.class, StringArraySet.class})
public class RubyArray<T extends IRubyObject>
extends RubyObject
implements List,
RandomAccess {
    public static final int DEFAULT_INSPECT_STR_SIZE = 10;
    private static final boolean USE_PACKED_ARRAYS = (Boolean)Options.PACKED_ARRAYS.load();
    public static final int ARRAY_DEFAULT_SIZE = 16;
    private static final int SMALL_ARRAY_LEN = 16;
    private static final int TMPLOCK_ARR_F = 512;
    private static final int TMPLOCK_OR_FROZEN_ARR_F = 0x200 | FROZEN_F;
    private volatile boolean isShared = false;
    protected IRubyObject[] values;
    protected int begin = 0;
    protected int realLength = 0;
    private static final int SORTED_THRESHOLD = 10;
    private static final JoinRecursive JOIN_RECURSIVE = new JoinRecursive();

    public static RubyClass createArrayClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Array", Object2, RubyArray::newEmptyArray).reifiedClass(RubyArray.class)).kindOf(new RubyModule.JavaClassKindOf(RubyArray.class))).classIndex(ClassIndex.ARRAY)).include(context, Enumerable)).defineMethods(context, RubyArray.class);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.ARRAY;
    }

    protected final void concurrentModification() {
        throw RubyArray.concurrentModification(this.getRuntime().getCurrentContext(), null);
    }

    private static RuntimeException concurrentModification(ThreadContext context, Exception cause2) {
        RaiseException ex = context.runtime.newConcurrencyError("Detected invalid array contents due to unsynchronized modifications with concurrent users");
        return ex;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject create(IRubyObject klass, IRubyObject[] args2, Block block) {
        return RubyArray.create(klass.getRuntime().getCurrentContext(), klass, args2, block);
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject klass, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return ((RubyClass)klass).allocate(context);
            }
            case 1: {
                return new RubyArrayOneObject((RubyClass)klass, args2[0]);
            }
            case 2: {
                return new RubyArrayTwoObject((RubyClass)klass, args2[0], args2[1]);
            }
        }
        RubyArray arr = (RubyArray)((RubyClass)klass).allocate(context);
        arr.values = (IRubyObject[])args2.clone();
        arr.realLength = args2.length;
        return arr;
    }

    @Deprecated(since="10.0.0.0")
    public static final RubyArray newArray(Ruby runtime2, long len) {
        ThreadContext context = runtime2.getCurrentContext();
        return Create.allocArray(context, RubyArray.checkLength(context, len));
    }

    @Deprecated(since="10.0.0.0")
    public static final RubyArray<?> newArrayLight(Ruby runtime2, long len) {
        return RubyArray.newArrayLight(runtime2, RubyArray.checkLength(runtime2.getCurrentContext(), len));
    }

    public static final RubyArray<?> newArray(Ruby runtime2, int len) {
        return RubyArray.newArray(runtime2.getCurrentContext(), len);
    }

    public static final RubyArray<?> newArray(ThreadContext context, int len) {
        if (len == 0) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        IRubyObject[] values2 = IRubyObject.array(Helpers.validateBufferLength(context, (long)len));
        return new RubyArray(context.runtime, values2, 0, 0);
    }

    public static final RubyArray<?> newArrayLight(Ruby runtime2, int len) {
        if (len == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] values2 = IRubyObject.array(Helpers.validateBufferLength(runtime2, (long)len));
        return new RubyArray(runtime2, runtime2.getArray(), values2, 0, 0, false);
    }

    @Deprecated(since="10.0.0.0")
    public static final RubyArray<?> newArray(Ruby runtime2) {
        return RubyArray.newArray(runtime2.getCurrentContext());
    }

    public static final RubyArray<?> newArray(ThreadContext context) {
        return RubyArray.newArray(context, 16);
    }

    public static final RubyArray<?> newArrayLight(Ruby runtime2) {
        return RubyArray.newArrayLight(runtime2, 16);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject obj) {
        return USE_PACKED_ARRAYS ? new RubyArrayOneObject(runtime2, obj) : new RubyArray(runtime2, Helpers.arrayOf(obj));
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject obj) {
        return USE_PACKED_ARRAYS ? new RubyArrayOneObject(runtime2, obj) : new RubyArray(runtime2, Helpers.arrayOf(obj));
    }

    public static RubyArray<?> newArrayLight(RubyClass arrayClass, IRubyObject obj) {
        return USE_PACKED_ARRAYS ? new RubyArrayOneObject(arrayClass, obj) : new RubyArray(arrayClass, Helpers.arrayOf(obj), false);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return USE_PACKED_ARRAYS ? new RubyArrayTwoObject(runtime2, car, cdr) : new RubyArray(runtime2, Helpers.arrayOf(car, cdr));
    }

    public static RubyArray<?> newArrayLight(RubyClass arrayClass, IRubyObject car, IRubyObject cdr) {
        return USE_PACKED_ARRAYS ? new RubyArrayTwoObject(arrayClass, car, cdr) : new RubyArray(arrayClass, Helpers.arrayOf(car, cdr), false);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject ... objs) {
        return new RubyArray(runtime2, objs, false);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return USE_PACKED_ARRAYS ? new RubyArrayTwoObject(runtime2, car, cdr) : new RubyArray(runtime2, Helpers.arrayOf(car, cdr));
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject first2, IRubyObject second2, IRubyObject third) {
        return new RubyArray(runtime2, Helpers.arrayOf(first2, second2, third));
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject first2, IRubyObject second2, IRubyObject third, IRubyObject fourth) {
        return new RubyArray(runtime2, Helpers.arrayOf(first2, second2, third, fourth));
    }

    public static RubyArray<?> newEmptyArray(Ruby runtime2) {
        return new RubyArray(runtime2, NULL_ARRAY);
    }

    public static RubyArray<?> newEmptyArray(Ruby runtime2, RubyClass klass) {
        return new RubyArray(runtime2, klass, NULL_ARRAY);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject[] args2) {
        int size2 = args2.length;
        if (size2 == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.isPackedArray(size2) ? RubyArray.packedArray(runtime2, args2) : new RubyArray(runtime2, (IRubyObject[])args2.clone());
    }

    public static RubyArray<?> newArray(Ruby runtime2, Collection<? extends IRubyObject> collection) {
        if (collection.isEmpty()) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] arr = collection.toArray(IRubyObject.NULL_ARRAY);
        return RubyArray.isPackedArray(collection) ? RubyArray.packedArray(runtime2, arr) : new RubyArray(runtime2, arr);
    }

    public static RubyArray<?> newArray(Ruby runtime2, List<? extends IRubyObject> list2) {
        if (list2.isEmpty()) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.isPackedArray(list2) ? RubyArray.packedArray(runtime2, list2) : new RubyArray(runtime2, list2.toArray(IRubyObject.NULL_ARRAY));
    }

    public static RubyArray<?> newSharedArray(RubyClass arrayClass, IRubyObject[] shared) {
        RubyArray sharedArray = new RubyArray(arrayClass, shared, true);
        sharedArray.isShared = true;
        return sharedArray;
    }

    private static RubyArray<?> packedArray(Ruby runtime2, IRubyObject[] args2) {
        return args2.length == 1 ? new RubyArrayOneObject(runtime2, args2[0]) : new RubyArrayTwoObject(runtime2, args2[0], args2[1]);
    }

    private static RubyArray<?> packedArray(Ruby runtime2, List<? extends IRubyObject> args2) {
        return args2.size() == 1 ? new RubyArrayOneObject(runtime2, args2.get(0)) : new RubyArrayTwoObject(runtime2, args2.get(0), args2.get(1));
    }

    private static boolean isPackedArray(int size2) {
        return USE_PACKED_ARRAYS && size2 <= 2;
    }

    private static boolean isPackedArray(Collection<? extends IRubyObject> collection) {
        return USE_PACKED_ARRAYS && collection.size() <= 2;
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject ... args2) {
        return RubyArray.newArrayMayCopy(runtime2, args2, 0, args2.length);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject[] args2, int start2) {
        return RubyArray.newArrayMayCopy(runtime2, args2, start2, args2.length - start2);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject[] args2, int start2, int length2) {
        if (length2 == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        if (USE_PACKED_ARRAYS) {
            if (length2 == 1) {
                return new RubyArrayOneObject(runtime2, args2[start2]);
            }
            if (length2 == 2) {
                return new RubyArrayTwoObject(runtime2, args2[start2], args2[start2 + 1]);
            }
        }
        return RubyArray.newArrayNoCopy(runtime2, args2, start2, length2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject ... args2) {
        return new RubyArray(runtime2, args2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2) {
        assert (begin2 >= 0) : "begin must be >= 0";
        assert (begin2 <= args2.length) : "begin must be <= length";
        return new RubyArray(runtime2, args2, begin2, args2.length - begin2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2, int length2) {
        assert (begin2 >= 0) : "begin must be >= 0";
        assert (length2 >= 0) : "length must be >= 0";
        return new RubyArray(runtime2, args2, begin2, length2);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime2, IRubyObject[] args2) {
        return new RubyArray(runtime2, args2, false);
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
        this.values = vals;
        this.realLength = vals.length;
    }

    public RubyArray(Ruby runtime2, IRubyObject[] vals, int begin2, int length2) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = length2;
    }

    private RubyArray(Ruby runtime2, RubyClass metaClass, IRubyObject[] vals, int begin2, int length2, boolean objectSpace) {
        super(runtime2, metaClass, objectSpace);
        this.values = vals;
        this.begin = begin2;
        this.realLength = length2;
    }

    public RubyArray(Ruby runtime2, int length2) {
        super(runtime2, runtime2.getArray());
        this.values = IRubyObject.array(Helpers.validateBufferLength(runtime2, (long)length2));
    }

    private RubyArray(Ruby runtime2, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
    }

    protected RubyArray(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, int length2) {
        super(runtime2, klass);
        this.values = IRubyObject.array(Helpers.validateBufferLength(runtime2, (long)length2));
    }

    private RubyArray(Ruby runtime2, RubyClass klass, IRubyObject[] vals, boolean objectspace) {
        super(runtime2, klass, objectspace);
        this.values = vals;
        this.realLength = vals.length;
    }

    protected RubyArray(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace);
    }

    public RubyArray(Ruby runtime2, RubyClass klass, IRubyObject[] vals) {
        super(runtime2, klass);
        this.values = vals;
        this.realLength = vals.length;
    }

    public RubyArray(RubyClass klass, IRubyObject[] vals, boolean shared) {
        super(klass);
        this.values = vals;
        this.realLength = vals.length;
        this.isShared = shared;
    }

    protected void unpack(ThreadContext context) {
    }

    private void alloc(ThreadContext context, int length2) {
        IRubyObject[] newValues = IRubyObject.array(Helpers.validateBufferLength(context, (long)length2));
        Helpers.fillNil(context, newValues);
        this.values = newValues;
        this.begin = 0;
    }

    private void realloc(ThreadContext context, int newLength, int valuesLength) {
        this.unpack(context);
        IRubyObject[] reallocated = IRubyObject.array(Helpers.validateBufferLength(context, (long)newLength));
        if (newLength > valuesLength) {
            Helpers.fillNil(context, reallocated, valuesLength, newLength);
            RubyArray.safeArrayCopy(context, this.values, this.begin, reallocated, 0, valuesLength);
        } else {
            RubyArray.safeArrayCopy(context, this.values, this.begin, reallocated, 0, newLength);
        }
        this.begin = 0;
        this.values = reallocated;
    }

    @Deprecated(since="10.0.0.0")
    protected static final void checkLength(Ruby runtime2, long length2) {
        RubyArray.checkLength(runtime2.getCurrentContext(), length2);
    }

    public static final int checkLength(ThreadContext context, long length2) {
        if (length2 < 0L) {
            throw Error.argumentError(context, "negative array size (or size too big)");
        }
        if (length2 >= Integer.MAX_VALUE) {
            throw Error.argumentError(context, "array size too big");
        }
        return (int)length2;
    }

    @Deprecated(since="9.4-")
    public final List<IRubyObject> getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject[] toJavaArray() {
        return this.toJavaArray(this.getCurrentContext());
    }

    public IRubyObject[] toJavaArray(ThreadContext context) {
        IRubyObject[] copy2 = IRubyObject.array(this.realLength);
        this.copyInto(context, copy2, 0);
        return copy2;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        this.unpack(this.getRuntime().getCurrentContext());
        return !this.isShared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        this.unpack(this.getRuntime().getCurrentContext());
        return !this.isShared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    public boolean isSharedJavaArray(RubyArray other) {
        return this.values == other.values && this.begin == other.begin && this.realLength == other.realLength;
    }

    protected RubyArray<?> makeShared() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.unpack(context);
        return this.makeShared(context, this.begin, this.realLength, Access.arrayClass(context));
    }

    private RubyArray makeShared(ThreadContext context, int beg, int len, RubyClass klass) {
        return this.makeShared(context, beg, len, new RubyArray<T>(context.runtime, klass));
    }

    private final RubyArray makeShared(ThreadContext context, int beg, int len, RubyArray sharedArray) {
        this.unpack(context);
        this.isShared = true;
        sharedArray.values = this.values;
        sharedArray.isShared = true;
        sharedArray.begin = beg;
        sharedArray.realLength = len;
        return sharedArray;
    }

    private RubyArray makeSharedFirst(ThreadContext context, IRubyObject num, boolean last2) {
        int n = Convert.toInt(context, num);
        if (n < 0) {
            throw Error.argumentError(context, "negative array size");
        }
        if (n > this.realLength) {
            n = this.realLength;
        }
        return this.makeShared(context, last2 ? this.begin + this.realLength - n : this.begin, n, Access.arrayClass(context));
    }

    @Deprecated(since="10.0.0.0")
    protected final void modifyCheck() {
        this.modifyCheck(this.getCurrentContext());
    }

    protected final void modifyCheck(ThreadContext context) {
        if ((this.flags & TMPLOCK_OR_FROZEN_ARR_F) != 0) {
            if ((this.flags & FROZEN_F) != 0) {
                throw context.runtime.newFrozenError(this);
            }
            if ((this.flags & 0x200) != 0) {
                throw Error.typeError(context, "can't modify array during iteration");
            }
        }
    }

    @Deprecated(since="10.0.0.0")
    protected void modify() {
        this.modify(this.getCurrentContext());
    }

    protected void modify(ThreadContext context) {
        this.modifyCheck(context);
        if (this.isShared) {
            IRubyObject[] vals = IRubyObject.array(this.realLength);
            RubyArray.safeArrayCopy(context, this.values, this.begin, vals, 0, this.realLength);
            this.begin = 0;
            this.values = vals;
            this.isShared = false;
        }
    }

    @Deprecated(since="9.4-")
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize(context, block);
            }
            case 1: {
                return this.initializeCommon(context, args2[0], null, block);
            }
            case 2: {
                return this.initializeCommon(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 2);
        return null;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.modifyCheck(context);
        this.unpack(context);
        this.realLength = 0;
        if (block.isGiven()) {
            Warn.warning(context, "given block not used");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, Block block) {
        return this.initializeCommon(context, arg0, null, block);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.initializeCommon(context, arg0, arg1, block);
    }

    protected IRubyObject initializeCommon(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject val;
        this.unpack(context);
        if (arg1 == null && !(arg0 instanceof RubyFixnum) && !(val = arg0.checkArrayType()).isNil()) {
            this.replace(val);
            return this;
        }
        long len = Convert.toLong(context, arg0);
        if (len < 0L) {
            throw Error.argumentError(context, "negative array size");
        }
        int ilen = Helpers.validateBufferLength(context, len);
        this.modify(context);
        if (ilen > this.values.length - this.begin) {
            this.values = IRubyObject.array(ilen);
            this.begin = 0;
        }
        if (block.isGiven()) {
            if (arg1 != null) {
                Warn.warn(context, "block supersedes default value argument");
            }
            if (block.getSignature() == Signature.NO_ARGUMENTS) {
                IRubyObject nil = context.nil;
                for (int i2 = 0; i2 < ilen; ++i2) {
                    this.storeInternal(context, i2, block.yield(context, nil));
                    this.realLength = i2 + 1;
                }
            } else {
                for (int i3 = 0; i3 < ilen; ++i3) {
                    this.storeInternal(context, i3, block.yield(context, Convert.asFixnum(context, i3)));
                    this.realLength = i3 + 1;
                }
            }
        } else {
            try {
                if (arg1 == null) {
                    Arrays.fill(this.values, this.begin, this.begin + ilen, context.nil);
                } else {
                    Arrays.fill(this.values, this.begin, this.begin + ilen, arg1);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw RubyArray.concurrentModification(context, ex);
            }
            this.realLength = ilen;
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject orig) {
        return this.replace(orig);
    }

    @Override
    public IRubyObject dup() {
        CachingCallSite initCopy = RubyArray.sites((ThreadContext)this.getRuntime().getCurrentContext()).initialize_copy;
        if (this.metaClass.getClassIndex() != ClassIndex.ARRAY || !initCopy.retrieveCache((IRubyObject)this).method.isBuiltin()) {
            return super.dup();
        }
        Ruby runtime2 = this.metaClass.runtime;
        RubyArray dup2 = this.dupImpl(runtime2, runtime2.getArray());
        return dup2;
    }

    protected RubyArray dupImpl(Ruby runtime2, RubyClass metaClass) {
        RubyArray<T> dup2 = new RubyArray<T>(runtime2, metaClass, this.values, this.begin, this.realLength, true);
        this.isShared = true;
        dup2.isShared = true;
        return dup2;
    }

    public RubyArray aryDup() {
        Ruby runtime2 = this.metaClass.runtime;
        return this.dupImpl(runtime2, runtime2.getArray());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject replace(IRubyObject orig) {
        return this.replace(this.getCurrentContext(), orig);
    }

    @JRubyMethod(name={"replace"})
    public IRubyObject replace(ThreadContext context, IRubyObject orig) {
        this.unpack(context);
        this.modifyCheck(context);
        if (this == orig) {
            return this;
        }
        RubyArray origArr = orig.convertToArray();
        origArr.unpack(context);
        origArr.isShared = true;
        this.isShared = true;
        this.values = origArr.values;
        this.realLength = origArr.realLength;
        this.begin = origArr.begin;
        return this;
    }

    @Override
    public RubyString to_s(ThreadContext context) {
        return this.inspect(context);
    }

    public boolean includes(ThreadContext context, IRubyObject item) {
        int end2 = this.realLength;
        for (int i2 = 0; i2 < end2; ++i2) {
            T value2 = this.eltOk(i2);
            if (!RubyArray.equalInternal(context, value2, item)) continue;
            return true;
        }
        return false;
    }

    public boolean includesByEql(ThreadContext context, IRubyObject item) {
        int end2 = this.realLength;
        for (int i2 = 0; i2 < end2; ++i2) {
            T value2 = this.eltOk(i2);
            if (!RubyArray.eqlInternal(context, item, value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashImpl(context));
    }

    private long hashImpl(ThreadContext context) {
        long h = Helpers.hashStart(context.runtime, this.realLength);
        h = Helpers.murmurCombine(h, System.identityHashCode(RubyArray.class));
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T value2 = this.eltOk(i2);
            RubyFixnum n = Helpers.safeHash(context, value2);
            h = Helpers.murmurCombine(h, n.value);
        }
        return Helpers.hashEnd(h);
    }

    public IRubyObject store(long index2, IRubyObject value2) {
        return this.store(this.metaClass.runtime.getCurrentContext(), index2, value2);
    }

    @JRubyAPI
    public IRubyObject store(ThreadContext context, long index2, IRubyObject value2) {
        if (index2 < 0L && (index2 += (long)this.realLength) < 0L) {
            throw Error.indexError(context, "index " + (index2 - (long)this.realLength) + " out of array");
        }
        if (index2 >= Integer.MAX_VALUE) {
            throw Error.indexError(context, "index " + index2 + " too big");
        }
        this.modify(context);
        this.storeInternal(context, (int)index2, value2);
        return value2;
    }

    protected void storeInternal(ThreadContext context, int index2, IRubyObject value2) {
        assert (index2 >= 0);
        if (index2 >= this.realLength) {
            this.resizeAndFillBackingArray(context, index2);
            this.realLength = index2 + 1;
        }
        RubyArray.safeArraySet(context, this.values, this.begin + index2, value2);
    }

    private void resizeAndFillBackingArray(ThreadContext context, int index2) {
        int valuesLength = this.values.length - this.begin;
        if (index2 >= valuesLength) {
            if (index2 - this.realLength >= 1) {
                Helpers.fillNil(context, this.values, this.begin + this.realLength, this.values.length);
            }
            this.storeRealloc(context, index2, valuesLength);
        } else if (index2 - this.realLength >= 1) {
            int baseIndex = this.begin + this.realLength;
            Helpers.fillNil(context, this.values, baseIndex, baseIndex + (index2 - this.realLength));
        }
    }

    private void storeRealloc(ThreadContext context, int index2, int valuesLength) {
        long newLength = valuesLength >> 1;
        if (newLength < 16L) {
            newLength = 16L;
        }
        if ((newLength += (long)index2) >= Integer.MAX_VALUE) {
            throw Error.indexError(context, "index " + index2 + " too big");
        }
        this.realloc(context, (int)newLength, valuesLength);
    }

    private final IRubyObject elt(long offset2) {
        if (offset2 < 0L || offset2 >= (long)this.realLength) {
            return this.metaClass.runtime.getNil();
        }
        return this.eltOk(offset2);
    }

    public T eltOk(long offset2) {
        try {
            return this.eltInternal((int)offset2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(this.getRuntime().getCurrentContext(), ex);
        }
    }

    public T eltSetOk(long offset2, T value2) {
        return this.eltSetOk((int)offset2, value2);
    }

    public T eltSetOk(int offset2, T value2) {
        try {
            return this.eltInternalSet(offset2, value2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(this.getRuntime().getCurrentContext(), ex);
        }
    }

    public final IRubyObject entry(long offset2) {
        return offset2 < 0L ? this.elt(offset2 + (long)this.realLength) : this.elt(offset2);
    }

    public final IRubyObject entry(int offset2) {
        return offset2 < 0 ? this.elt(offset2 + this.realLength) : this.elt(offset2);
    }

    public T eltInternal(int offset2) {
        return (T)this.values[this.begin + offset2];
    }

    public T eltInternalSet(int offset2, T item) {
        this.values[this.begin + offset2] = item;
        return item;
    }

    @Deprecated(since="9.4-")
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(rest=true)
    public IRubyObject fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        int length2 = args2.length;
        if (length2 == 0) {
            return Create.newEmptyArray(context);
        }
        int arraySize = this.size();
        RubyArray<?> result2 = Create.allocArray(context, length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            int index2 = Convert.toInt(context, args2[i2]);
            if (index2 >= arraySize) {
                if (!block.isGiven()) {
                    throw Error.indexError(context, "index " + index2 + " outside of array bounds: 0...0");
                }
                result2.append(context, block.yield(context, Convert.asFixnum(context, index2)));
                continue;
            }
            result2.append(context, (IRubyObject)this.eltOk(index2));
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, Block block) {
        long index2 = Convert.toLong(context, arg0);
        if (index2 < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            throw Error.indexError(context, "index " + index2 + " out of array");
        }
        return this.eltOk((int)index2);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        long index2;
        if (block.isGiven()) {
            Warn.warn(context, "block supersedes default value argument");
        }
        if ((index2 = Convert.toLong(context, arg0)) < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            return arg1;
        }
        return this.eltOk((int)index2);
    }

    public static RubyArray aryToAry(ThreadContext context, IRubyObject obj) {
        IRubyObject tmp = TypeConverter.checkArrayType(context, obj);
        return tmp != context.nil ? (RubyArray<?>)tmp : RubyArray.newArray(context.runtime, obj);
    }

    @Deprecated(since="9.2.5.0")
    public static RubyArray aryToAry(IRubyObject obj) {
        return RubyArray.aryToAry(obj.getRuntime().getCurrentContext(), obj);
    }

    private void splice(ThreadContext context, int beg, int len, IRubyObject rpl) {
        int rlen;
        RubyArray<?> rplArr;
        if (len < 0) {
            throw Error.indexError(context, "negative length (" + len + ")");
        }
        if (beg < 0 && (beg += this.realLength) < 0) {
            throw Error.indexError(context, "index " + (beg - this.realLength) + " out of array");
        }
        if (rpl == null) {
            rplArr = null;
            rlen = 0;
        } else if (rpl.isNil()) {
            rplArr = RubyArray.newArray(context.runtime, rpl);
            rlen = 1;
        } else {
            rplArr = RubyArray.aryToAry(context, rpl);
            rlen = rplArr.realLength;
        }
        this.splice(context, beg, len, rplArr, rlen);
    }

    private void splice(ThreadContext context, int beg, int len, RubyArray rplArr, int rlen) {
        if (len < 0) {
            throw Error.indexError(context, "negative length (" + len + ")");
        }
        if (beg < 0 && (beg += this.realLength) < 0) {
            Error.indexError(context, "index " + (beg - this.realLength) + " out of array");
        }
        this.unpack(context);
        this.modify(context);
        int valuesLength = this.values.length - this.begin;
        if (beg >= this.realLength) {
            len = beg + rlen;
            if (len >= valuesLength) {
                this.spliceRealloc(context, len, valuesLength);
            }
            try {
                Helpers.fillNil(context, this.values, this.begin + this.realLength, this.begin + beg);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw RubyArray.concurrentModification(context, e);
            }
            this.realLength = len;
        } else {
            int alen;
            if (beg + len > this.realLength) {
                len = this.realLength - beg;
            }
            if ((alen = this.realLength + rlen - len) >= valuesLength) {
                this.spliceRealloc(context, alen, valuesLength);
            }
            if (len != rlen) {
                RubyArray.safeArrayCopy(context, this.values, this.begin + (beg + len), this.values, this.begin + beg + rlen, this.realLength - (beg + len));
                this.realLength = alen;
            }
        }
        if (rlen > 0) {
            rplArr.copyInto(context, this.values, this.begin + beg, rlen);
        }
    }

    private final void spliceOne(ThreadContext context, long beg, IRubyObject rpl) {
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw Error.indexError(context, "index " + (beg - (long)this.realLength) + " out of array");
        }
        this.unpack(context);
        this.modify(context);
        int valuesLength = this.values.length - this.begin;
        if (beg >= (long)this.realLength) {
            int len = (int)beg + 1;
            if (len >= valuesLength) {
                this.spliceRealloc(context, len, valuesLength);
            }
            Helpers.fillNil(context, this.values, this.begin + this.realLength, this.begin + (int)beg);
            this.realLength = len;
        } else {
            int len = beg > (long)this.realLength ? this.realLength - (int)beg : 0;
            int alen = this.realLength + 1 - len;
            if (alen >= valuesLength) {
                this.spliceRealloc(context, alen, valuesLength);
            }
            if (len == 0) {
                RubyArray.safeArrayCopy(context, this.values, this.begin + (int)beg, this.values, this.begin + (int)beg + 1, this.realLength - (int)beg);
                this.realLength = alen;
            }
        }
        RubyArray.safeArraySet(context, this.values, this.begin + (int)beg, rpl);
    }

    private void spliceRealloc(ThreadContext context, int length2, int valuesLength) {
        int tryLength = Helpers.calculateBufferLength(context.runtime, valuesLength);
        int len = length2 > tryLength ? length2 : tryLength;
        IRubyObject[] vals = IRubyObject.array(len);
        System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
        if (len > length2) {
            Helpers.fillNil(context, vals, length2, len);
        }
        this.begin = 0;
        this.values = vals;
    }

    private void unshiftRealloc(ThreadContext context, int valuesLength) {
        int newLength = valuesLength >> 1;
        if (newLength < 16) {
            newLength = 16;
        }
        newLength = Helpers.addBufferLength(context, valuesLength, newLength);
        IRubyObject[] vals = IRubyObject.array(newLength);
        int shiftedBegin = newLength - valuesLength;
        int unshiftedBegin = shiftedBegin - 1;
        RubyArray.safeArrayCopy(context, this.values, this.begin, vals, shiftedBegin, valuesLength);
        Helpers.fillNil(context, vals, 0, unshiftedBegin);
        this.values = vals;
        this.begin = unshiftedBegin;
    }

    public IRubyObject insert() {
        throw Error.argumentError(this.getRuntime().getCurrentContext(), 0, 1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject arg2) {
        return this.insert(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert(ThreadContext context, IRubyObject arg2) {
        this.modifyCheck(context);
        Convert.toLong(context, arg2);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        return this.insert(this.getCurrentContext(), arg1, arg2);
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        this.modifyCheck(context);
        this.insert(context, Convert.toLong(context, arg1), arg2);
        return this;
    }

    private void insert(ThreadContext context, long pos2, IRubyObject val) {
        if (pos2 == -1L) {
            pos2 = this.realLength;
        } else if (pos2 < 0L) {
            long minpos = -this.realLength - 1;
            if (pos2 < minpos) {
                throw Error.indexError(context, "index " + pos2 + " too small for array; minimum: " + minpos);
            }
            ++pos2;
        }
        this.spliceOne(context, pos2, val);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject[] args2) {
        return this.insert(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true, checkArity=false)
    public IRubyObject insert(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.insert();
            }
            case 1: {
                return this.insert(args2[0]);
            }
            case 2: {
                return this.insert(args2[0], args2[1]);
            }
        }
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        this.modifyCheck(context);
        long pos2 = RubyNumeric.num2long(args2[0]);
        if (argc == 1) {
            return this;
        }
        this.unpack(context);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        RubyArray<T> inserted = new RubyArray<T>(context.runtime, false);
        inserted.values = args2;
        inserted.begin = 1;
        inserted.realLength = argc - 1;
        this.splice(context, Convert.checkInt(context, pos2), 0, inserted, inserted.realLength);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray transpose() {
        return this.transpose(this.getCurrentContext());
    }

    @JRubyMethod(name={"transpose"})
    public RubyArray transpose(ThreadContext context) {
        int alen = this.realLength;
        if (alen == 0) {
            return this.aryDup();
        }
        int elen = -1;
        IRubyObject[] result2 = null;
        for (int i2 = 0; i2 < alen; ++i2) {
            int j;
            RubyArray tmp = this.elt(i2).convertToArray();
            if (elen < 0) {
                elen = tmp.realLength;
                result2 = IRubyObject.array(elen);
                for (j = 0; j < elen; ++j) {
                    result2[j] = RubyArray.newBlankArray(context, alen);
                }
            } else if (elen != tmp.realLength) {
                throw Error.indexError(context, "element size differs (" + tmp.realLength + " should be " + elen + ")");
            }
            for (j = 0; j < elen; ++j) {
                ((RubyArray)result2[j]).storeInternal(context, i2, tmp.elt(j));
            }
        }
        return new RubyArray<T>(context.runtime, result2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        int length2 = this.realLength;
        RubyArray<?> result2 = Create.allocArray(context, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyFixnum) {
                RubyFixnum fix2 = (RubyFixnum)arg2;
                result2.append(context, this.entry(fix2.getValue()));
                continue;
            }
            if (arg2 instanceof RubyRange) {
                RubyRange range = (RubyRange)arg2;
                int[] begLen = range.begLenInt(context, length2, 1);
                if (begLen == null) continue;
                int beg = begLen[0];
                int len = begLen[1];
                for (int j = 0; j < len; ++j) {
                    result2.append(context, this.entry(j + beg));
                }
                continue;
            }
            result2.append(context, this.entry(Convert.toLong(context, arg2)));
        }
        return result2;
    }

    public IRubyObject subseq(long beg, long len) {
        return this.subseq(this.getRuntime().getArray(), beg, len, true);
    }

    public IRubyObject subseq_step(ThreadContext context, RubyArithmeticSequence arg0) {
        RubyArray<?> result1;
        long alen;
        long end2;
        long step2 = this.getStep(context, arg0);
        IRubyObject aseqBeg = this.getBegin(context, arg0);
        IRubyObject aseqEnd = this.getEnd(context, arg0);
        boolean aseqExcl = arg0.exclude_end(context).isTrue();
        long len = this.realLength;
        if (step2 < 0L) {
            if (aseqExcl && !aseqEnd.isNil()) {
                aseqEnd = Convert.asFixnum(context, Convert.toLong(context, aseqEnd) + 1L);
                aseqExcl = false;
            }
            IRubyObject tmp = aseqBeg;
            aseqBeg = aseqEnd;
            aseqEnd = tmp;
        }
        if (step2 < -1L || step2 > 1L) {
            int[] ret;
            try {
                ret = RubyRange.newRange(context, aseqBeg, aseqEnd, aseqExcl).begLenInt(context, (int)len, 1);
            }
            catch (RaiseException ex) {
                if (ex.getException() instanceof RubyRangeError) {
                    throw Error.rangeError(context, String.valueOf(arg0.inspect(context)) + " out of range");
                }
                throw ex;
            }
            if (ret != null && ((long)ret[0] > len || (long)ret[1] > len)) {
                throw Error.rangeError(context, String.valueOf(arg0.inspect(context)) + " out of range");
            }
        }
        long beg = aseqBeg.isNil() ? 0L : aseqBeg.convertToFloat().asLong(context);
        long l = end2 = aseqEnd.isNil() ? -1L : aseqEnd.convertToFloat().asLong(context);
        if (aseqEnd.isNil()) {
            aseqExcl = false;
        }
        if (beg < 0L && (beg += len) < 0L) {
            throw Error.rangeError(context, "integer " + beg + " out of range of fixnum");
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!aseqExcl) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        if (beg > (alen = (long)this.realLength)) {
            return context.nil;
        }
        if (beg < 0L || len < 0L) {
            return context.nil;
        }
        if (alen < len || alen < beg + len) {
            len = alen - beg;
        }
        if (len == 0L) {
            return Create.newEmptyArray(context);
        }
        if (step2 == 0L) {
            throw Error.rangeError(context, "slice step cannot be zero");
        }
        if (step2 == 1L) {
            return this.subseq(beg, len);
        }
        long orig_len = len;
        if (step2 > 0L && step2 >= len) {
            return Create.newArray(context, this.eltOk(beg));
        }
        if (step2 < 0L && step2 < -len) {
            step2 = -len;
        }
        long ustep = step2 < 0L ? -step2 : step2;
        len = (len + ustep - 1L) / ustep;
        long j = beg + (step2 > 0L ? 0L : orig_len - 1L);
        RubyArray<?> result2 = result1 = Create.allocArray(context, len);
        for (long i2 = 0L; i2 < len; ++i2) {
            result2.append(context, (IRubyObject)this.eltOk(j));
            j += step2;
        }
        return result2;
    }

    private IRubyObject getBegin(ThreadContext context, RubyArithmeticSequence arg0) {
        return arg0.begin(context);
    }

    private IRubyObject getEnd(ThreadContext context, RubyArithmeticSequence arg0) {
        return arg0.end(context);
    }

    private Long getStep(ThreadContext context, RubyArithmeticSequence arg0) {
        return arg0.step(context).isNil() ? null : Long.valueOf(Convert.toLong(context, arg0.step(context)));
    }

    public IRubyObject subseqLight(long beg, long len) {
        return this.subseq(this.metaClass, beg, len, true);
    }

    public IRubyObject subseq(RubyClass metaClass, long beg, long len, boolean light) {
        Ruby runtime2 = metaClass.runtime;
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return runtime2.getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray<T>(runtime2, metaClass, IRubyObject.NULL_ARRAY, !light);
        }
        return this.makeShared(runtime2.getCurrentContext(), this.begin + (int)beg, (int)len, new RubyArray<T>(runtime2, metaClass, !light));
    }

    @JRubyMethod(name={"length"}, alias={"size"})
    public RubyFixnum length(ThreadContext context) {
        return Convert.asFixnum(context, this.realLength);
    }

    @Deprecated(since="10.0.0.0")
    public RubyFixnum length() {
        return this.length(this.getCurrentContext());
    }

    protected static IRubyObject size(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        return self2.length(context);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> append(IRubyObject item) {
        return this.append(this.getCurrentContext(), item);
    }

    @JRubyMethod(name={"<<"})
    public RubyArray append(ThreadContext context, IRubyObject item) {
        this.unpack(context);
        this.modify(context);
        int valuesLength = this.values.length - this.begin;
        if (this.realLength == valuesLength) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw Error.indexError(context, "index 2147483647 too big");
            }
            long newLength = valuesLength + (valuesLength >> 1);
            if (newLength > Integer.MAX_VALUE) {
                newLength = Integer.MAX_VALUE;
            } else if (newLength < 16L) {
                newLength = 16L;
            }
            this.realloc(context, (int)newLength, valuesLength);
        }
        RubyArray.safeArraySet(context, this.values, this.begin + this.realLength++, item);
        return this;
    }

    @Deprecated(since="9.2.0.0")
    public RubyArray<?> push_m(IRubyObject[] items) {
        return this.push(items);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray push(IRubyObject item) {
        this.append(item);
        return this;
    }

    @JRubyMethod(name={"push"}, alias={"append"})
    public RubyArray push(ThreadContext context, IRubyObject item) {
        this.append(context, item);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> push(IRubyObject[] items) {
        return this.push(this.getCurrentContext(), items);
    }

    @JRubyMethod(name={"push"}, alias={"append"}, rest=true)
    public RubyArray push(ThreadContext context, IRubyObject[] items) {
        if (items.length == 0) {
            this.modifyCheck(context);
        }
        for (IRubyObject item : items) {
            this.append(context, item);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context) {
        this.unpack(context);
        this.modifyCheck(context);
        if (this.realLength == 0) {
            return context.nil;
        }
        if (this.isShared) {
            return RubyArray.safeArrayRef(context, this.values, this.begin + --this.realLength);
        }
        int index2 = this.begin + --this.realLength;
        return RubyArray.safeArrayRefSet(context, this.values, index2, context.nil);
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context, IRubyObject num) {
        this.unpack(context);
        this.modifyCheck(context);
        RubyArray result2 = this.makeSharedFirst(context, num, true);
        this.realLength -= result2.realLength;
        return result2;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.unpack(context);
        this.modifyCheck(context);
        if (this.realLength == 0) {
            return context.nil;
        }
        IRubyObject obj = RubyArray.safeArrayRefCondSet(context, this.values, this.begin, !this.isShared, context.nil);
        ++this.begin;
        --this.realLength;
        return obj;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context, IRubyObject num) {
        this.unpack(context);
        this.modify(context);
        RubyArray result2 = this.makeSharedFirst(context, num, false);
        int n = result2.realLength;
        this.begin += n;
        this.realLength -= n;
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift() {
        return this.unshift(this.getCurrentContext());
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"})
    public IRubyObject unshift(ThreadContext context) {
        this.modifyCheck(context);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift(IRubyObject item) {
        return this.unshift(this.getCurrentContext(), item);
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"})
    public IRubyObject unshift(ThreadContext context, IRubyObject item) {
        this.unpack(context);
        if (this.begin == 0 || this.isShared) {
            this.modify(context);
            int valuesLength = this.values.length - this.begin;
            if (valuesLength == 0) {
                this.alloc(context, 16);
                this.begin = 15;
            } else if (this.realLength == valuesLength) {
                this.unshiftRealloc(context, valuesLength);
            } else {
                RubyArray.safeArrayCopy(context, this.values, this.begin, this.values, this.begin + 1, this.realLength);
            }
        } else {
            this.modifyCheck(context);
            --this.begin;
        }
        ++this.realLength;
        this.values[this.begin] = item;
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift(IRubyObject[] items) {
        return this.unshift(this.getCurrentContext(), items);
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"}, rest=true)
    public IRubyObject unshift(ThreadContext context, IRubyObject[] items) {
        this.unpack(context);
        if (items.length == 0) {
            this.modifyCheck(context);
            return this;
        }
        int len = this.realLength;
        this.store((long)len + (long)items.length - 1L, context.nil);
        try {
            System.arraycopy(this.values, this.begin, this.values, this.begin + items.length, len);
            ArraySupport.copy(items, 0, this.values, this.begin, items.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
        return this;
    }

    @JRubyMethod(name={"include?"})
    public RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return Convert.asBoolean(context, this.includes(context, item));
    }

    @Override
    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isFrozen() || (this.flags & 0x200) != 0);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aref(IRubyObject[] args2) {
        ThreadContext context = this.getCurrentContext();
        return switch (args2.length) {
            case 1 -> this.aref(context, args2[0]);
            case 2 -> this.aref(context, args2[0], args2[1]);
            default -> {
                Arity.raiseArgumentError(context, args2.length, 1, 2);
                yield null;
            }
        };
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject aref(IRubyObject arg0) {
        return this.aref(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(ThreadContext context, IRubyObject arg0) {
        IRubyObject iRubyObject;
        if (arg0 instanceof RubyArithmeticSequence) {
            return this.subseq_step(context, (RubyArithmeticSequence)arg0);
        }
        if (arg0 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg0;
            iRubyObject = this.entry(fixnum.getValue());
        } else {
            iRubyObject = this.arefCommon(context, arg0);
        }
        return iRubyObject;
    }

    private IRubyObject arefCommon(ThreadContext context, IRubyObject arg0) {
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            long[] beglen = range.begLen(context, this.realLength, 0);
            return beglen == null ? context.nil : this.subseq(beglen[0], beglen[1]);
        }
        JavaSites.ArraySites sites = RubyArray.sites(context);
        if (RubyRange.isRangeLike(context, arg0, sites.begin_checked, sites.end_checked, sites.exclude_end_checked)) {
            RubyRange range = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
            long[] beglen = range.begLen(context, this.realLength, 0);
            return beglen == null ? context.nil : this.subseq(beglen[0], beglen[1]);
        }
        return this.entry(Convert.toLong(context, arg0));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aref(IRubyObject arg0, IRubyObject arg1) {
        return this.aref(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long beg = Convert.toLong(context, arg0);
        if (beg < 0L) {
            beg += (long)this.realLength;
        }
        return this.subseq(beg, Convert.toLong(context, arg1));
    }

    @Deprecated(since="9.4-")
    public IRubyObject aset(IRubyObject[] args2) {
        return switch (args2.length) {
            case 2 -> this.aset(args2[0], args2[1]);
            case 3 -> this.aset(args2[0], args2[1], args2[2]);
            default -> throw Error.argumentError(this.getCurrentContext(), "wrong number of arguments (" + args2.length + " for 2)");
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        return this.aset(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        this.modifyCheck(context);
        if (arg0 instanceof RubyFixnum) {
            this.store(((RubyFixnum)arg0).value, arg1);
        } else if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            int beg0 = this.checkLongForInt(context, range.begLen0(context, this.realLength));
            int beg1 = this.checkLongForInt(context, range.begLen1(context, this.realLength, beg0));
            this.splice(context, beg0, beg1, arg1);
        } else {
            this.asetFallback(context, arg0, arg1);
        }
        return arg1;
    }

    private int checkLongForInt(ThreadContext context, long value2) {
        if ((long)((int)value2) != value2) {
            throw Error.indexError(context, String.format("index %d is too big", value2));
        }
        return (int)value2;
    }

    private void asetFallback(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        JavaSites.ArraySites sites = RubyArray.sites(context);
        if (RubyRange.isRangeLike(context, arg0, sites.begin_checked, sites.end_checked, sites.exclude_end_checked)) {
            RubyRange range = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
            int beg = Convert.checkInt(context, range.begLen0(context, this.realLength));
            this.splice(context, beg, Convert.checkInt(context, range.begLen1(context, this.realLength, beg)), arg1);
        } else {
            this.store(Convert.toLong(context, arg0), arg1);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.aset(this.getCurrentContext(), arg0, arg1, arg2);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modifyCheck(context);
        this.splice(context, Convert.toInt(context, arg0), Convert.toInt(context, arg1), arg2);
        return arg2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject at(IRubyObject pos2) {
        return this.at(this.getCurrentContext(), pos2);
    }

    @JRubyMethod(name={"at"})
    public IRubyObject at(ThreadContext context, IRubyObject pos2) {
        return this.entry(Convert.toLong(context, pos2));
    }

    @JRubyMethod(name={"concat"})
    public RubyArray concat(ThreadContext context, IRubyObject obj) {
        this.modifyCheck(context);
        this.concat(context, obj.convertToArray());
        return this;
    }

    private void concat(ThreadContext context, RubyArray<?> obj) {
        this.splice(context, this.realLength, 0, obj, obj.realLength);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray aryAppend(RubyArray y) {
        return this.aryAppend(this.getCurrentContext(), y);
    }

    public RubyArray aryAppend(ThreadContext context, RubyArray<?> y) {
        if (y.realLength > 0) {
            this.splice(context, this.realLength, 0, y, y.realLength);
        }
        return this;
    }

    @JRubyMethod(name={"concat"}, rest=true)
    public RubyArray concat(ThreadContext context, IRubyObject[] objs) {
        this.modifyCheck(context);
        if (objs.length == 0) {
            return this;
        }
        int len = objs.length;
        RubyArray<?> result2 = Create.allocArray(context, len);
        for (IRubyObject obj : objs) {
            result2.concat(context, obj.convertToArray());
        }
        return this.aryAppend(context, result2);
    }

    public RubyArray concat(IRubyObject obj) {
        return this.concat(this.metaClass.runtime.getCurrentContext(), obj);
    }

    protected IRubyObject inspectAry(ThreadContext context) {
        RubyString str = RubyString.newStringLight(context.runtime, 10, (Encoding)USASCIIEncoding.INSTANCE);
        str.cat((byte)91);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            RubyString s2 = RubyArray.inspect(context, RubyArray.safeArrayRef(context, this.values, this.begin + i2));
            if (i2 > 0) {
                ByteList bytes2 = str.getByteList();
                bytes2.append((byte)44).append((byte)32);
            } else {
                EncodingUtils.encAssociateIndex(str, s2.getEncoding());
            }
            str.catWithCodeRange(s2);
        }
        str.cat((byte)93);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"}, alias={"to_s"})
    public RubyString inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.realLength == 0) {
            return Create.newSharedString(context, Inspector.EMPTY_ARRAY_BL);
        }
        if (runtime2.isInspecting(this)) {
            return Create.newSharedString(context, Inspector.RECURSIVE_ARRAY_BL);
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = (RubyString)this.inspectAry(context);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    @Deprecated(since="9.4-")
    public IRubyObject first(IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.first(this.getCurrentContext());
            case 1 -> this.first(this.getCurrentContext(), args2[0]);
            default -> {
                Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 0, 1);
                yield null;
            }
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject first() {
        return this.first(this.getCurrentContext());
    }

    @JRubyMethod(name={"first"})
    @JRubyAPI
    public IRubyObject first(ThreadContext context) {
        return this.realLength == 0 ? context.nil : this.eltOk(0L);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject first(IRubyObject arg0) {
        return this.first(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"first"})
    @JRubyAPI
    public IRubyObject first(ThreadContext context, IRubyObject arg0) {
        long n = Convert.toLong(context, arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else {
            if (n < 0L) {
                throw Error.argumentError(context, "negative array size (or size too big)");
            }
            if (n == 1L) {
                return Create.newArray(context, this.eltOk(0L));
            }
            if (n == 2L) {
                return Create.newArray(context, this.eltOk(0L), this.eltOk(1L));
            }
        }
        this.unpack(context);
        return this.makeShared(context, this.begin, (int)n, Access.arrayClass(context));
    }

    @Deprecated(since="9.4-")
    public IRubyObject last(IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.last(this.getCurrentContext());
            case 1 -> this.last(this.getCurrentContext(), args2[0]);
            default -> {
                Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 0, 1);
                yield null;
            }
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject last() {
        return this.last(this.getCurrentContext());
    }

    @JRubyMethod(name={"last"})
    @JRubyAPI
    public IRubyObject last(ThreadContext context) {
        return this.realLength == 0 ? context.nil : this.eltOk(this.realLength - 1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject last(IRubyObject arg0) {
        return this.last(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(ThreadContext context, IRubyObject arg0) {
        long n = Convert.toLong(context, arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        }
        if (n < 0L) {
            throw Error.argumentError(context, "negative array size (or size too big)");
        }
        if (n == 1L) {
            return Create.newArray(context, this.eltOk(this.realLength - 1));
        }
        if (n == 2L) {
            return Create.newArray(context, this.eltOk(this.realLength - 2), this.eltOk(this.realLength - 1));
        }
        this.unpack(context);
        return this.makeShared(context, this.begin + this.realLength - (int)n, (int)n, Access.arrayClass(context));
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyArray::size);
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            block.yield(context, (IRubyObject)this.eltOk(i2));
        }
        return this;
    }

    public IRubyObject eachSlice(ThreadContext context, int size2, Block block) {
        int realLength;
        boolean specificArity;
        this.unpack(context);
        RubyClass array2 = Access.arrayClass(context);
        int begin2 = this.begin;
        RubyArray window = this.makeShared(context, begin2, size2, array2);
        Signature signature = block.getSignature();
        boolean bl = specificArity = signature.isFixed() && signature.required() != 1;
        for (realLength = this.realLength; realLength >= size2; realLength -= size2) {
            block.yield(context, window);
            if (specificArity) {
                window.begin = begin2 += size2;
                continue;
            }
            window = this.makeShared(context, begin2 += size2, size2, array2);
        }
        if (realLength > 0) {
            window.realLength = realLength;
            block.yield(context, window);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_slice(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = Convert.toInt(context, arg2);
        if (size2 <= 0) {
            throw Error.argumentError(context, "invalid slice size");
        }
        return block.isGiven() ? this.eachSlice(context, size2, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_slice", arg2, arg2);
    }

    public IRubyObject eachIndex(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            block.yield(context, Convert.asFixnum(context, i2));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_index(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachIndex(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_index", RubyArray::size);
    }

    public IRubyObject reverseEach(ThreadContext context, Block block) {
        int len = this.realLength;
        while (len-- > 0) {
            block.yield(context, (IRubyObject)this.eltOk(len));
            if (this.realLength >= len) continue;
            len = this.realLength;
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject reverse_each(ThreadContext context, Block block) {
        return block.isGiven() ? this.reverseEach(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reverse_each", RubyArray::size);
    }

    protected int joinStrings(RubyString sep, int max2, RubyString result2) {
        int i2;
        T t;
        if (max2 > 0 && (t = this.eltOk(0L)) instanceof EncodingCapable) {
            EncodingCapable ec = (EncodingCapable)t;
            result2.setEncoding(ec.getEncoding());
        }
        try {
            T val;
            for (i2 = 0; i2 < max2 && (val = this.eltInternal(i2)) instanceof RubyString; ++i2) {
                if (i2 > 0 && sep != null) {
                    result2.catWithCodeRange(sep);
                }
                result2.append((IRubyObject)val);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(this.getRuntime().getCurrentContext(), e);
        }
        return i2;
    }

    private RubyString joinAny(ThreadContext context, RubyString sep, int i2, RubyString result2, boolean[] first2) {
        assert (i2 >= 0) : "joining elements before beginning of array";
        JavaSites.CheckedSites to_ary_checked = null;
        while (i2 < this.realLength) {
            T val;
            if (i2 > 0 && sep != null) {
                result2.catWithCodeRange(sep);
            }
            if ((val = this.eltOk(i2)) instanceof RubyString) {
                RubyArray.strJoin(result2, (RubyString)val, first2);
            } else if (val instanceof RubyArray) {
                this.recursiveJoin(context, (IRubyObject)val, sep, result2, (RubyArray)val, first2);
            } else {
                IRubyObject tmp = val.checkStringType();
                if (tmp != context.nil) {
                    RubyArray.strJoin(result2, (RubyString)tmp, first2);
                } else {
                    if (to_ary_checked == null) {
                        to_ary_checked = RubyArray.sites((ThreadContext)context).to_ary_checked;
                    }
                    if ((tmp = TypeConverter.convertToTypeWithCheck(context, val, Access.arrayClass(context), to_ary_checked)) != context.nil) {
                        this.recursiveJoin(context, (IRubyObject)val, sep, result2, (RubyArray)tmp, first2);
                    } else {
                        RubyArray.strJoin(result2, RubyString.objAsString(context, val), first2);
                    }
                }
            }
            ++i2;
        }
        return result2;
    }

    private static void strJoin(RubyString result2, RubyString val, boolean[] first2) {
        result2.catWithCodeRange(val);
        if (first2[0]) {
            result2.setEncoding(val.getEncoding());
            first2[0] = false;
        }
    }

    private void recursiveJoin(ThreadContext context, IRubyObject outValue, RubyString sep, RubyString result2, RubyArray ary, boolean[] first2) {
        if (ary == this) {
            throw Error.argumentError(context, "recursive array join");
        }
        first2[0] = false;
        context.safeRecurse(JOIN_RECURSIVE, new JoinRecursive.State(ary, outValue, sep, result2, first2), outValue, "join", true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject join19(ThreadContext context, IRubyObject sep) {
        return this.join(context, sep);
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context, IRubyObject sep) {
        if (sep == context.nil) {
            sep = this.getDefaultSeparator(context);
        }
        if (this.realLength == 0) {
            return RubyString.newEmptyString(context.runtime, (Encoding)USASCIIEncoding.INSTANCE);
        }
        int len = 1;
        RubyString sepString = null;
        if (sep != context.nil) {
            sepString = sep.convertToString();
            len += sepString.size() * (this.realLength - 1);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T val = this.eltOk(i2);
            IRubyObject tmp = val.checkStringType();
            if (tmp == context.nil || tmp != val) {
                if (i2 > this.realLength) {
                    i2 = this.realLength;
                }
                RubyString result2 = RubyString.newStringLight(context.runtime, len += (this.realLength - i2) * 10, (Encoding)USASCIIEncoding.INSTANCE);
                i2 = this.joinStrings(sepString, i2, result2);
                boolean[] first2 = new boolean[]{i2 == 0};
                return this.joinAny(context, sepString, i2, result2, first2);
            }
            len += ((RubyString)tmp).getByteList().length();
        }
        RubyString result3 = RubyString.newStringLight(context.runtime, len);
        this.joinStrings(sepString, this.realLength, result3);
        return result3;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject join19(ThreadContext context) {
        return this.join(context);
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join(ThreadContext context) {
        return this.join(context, context.nil);
    }

    private IRubyObject getDefaultSeparator(ThreadContext context) {
        IRubyObject sep = Access.globalVariables(context).get("$,");
        if (!sep.isNil()) {
            Warn.warnDeprecated(context, "$, is set to non-nil value");
        }
        return sep;
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a(ThreadContext context) {
        RubyClass arrayClass = Access.arrayClass(context);
        return this.metaClass != arrayClass ? this.dupImpl(context.runtime, arrayClass) : this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_ary() {
        return this;
    }

    @JRubyMethod(name={"to_ary"})
    public IRubyObject to_ary(ThreadContext context) {
        return this;
    }

    @Deprecated(since="9.3.0.0")
    public IRubyObject to_h(ThreadContext context) {
        return this.to_h(context, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"to_h"})
    public IRubyObject to_h(ThreadContext context, Block block) {
        boolean useSmallHash = this.realLength <= 10;
        RubyHash hash2 = useSmallHash ? Create.newSmallHash(context) : Create.newHash(context);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T e = this.eltOk(i2);
            Object elt = block.isGiven() ? block.yield(context, (IRubyObject)e) : e;
            IRubyObject key_value_pair = elt.checkArrayType();
            if (key_value_pair == context.nil) {
                throw Error.typeError(context, "wrong element type ", elt, " at " + i2 + " (expected array)");
            }
            RubyArray ary = (RubyArray)key_value_pair;
            if (ary.getLength() != 2) {
                throw Error.argumentError(context, "wrong array length at " + i2 + " (expected 2, was " + ary.getLength() + ")");
            }
            if (useSmallHash) {
                hash2.fastASetSmall(context.runtime, (IRubyObject)ary.eltOk(0L), (IRubyObject)ary.eltOk(1L), true);
                continue;
            }
            hash2.fastASet(context.runtime, (IRubyObject)ary.eltOk(0L), (IRubyObject)ary.eltOk(1L), true);
        }
        return hash2;
    }

    @Override
    public RubyArray convertToArray() {
        return this;
    }

    @Override
    public IRubyObject checkArrayType() {
        return this;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return context.tru;
        }
        if (!(obj instanceof RubyArray)) {
            if (obj == context.nil) {
                return context.fals;
            }
            if (!RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, obj, obj)) {
                return context.fals;
            }
            return Helpers.rbEqual(context, obj, this);
        }
        return RecursiveComparator.compare(context, RubyArray.sites((ThreadContext)context).op_equal, this, obj, false);
    }

    public RubyBoolean compare(ThreadContext context, CallSite site, IRubyObject other) {
        if (!(other instanceof RubyArray)) {
            if (!RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, other, other)) {
                return context.fals;
            }
            return Helpers.rbEqual(context, other, this);
        }
        RubyArray ary = (RubyArray)other;
        if (this.realLength != ary.realLength) {
            return context.fals;
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject b2;
            IRubyObject a = this.elt(i2);
            if (a == (b2 = ary.elt(i2)) || site.call(context, a, a, b2).isTrue()) continue;
            return context.fals;
        }
        return context.tru;
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql(ThreadContext context, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            return context.fals;
        }
        return RecursiveComparator.compare(context, RubyArray.sites((ThreadContext)context).eql, this, obj, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject compact_bang() {
        return this.compact_bang(this.getCurrentContext());
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang(ThreadContext context) {
        int p2;
        this.unpack(context);
        this.modify(context);
        int t = p2 = this.begin;
        int end2 = p2 + this.realLength;
        try {
            while (t < end2) {
                if (this.values[t].isNil()) {
                    ++t;
                    continue;
                }
                this.values[p2++] = this.values[t++];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
        if (this.realLength == (p2 -= this.begin)) {
            return context.nil;
        }
        this.realloc(context, p2, this.values.length - this.begin);
        this.realLength = p2;
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject compact() {
        return this.compact(this.getCurrentContext());
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact(ThreadContext context) {
        RubyArray ary = this.aryDup();
        ary.compact_bang(context);
        return ary;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject empty_p() {
        return this.empty_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return this.realLength == 0 ? context.tru : context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rb_clear() {
        return this.rb_clear(this.getCurrentContext());
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear(ThreadContext context) {
        this.modifyCheck(context);
        if (this.isShared) {
            this.alloc(context, 16);
            this.isShared = false;
        } else if (this.values.length > 32) {
            this.alloc(context, 32);
        } else {
            try {
                this.begin = 0;
                Helpers.fillNil(context, this.values, 0, this.realLength);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw RubyArray.concurrentModification(context, e);
            }
        }
        this.realLength = 0;
        return this;
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw Error.argumentError(context, 0, 1);
        }
        return this.fillCommon(context, 0, (long)this.realLength, block);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg2, Block block) {
        if (!block.isGiven()) {
            return this.fillCommon(context, 0, (long)this.realLength, arg2);
        }
        if (arg2 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg2;
            int[] beglen = range.begLenInt(context, this.realLength, 1);
            return this.fillCommon(context, beglen[0], (long)beglen[1], block);
        }
        int beg = this.fillBegin(context, arg2);
        return this.fillCommon(context, beg, this.fillLen(context, beg, null), block);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            int beg = this.fillBegin(context, arg1);
            return this.fillCommon(context, beg, this.fillLen(context, beg, arg2), block);
        }
        if (arg2 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg2;
            int[] beglen = range.begLenInt(context, this.realLength, 1);
            return this.fillCommon(context, beglen[0], (long)beglen[1], arg1);
        }
        int beg = this.fillBegin(context, arg2);
        return this.fillCommon(context, beg, this.fillLen(context, beg, null), arg1);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        if (block.isGiven()) {
            throw Error.argumentError(context, 3, 2);
        }
        int beg = this.fillBegin(context, arg2);
        return this.fillCommon(context, beg, this.fillLen(context, beg, arg3), arg1);
    }

    private int fillBegin(ThreadContext context, IRubyObject arg2) {
        int beg;
        int n = beg = arg2.isNil() ? 0 : Convert.toInt(context, arg2);
        if (beg < 0 && (beg = this.realLength + beg) < 0) {
            beg = 0;
        }
        return beg;
    }

    private long fillLen(ThreadContext context, long beg, IRubyObject arg2) {
        return arg2 == null || arg2.isNil() ? (long)this.realLength - beg : Convert.toLong(context, arg2);
    }

    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, IRubyObject item) {
        this.unpack(context);
        this.modify(context);
        if (len < 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw Error.argumentError(context, "argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            this.resizeAndFillBackingArray(context, end2);
            this.realLength = end2;
        }
        if (len > 0L) {
            try {
                Arrays.fill(this.values, this.begin + beg, this.begin + end2, item);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw RubyArray.concurrentModification(context, ex);
            }
        }
        return this;
    }

    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, Block block) {
        this.unpack(context);
        this.modify(context);
        if (len < 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw Error.argumentError(context, "argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            this.resizeAndFillBackingArray(context, end2);
            this.realLength = end2;
        }
        for (int i2 = beg; i2 < end2; ++i2) {
            IRubyObject v = block.yield(context, Convert.asFixnum(context, i2));
            if (i2 >= this.realLength) break;
            RubyArray.safeArraySet(context, this.values, this.begin + i2, v);
        }
        return this;
    }

    public IRubyObject index(ThreadContext context, IRubyObject obj) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!RubyArray.equalInternal(context, this.eltOk(i2), obj)) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    @JRubyMethod(name={"index", "find_index"})
    public IRubyObject index(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            Warn.warn(context, "given block not used");
        }
        return this.index(context, obj);
    }

    @JRubyMethod(name={"index", "find_index"})
    public IRubyObject index(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "index");
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject bsearch(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "bsearch");
        }
        int rVal = this.bsearch_index_internal(context, block);
        if (rVal == -1) {
            return context.nil;
        }
        return this.eltOk(rVal);
    }

    @JRubyMethod
    public IRubyObject bsearch_index(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "bsearch_index");
        }
        int rVal = this.bsearch_index_internal(context, block);
        if (rVal == -1) {
            return context.nil;
        }
        return Convert.asFixnum(context, rVal);
    }

    private int bsearch_index_internal(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        int low = 0;
        int high = this.realLength;
        boolean smaller = false;
        boolean satisfied = false;
        CallSite op_cmp2 = null;
        while (low < high) {
            int mid = low + (high - low) / 2;
            IRubyObject v = block.yieldSpecific(context, (IRubyObject)this.eltOk(mid));
            if (v instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)v;
                long fixValue = fixnum.getValue();
                if (fixValue == 0L) {
                    return mid;
                }
                smaller = fixValue < 0L;
            } else if (v == context.tru) {
                satisfied = true;
                smaller = true;
            } else if (v == context.fals || v == context.nil) {
                smaller = false;
            } else if (runtime2.getNumeric().isInstance(v)) {
                if (op_cmp2 == null) {
                    op_cmp2 = RubyArray.sites((ThreadContext)context).op_cmp_bsearch;
                }
                RubyFixnum zero = Convert.asFixnum(context, 0);
                switch (RubyComparable.cmpint(context, op_cmp2.call(context, v, v, (IRubyObject)zero), v, zero)) {
                    case 0: {
                        return mid;
                    }
                    case 1: {
                        smaller = false;
                        break;
                    }
                    case -1: {
                        smaller = true;
                    }
                }
            } else {
                throw Error.typeError(context, "wrong argument type ", v, " (must be numeric, true, false or nil");
            }
            if (smaller) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        if (low == this.realLength) {
            return -1;
        }
        if (!satisfied) {
            return -1;
        }
        return low;
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject obj) {
        this.unpack(context);
        int i2 = this.realLength;
        while (i2-- > 0) {
            if (i2 > this.realLength) {
                i2 = this.realLength;
                continue;
            }
            if (!RubyArray.equalInternal(context, this.eltOk(i2), obj)) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            Warn.warn(context, "given block not used");
        }
        return this.rindex(context, obj);
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "rindex");
        }
        int i2 = this.realLength;
        while (i2-- > 0) {
            if (i2 >= this.realLength) {
                i2 = this.realLength;
                continue;
            }
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject indexes(IRubyObject[] args2) {
        return this.indexes(this.getCurrentContext(), args2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject indexes(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        Warn.warn(context, "Array#indexes is deprecated; use Array#values_at");
        if (argc == 1) {
            return Create.newArray(context, args2[0]);
        }
        RubyArray ary = RubyArray.newBlankArrayInternal(context.runtime, argc);
        for (int i2 = 0; i2 < argc; ++i2) {
            ary.storeInternal(context, i2, this.aref(context, args2[i2]));
        }
        ary.realLength = argc;
        return ary;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject reverse_bang() {
        return this.reverse_bang(this.getCurrentContext());
    }

    @JRubyMethod(name={"reverse!"})
    public IRubyObject reverse_bang(ThreadContext context) {
        this.modify(context);
        try {
            if (this.realLength > 1) {
                int len = this.realLength;
                for (int i2 = 0; i2 < len >> 1; ++i2) {
                    T tmp = this.eltInternal(i2);
                    this.eltInternalSet(i2, this.eltInternal(len - i2 - 1));
                    this.eltInternalSet(len - i2 - 1, tmp);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject reverse() {
        return this.reverse(this.getCurrentContext());
    }

    @JRubyMethod(name={"reverse"})
    @JRubyAPI
    public IRubyObject reverse(ThreadContext context) {
        return this.realLength > 1 ? this.safeReverse() : this.aryDup();
    }

    protected RubyArray safeReverse() {
        int length2 = this.realLength;
        int myBegin = this.begin;
        IRubyObject[] myValues = this.values;
        IRubyObject[] vals = IRubyObject.array(length2);
        Ruby runtime2 = this.metaClass.runtime;
        try {
            for (int i2 = 0; i2 <= length2 >> 1; ++i2) {
                vals[i2] = myValues[myBegin + length2 - i2 - 1];
                vals[length2 - i2 - 1] = myValues[myBegin + i2];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(runtime2.getCurrentContext(), e);
        }
        return new RubyArray<T>(runtime2, runtime2.getArray(), vals);
    }

    public RubyArray collectArray(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this.makeShared();
        }
        RubyArray<?> ary = Create.allocArray(context, this.realLength);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            ary.append(context, block.yieldNonArray(context, (IRubyObject)this.eltOk(i2), null));
        }
        return ary;
    }

    public RubyEnumerator collectEnum(ThreadContext context) {
        return RubyEnumerator.enumWithSize(context, this, "collect", RubyArray::size);
    }

    public RubyArray collect(ThreadContext context, Block block) {
        return this.collectArray(context, block);
    }

    @JRubyMethod(name={"collect"})
    public IRubyObject rbCollect(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectArray(context, block) : this.collectEnum(context);
    }

    @JRubyMethod(name={"map"})
    public IRubyObject map(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectArray(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "map", RubyArray::size);
    }

    public RubyArray collectBang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        this.modify(context);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            this.storeInternal(context, i2, block.yield(context, (IRubyObject)this.eltOk(i2)));
        }
        return this;
    }

    @JRubyMethod(name={"collect!"})
    public IRubyObject collect_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "collect!", RubyArray::size);
    }

    @JRubyMethod(name={"map!"})
    public IRubyObject map_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "map!", RubyArray::size);
    }

    public IRubyObject selectCommon(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        switch (this.realLength) {
            case 1: {
                T value2 = this.eltOk(0L);
                if (block.yield(context, (IRubyObject)value2).isTrue()) {
                    return new RubyArrayOneObject(runtime2, (IRubyObject)value2);
                }
                return RubyArray.newEmptyArray(runtime2);
            }
            case 2: {
                T value3 = this.eltOk(0L);
                boolean first2 = block.yield(context, (IRubyObject)value3).isTrue();
                T value2 = this.eltOk(1L);
                boolean second2 = block.yield(context, (IRubyObject)value2).isTrue();
                if (first2) {
                    if (second2) {
                        return RubyArray.newArray(runtime2, value3, value2);
                    }
                    return RubyArray.newArray(runtime2, value3);
                }
                if (second2) {
                    return RubyArray.newArray(runtime2, value2);
                }
                return RubyArray.newEmptyArray(runtime2);
            }
        }
        RubyArray<?> result2 = Create.allocArray(context, this.realLength);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T value4 = this.eltOk(i2);
            if (!block.yield(context, (IRubyObject)value4).isTrue()) continue;
            result2.append(context, (IRubyObject)value4);
        }
        return result2;
    }

    @JRubyMethod(name={"select"}, alias={"filter"})
    public IRubyObject select(ThreadContext context, Block block) {
        return block.isGiven() ? this.selectCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "select", RubyArray::size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", RubyArray::size);
        }
        this.unpack(context);
        this.modify(context);
        boolean modified = false;
        int len0 = 0;
        int len1 = 0;
        try {
            int i2 = 0;
            int i1 = 0;
            while (i1 < this.realLength) {
                T value2 = this.eltOk(i1);
                if (!block.yield(context, (IRubyObject)value2).isTrue()) {
                    modified = true;
                } else {
                    if (i1 != i2) {
                        this.eltSetOk(i2, value2);
                    }
                    len1 = ++i2;
                }
                len0 = ++i1;
            }
            IRubyObject iRubyObject = i1 == i2 ? context.nil : this;
            return iRubyObject;
        }
        finally {
            if (modified) {
                this.checkFrozen();
            }
            this.selectBangEnsure(context, len0, len1);
        }
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", RubyArray::size);
        }
        this.select_bang(context, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject deconstruct(ThreadContext context) {
        return this;
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        this.unpack(context);
        int i2 = 0;
        IRubyObject value2 = item;
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = RubyArray.safeArrayRef(context, this.values, this.begin + i1);
            if (RubyArray.equalInternal(context, e, item)) {
                value2 = e;
                continue;
            }
            if (i1 != i2) {
                this.store(i2, e);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            return block.isGiven() ? block.yield(context, item) : context.nil;
        }
        this.modify(context);
        int myRealLength = this.realLength;
        int myBegin = this.begin;
        IRubyObject[] myValues = this.values;
        try {
            if (myRealLength > i2) {
                Helpers.fillNil(context, myValues, myBegin + i2, myBegin + myRealLength);
                this.realLength = i2;
                int valuesLength = myValues.length - myBegin;
                if (i2 << 1 < valuesLength && valuesLength > 16) {
                    this.realloc(context, i2 << 1, valuesLength);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject delete_at(int pos2) {
        return this.delete_at(this.getCurrentContext(), pos2);
    }

    public IRubyObject delete_at(ThreadContext context, int pos2) {
        int len = this.realLength;
        if (pos2 >= len || pos2 < 0 && (pos2 += len) < 0) {
            return context.nil;
        }
        this.unpack(context);
        this.modify(context);
        try {
            IRubyObject obj = this.values[this.begin + pos2];
            if (pos2 == 0) {
                this.values[this.begin] = context.nil;
                ++this.begin;
                --this.realLength;
                return obj;
            }
            if (pos2 == this.realLength - 1) {
                this.values[this.begin + this.realLength - 1] = context.nil;
                --this.realLength;
                return obj;
            }
            System.arraycopy(this.values, this.begin + pos2 + 1, this.values, this.begin + pos2, len - (pos2 + 1));
            this.values[this.begin + len - 1] = context.nil;
            --this.realLength;
            return obj;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"delete_at"})
    public IRubyObject delete_at(ThreadContext context, IRubyObject obj) {
        return this.delete_at(Convert.toInt(context, obj));
    }

    public final IRubyObject rejectCommon(ThreadContext context, Block block) {
        RubyArray<?> ary = Create.newArray(context);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T v = this.eltOk(i2);
            if (block.yieldSpecific(context, (IRubyObject)v).isTrue()) continue;
            ary.push(context, (IRubyObject)v);
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject", RubyArray::size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject rejectBang(ThreadContext context, Block block) {
        this.unpack(context);
        this.modify(context);
        int beg = this.begin;
        boolean modified = false;
        int len0 = 0;
        int len1 = 0;
        try {
            int i2 = 0;
            int i1 = 0;
            while (i1 < this.realLength) {
                IRubyObject[] values2 = this.values;
                IRubyObject value2 = RubyArray.safeArrayRef(context, values2, beg + i1);
                if (block.yield(context, value2).isTrue()) {
                    modified = true;
                } else {
                    if (i1 != i2) {
                        RubyArray.safeArraySet(context, values2, beg + i2, value2);
                    }
                    len1 = ++i2;
                }
                len0 = ++i1;
            }
            IRubyObject iRubyObject = i1 == i2 ? context.nil : this;
            return iRubyObject;
        }
        finally {
            if (modified) {
                this.checkFrozen();
            }
            this.selectBangEnsure(context, len0, len1);
        }
    }

    private void selectBangEnsure(ThreadContext context, int i1, int i2) {
        int len = this.realLength;
        if (i2 < len && i2 < i1) {
            int tail = 0;
            int beg = this.begin;
            if (i1 < len) {
                tail = len - i1;
                RubyArray.safeArrayCopy(context, this.values, beg + i1, this.values, beg + i2, tail);
            } else if (this.realLength > 0) {
                try {
                    Helpers.fillNil(context, this.values, beg + i2, beg + i1);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw RubyArray.concurrentModification(context, ex);
                }
            }
            this.realLength = i2 + tail;
        }
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", RubyArray::size);
    }

    public IRubyObject deleteIf(ThreadContext context, Block block) {
        this.rejectBang(context, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.deleteIf(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", RubyArray::size);
    }

    @JRubyMethod(optional=1, rest=true, checkArity=false)
    public IRubyObject zip(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyClass array2 = Access.arrayClass(context);
        JavaSites.ArraySites sites = RubyArray.sites(context);
        IRubyObject[] newArgs = IRubyObject.array(args2.length);
        boolean hasUncoercible = false;
        JavaSites.CheckedSites to_ary_checked = sites.to_ary_checked;
        for (int i3 = 0; i3 < args2.length; ++i3) {
            newArgs[i3] = TypeConverter.convertToType(context, args2[i3], array2, to_ary_checked, false);
            if (!newArgs[i3].isNil()) continue;
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            CallSite to_enum = sites.to_enum;
            RubySymbol each2 = Convert.asSymbol(context, "each");
            for (int i4 = 0; i4 < args2.length; ++i4) {
                IRubyObject arg3 = args2[i4];
                if (!arg3.respondsTo("each")) {
                    throw Error.typeError(context, arg3, "must respond to :each");
                }
                newArgs[i4] = to_enum.call(context, arg3, arg3, (IRubyObject)each2);
            }
        }
        if (hasUncoercible) {
            return this.zipCommon(context, newArgs, block, (ctx, arg2, i2) -> RubyEnumerable.zipEnumNext(ctx, arg2));
        }
        return this.zipCommon(context, newArgs, block, (ctx, arg2, i2) -> ((RubyArray)arg2).elt(i2));
    }

    private IRubyObject zipCommon(ThreadContext context, IRubyObject[] args2, Block block, ArgumentVisitor visitor) {
        if (block.isGiven()) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                IRubyObject[] tmp = IRubyObject.array(Helpers.addBufferLength(context, args2.length, 1));
                tmp[0] = this.eltInternal(i2);
                for (int j = 0; j < args2.length; ++j) {
                    tmp[j + 1] = visitor.visit(context, args2[j], i2);
                }
                block.yield(context, RubyArray.newArrayMayCopy(context.runtime, tmp));
            }
            return context.nil;
        }
        IRubyObject[] result2 = IRubyObject.array(this.realLength);
        try {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                IRubyObject[] tmp = IRubyObject.array(Helpers.addBufferLength(context, args2.length, 1));
                tmp[0] = this.eltInternal(i3);
                for (int j = 0; j < args2.length; ++j) {
                    tmp[j + 1] = visitor.visit(context, args2[j], i3);
                }
                result2[i3] = RubyArray.newArrayMayCopy(context.runtime, tmp);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return RubyArray.newArrayMayCopy(context.runtime, result2);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject obj) {
        boolean isAnArray;
        boolean bl = isAnArray = obj instanceof RubyArray || obj.getMetaClass().getSuperClass() == Access.arrayClass(context);
        if (!isAnArray && !RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, obj, obj, true)) {
            return context.nil;
        }
        RubyArray ary2 = !isAnArray ? (RubyArray)RubyArray.sites((ThreadContext)context).to_ary.call(context, obj, obj) : obj.convertToArray();
        return this.cmpCommon(context, ary2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject cmpCommon(ThreadContext context, RubyArray ary2) {
        int len;
        if (this == ary2 || context.runtime.isInspecting(this)) {
            return Convert.asFixnum(context, 0);
        }
        try {
            context.runtime.registerInspecting(this);
            len = this.realLength;
            if (len > ary2.realLength) {
                len = ary2.realLength;
            }
            CallSite cmp2 = RubyArray.sites((ThreadContext)context).cmp;
            for (int i2 = 0; i2 < len; ++i2) {
                RubyFixnum fixnum;
                IRubyObject elt = this.elt(i2);
                IRubyObject v = cmp2.call(context, elt, elt, ary2.elt(i2));
                if (v instanceof RubyFixnum && (fixnum = (RubyFixnum)v).getValue() == 0L) continue;
                IRubyObject iRubyObject = v;
                return iRubyObject;
            }
        }
        finally {
            context.runtime.unregisterInspecting(this);
        }
        len = this.realLength - ary2.realLength;
        int cmpValue = len == 0 ? 0 : (len > 0 ? 1 : -1);
        return Convert.asFixnum(context, cmpValue);
    }

    @Deprecated(since="9.4-")
    public IRubyObject slice_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(args2[0]);
            }
            case 2: {
                return this.slice_bang(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 1, 2);
        return null;
    }

    private IRubyObject slice_internal(ThreadContext context, int pos2, int len) {
        if (len < 0) {
            return context.nil;
        }
        int orig_len = this.realLength;
        if (pos2 < 0 && (pos2 += orig_len) < 0) {
            return context.nil;
        }
        if (orig_len < pos2) {
            return context.nil;
        }
        if (orig_len < pos2 + len) {
            len = orig_len - pos2;
        }
        if (len == 0) {
            return Create.newEmptyArray(context);
        }
        this.unpack(context);
        RubyArray result2 = this.makeShared(context, this.begin + pos2, len, Access.arrayClass(context));
        this.splice(context, pos2, len, null, 0);
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject slice_bang(IRubyObject arg0) {
        return this.slice_bang(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        this.modifyCheck(context);
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (!range.checkBegin(context, this.realLength)) {
                return context.nil;
            }
            int pos2 = Convert.checkInt(context, range.begLen0(context, this.realLength));
            int len = Convert.checkInt(context, range.begLen1(context, this.realLength, pos2));
            return this.slice_internal(context, pos2, len);
        }
        return this.delete_at(Convert.toInt(context, arg0));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        return this.slice_bang(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        this.modifyCheck(context);
        return this.slice_internal(context, Convert.toInt(context, arg0), Convert.toInt(context, arg1));
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject key2) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            RubyArray arr;
            IRubyObject v = TypeConverter.checkArrayType(context, RubyArray.sites((ThreadContext)context).to_ary_checked, this.eltOk(i2));
            if (!(v instanceof RubyArray) || (arr = (RubyArray)v).size() <= 0 || arr.realLength <= 0 || !RubyArray.equalInternal(context, arr.elt(0L), key2)) continue;
            return arr;
        }
        return context.nil;
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject value2) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = TypeConverter.checkArrayType(context, RubyArray.sites((ThreadContext)context).to_ary_checked, this.eltOk(i2));
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 1 || !RubyArray.equalInternal(context, arr.eltOk(1L), value2)) continue;
            return arr;
        }
        return context.nil;
    }

    protected boolean flatten(ThreadContext context, int level2, RubyArray result2) {
        IdentityHashMap<RubyArray, IRubyObject> memo;
        T elt;
        int i2;
        this.unpack(context);
        IRubyObject tmp = null;
        for (i2 = 0; i2 < this.realLength && (tmp = TypeConverter.checkArrayType(context.runtime, elt = this.eltOk(i2))).isNil(); ++i2) {
        }
        RubyArray.safeArrayCopy(context, this.values, this.begin, result2.values, result2.begin, i2);
        result2.realLength = i2;
        if (i2 == this.realLength) {
            return false;
        }
        Stack<Serializable> stack = new Stack<Serializable>();
        stack.push(this);
        stack.push(Integer.valueOf(i2 + 1));
        RubyArray ary = (RubyArray)tmp;
        if (level2 < 0) {
            memo = new IdentityHashMap<RubyArray, IRubyObject>(5);
            memo.put(this, NEVER);
            memo.put((RubyArray)tmp, NEVER);
        } else {
            memo = null;
        }
        i2 = 0;
        try {
            while (true) {
                if (i2 < ary.realLength) {
                    T elt2 = ary.eltOk(i2++);
                    if (level2 >= 0 && stack.size() / 2 >= level2) {
                        result2.append(context, (IRubyObject)elt2);
                        continue;
                    }
                    tmp = TypeConverter.checkArrayType(context, elt2);
                    if (tmp.isNil()) {
                        result2.append(context, (IRubyObject)elt2);
                        continue;
                    }
                    if (memo != null) {
                        if (memo.get(tmp) != null) {
                            throw Error.argumentError(context, "tried to flatten recursive array");
                        }
                        memo.put(ary, NEVER);
                    }
                    stack.push(ary);
                    stack.push(Integer.valueOf(i2));
                    ary = (RubyArray)tmp;
                    i2 = 0;
                    continue;
                }
                if (!stack.isEmpty()) {
                    if (memo != null) {
                        memo.remove(ary);
                    }
                    i2 = (Integer)stack.pop();
                    ary = (RubyArray)stack.pop();
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return stack != null;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context) {
        this.unpack(context);
        this.modifyCheck(context);
        RubyArray<T> result2 = new RubyArray<T>(context.runtime, this.getType(), this.realLength);
        if (this.flatten(context, -1, result2)) {
            this.modifyCheck(context);
            this.isShared = false;
            this.begin = 0;
            this.realLength = result2.realLength;
            this.values = result2.values;
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        this.unpack(context);
        this.modifyCheck(context);
        int level2 = Convert.toInt(context, arg2);
        if (level2 == 0) {
            return context.nil;
        }
        RubyArray<T> result2 = new RubyArray<T>(context.runtime, this.getType(), this.realLength);
        if (this.flatten(context, level2, result2)) {
            this.isShared = false;
            this.begin = 0;
            this.realLength = result2.realLength;
            this.values = result2.values;
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        RubyArray<?> result2 = RubyArray.newArray(context, this.realLength);
        this.flatten(context, -1, result2);
        return result2;
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context, IRubyObject arg2) {
        int level2 = Convert.toInt(context, arg2);
        if (level2 == 0) {
            return this.makeShared();
        }
        RubyArray<?> result2 = RubyArray.newArray(context, this.realLength);
        this.flatten(context, level2, result2);
        return result2;
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, Block block) {
        if (block.isGiven()) {
            int n = 0;
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (!block.yield(context, this.elt(i2)).isTrue()) continue;
                ++n;
            }
            return Convert.asFixnum(context, n);
        }
        return Convert.asFixnum(context, this.realLength);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, IRubyObject obj, Block block) {
        if (block.isGiven()) {
            Warn.warn(context, "given block not used");
        }
        int n = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!RubyArray.equalInternal(context, this.elt(i2), obj)) continue;
            ++n;
        }
        return Convert.asFixnum(context, n);
    }

    @JRubyMethod(name={"nitems"})
    public IRubyObject nitems(ThreadContext context) {
        int n = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (this.eltOk(i2).isNil()) continue;
            ++n;
        }
        return Convert.asFixnum(context, n);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject nitems() {
        return this.nitems(this.getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_plus(IRubyObject obj) {
        return this.op_plus(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject obj) {
        RubyArray y = obj.convertToArray();
        int len = this.realLength + y.realLength;
        switch (len) {
            case 1: {
                return new RubyArrayOneObject(context.runtime, (IRubyObject)(this.realLength == 1 ? this.eltInternal(0) : y.eltInternal(0)));
            }
            case 2: {
                switch (this.realLength) {
                    case 0: {
                        return RubyArray.newArray(context.runtime, y.eltInternal(0), y.eltInternal(1));
                    }
                    case 1: {
                        return RubyArray.newArray(context.runtime, this.eltInternal(0), y.eltInternal(0));
                    }
                    case 2: {
                        return RubyArray.newArray(context.runtime, this.eltInternal(0), this.eltInternal(1));
                    }
                }
            }
        }
        RubyArray<?> z = Create.allocArray(context, len);
        try {
            this.copyInto(context, z.values, 0);
            y.copyInto(context, z.values, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
        z.realLength = len;
        return z;
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_times(ThreadContext context, IRubyObject times2) {
        IRubyObject tmp = times2.checkStringType();
        if (!tmp.isNil()) {
            return this.join(context, tmp);
        }
        long len = Convert.toLong(context, times2);
        if (len == 0L) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        if (len < 0L) {
            throw Error.argumentError(context, "negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw Error.argumentError(context, "argument too big");
        }
        RubyArray<?> ary2 = Create.allocArray(context, len *= (long)this.realLength);
        ary2.realLength = ary2.values.length;
        try {
            int i2 = 0;
            while ((long)i2 < len) {
                this.copyInto(context, ary2.values, i2);
                i2 += this.realLength;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
        return ary2;
    }

    private RubyHash makeHash(Ruby runtime2) {
        return this.makeHash(new RubyHash(runtime2, Math.min(this.realLength, 128), false));
    }

    private RubyHash makeHash(RubyHash hash2) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.elt(i2);
            hash2.internalPutIfNoKey(v, v);
        }
        return hash2;
    }

    private RubyHash makeHash(ThreadContext context, Block block) {
        return this.makeHash(context, new RubyHash(context.runtime, Math.min(this.realLength, 128), false), block);
    }

    private RubyHash makeHash(ThreadContext context, RubyHash hash2, Block block) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.elt(i2);
            IRubyObject k = block.yield(context, v);
            hash2.internalPutIfNoKey(k, v);
        }
        return hash2;
    }

    private void setValuesFrom(ThreadContext context, RubyHash hash2) {
        try {
            hash2.visitAll(context, RubyHash.SetValueVisitor, this);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    private void clearValues(ThreadContext context, int from, int to) {
        try {
            Helpers.fillNil(context, this.values, this.begin + from, this.begin + to);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    public IRubyObject uniq_bang(ThreadContext context) {
        RubyHash hash2 = this.makeHash(context.runtime);
        int newLength = hash2.size;
        if (this.realLength == newLength) {
            return context.nil;
        }
        this.modify(context);
        this.unpack(context);
        this.setValuesFrom(context, hash2);
        this.clearValues(context, newLength, this.realLength);
        this.realLength = newLength;
        return this;
    }

    @JRubyMethod(name={"uniq!"})
    public IRubyObject uniq_bang(ThreadContext context, Block block) {
        this.modifyCheck(context);
        if (!block.isGiven()) {
            return this.uniq_bang(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        int newLength = hash2.size;
        if (this.realLength == newLength) {
            return context.nil;
        }
        this.modify(context);
        this.unpack(context);
        this.setValuesFrom(context, hash2);
        this.clearValues(context, newLength, this.realLength);
        this.realLength = newLength;
        return this;
    }

    public IRubyObject uniq(ThreadContext context) {
        RubyHash hash2 = this.makeHash(context.runtime);
        int newLength = hash2.size;
        if (this.realLength == newLength) {
            return this.makeShared();
        }
        RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, Access.arrayClass(context), newLength);
        result2.setValuesFrom(context, hash2);
        result2.realLength = newLength;
        return result2;
    }

    @JRubyMethod(name={"uniq"})
    public IRubyObject uniq(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this.uniq(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        int newLength = hash2.size;
        if (this.realLength == newLength) {
            return this.makeShared();
        }
        RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, Access.arrayClass(context), newLength);
        result2.setValuesFrom(context, hash2);
        result2.realLength = newLength;
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_diff(IRubyObject other) {
        return this.op_diff(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_diff(ThreadContext context, IRubyObject other) {
        int len = this.realLength;
        RubyArray res = RubyArray.newBlankArrayInternal(context.runtime, len);
        int index2 = 0;
        RubyHash hash2 = other.convertToArray().makeHash(context.runtime);
        for (int i2 = 0; i2 < len; ++i2) {
            T val = this.eltOk(i2);
            if (hash2.fastARef((IRubyObject)val) != null) continue;
            res.storeInternal(context, index2++, (IRubyObject)val);
        }
        if (index2 == 0) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        if (index2 == 1 && len == 2) {
            return RubyArray.newArray(context.runtime, res.eltInternal(0));
        }
        assert (index2 == res.realLength);
        if (!(res instanceof RubyArraySpecialized)) {
            Helpers.fillNil(context, res.values, index2, res.values.length);
        }
        return res;
    }

    @JRubyMethod(name={"difference"}, rest=true)
    public IRubyObject difference(ThreadContext context, IRubyObject[] args2) {
        int i2;
        BitSet isHash = new BitSet(args2.length);
        RubyArray[] arrays = new RubyArray[args2.length];
        RubyHash[] hashes = new RubyHash[args2.length];
        RubyArray<?> diff = Create.newArray(context);
        for (i2 = 0; i2 < args2.length; ++i2) {
            arrays[i2] = args2[i2].convertToArray();
            isHash.set(i2, this.realLength > 16 && arrays[i2].realLength > 16);
            if (!isHash.get(i2)) continue;
            hashes[i2] = arrays[i2].makeHash(context.runtime);
        }
        for (i2 = 0; i2 < this.realLength; ++i2) {
            int j;
            IRubyObject elt = this.elt(i2);
            for (j = 0; j < args2.length && !(isHash.get(j) ? hashes[j].fastARef(elt) != null : arrays[j].includesByEql(context, elt)); ++j) {
            }
            if (j != args2.length) continue;
            diff.append(context, elt);
        }
        return diff;
    }

    @JRubyMethod(rest=true)
    public IRubyObject intersection(ThreadContext context, IRubyObject[] args2) {
        RubyArray result2 = this.aryDup();
        for (IRubyObject arg2 : args2) {
            result2 = (RubyArray)result2.op_and(arg2);
        }
        return result2;
    }

    @JRubyMethod(name={"intersect?"})
    public IRubyObject intersect_p(ThreadContext context, IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        int len = this.realLength;
        if (len == 0 || ary2.realLength == 0) {
            return context.fals;
        }
        if (len <= 16 && ary2.realLength <= 16) {
            for (int i2 = 0; i2 < len; ++i2) {
                if (!ary2.includesByEql(context, this.elt(i2))) continue;
                return context.tru;
            }
            return context.fals;
        }
        RubyArray shorter = this;
        RubyArray longer = ary2;
        if (len > ary2.realLength) {
            longer = this;
            shorter = ary2;
        }
        RubyHash hash2 = shorter.makeHash(context.runtime);
        for (int i3 = 0; i3 < longer.realLength; ++i3) {
            T val = longer.eltOk(i3);
            if (hash2.fastARef((IRubyObject)val) == null) continue;
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_and(IRubyObject other) {
        return this.op_and(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        int len = this.realLength;
        int maxSize = len < ary2.realLength ? len : ary2.realLength;
        switch (maxSize) {
            case 0: {
                return RubyArray.newEmptyArray(context.runtime);
            }
            case 1: {
                if (len != 0 && ary2.realLength != 0) break;
                return RubyArray.newEmptyArray(context.runtime);
            }
        }
        RubyArray res = RubyArray.newBlankArrayInternal(context.runtime, maxSize);
        int index2 = 0;
        RubyHash hash2 = ary2.makeHash(context.runtime);
        for (int i2 = 0; i2 < len; ++i2) {
            IRubyObject val = this.elt(i2);
            if (!hash2.fastDelete(val)) continue;
            res.storeInternal(context, index2++, val);
        }
        if (index2 == 0) {
            return Create.newEmptyArray(context);
        }
        if (index2 == 1 && maxSize == 2) {
            return Create.newArray(context, res.eltInternal(0));
        }
        assert (index2 == res.realLength);
        if (!(res instanceof RubyArraySpecialized)) {
            Helpers.fillNil(context, res.values, index2, res.values.length);
        }
        return res;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_or(IRubyObject other) {
        return this.op_or(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        int maxSize = this.realLength + ary2.realLength;
        if (maxSize == 0) {
            return Create.newEmptyArray(context);
        }
        RubyHash set2 = ary2.makeHash(this.makeHash(context.runtime));
        RubyArray res = RubyArray.newBlankArrayInternal(context.runtime, set2.size);
        res.setValuesFrom(context, set2);
        int index2 = res.realLength = set2.size;
        if (index2 == 1 && maxSize == 2) {
            return Create.newArray(context, res.eltInternal(0));
        }
        return res;
    }

    @JRubyMethod(name={"union"}, rest=true)
    public IRubyObject union(ThreadContext context, IRubyObject[] args2) {
        RubyArray[] arrays = new RubyArray[args2.length];
        int maxSize = this.realLength;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            arrays[i2] = args2[i2].convertToArray();
            maxSize += arrays[i2].realLength;
        }
        if (maxSize == 0) {
            return Create.newEmptyArray(context);
        }
        if (maxSize <= 16) {
            RubyArray<?> result2 = Create.newArray(context);
            result2.unionInternal(context, this);
            result2.unionInternal(context, arrays);
            return result2;
        }
        RubyHash set2 = this.makeHash(context.runtime);
        for (int i3 = 0; i3 < arrays.length; ++i3) {
            for (int j = 0; j < arrays[i3].realLength; ++j) {
                set2.fastASet(arrays[i3].elt(j), NEVER);
            }
        }
        RubyArray result3 = set2.keys();
        return result3;
    }

    private void unionInternal(ThreadContext context, RubyArray ... args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            for (int j = 0; j < args2[i2].realLength; ++j) {
                IRubyObject elt = args2[i2].elt(j);
                if (this.includesByEql(context, elt)) continue;
                this.append(context, elt);
            }
        }
    }

    @JRubyMethod(name={"sort"})
    public RubyArray sort(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang(context, block);
        return ary;
    }

    @JRubyMethod(name={"sort!"})
    public IRubyObject sort_bang(ThreadContext context, Block block) {
        this.modify(context);
        if (this.realLength > 1) {
            return block.isGiven() ? this.sortInternal(context, block) : this.sortInternal(context, true);
        }
        return this;
    }

    protected IRubyObject sortInternal(ThreadContext context, boolean honorOverride) {
        try {
            Arrays.sort(this.values, this.begin, this.begin + this.realLength, new DefaultComparator(context, honorOverride){

                @Override
                protected int compareGeneric(IRubyObject o1, IRubyObject o2) {
                    int result2 = super.compareGeneric(o1, o2);
                    RubyArray.this.modifyCheck(this.context);
                    return result2;
                }
            });
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return this;
    }

    protected static int compareFixnums(RubyFixnum o1, RubyFixnum o2) {
        return DefaultComparator.compareInteger(o1, o2);
    }

    protected static int compareOthers(ThreadContext context, IRubyObject o1, IRubyObject o2) {
        return DefaultComparator.compareGeneric(context, o1, o2);
    }

    protected IRubyObject sortInternal(ThreadContext context, Block block) {
        this.unpack(context);
        IRubyObject[] newValues = IRubyObject.array(this.realLength);
        int length2 = this.realLength;
        this.copyInto(context, newValues, 0);
        CallSite gt = RubyArray.sites((ThreadContext)context).op_gt_sort;
        CallSite lt = RubyArray.sites((ThreadContext)context).op_lt_sort;
        Arrays.sort(newValues, 0, length2, new BlockComparator(context, block, gt, lt){

            @Override
            public int compare(IRubyObject obj1, IRubyObject obj2) {
                int result2 = super.compare(obj1, obj2);
                RubyArray.this.modifyCheck(this.context);
                return result2;
            }
        });
        this.values = newValues;
        this.begin = 0;
        this.realLength = length2;
        return this;
    }

    @JRubyMethod(name={"sort_by!"})
    public IRubyObject sort_by_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "sort_by!", RubyArray::size);
        }
        this.modifyCheck(context);
        RubyArray sorted = RubyArray.sites((ThreadContext)context).sort_by.call(context, (IRubyObject)this, (IRubyObject)this, block).convertToArray();
        this.replace(sorted);
        return this;
    }

    @JRubyMethod(name={"take"})
    public IRubyObject take(ThreadContext context, IRubyObject n) {
        long len = Convert.toLong(context, n);
        if (len < 0L) {
            throw Error.argumentError(context, "attempt to take negative size");
        }
        return this.subseq(0L, len);
    }

    @JRubyMethod(name={"take_while"})
    public IRubyObject take_while(ThreadContext context, Block block) {
        int i2;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "take_while");
        }
        for (i2 = 0; i2 < this.realLength && block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue(); ++i2) {
        }
        return this.subseq(0L, i2);
    }

    @JRubyMethod(name={"drop"})
    public IRubyObject drop(ThreadContext context, IRubyObject n) {
        long pos2 = Convert.toLong(context, n);
        if (pos2 < 0L) {
            throw Error.argumentError(context, "attempt to drop negative size");
        }
        RubyArray<?> result2 = this.subseq(pos2, this.realLength);
        return result2.isNil() ? Create.newEmptyArray(context) : result2;
    }

    @JRubyMethod(name={"drop_while"})
    public IRubyObject drop_while(ThreadContext context, Block block) {
        int i2;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "drop_while");
        }
        for (i2 = 0; i2 < this.realLength && block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue(); ++i2) {
        }
        RubyArray<?> result2 = this.subseq(i2, this.realLength);
        return result2.isNil() ? Create.newEmptyArray(context) : result2;
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "cycle", RubyArray::cycleSize);
        }
        return this.cycleCommon(context, -1L, block);
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return this.cycle(context, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "cycle", new IRubyObject[]{arg2}, RubyArray::cycleSize);
        }
        long times2 = Convert.toLong(context, arg2);
        return times2 <= 0L ? context.nil : this.cycleCommon(context, times2, block);
    }

    private IRubyObject cycleCommon(ThreadContext context, long n, Block block) {
        while (this.realLength > 0 && (n < 0L || 0L < n--)) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, (IRubyObject)this.eltOk(i2));
            }
        }
        return context.nil;
    }

    private static IRubyObject cycleSize(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        IRubyObject n;
        if (self2.realLength == 0) {
            return Convert.asFixnum(context, 0);
        }
        IRubyObject iRubyObject = n = args2 != null && args2.length > 0 ? args2[0] : context.nil;
        if (n == null || n.isNil()) {
            return Convert.asFloat(context, Double.POSITIVE_INFINITY);
        }
        long multiple = Convert.toLong(context, n);
        if (multiple <= 0L) {
            return Convert.asFixnum(context, 0);
        }
        RubyFixnum length2 = self2.length(context);
        return RubyArray.sites((ThreadContext)context).op_times.call(context, (IRubyObject)length2, (IRubyObject)length2, (IRubyObject)Convert.asFixnum(context, multiple));
    }

    public IRubyObject product(ThreadContext context, IRubyObject[] args2) {
        return this.product(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"product"}, rest=true)
    public IRubyObject product(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean useBlock = block.isGiven();
        int n = args2.length + 1;
        RubyArray[] arrays = new RubyArray[n];
        int[] counters = new int[n];
        arrays[0] = this;
        RubyClass array2 = Access.arrayClass(context);
        JavaSites.CheckedSites to_ary_checked = RubyArray.sites((ThreadContext)context).to_ary_checked;
        for (int i2 = 1; i2 < n; ++i2) {
            arrays[i2] = (RubyArray)TypeConverter.convertToType(context, args2[i2 - 1], array2, to_ary_checked);
        }
        int resultLen = 1;
        for (int i3 = 0; i3 < n; ++i3) {
            int k = arrays[i3].realLength;
            int l = resultLen;
            if (k == 0) {
                return useBlock ? this : Create.newEmptyArray(context);
            }
            if ((resultLen *= k) >= k && resultLen >= l && resultLen / k == l || block.isGiven()) continue;
            throw Error.rangeError(context, "too big to product");
        }
        RubyArray result2 = useBlock ? null : RubyArray.newBlankArrayInternal(context.runtime, resultLen);
        for (int i4 = 0; i4 < resultLen; ++i4) {
            int m;
            RubyArray sub3 = RubyArray.newBlankArrayInternal(context.runtime, n);
            for (int j = 0; j < n; ++j) {
                sub3.eltInternalSet(j, arrays[j].entry(counters[j]));
            }
            sub3.realLength = n;
            if (useBlock) {
                block.yieldSpecific(context, sub3);
            } else {
                result2.eltInternalSet(i4, sub3);
            }
            int n2 = m = n - 1;
            counters[n2] = counters[n2] + 1;
            while (m > 0 && counters[m] == arrays[m].realLength) {
                counters[m] = 0;
                int n3 = --m;
                counters[n3] = counters[n3] + 1;
            }
        }
        if (useBlock) {
            return this;
        }
        result2.realLength = resultLen;
        return result2;
    }

    @JRubyMethod(name={"combination"})
    public IRubyObject combination(ThreadContext context, IRubyObject num, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "combination", new IRubyObject[]{num}, RubyArray::combinationSize);
        }
        int n = Convert.toInt(context, num);
        if (n == 0) {
            block.yield(context, Create.newEmptyArray(context));
        } else if (n == 1) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, Create.newArray(context, this.eltOk(i2)));
            }
        } else if (n >= 0 && this.realLength >= n) {
            int[] stack = new int[n + 1];
            RubyArray<?> values2 = this.makeShared();
            RubyArray.combinate(context, this.size(), n, stack, values2, block);
        }
        return this;
    }

    private static void combinate(ThreadContext context, int len, int n, int[] stack, RubyArray values2, Block block) {
        int lev = 0;
        Arrays.fill(stack, 1, 1 + n, 0);
        stack[0] = -1;
        while (true) {
            ++lev;
            while (lev < n) {
                stack[lev + 1] = stack[lev] + 1;
                ++lev;
            }
            RubyArray.yieldValues(context, n, stack, 1, values2, block);
            do {
                if (lev == 0) {
                    return;
                }
                int n2 = lev--;
                stack[n2] = stack[n2] + 1;
            } while (stack[lev + 1] + n == len + lev + 1);
        }
    }

    private static void rcombinate(ThreadContext context, int n, int r, int[] p2, RubyArray values2, Block block) {
        int i2 = 0;
        int index2 = 0;
        p2[index2] = i2;
        while (true) {
            int n2;
            if (++index2 < r - 1) {
                p2[index2] = i2;
                continue;
            }
            while (i2 < n) {
                p2[index2] = i2++;
                RubyArray.yieldValues(context, r, p2, 0, values2, block);
            }
            do {
                if (index2 <= 0) {
                    return;
                }
                int n3 = --index2;
                n2 = p2[n3] + 1;
                p2[n3] = n2;
                i2 = n2;
            } while (n2 >= n);
        }
    }

    private static IRubyObject combinationSize(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        long n = self2.realLength;
        assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
        long k = ((RubyNumeric)args2[0]).asLong(context);
        return RubyArray.binomialCoefficient(context, k, n);
    }

    private static IRubyObject binomialCoefficient(ThreadContext context, long comb, long size2) {
        if (comb > size2 - comb) {
            comb = size2 - comb;
        }
        if (comb < 0L) {
            return Convert.asFixnum(context, 0);
        }
        IRubyObject r = RubyArray.descendingFactorial(context, size2, comb);
        IRubyObject v = RubyArray.descendingFactorial(context, comb, comb);
        return RubyArray.sites((ThreadContext)context).op_quo.call(context, r, r, v);
    }

    @JRubyMethod(name={"repeated_combination"})
    public IRubyObject repeatedCombination(ThreadContext context, IRubyObject num, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "repeated_combination", new IRubyObject[]{num}, RubyArray::repeatedCombinationSize);
        }
        int n = Convert.toInt(context, num);
        if (n >= 0) {
            if (n == 0) {
                block.yield(context, Create.newEmptyArray(context));
            } else if (n == 1) {
                for (int i2 = 0; i2 < this.realLength; ++i2) {
                    block.yield(context, Create.newArray(context, this.eltOk(i2)));
                }
            } else {
                int[] p2 = new int[n];
                RubyArray<?> values2 = this.makeShared();
                RubyArray.rcombinate(context, this.realLength, n, p2, values2, block);
            }
        }
        return this;
    }

    private static IRubyObject repeatedCombinationSize(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        long n = self2.realLength;
        assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
        long k = ((RubyNumeric)args2[0]).asLong(context);
        return k == 0L ? Convert.asFixnum(context, 1) : RubyArray.binomialCoefficient(context, k, n + k - 1L);
    }

    /*
     * Unable to fully structure code
     */
    private static void permute(ThreadContext context, int n, int r, int[] p, boolean[] used, RubyArray values, Block block) {
        i = 0;
        index = 0;
        block0: while (true) {
            if ((unused = Helpers.memchr(used, i, false, n - i)) == -1) {
                if (index == 0) break;
                i = p[--index];
                used[i++] = false;
                continue;
            }
            p[index] = i = unused;
            used[i] = true;
            if (++index < r - 1) {
                i = 0;
                p[index] = 0;
                continue;
            }
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block0;
                if (!used[i]) {
                    p[index] = i;
                    RubyArray.yieldValues(context, r, p, 0, values, block);
                }
                ++i;
            }
            break;
        }
    }

    private static void yieldValues(ThreadContext context, int r, int[] p2, int pStart, RubyArray values2, Block block) {
        RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, r);
        for (int j = 0; j < r; ++j) {
            result2.eltInternalSet(j, values2.eltInternal(p2[j + pStart]));
        }
        result2.realLength = r;
        block.yield(context, result2);
    }

    private static void rpermute(ThreadContext context, int n, int r, int[] p2, RubyArray values2, Block block) {
        int index2 = 0;
        p2[index2] = 0;
        while (true) {
            int n2;
            if (++index2 < r - 1) {
                p2[index2] = 0;
                continue;
            }
            int i2 = 0;
            while (i2 < n) {
                p2[index2] = i2++;
                RubyArray.yieldValues(context, r, p2, 0, values2, block);
            }
            do {
                if (index2 <= 0) {
                    return;
                }
                n2 = --index2;
            } while ((p2[n2] = p2[n2] + 1) >= n);
        }
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, IRubyObject num, Block block) {
        return block.isGiven() ? this.permutationCommon(context, Convert.toInt(context, num), false, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "permutation", new IRubyObject[]{num}, RubyArray::permutationSize);
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, Block block) {
        return block.isGiven() ? this.permutationCommon(context, this.realLength, false, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "permutation", RubyArray::permutationSize);
    }

    @JRubyMethod(name={"repeated_permutation"})
    public IRubyObject repeated_permutation(ThreadContext context, IRubyObject num, Block block) {
        return block.isGiven() ? this.permutationCommon(context, Convert.toInt(context, num), true, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "repeated_permutation", new IRubyObject[]{num}, RubyArray::repeatedPermutationSize);
    }

    private static IRubyObject repeatedPermutationSize(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        RubyFixnum n = self2.length(context);
        assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
        long k = ((RubyNumeric)args2[0]).asLong(context);
        if (k < 0L) {
            return Convert.asFixnum(context, 0);
        }
        RubyFixnum v = Convert.asFixnum(context, k);
        return RubyArray.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)n, (IRubyObject)n, (IRubyObject)v);
    }

    private IRubyObject permutationCommon(ThreadContext context, int r, boolean repeat, Block block) {
        if (r == 0) {
            block.yield(context, Create.newEmptyArray(context));
        } else if (r == 1) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, Create.newArray(context, this.eltOk(i2)));
            }
        } else if (r >= 0) {
            this.unpack(context);
            int n = this.realLength;
            if (repeat) {
                RubyArray.rpermute(context, n, r, new int[r], this.makeShared(context, this.begin, n, this.metaClass), block);
            } else {
                RubyArray.permute(context, n, r, new int[r], new boolean[n], this.makeShared(context, this.begin, n, this.metaClass), block);
            }
        }
        return this;
    }

    private static IRubyObject permutationSize(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        long k;
        long n = self2.realLength;
        if (args2 != null && args2.length > 0) {
            assert (args2[0] instanceof RubyNumeric);
            k = ((RubyNumeric)args2[0]).asLong(context);
        } else {
            k = n;
        }
        return RubyArray.descendingFactorial(context, n, k);
    }

    private static IRubyObject descendingFactorial(ThreadContext context, long from, long howMany) {
        IRubyObject cnt = Convert.asFixnum(context, howMany >= 0L ? 1 : 0);
        CallSite op_times2 = RubyArray.sites((ThreadContext)context).op_times;
        while (howMany-- > 0L) {
            cnt = op_times2.call(context, cnt, cnt, (IRubyObject)Convert.asFixnum(context, from--));
        }
        return cnt;
    }

    @JRubyMethod(name={"shuffle!"})
    public IRubyObject shuffle_bang(ThreadContext context) {
        return this.shuffleBang(context, context.runtime.getRandomClass());
    }

    @JRubyMethod(name={"shuffle!"})
    public IRubyObject shuffle_bang(ThreadContext context, IRubyObject opts) {
        IRubyObject hash2 = TypeConverter.checkHashType(context.runtime, opts);
        if (hash2.isNil()) {
            throw Error.argumentError(context, 1, 0, 0);
        }
        IRubyObject ret = ArgsUtil.extractKeywordArg(context, (RubyHash)hash2, "random");
        return ret == null ? this.shuffle(context) : this.shuffleBang(context, ret);
    }

    private IRubyObject shuffleBang(ThreadContext context, IRubyObject randgen) {
        int i2;
        this.modify(context);
        int len = i2 = this.realLength;
        try {
            while (i2 > 0) {
                int r = (int)RubyArray.randUpto(context, randgen, i2);
                if (len != this.realLength) {
                    throw Error.runtimeError(context, "modified during shuffle");
                }
                T tmp = this.eltOk(--i2);
                this.eltSetOk(i2, this.eltOk(r));
                this.eltSetOk(r, tmp);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return this;
    }

    @JRubyMethod(name={"shuffle"})
    public IRubyObject shuffle(ThreadContext context) {
        RubyArray ary = this.aryDup();
        ary.shuffle_bang(context);
        return ary;
    }

    @JRubyMethod(name={"shuffle"})
    public IRubyObject shuffle(ThreadContext context, IRubyObject opts) {
        RubyArray ary = this.aryDup();
        ary.shuffle_bang(context, opts);
        return ary;
    }

    @JRubyMethod(name={"sample"})
    public IRubyObject sample(ThreadContext context) {
        return this.sampleCommon(context, Access.randomClass(context));
    }

    @JRubyMethod(name={"sample"})
    public IRubyObject sample(ThreadContext context, IRubyObject sampleOrOpts) {
        IRubyObject hash2 = TypeConverter.checkHashType(context.runtime, sampleOrOpts);
        if (hash2.isNil()) {
            return this.sampleCommon(context, sampleOrOpts, Access.randomClass(context));
        }
        IRubyObject ret = ArgsUtil.extractKeywordArg(context, (RubyHash)hash2, "random");
        return this.sampleCommon(context, ret != null ? ret : Access.randomClass(context));
    }

    @JRubyMethod(name={"sample"})
    public IRubyObject sample(ThreadContext context, IRubyObject sample2, IRubyObject opts) {
        IRubyObject hash2 = TypeConverter.checkHashType(context.runtime, opts);
        if (hash2.isNil()) {
            throw Error.argumentError(context, 2, 0, 1);
        }
        IRubyObject ret = ArgsUtil.extractKeywordArg(context, (RubyHash)hash2, "random");
        return this.sampleCommon(context, sample2, ret != null ? ret : Access.randomClass(context));
    }

    private IRubyObject sampleCommon(ThreadContext context, IRubyObject randgen) {
        if (this.realLength == 0) {
            return context.nil;
        }
        if (this.realLength == 1) {
            return this.eltOk(0L);
        }
        long rand2 = RubyArray.randUpto(context, randgen, this.realLength);
        if (rand2 < 0L || (long)this.realLength <= rand2) {
            return context.nil;
        }
        return this.eltOk(rand2);
    }

    private IRubyObject sampleCommon(ThreadContext context, IRubyObject sample2, IRubyObject randgen) {
        int len = this.realLength;
        int n = Convert.toInt(context, sample2);
        try {
            int k;
            int i2;
            if (n < 0) {
                throw Error.argumentError(context, "negative sample number");
            }
            if (n > len) {
                n = len;
            }
            long[] rnds = new long[10];
            if (n <= 10) {
                for (i2 = 0; i2 < n; ++i2) {
                    rnds[i2] = RubyArray.randUpto(context, randgen, len - i2);
                }
            }
            if ((len = this.realLength) < (k = len) && n <= 10) {
                for (i2 = 0; i2 < n; ++i2) {
                    if (rnds[i2] < (long)len) continue;
                    return Create.newEmptyArray(context);
                }
            }
            if (n > len) {
                n = len;
            }
            switch (n) {
                case 0: {
                    return Create.newEmptyArray(context);
                }
                case 1: {
                    return this.realLength <= 0 ? Create.newEmptyArray(context) : Create.newArray(context, this.eltOk((int)rnds[0]));
                }
                case 2: {
                    i2 = (int)rnds[0];
                    int j = (int)rnds[1];
                    if (j >= i2) {
                        ++j;
                    }
                    return Create.newArray(context, this.eltOk(i2), this.eltOk(j));
                }
                case 3: {
                    i2 = (int)rnds[0];
                    int j = (int)rnds[1];
                    k = (int)rnds[2];
                    int l = j;
                    int g = i2;
                    if (j >= i2) {
                        l = i2;
                        g = ++j;
                    }
                    if (k >= l && ++k >= g) {
                        ++k;
                    }
                    return Create.newArray(context, this.eltOk(i2), this.eltOk(j), this.eltOk(k));
                }
            }
            if (n > len) {
                n = len;
            }
            if (n <= 10) {
                int[] idx = new int[10];
                int[] sorted = new int[10];
                sorted[0] = idx[0] = (int)rnds[0];
                for (i2 = 1; i2 < n; ++i2) {
                    int j;
                    k = (int)rnds[i2];
                    for (j = 0; j < i2 && k >= sorted[j]; ++k, ++j) {
                    }
                    System.arraycopy(sorted, j, sorted, j + 1, i2 - j);
                    sorted[j] = idx[i2] = k;
                }
                IRubyObject[] result2 = IRubyObject.array(n);
                for (i2 = 0; i2 < n; ++i2) {
                    result2[i2] = this.eltOk(idx[i2]);
                }
                return RubyArray.newArrayMayCopy(context.runtime, result2);
            }
            IRubyObject[] result3 = IRubyObject.array(len);
            System.arraycopy(this.values, this.begin, result3, 0, len);
            for (i2 = 0; i2 < n; ++i2) {
                int j = (int)RubyRandom.randomLongLimited(context, randgen, len - i2 - 1) + i2;
                IRubyObject tmp = result3[j];
                result3[j] = result3[i2];
                result3[i2] = tmp;
            }
            RubyArray ary = RubyArray.newArrayNoCopy(context.runtime, result3);
            ary.realLength = n;
            return ary;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    private static long randUpto(ThreadContext context, IRubyObject randgen, int max2) {
        return RubyRandom.randomLongLimited(context, randgen, max2 - 1);
    }

    private static void aryReverse(IRubyObject[] _p1, int p1, IRubyObject[] _p2, int p2) {
        while (p1 < p2) {
            IRubyObject tmp = _p1[p1];
            _p1[p1++] = _p2[p2];
            _p2[p2--] = tmp;
        }
    }

    protected IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        this.modify(context);
        try {
            if (cnt != 0) {
                IRubyObject[] ptr = this.values;
                int len = this.realLength;
                if (len > 0 && (cnt = RubyArray.rotateCount(cnt, len)) > 0) {
                    if (cnt < --len) {
                        RubyArray.aryReverse(ptr, this.begin + cnt, ptr, this.begin + len);
                    }
                    if (--cnt > 0) {
                        RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + cnt);
                    }
                    if (len > 0) {
                        RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + len);
                    }
                    return this;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return context.nil;
    }

    private static int rotateCount(int cnt, int len) {
        return cnt < 0 ? len - ~cnt % len - 1 : cnt % len;
    }

    protected IRubyObject internalRotate(ThreadContext context, int cnt) {
        int len = this.realLength;
        RubyArray rotated = this.aryDup();
        rotated.modify(context);
        try {
            if (len > 0) {
                cnt = RubyArray.rotateCount(cnt, len);
                IRubyObject[] ptr = this.values;
                IRubyObject[] ptr2 = rotated.values;
                System.arraycopy(ptr, this.begin + cnt, ptr2, 0, len -= cnt);
                System.arraycopy(ptr, this.begin, ptr2, len, cnt);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
        return rotated;
    }

    @JRubyMethod(name={"rotate!"})
    public IRubyObject rotate_bang(ThreadContext context) {
        this.internalRotateBang(context, 1);
        return this;
    }

    @JRubyMethod(name={"rotate!"})
    public IRubyObject rotate_bang(ThreadContext context, IRubyObject cnt) {
        this.internalRotateBang(context, Convert.toInt(context, cnt));
        return this;
    }

    @JRubyMethod(name={"rotate"})
    public IRubyObject rotate(ThreadContext context) {
        return this.internalRotate(context, 1);
    }

    @JRubyMethod(name={"rotate"})
    public IRubyObject rotate(ThreadContext context, IRubyObject cnt) {
        return this.internalRotate(context, Convert.toInt(context, cnt));
    }

    @JRubyMethod(name={"all?"})
    public IRubyObject all_p(ThreadContext context, Block block) {
        return this.all_pCommon(context, null, block);
    }

    @JRubyMethod(name={"all?"})
    public IRubyObject all_p(ThreadContext context, IRubyObject arg2, Block block) {
        return this.all_pCommon(context, arg2, block);
    }

    public IRubyObject all_pCommon(ThreadContext context, IRubyObject arg2, Block block) {
        boolean patternGiven;
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.all_pCommon(context, self_each, this, arg2, block);
        }
        boolean bl = patternGiven = arg2 != null;
        if (block.isGiven() && patternGiven) {
            Warn.warn(context, "given block not used");
        }
        if (!block.isGiven() || patternGiven) {
            return this.all_pBlockless(context, arg2);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return context.fals;
        }
        return context.tru;
    }

    private IRubyObject all_pBlockless(ThreadContext context, IRubyObject pattern) {
        if (pattern == null) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (this.eltOk(i2).isTrue()) continue;
                return context.fals;
            }
        } else {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                if (pattern.callMethod(context, "===", (IRubyObject)this.eltOk(i3)).isTrue()) continue;
                return context.fals;
            }
        }
        return context.tru;
    }

    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, Block block) {
        return this.any_pCommon(context, null, block);
    }

    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, IRubyObject arg2, Block block) {
        return this.any_pCommon(context, arg2, block);
    }

    public IRubyObject any_pCommon(ThreadContext context, IRubyObject arg2, Block block) {
        boolean patternGiven;
        if (this.isEmpty()) {
            return context.fals;
        }
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.any_pCommon(context, self_each, this, arg2, block);
        }
        boolean bl = patternGiven = arg2 != null;
        if (block.isGiven() && patternGiven) {
            Warn.warn(context, "given block not used");
        }
        if (!block.isGiven() || patternGiven) {
            return this.any_pBlockless(context, arg2);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return context.tru;
        }
        return context.fals;
    }

    private IRubyObject any_pBlockless(ThreadContext context, IRubyObject pattern) {
        if (pattern == null) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (!this.eltOk(i2).isTrue()) continue;
                return context.tru;
            }
        } else {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                if (!pattern.callMethod(context, "===", (IRubyObject)this.eltOk(i3)).isTrue()) continue;
                return context.tru;
            }
        }
        return context.fals;
    }

    @JRubyMethod(name={"none?"})
    public IRubyObject none_p(ThreadContext context, Block block) {
        return this.none_pCommon(context, null, block);
    }

    @JRubyMethod(name={"none?"})
    public IRubyObject none_p(ThreadContext context, IRubyObject arg2, Block block) {
        return this.none_pCommon(context, arg2, block);
    }

    public IRubyObject none_pCommon(ThreadContext context, IRubyObject arg2, Block block) {
        boolean patternGiven;
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.none_pCommon(context, self_each, this, arg2, block);
        }
        boolean bl = patternGiven = arg2 != null;
        if (block.isGiven() && patternGiven) {
            Warn.warn(context, "given block not used");
        }
        if (!block.isGiven() || patternGiven) {
            return this.none_pBlockless(context, arg2);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return context.fals;
        }
        return context.tru;
    }

    private IRubyObject none_pBlockless(ThreadContext context, IRubyObject pattern) {
        if (pattern == null) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (!this.eltOk(i2).isTrue()) continue;
                return context.fals;
            }
        } else {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                if (!pattern.callMethod(context, "===", (IRubyObject)this.eltOk(i3)).isTrue()) continue;
                return context.fals;
            }
        }
        return context.tru;
    }

    @JRubyMethod(name={"one?"})
    public IRubyObject one_p(ThreadContext context, Block block) {
        return this.one_pCommon(context, null, block);
    }

    @JRubyMethod(name={"one?"})
    public IRubyObject one_p(ThreadContext context, IRubyObject arg2, Block block) {
        return this.one_pCommon(context, arg2, block);
    }

    public IRubyObject one_pCommon(ThreadContext context, IRubyObject arg2, Block block) {
        boolean patternGiven;
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.one_pCommon(context, self_each, this, arg2, block);
        }
        boolean bl = patternGiven = arg2 != null;
        if (block.isGiven() && patternGiven) {
            Warn.warn(context, "given block not used");
        }
        if (!block.isGiven() || patternGiven) {
            return this.one_pBlockless(context, arg2);
        }
        boolean found = false;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            if (found) {
                return context.fals;
            }
            found = true;
        }
        return found ? context.tru : context.fals;
    }

    private IRubyObject one_pBlockless(ThreadContext context, IRubyObject pattern) {
        boolean found = false;
        if (pattern == null) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (!this.eltOk(i2).isTrue()) continue;
                if (found) {
                    return context.fals;
                }
                found = true;
            }
        } else {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                if (!pattern.callMethod(context, "===", (IRubyObject)this.eltOk(i3)).isTrue()) continue;
                if (found) {
                    return context.fals;
                }
                found = true;
            }
        }
        return found ? context.tru : context.fals;
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context, Block block) {
        RubyFixnum zero = Convert.asFixnum(context, 0);
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        return !self_each.isBuiltin(this) ? RubyEnumerable.sumCommon(context, self_each, this, zero, block) : this.sumCommon(context, zero, block);
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context, IRubyObject init, Block block) {
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        return !self_each.isBuiltin(this) ? RubyEnumerable.sumCommon(context, self_each, this, init, block) : this.sumCommon(context, init, block);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject sumCommon(ThreadContext context, IRubyObject init, Block block) {
        int i2;
        IRubyObject result2 = init;
        boolean is_fixnum = false;
        boolean is_bignum = false;
        boolean is_rational = false;
        boolean is_float = false;
        if (result2 instanceof RubyFixnum) {
            is_fixnum = true;
        } else if (result2 instanceof RubyBignum) {
            is_bignum = true;
        } else if (result2 instanceof RubyRational) {
            is_rational = true;
        } else if (result2 instanceof RubyFloat) {
            is_float = true;
        }
        Object var10_10 = null;
        if (is_fixnum) {
            long sum2 = ((RubyFixnum)result2).value;
            for (i2 = 0; i2 < this.realLength; ++i2) {
                block46: {
                    void var10_14;
                    void var10_11;
                    if (var10_11 == null) {
                        T t = this.eltOk(i2);
                        if (block.isGiven()) {
                            IRubyObject iRubyObject = block.yield(context, (IRubyObject)t);
                        }
                    }
                    if (var10_14 instanceof RubyFixnum) {
                        try {
                            sum2 = Math.addExact(sum2, ((RubyFixnum)var10_14).value);
                            break block46;
                        }
                        catch (ArithmeticException ae) {
                            is_bignum = true;
                            break;
                        }
                    }
                    if (var10_14 instanceof RubyBignum) {
                        is_bignum = true;
                        break;
                    }
                    if (var10_14 instanceof RubyRational) {
                        is_rational = true;
                        break;
                    }
                    is_float = var10_14 instanceof RubyFloat;
                    break;
                }
                Object var10_15 = null;
            }
            result2 = is_bignum ? RubyBignum.newBignum(context.runtime, sum2) : (is_rational ? RubyRational.newRational(context.runtime, sum2, 1L) : (is_float ? Convert.asFloat(context, (double)sum2) : Convert.asFixnum(context, sum2)));
        }
        if (is_bignum) {
            BigInteger sum3 = ((RubyBignum)result2).value;
            while (i2 < this.realLength) {
                void var10_19;
                void var10_16;
                if (var10_16 == null) {
                    T t = this.eltOk(i2);
                    if (block.isGiven()) {
                        IRubyObject iRubyObject = block.yield(context, (IRubyObject)t);
                    }
                }
                if (var10_19 instanceof RubyFixnum) {
                    long val = ((RubyFixnum)var10_19).value;
                    sum3 = sum3.add(BigInteger.valueOf(val));
                } else if (var10_19 instanceof RubyBignum) {
                    sum3 = sum3.add(((RubyBignum)var10_19).value);
                } else {
                    if (var10_19 instanceof RubyRational) {
                        is_rational = true;
                        break;
                    }
                    is_float = var10_19 instanceof RubyFloat;
                    break;
                }
                Object var10_20 = null;
                ++i2;
            }
            result2 = is_rational ? RubyRational.newInstance(context, RubyBignum.newBignum(context.runtime, sum3)) : (is_float ? Convert.asFloat(context, sum3.doubleValue()) : RubyBignum.newBignum(context.runtime, sum3));
        }
        if (is_rational) {
            while (i2 < this.realLength) {
                void var10_24;
                void var10_21;
                if (var10_21 == null) {
                    T t = this.eltOk(i2);
                    if (block.isGiven()) {
                        IRubyObject iRubyObject = block.yield(context, (IRubyObject)t);
                    }
                }
                if (var10_24 instanceof RubyFixnum || var10_24 instanceof RubyBignum || var10_24 instanceof RubyRational) {
                    if (result2 instanceof RubyInteger) {
                        result2 = ((RubyInteger)result2).op_plus(context, (IRubyObject)var10_24);
                    } else {
                        if (!(result2 instanceof RubyRational)) throw Error.typeError(context, "BUG: unexpected type in rational part of Array#sum");
                        result2 = ((RubyRational)result2).op_plus(context, (IRubyObject)var10_24);
                    }
                } else {
                    if (!(var10_24 instanceof RubyFloat)) break;
                    result2 = Convert.asFloat(context, ((RubyRational)result2).asDouble(context));
                    is_float = true;
                    break;
                }
                Object var10_25 = null;
                ++i2;
            }
        }
        if (is_float) {
            double f = ((RubyFloat)result2).value;
            double c = 0.0;
            while (i2 < this.realLength) {
                void var10_29;
                void var10_26;
                if (var10_26 == null) {
                    T t = this.eltOk(i2);
                    if (block.isGiven()) {
                        IRubyObject iRubyObject = block.yield(context, (IRubyObject)t);
                    }
                }
                if (!(var10_29 instanceof RubyFloat) && !(var10_29 instanceof RubyFixnum) && !(var10_29 instanceof RubyBignum) && !(var10_29 instanceof RubyRational)) break;
                double x = ((RubyNumeric)var10_29).asDouble(context);
                if (!Double.isNaN(f)) {
                    if (Double.isNaN(x)) {
                        f = x;
                    } else if (Double.isInfinite(x)) {
                        f = Double.isInfinite(f) && Math.signum(x) != Math.signum(f) ? Double.NaN : x;
                    } else if (!Double.isInfinite(f)) {
                        double t = f + x;
                        c = Math.abs(f) >= Math.abs(x) ? (c += f - t + x) : (c += x - t + f);
                        f = t;
                    }
                }
                Object var10_30 = null;
                ++i2;
            }
            result2 = Convert.asFloat(context, f += c);
        }
        while (i2 < this.realLength) {
            void var10_34;
            void var10_31;
            if (var10_31 == null) {
                T t = this.eltOk(i2);
                if (block.isGiven()) {
                    IRubyObject iRubyObject = block.yield(context, (IRubyObject)t);
                }
            }
            result2 = result2.callMethod(context, "+", (IRubyObject)var10_34);
            Object var10_35 = null;
            ++i2;
        }
        return result2;
    }

    public IRubyObject find(ThreadContext context, IRubyObject ifnone, Block block) {
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.detectCommon(context, self_each, (IRubyObject)this, block);
        }
        return this.detectCommon(context, ifnone, block);
    }

    public IRubyObject find_index(ThreadContext context, Block block) {
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.find_indexCommon(context, self_each, this, block, Signature.OPTIONAL);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, (IRubyObject)this.eltOk(i2)).isTrue()) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    public IRubyObject find_index(ThreadContext context, IRubyObject cond) {
        CachingCallSite self_each = RubyArray.sites((ThreadContext)context).self_each;
        if (!self_each.isBuiltin(this)) {
            return RubyEnumerable.find_indexCommon(context, self_each, this, cond);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!this.eltOk(i2).equals(cond)) continue;
            return Convert.asFixnum(context, i2);
        }
        return context.nil;
    }

    public IRubyObject detectCommon(ThreadContext context, IRubyObject ifnone, Block block) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T value2 = this.eltOk(i2);
            if (!block.yield(context, (IRubyObject)value2).isTrue()) continue;
            return value2;
        }
        return ifnone != null && !ifnone.isNil() ? RubyArray.sites((ThreadContext)context).call.call(context, ifnone, ifnone) : context.nil;
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyArray array2, MarshalStream output) throws IOException {
        RubyArray.marshalTo(array2.getCurrentContext(), array2, output);
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(ThreadContext context, RubyArray array2, MarshalStream output) throws IOException {
        output.registerLinkTarget(context, array2);
        int length2 = array2.realLength;
        output.writeInt(length2);
        try {
            for (int i2 = 0; i2 < length2; ++i2) {
                output.dumpObject((IRubyObject)array2.eltInternal(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyArray array2, MarshalDumper output) {
        output.registerLinkTarget(array2);
        int length2 = array2.realLength;
        output.writeInt(out, length2);
        try {
            for (int i2 = 0; i2 < length2; ++i2) {
                output.dumpObject(context, out, (IRubyObject)array2.eltInternal(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        int size2 = input.unmarshalInt();
        ThreadContext context = input.getRuntime().getCurrentContext();
        RubyArray result2 = (RubyArray)input.entry(Create.allocArray(context, size2));
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.append(context, input.unmarshalObject());
        }
        return result2;
    }

    public static RubyArray unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        int size2 = input.unmarshalInt(context, in);
        RubyArray result2 = (RubyArray)input.entry(Create.allocArray(context, size2));
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.append(context, input.unmarshalObject(context, in));
        }
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyArray newBlankArray(Ruby runtime2, int size2) {
        return RubyArray.newBlankArray(runtime2.getCurrentContext(), size2);
    }

    public static RubyArray newBlankArray(ThreadContext context, int size2) {
        switch (size2) {
            case 0: {
                return Create.newEmptyArray(context);
            }
            case 1: {
                if (!USE_PACKED_ARRAYS) break;
                return new RubyArrayOneObject(context.runtime, context.nil);
            }
            case 2: {
                if (!USE_PACKED_ARRAYS) break;
                return new RubyArrayTwoObject(context.runtime, context.nil, context.nil);
            }
        }
        return RubyArray.newArray(context, size2);
    }

    static RubyArray newBlankArrayInternal(Ruby runtime2, int size2) {
        return RubyArray.newBlankArrayInternal(runtime2, runtime2.getArray(), size2);
    }

    static RubyArray newBlankArrayInternal(Ruby runtime2, RubyClass metaClass, int size2) {
        switch (size2) {
            case 0: {
                return RubyArray.newEmptyArray(runtime2);
            }
            case 1: {
                if (!USE_PACKED_ARRAYS) break;
                return new RubyArrayOneObject(metaClass, null);
            }
            case 2: {
                if (!USE_PACKED_ARRAYS) break;
                return new RubyArrayTwoObject(metaClass, null, null);
            }
        }
        return new RubyArray(runtime2, metaClass, size2);
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return arg2.checkArrayType();
    }

    @JRubyMethod(name={"pack"})
    public RubyString pack(ThreadContext context, IRubyObject obj) {
        RubyString format = obj.convertToString();
        try {
            RubyString buffer = Create.newString(context, new ByteList());
            return Pack.pack(context, this, format, buffer);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
    }

    @JRubyMethod(name={"pack"})
    public RubyString pack(ThreadContext context, IRubyObject obj, IRubyObject maybeOpts) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, maybeOpts);
        IRubyObject buffer = null;
        if (opts != context.nil) {
            buffer = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "buffer");
            if (buffer == context.nil) {
                buffer = null;
            }
            if (buffer != null && !(buffer instanceof RubyString)) {
                throw Error.typeError(context, "buffer must be String, not ", buffer, "");
            }
        }
        if (buffer == null) {
            buffer = Create.newString(context, new ByteList());
        }
        return Pack.pack(context, this, obj.convertToString(), (RubyString)buffer);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0) {
        return this.at(arg0);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject val = this.at(arg0);
        return RubyObject.dig1(context, val, arg1);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject val = this.at(arg0);
        return RubyObject.dig2(context, val, arg1, arg2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject val = this.at(args2[0]);
        return argc == 1 ? val : RubyObject.dig(context, val, args2, 1);
    }

    private IRubyObject maxWithBlock(ThreadContext context, Block block) {
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T v = this.eltOk(i2);
            if (result2 != UNDEF && RubyComparable.cmpint(context, op_gt2, op_lt2, block.yieldArray(context, Create.newArray(context, v, result2), null), v, result2) <= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"max"})
    public IRubyObject max(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.maxWithBlock(context, block);
        }
        if (this.realLength < 1) {
            return context.nil;
        }
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CachingCallSite op_cmp2 = sites.op_cmp_minmax;
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        int generation = this.getArg0Generation(op_cmp2);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T v = this.eltOk(i2);
            if (result2 != UNDEF && RubyArray.optimizedCmp(context, v, result2, generation, op_cmp2, op_gt2, op_lt2) <= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"max"})
    public IRubyObject max(ThreadContext context, IRubyObject num, Block block) {
        if (!num.isNil()) {
            return RubyEnumerable.max(context, this, num, block);
        }
        return this.max(context, block);
    }

    private IRubyObject minWithBlock(ThreadContext context, Block block) {
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T v = this.eltOk(i2);
            if (result2 != UNDEF && RubyComparable.cmpint(context, op_gt2, op_lt2, block.yieldArray(context, Create.newArray(context, v, result2), null), v, result2) >= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"min"})
    public IRubyObject min(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.minWithBlock(context, block);
        }
        if (this.realLength == 0) {
            return context.nil;
        }
        if (this.realLength == 1) {
            return this.eltInternal(0);
        }
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CachingCallSite op_cmp2 = sites.op_cmp_minmax;
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        int generation = this.getArg0Generation(op_cmp2);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            T v = this.eltOk(i2);
            if (result2 != UNDEF && RubyArray.optimizedCmp(context, v, result2, generation, op_cmp2, op_gt2, op_lt2) >= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    private int getArg0Generation(CachingCallSite op_cmp2) {
        T arg0 = this.eltInternal(0);
        RubyClass metaclass = arg0.getMetaClass();
        CacheEntry entry = op_cmp2.retrieveCache(metaclass);
        int generation = -1;
        if (entry.method.isBuiltin()) {
            generation = entry.token;
        }
        return generation;
    }

    @JRubyMethod(name={"min"})
    public IRubyObject min(ThreadContext context, IRubyObject num, Block block) {
        return num.isNil() ? this.min(context, block) : RubyEnumerable.min(context, this, num, block);
    }

    @JRubyMethod
    public IRubyObject minmax(ThreadContext context, Block block) {
        return block.isGiven() ? Helpers.invokeSuper(context, (IRubyObject)this, (RubyModule)Access.arrayClass(context), "minmax", NULL_ARRAY, block) : Create.newArray(context, this.callMethod("min"), this.callMethod("max"));
    }

    private static final int optimizedCmp(ThreadContext context, IRubyObject a, IRubyObject b2, int token2, CachingCallSite op_cmp2, CallSite op_gt2, CallSite op_lt2) {
        if (token2 == ((RubyBasicObject)a).metaClass.generation) {
            RubyObject aa;
            if (a instanceof RubyFixnum) {
                aa = (RubyFixnum)a;
                if (b2 instanceof RubyFixnum) {
                    RubyFixnum bb = (RubyFixnum)b2;
                    return Long.compare(((RubyFixnum)aa).getValue(), bb.getValue());
                }
            }
            if (a instanceof RubyString) {
                aa = (RubyString)a;
                if (b2 instanceof RubyString) {
                    RubyString bb = (RubyString)b2;
                    return ((RubyString)aa).op_cmp(bb);
                }
            }
        }
        return RubyComparable.cmpint(context, op_gt2, op_lt2, op_cmp2.call(context, a, a, b2), a, b2);
    }

    @Override
    public Class getJavaClass() {
        return List.class;
    }

    @Deprecated(since="10.0.0.0")
    public void copyInto(IRubyObject[] target2, int start2) {
        this.copyInto(this.getCurrentContext(), target2, start2);
    }

    public void copyInto(ThreadContext context, IRubyObject[] target2, int start2) {
        assert (target2.length - start2 >= this.realLength);
        RubyArray.safeArrayCopy(context, this.values, this.begin, target2, start2, this.realLength);
    }

    @Deprecated(since="10.0.0.0")
    public void copyInto(IRubyObject[] target2, int start2, int len) {
        this.copyInto(this.getCurrentContext(), target2, start2, len);
    }

    public void copyInto(ThreadContext context, IRubyObject[] target2, int start2, int len) {
        assert (target2.length - start2 >= len);
        RubyArray.safeArrayCopy(context, this.values, this.begin, target2, start2, len);
    }

    @Override
    public int size() {
        return this.realLength;
    }

    @Override
    public boolean isEmpty() {
        return this.realLength == 0;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] array2 = new Object[this.realLength];
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            array2[i2] = this.eltInternal(i2).toJava(Object.class);
        }
        return array2;
    }

    @Override
    public Object[] toArray(Object[] arg2) {
        Object[] array2 = arg2;
        Class<?> type2 = array2.getClass().getComponentType();
        if (array2.length < this.realLength) {
            array2 = (Object[])Array.newInstance(type2, this.realLength);
        }
        int length2 = this.realLength;
        for (int i2 = 0; i2 < length2; ++i2) {
            array2[i2] = this.eltInternal(i2).toJava(type2);
        }
        return array2;
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2.isArray()) {
            Class<?> type2 = target2.getComponentType();
            Object rawJavaArray = Array.newInstance(type2, this.realLength);
            try {
                ArrayUtils.copyDataToJavaArrayDirect(this, rawJavaArray);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw RubyArray.concurrentModification(this.getRuntime().getCurrentContext(), ex);
            }
            return target2.cast(rawJavaArray);
        }
        return super.toJava(target2);
    }

    @Override
    public boolean add(Object element) {
        return this.add(this.getRuntime().getCurrentContext(), element);
    }

    public boolean add(ThreadContext context, Object element) {
        this.append(context, JavaUtil.convertJavaToUsableRubyObject(context.runtime, element));
        return true;
    }

    @Override
    public boolean remove(Object element) {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        this.unpack(context);
        IRubyObject item = JavaUtil.convertJavaToUsableRubyObject(runtime2, element);
        boolean listchanged = false;
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = this.values[this.begin + i1];
            if (!RubyArray.equalInternal(context, e, item)) continue;
            this.delete_at(i1);
            listchanged = true;
            break;
        }
        return listchanged;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index2, Collection c) {
        Iterator iter = c.iterator();
        int i2 = index2;
        while (iter.hasNext()) {
            this.add(i2, iter.next());
            ++i2;
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean listChanged = false;
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            IRubyObject deleted = this.delete(context, JavaUtil.convertJavaToUsableRubyObject(runtime2, iter.next()), Block.NULL_BLOCK);
            if (deleted.isNil()) continue;
            listChanged = true;
        }
        return listChanged;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        for (Object element : this) {
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index2) {
        return this.elt(index2).toJava(Object.class);
    }

    public Object set(int index2, Object element) {
        Object previous = this.elt(index2).toJava(Object.class);
        this.store(index2, JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, element));
        return previous;
    }

    public void add(int index2, Object element) {
        this.insert(this.metaClass.runtime.getCurrentContext(), index2, JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, element));
    }

    public Object remove(int index2) {
        return this.delete_at(index2).toJava(Object.class);
    }

    @Override
    public int indexOf(Object element) {
        int myBegin = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, element);
            for (int i2 = myBegin; i2 < myBegin + this.realLength; ++i2) {
                if (!convertedElement.equals(this.values[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, element);
            for (int i2 = this.realLength - 1; i2 >= 0; --i2) {
                if (!convertedElement.equals(this.eltInternal(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int index2) {
        return new RubyArrayConversionListIterator(index2);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    @Override
    public void clear() {
        this.rb_clear(this.getRuntime().getCurrentContext());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyArray) {
            return this.op_equal(this.metaClass.runtime.getCurrentContext(), (RubyArray)other).isTrue();
        }
        return false;
    }

    private static IRubyObject safeArrayRef(ThreadContext context, IRubyObject[] values2, int i2) {
        try {
            return values2[i2];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    protected static IRubyObject safeArraySet(ThreadContext context, IRubyObject[] values2, int i2, IRubyObject value2) {
        try {
            values2[i2] = value2;
            return values2[i2];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    private static IRubyObject safeArrayRefSet(ThreadContext context, IRubyObject[] values2, int i2, IRubyObject value2) {
        try {
            IRubyObject tmp = values2[i2];
            values2[i2] = value2;
            return tmp;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw RubyArray.concurrentModification(context, e);
        }
    }

    private static IRubyObject safeArrayRefCondSet(ThreadContext context, IRubyObject[] values2, int i2, boolean doSet, IRubyObject value2) {
        try {
            IRubyObject tmp = values2[i2];
            if (doSet) {
                values2[i2] = value2;
            }
            return tmp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    private static void safeArrayCopy(ThreadContext context, IRubyObject[] source2, int sourceStart, IRubyObject[] target2, int targetStart, int length2) {
        try {
            System.arraycopy(source2, sourceStart, target2, targetStart, length2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw RubyArray.concurrentModification(context, ex);
        }
    }

    private static JavaSites.ArraySites sites(ThreadContext context) {
        return context.sites.Array;
    }

    @Deprecated(since="9.1.3.0")
    public void ensureCapacity(int minCapacity) {
        this.unpack(this.getCurrentContext());
        if (this.isShared || this.values.length - this.begin < minCapacity) {
            int len = this.realLength;
            int newCapacity = minCapacity > len ? minCapacity : len;
            Object[] values2 = IRubyObject.array(newCapacity);
            ArraySupport.copy(this.values, this.begin, values2, 0, len);
            this.values = values2;
            this.begin = 0;
        }
    }

    @Override
    @Deprecated(since="9.2.10.0")
    public RubyArray to_a() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        RubyClass arrayClass = Access.arrayClass(context);
        return this.metaClass != arrayClass ? this.dupImpl(context.runtime, arrayClass) : this;
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject shuffle(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.shuffle(context);
            }
            case 1: {
                return this.shuffle(context, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 0);
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject shuffle_bang(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.shuffle_bang(context, context.nil);
            }
            case 1: {
                return this.shuffle_bang(context, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 0);
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject sample(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.sample(context);
            }
            case 1: {
                return this.sample(context, args2[0]);
            }
            case 2: {
                return this.sample(context, args2[0], args2[1]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 1);
    }

    public Stream<IRubyObject> rubyStream() {
        return Stream.iterate(0, i2 -> i2 + 1).limit(this.realLength).map(this::eltInternal);
    }

    private static class JoinRecursive
    implements ThreadContext.RecursiveFunctionEx<State> {
        private JoinRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, State state2, IRubyObject obj, boolean recur) {
            if (recur) {
                throw Error.argumentError(context, "recursive array join");
            }
            state2.ary.joinAny(context, state2.sep, 0, state2.result, state2.first);
            return context.nil;
        }

        protected static class State {
            private final RubyArray ary;
            private final RubyString sep;
            private final RubyString result;
            private final boolean[] first;

            State(RubyArray ary, IRubyObject outValue, RubyString sep, RubyString result2, boolean[] first2) {
                this.ary = ary;
                this.sep = sep;
                this.result = result2;
                this.first = first2;
            }
        }
    }

    public static interface ArgumentVisitor {
        public IRubyObject visit(ThreadContext var1, IRubyObject var2, int var3);
    }

    public static class DefaultComparator
    implements Comparator<IRubyObject> {
        final ThreadContext context;
        private final boolean fixnumBypass;
        private final boolean stringBypass;

        public DefaultComparator(ThreadContext context) {
            this(context, true);
        }

        DefaultComparator(ThreadContext context, boolean honorOverride) {
            this.context = context;
            if (honorOverride && context != null) {
                this.fixnumBypass = !honorOverride || Access.fixnumClass(context).isMethodBuiltin("<=>");
                this.stringBypass = !honorOverride || Access.stringClass(context).isMethodBuiltin("<=>");
            } else {
                this.fixnumBypass = false;
                this.stringBypass = false;
            }
        }

        @Override
        public int compare(IRubyObject obj1, IRubyObject obj2) {
            if (this.fixnumBypass && obj1 instanceof RubyFixnum) {
                RubyFixnum fix1 = (RubyFixnum)obj1;
                if (obj2 instanceof RubyFixnum) {
                    RubyFixnum fix2 = (RubyFixnum)obj2;
                    return DefaultComparator.compareInteger(fix1, fix2);
                }
            }
            if (this.stringBypass && obj1 instanceof RubyString) {
                RubyString str1 = (RubyString)obj1;
                if (obj2 instanceof RubyString) {
                    RubyString str2 = (RubyString)obj2;
                    return DefaultComparator.compareString(str1, str2);
                }
            }
            return this.compareGeneric(obj1, obj2);
        }

        protected int compareGeneric(IRubyObject o1, IRubyObject o2) {
            ThreadContext context = this.context();
            return DefaultComparator.compareGeneric(context, RubyArray.sites((ThreadContext)context).op_cmp_sort, o1, o2);
        }

        protected ThreadContext context() {
            return this.context;
        }

        public static int compareInteger(RubyFixnum o1, RubyFixnum o2) {
            long b2;
            long a = o1.getValue();
            return a > (b2 = o2.getValue()) ? 1 : (a == b2 ? 0 : -1);
        }

        public static int compareString(RubyString o1, RubyString o2) {
            return o1.op_cmp(o2);
        }

        public static int compareGeneric(ThreadContext context, IRubyObject o1, IRubyObject o2) {
            return DefaultComparator.compareGeneric(context, RubyArray.sites((ThreadContext)context).op_cmp_sort, o1, o2);
        }

        public static int compareGeneric(ThreadContext context, CallSite op_cmp_sort, IRubyObject o1, IRubyObject o2) {
            IRubyObject ret = op_cmp_sort.call(context, o1, o1, o2);
            return RubyComparable.cmpint(context, ret, o1, o2);
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        @Override
        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject element = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return element.toJava(Object.class);
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int index2) {
            this.index = index2;
        }

        @Override
        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return RubyArray.this.elt(this.index).toJava(Object.class);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object obj) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToUsableRubyObject(RubyArray.this.metaClass.runtime, obj));
        }

        public void add(Object obj) {
            Ruby runtime2 = RubyArray.this.metaClass.runtime;
            RubyArray.this.insert(new IRubyObject[]{Convert.asFixnum(runtime2.getCurrentContext(), this.index++), JavaUtil.convertJavaToUsableRubyObject(runtime2, obj)});
            this.last = -1;
        }
    }

    static class BlockComparator
    implements Comparator<IRubyObject> {
        final ThreadContext context;
        protected final Block block;
        protected final IRubyObject self;
        private final CallSite gt;
        private final CallSite lt;

        BlockComparator(ThreadContext context, Block block, CallSite gt, CallSite lt) {
            this(context, block, null, gt, lt);
        }

        BlockComparator(ThreadContext context, Block block, IRubyObject self2, CallSite gt, CallSite lt) {
            this.context = context == null ? self2.getRuntime().getCurrentContext() : context;
            this.block = block;
            this.self = self2;
            this.gt = gt;
            this.lt = lt;
        }

        @Override
        public int compare(IRubyObject obj1, IRubyObject obj2) {
            return RubyComparable.cmpint(this.context, this.gt, this.lt, this.yieldBlock(obj1, obj2), obj1, obj2);
        }

        protected final IRubyObject yieldBlock(IRubyObject obj1, IRubyObject obj2) {
            return this.block.yieldArray(this.context, Create.newArray(this.context, obj1, obj2), this.self);
        }

        protected final ThreadContext context() {
            return this.context;
        }
    }
}

