/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.api.Access;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class GlobalSite
extends MutableCallSite {
    public static final Handle GLOBAL_BOOTSTRAP_H = new Handle(6, CodegenUtils.p(GlobalSite.class), "globalBootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE), false);
    private static final Logger LOG = LoggerFactory.getLogger(GlobalSite.class);
    private final String name;
    private volatile int failures;
    private final String file;
    private final int line;

    public GlobalSite(MethodType type2, String name2, String file2, int line) {
        super(type2);
        this.name = name2;
        this.file = file2;
        this.line = line;
    }

    @Override
    public void setTarget(MethodHandle target2) {
        super.setTarget(target2);
        this.incrementFailures();
    }

    public int failures() {
        return this.failures;
    }

    public void incrementFailures() {
        ++this.failures;
    }

    public String name() {
        return this.name;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public static CallSite globalBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = JavaNameMangler.demangleMethodName(names2[1]);
        GlobalSite site = new GlobalSite(type2, varName, file2, line);
        MethodHandle handle = operation.equals("get") ? lookup.findVirtual(GlobalSite.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, ThreadContext.class)) : lookup.findVirtual(GlobalSite.class, "setGlobalFallback", MethodType.methodType(Void.TYPE, IRubyObject.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public IRubyObject getGlobalFallback(ThreadContext context) throws Throwable {
        MethodHandle target2;
        GlobalVariable variable = Access.globalVariables(context).getVariable(this.name());
        if (this.failures() > (Integer)Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() || variable.getScope() != GlobalVariable.Scope.GLOBAL || RubyGlobal.UNCACHED_GLOBALS.contains(this.name())) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_GLOBALS.load()).booleanValue()) {
                LOG.info("global " + this.name() + " (" + this.file() + ":" + this.line() + ") uncacheable or rebound > " + String.valueOf(Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load()) + " times, reverting to simple lookup", new Object[0]);
            }
            MethodHandle uncached = MethodHandles.lookup().findStatic(GlobalSite.class, "getGlobalUncached", MethodType.methodType(IRubyObject.class, GlobalVariable.class));
            uncached = uncached.bindTo(variable);
            uncached = MethodHandles.dropArguments(uncached, 0, new Class[]{ThreadContext.class});
            this.setTarget(uncached);
            return (IRubyObject)uncached.invokeWithArguments(context);
        }
        SwitchPoint switchPoint = (SwitchPoint)variable.getInvalidator().getData();
        IAccessor accessor = variable.getAccessor();
        IRubyObject value2 = accessor.getValue();
        if (accessor instanceof UndefinedAccessor) {
            target2 = Binder.from((MethodType)this.type()).dropAll().append(new Object[]{accessor}).invokeVirtualQuiet("getValue");
        } else {
            target2 = MethodHandles.constant(IRubyObject.class, value2);
            target2 = MethodHandles.dropArguments(target2, 0, new Class[]{ThreadContext.class});
        }
        MethodHandle fallback = MethodHandles.lookup().findVirtual(GlobalSite.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, ThreadContext.class));
        fallback = fallback.bindTo(this);
        target2 = switchPoint.guardWithTest(target2, fallback);
        this.setTarget(target2);
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_GLOBALS.load()).booleanValue()) {
            LOG.info("global " + this.name() + " (" + this.file() + ":" + this.line() + ") cached", new Object[0]);
        }
        return value2;
    }

    public static IRubyObject getGlobalUncached(GlobalVariable variable) throws Throwable {
        return variable.getAccessor().getValue();
    }

    public void setGlobalFallback(IRubyObject value2, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        GlobalVariable variable = runtime2.getGlobalVariables().getVariable(this.name());
        MethodHandle uncached = MethodHandles.lookup().findStatic(GlobalSite.class, "setGlobalUncached", MethodType.methodType(Void.TYPE, GlobalVariable.class, IRubyObject.class));
        uncached = uncached.bindTo(variable);
        uncached = MethodHandles.dropArguments(uncached, 1, new Class[]{ThreadContext.class});
        this.setTarget(uncached);
        uncached.invokeWithArguments(value2, context);
    }

    public static void setGlobalUncached(GlobalVariable variable, IRubyObject value2) throws Throwable {
        variable.getAccessor().setValue(value2);
        variable.trace(value2);
        variable.invalidate();
    }
}

