/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.headius.backport9.buffer.Buffers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.posix.CmsgHdr;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    protected static final int F_GETFL = Fcntl.F_GETFL.intValue();
    protected static final int F_SETFL = Fcntl.F_SETFL.intValue();
    protected static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

    static RubyClass createUNIXSocket(ThreadContext context, RubyClass BasicSocket) {
        return (RubyClass)Define.defineClass(context, "UNIXSocket", BasicSocket, RubyUNIXSocket::new).defineMethods(context, RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject _fileno) {
        int fileno2 = Convert.toInt(context, _fileno);
        RubyClass klass = (RubyClass)recv2;
        RubyUNIXSocket unixSocket = (RubyUNIXSocket)Helpers.invoke(context, klass, "allocate");
        UnixSocketChannel channel = UnixSocketChannel.fromFD((int)fileno2);
        unixSocket.init_sock(context.runtime, (Channel)channel);
        return unixSocket;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context, path2, false);
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return Create.newEmptyString(context);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        return Create.newArray(context, (IRubyObject)Create.newString(context, "AF_UNIX"), (IRubyObject)Create.newEmptyString(context));
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        String _path = this.getUnixRemoteSocket(context).path();
        RubyString path2 = _path == null ? Create.newEmptyString(context) : Create.newString(context, _path);
        return Create.newArray(context, (IRubyObject)Create.newString(context, "AF_UNIX"), (IRubyObject)path2);
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1, checkArity=false)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject _length = args2[0];
        IRubyObject _flags = argc == 2 ? args2[1] : context.nil;
        int flags2 = _flags.isNil() ? 0 : Convert.toInt(context, _flags);
        return Create.newArray(context, this.recv(context, _length), this.peeraddr(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject send_io(ThreadContext context, IRubyObject arg2) {
        int fd;
        POSIX posix = context.runtime.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        if (arg2.callMethod(context, "kind_of?", Access.ioClass(context)).isTrue()) {
            fd = ((RubyIO)arg2).getOpenFileChecked().getFileno();
        } else if (arg2.callMethod(context, "kind_of?", Access.fixnumClass(context)).isTrue()) {
            fd = ((RubyFixnum)arg2).asInt(context);
        } else {
            throw Error.typeError(context, "neither IO nor file descriptor");
        }
        if (FilenoUtil.isFake(fd)) {
            throw Error.typeError(context, "file descriptor is not native");
        }
        byte[] dataBytes = new byte[]{0};
        MsgHdr outMessage = posix.allocateMsgHdr();
        ByteBuffer[] outIov = new ByteBuffer[]{ByteBuffer.allocateDirect(dataBytes.length)};
        outIov[0].put(dataBytes);
        Buffers.flipBuffer((Buffer)outIov[0]);
        outMessage.setIov(outIov);
        CmsgHdr outControl = outMessage.allocateControl(4);
        outControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        outControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, fd);
        outControl.setData(fdBuf);
        boolean locked2 = fptr.lock();
        try {
            while (posix.sendmsg(fptr.getFileno(), outMessage, 0) == -1) {
                if (fptr.waitWritable(context)) continue;
                throw context.runtime.newErrnoFromInt(posix.errno(), "sendmsg(2)");
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=2, checkArity=false)
    public IRubyObject recv_io(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 2);
        POSIX posix = context.runtime.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        IRubyObject klass = argc > 0 ? args2[0] : Access.ioClass(context);
        IRubyObject mode2 = argc > 1 ? args2[1] : context.nil;
        MsgHdr inMessage = posix.allocateMsgHdr();
        ByteBuffer[] inIov = new ByteBuffer[]{ByteBuffer.allocateDirect(1)};
        inMessage.setIov(inIov);
        CmsgHdr inControl = inMessage.allocateControl(4);
        inControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        inControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, -1);
        inControl.setData(fdBuf);
        boolean locked2 = fptr.lock();
        try {
            while (posix.recvmsg(fptr.getFileno(), inMessage, 0) == -1) {
                if (fptr.waitReadable(context)) continue;
                throw context.runtime.newErrnoFromInt(posix.errno(), "recvmsg(2)");
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        ByteBuffer inFdBuf = inMessage.getControls()[0].getData();
        inFdBuf.order(ByteOrder.nativeOrder());
        RubyFixnum fd = Convert.asFixnum(context, inFdBuf.getInt());
        if (klass.isNil()) {
            return fd;
        }
        if (mode2.isNil()) {
            return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd);
        }
        return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd, mode2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, checkArity=false, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 2);
        Ruby runtime2 = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass UNIXSocket = Access.getClass(context, "UNIXSocket");
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock.init_sock(runtime2, (Channel)sp[0], "");
            RubyUNIXSocket sock2 = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock2.init_sock(runtime2, (Channel)sp[1], "");
            return Create.newArray(context, (IRubyObject)sock, (IRubyObject)sock2);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    @Override
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        SocketLevel level2 = SocketUtils.levelFromArg(context, _level);
        SocketOption opt = SocketUtils.optionFromArg(context, _opt);
        block0 : switch (level2) {
            case SOL_SOCKET: {
                switch (opt) {
                    case SO_KEEPALIVE: {
                        break block0;
                    }
                }
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
            default: {
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
        }
        return Convert.asFixnum(context, 0);
    }

    protected static void rb_sys_fail(Ruby runtime2, String message2) {
        int n = LastError.getLastError((Runtime)Runtime.getSystemRuntime());
        RubyClass instance = runtime2.getErrno(n);
        if (instance == null) {
            throw runtime2.newSystemCallError(message2);
        }
        throw runtime2.newErrnoFromInt(n, message2);
    }

    protected void init_unixsock(ThreadContext context, IRubyObject _path, boolean server) {
        RubyString strPath = RubyUNIXSocket.unixsockPathValue(context, _path);
        ByteList path2 = strPath.getByteList();
        String fpath = Helpers.decodeByteList(context.runtime, path2);
        int maxSize = 103;
        if (fpath.length() > 103) {
            throw Error.argumentError(context, "too long unix socket path (max: " + maxSize + "bytes)");
        }
        Closeable closeable = null;
        try {
            if (server) {
                UnixServerSocketChannel channel = UnixServerSocketChannel.open();
                UnixServerSocket socket2 = channel.socket();
                closeable = channel;
                socket2.bind((SocketAddress)new UnixSocketAddress(new File(fpath)));
                this.init_sock(context.runtime, (Channel)channel, fpath);
            } else {
                File fpathFile = new File(fpath);
                if (!fpathFile.exists()) {
                    throw context.runtime.newErrnoENOENTError("unix socket");
                }
                UnixSocketChannel channel = UnixSocketChannel.open();
                closeable = channel;
                channel.connect(new UnixSocketAddress(fpathFile));
                this.init_sock(context.runtime, (Channel)channel);
            }
            closeable = null;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static RubyString unixsockPathValue(ThreadContext context, IRubyObject path2) {
        return Check.checkEmbeddedNulls(context, path2.convertToString());
    }

    protected void init_sock(Ruby runtime2, Channel channel, String path2) {
        this.MakeOpenFile();
        ModeFlags modes = RubyUNIXSocket.newModeFlags(runtime2, ModeFlags.RDWR);
        this.openFile.setFD(RubyUNIXSocket.newChannelFD(runtime2, channel));
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
        this.openFile.setPath(path2);
    }

    protected void init_sock(Ruby runtime2, Channel channel) {
        this.init_sock(runtime2, channel, null);
    }
}

