/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import java.math.RoundingMode;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Integer"}, parent="Numeric", overrides={RubyFixnum.class, RubyBignum.class})
public abstract class RubyInteger
extends RubyNumeric {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    static final byte[][] SINGLE_CHAR_BYTES;
    static final ByteList[] SINGLE_CHAR_USASCII_BYTELISTS;
    static final ByteList[] SINGLE_CHAR_ASCII8BIT_BYTELISTS;
    static final ByteList[] SINGLE_CHAR_UTF8_BYTELISTS;
    public static final int NUMERR_TYPE = 1;
    public static final int NUMERR_NEGATIVE = 2;
    public static final int NUMERR_TOOLARGE = 3;
    private static final long HALF_LONG_MSB = 0x80000000L;

    public static RubyClass createIntegerClass(ThreadContext context, RubyClass Numeric2) {
        return ((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Integer", Numeric2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyInteger.class)).kindOf(new RubyModule.JavaClassKindOf(RubyInteger.class))).classIndex(ClassIndex.INTEGER)).defineMethods(context, RubyInteger.class).tap(c -> c.singletonClass(context).undefMethods(context, "new"));
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyInteger(RubyClass rubyClass) {
        super(rubyClass);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime2, rubyClass, useObjectSpace);
    }

    @Deprecated
    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, rubyClass, useObjectSpace, canBeTainted);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return Convert.asFloat(context, this.asDouble(context));
    }

    @Deprecated(since="10.0")
    public int signum() {
        return this.signum(this.getCurrentContext());
    }

    @JRubyAPI
    public int signum(ThreadContext context) {
        return this.asBigInteger(context).signum();
    }

    @Deprecated(since="10.0")
    public RubyInteger negate() {
        return this.negate(this.getCurrentContext());
    }

    public RubyInteger negate(ThreadContext context) {
        return Convert.toInteger(context, RubyInteger.sites((ThreadContext)context).op_uminus.call(context, this, this));
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        return Convert.asBoolean(context, this.isNegativeNumber(context));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        return Convert.asBoolean(context, this.isPositiveNumber(context));
    }

    @Override
    public boolean isNegativeNumber(ThreadContext context) {
        return this.signum(context) < 0;
    }

    @Override
    public boolean isPositiveNumber(ThreadContext context) {
        return this.signum(context) > 0;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject sqrt(ThreadContext context, IRubyObject self2, IRubyObject num) {
        return Convert.toInteger(context, num).sqrt(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self2, IRubyObject num) {
        return TypeConverter.checkIntegerType(context, num);
    }

    public abstract IRubyObject sqrt(ThreadContext var1);

    public static final long floorSqrt(long x) {
        if ((x & 0xFFF0000000000000L) == 0L) {
            return (long)StrictMath.sqrt(x);
        }
        long result2 = (long)StrictMath.sqrt(2.0 * (double)(x >>> 1));
        return result2 * result2 - x > 0L ? result2 - 1L : result2;
    }

    public static final BigInteger floorSqrt(BigInteger x) {
        if (x == null) {
            return null;
        }
        int zeroCompare = x.compareTo(BigInteger.ZERO);
        if (zeroCompare < 0) {
            return null;
        }
        if (zeroCompare == 0) {
            return BigInteger.ZERO;
        }
        int bit = Math.max(0, x.bitLength() - 63 & 0xFFFFFFFE);
        BigInteger result2 = BigInteger.valueOf(RubyInteger.floorSqrt(x.shiftRight(bit).longValue()) & 0xFFFFFFFFL);
        result2 = result2.shiftLeft(bit >>>= 1);
        while (bit != 0) {
            BigInteger resultHigh;
            if ((resultHigh = result2.setBit(--bit)).multiply(resultHigh).compareTo(x) > 0) continue;
            result2 = resultHigh;
        }
        return result2;
    }

    @Override
    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p(ThreadContext context) {
        return context.tru;
    }

    @JRubyMethod
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumUpto(context, ((RubyFixnum)this).value, ((RubyFixnum)to).value, block);
            } else {
                RubyInteger.duckUpto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "upto", new IRubyObject[]{to}, RubyInteger::uptoSize);
    }

    static void fixnumUpto(ThreadContext context, long from, long to, Block block) {
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = context.nil;
            for (i2 = from; i2 < to; ++i2) {
                block.yield(context, nil);
                context.pollThreadEvents();
            }
            if (i2 <= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            for (i3 = from; i3 < to; ++i3) {
                block.yield(context, Convert.asFixnum(context, i3));
                context.pollThreadEvents();
            }
            if (i3 <= to) {
                block.yield(context, Convert.asFixnum(context, i3));
            }
        }
    }

    static void duckUpto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        IRubyObject i2 = from;
        RubyFixnum one = Convert.asFixnum(context, 1);
        while (!RubyInteger.sites((ThreadContext)context).op_gt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_plus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static IRubyObject uptoSize(ThreadContext context, IRubyObject from, IRubyObject[] args2) {
        return RubyInteger.intervalStepSize(context, from, args2[0], RubyFixnum.one(context.runtime), false);
    }

    @JRubyMethod
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumDownto(context, ((RubyFixnum)this).value, ((RubyFixnum)to).value, block);
            } else {
                RubyInteger.duckDownto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "downto", new IRubyObject[]{to}, RubyInteger::downtoSize);
    }

    private static void fixnumDownto(ThreadContext context, long from, long to, Block block) {
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = context.nil;
            for (i2 = from; i2 > to; --i2) {
                block.yield(context, nil);
            }
            if (i2 >= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            for (i3 = from; i3 > to; --i3) {
                block.yield(context, Convert.asFixnum(context, i3));
            }
            if (i3 >= to) {
                block.yield(context, Convert.asFixnum(context, i3));
            }
        }
    }

    private static void duckDownto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(context.runtime);
        while (!RubyInteger.sites((ThreadContext)context).op_lt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_minus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static IRubyObject downtoSize(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyInteger.intervalStepSize(context, recv2, args2[0], Convert.asFixnum(context, -1), false);
    }

    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "times", RubyInteger::timesSize);
        }
        IRubyObject i2 = Convert.asFixnum(context, 0);
        RubyFixnum one = Convert.asFixnum(context, 1);
        while (((RubyInteger)i2).op_lt(context, this).isTrue()) {
            block.yield(context, i2);
            i2 = ((RubyInteger)i2).op_plus(context, one);
        }
        return this;
    }

    protected static IRubyObject timesSize(ThreadContext context, RubyInteger recv2, IRubyObject[] args2) {
        RubyFixnum fixnum;
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (recv2 instanceof RubyFixnum && (fixnum = (RubyFixnum)recv2).getValue() < 0L || RubyInteger.sites((ThreadContext)context).op_lt.call(context, (IRubyObject)recv2, (IRubyObject)recv2, (IRubyObject)zero).isTrue()) {
            return zero;
        }
        return recv2;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return ((RubyFixnum)this).op_plus_one(context);
        }
        if (this instanceof RubyBignum) {
            return ((RubyBignum)this).op_plus(context, 1L);
        }
        return RubyInteger.numFuncall(context, this, RubyInteger.sites((ThreadContext)context).op_plus, RubyFixnum.one(context.runtime));
    }

    public static ByteList singleCharByteList(byte index2) {
        if (index2 >= 0) {
            return SINGLE_CHAR_USASCII_BYTELISTS[index2];
        }
        return SINGLE_CHAR_ASCII8BIT_BYTELISTS[Byte.toUnsignedInt(index2)];
    }

    static ByteList singleCharUSASCIIByteList(byte index2) {
        return SINGLE_CHAR_USASCII_BYTELISTS[index2];
    }

    static ByteList singleCharASCII8BITByteList(byte index2) {
        return SINGLE_CHAR_ASCII8BIT_BYTELISTS[Byte.toUnsignedInt(index2)];
    }

    public static ByteList singleCharUTF8ByteList(byte index2) {
        return SINGLE_CHAR_UTF8_BYTELISTS[Byte.toUnsignedInt(index2)];
    }

    public static RubyString singleCharString(Ruby runtime2, byte b2, RubyClass meta, Encoding enc) {
        ByteList bytes2 = null;
        int ub = Byte.toUnsignedInt(b2);
        if (enc == ASCIIEncoding.INSTANCE) {
            bytes2 = RubyInteger.singleCharASCII8BITByteList(b2);
        } else if (ub < 128) {
            if (enc == USASCIIEncoding.INSTANCE) {
                bytes2 = RubyInteger.singleCharUSASCIIByteList(b2);
            } else if (enc == RubyString.UTF8) {
                bytes2 = RubyInteger.singleCharUTF8ByteList(b2);
            }
        }
        if (bytes2 == null) {
            return RubyString.newStringShared(runtime2, SINGLE_CHAR_BYTES[ub], enc);
        }
        return RubyString.newStringShared(runtime2, meta, bytes2);
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context) {
        long uint = this.toUnsignedInteger(context);
        if (uint > 255L) {
            Encoding enc = context.runtime.getDefaultInternalEncoding();
            if (enc == null) {
                throw Error.rangeError(context, uint + " out of char range");
            }
            return this.chrCommon(context, uint, enc);
        }
        return Create.newSharedString(context, RubyInteger.singleCharByteList((byte)uint));
    }

    private long toUnsignedInteger(ThreadContext context) {
        long uintResult = RubyInteger.numToUint(context, this);
        long uint = uintResult >>> 32;
        int ret = (int)(uintResult & 0xFFFFFFFFFFFFFFFFL);
        if (ret != 0) {
            throw Error.rangeError(context, (String)(this instanceof RubyFixnum ? this.asLong(context) + " out of char range" : "bignum out of char range"));
        }
        return uint;
    }

    @Deprecated(since="10.0")
    public static long numToUint(IRubyObject val) {
        return RubyInteger.numToUint(((RubyBasicObject)val).getCurrentContext(), val);
    }

    public static long numToUint(ThreadContext context, IRubyObject val) {
        if (val instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)val;
            long v = fixnum.getValue();
            if (v > 0xFFFFFFFFL) {
                return 3L;
            }
            if (v < 0L) {
                return 2L;
            }
            return v << 32;
        }
        if (val instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)val;
            if (bignum.isNegativeNumber(context)) {
                return 2L;
            }
            return 3L;
        }
        return 1L;
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context, IRubyObject arg2) {
        Encoding encoding2;
        long uint = this.toUnsignedInteger(context);
        if (arg2 instanceof RubyEncoding) {
            RubyEncoding encArg = (RubyEncoding)arg2;
            encoding2 = encArg.getEncoding();
        } else {
            encoding2 = Access.encodingService(context).findEncoding(arg2.convertToString());
        }
        Encoding enc = encoding2;
        return this.chrCommon(context, uint, enc);
    }

    private RubyString chrCommon(ThreadContext context, long value2, Encoding enc) {
        if (value2 > 0xFFFFFFFFL) {
            throw Error.rangeError(context, String.valueOf(this) + " out of char range");
        }
        int c = (int)value2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        return EncodingUtils.encUintChr(context, c, enc);
    }

    @JRubyMethod(name={"ord"})
    public IRubyObject ord(ThreadContext context) {
        return this;
    }

    @Deprecated(since="10.0")
    public IRubyObject to_i() {
        return this.to_i(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_i(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"ceil"})
    public abstract IRubyObject ceil(ThreadContext var1, IRubyObject var2);

    protected RubyNumeric integerCeil(ThreadContext context, RubyNumeric f) {
        boolean neg = this.signum(context) < 0;
        RubyNumeric num = neg ? (RubyNumeric)this.op_uminus(context) : (RubyNumeric)this.op_plus(context, f.op_minus(context, Convert.asFixnum(context, 1)));
        num = (RubyNumeric)((RubyInteger)num.div(context, f)).op_mul(context, f);
        if (neg) {
            num = (RubyNumeric)num.op_uminus(context);
        }
        return num;
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"floor"})
    public abstract IRubyObject floor(ThreadContext var1, IRubyObject var2);

    protected RubyNumeric integerFloor(ThreadContext context, RubyInteger f) {
        boolean neg;
        RubyNumeric num = this;
        boolean bl = neg = this.signum(context) < 0;
        if (neg) {
            num = (RubyNumeric)((RubyInteger)((RubyInteger)num.op_uminus(context)).op_plus(context, f)).op_minus(context, 1L);
        }
        num = (RubyNumeric)((RubyInteger)num.div(context, f)).op_mul(context, f);
        if (neg) {
            num = (RubyNumeric)num.op_uminus(context);
        }
        return num;
    }

    @Override
    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"truncate"})
    public abstract IRubyObject truncate(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject _digits) {
        return this.round(context, _digits, context.nil);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject digits2, IRubyObject _opts) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, _opts);
        int ndigits = Convert.toInt(context, digits2);
        RoundingMode roundingMode = RubyInteger.getRoundingMode(context, opts);
        if (ndigits >= 0) {
            return this;
        }
        return this.roundShared(context, ndigits, roundingMode);
    }

    public IRubyObject round(ThreadContext context, int ndigits) {
        return this.roundShared(context, ndigits, RoundingMode.HALF_UP);
    }

    public RubyNumeric roundShared(ThreadContext context, int ndigits, RoundingMode roundingMode) {
        if (this.int_round_zero_p(context, ndigits)) {
            return Convert.asFixnum(context, 0);
        }
        RubyNumeric f = Numeric.int_pow(context, 10L, -ndigits);
        RubyInteger rubyInteger = this;
        if (rubyInteger instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)rubyInteger;
            if (f instanceof RubyFixnum) {
                boolean neg;
                RubyFixnum ff = (RubyFixnum)f;
                long x = fixnum.getValue();
                long y = ff.getValue();
                boolean bl = neg = x < 0L;
                if (neg) {
                    x = -x;
                }
                x = RubyInteger.doRound(context, roundingMode, x, y);
                if (neg) {
                    x = -x;
                }
                return Convert.asFixnum(context, x);
            }
        }
        if (f instanceof RubyFloat) {
            return Convert.asFixnum(context, 0);
        }
        RubyNumeric h = (RubyNumeric)f.idiv(context, 2L);
        RubyNumeric r = (RubyNumeric)this.op_mod(context, f);
        RubyNumeric n = (RubyNumeric)this.op_minus(context, r);
        if ((r = (RubyNumeric)r.op_cmp(context, h)).isPositiveNumber(context) || r.isZero(context) && RubyInteger.doRoundCheck(context, roundingMode, this, n, f)) {
            n = (RubyNumeric)n.op_plus(context, f);
        }
        return n;
    }

    private static long doRound(ThreadContext context, RoundingMode roundingMode, long n, long f) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyInteger.int_round_half_up(n, f);
            }
            case HALF_DOWN: {
                return RubyInteger.int_round_half_down(n, f);
            }
            case HALF_EVEN: {
                return RubyInteger.int_round_half_even(n, f);
            }
        }
        throw Error.argumentError(context, "invalid rounding mode: " + String.valueOf((Object)roundingMode));
    }

    private static boolean doRoundCheck(ThreadContext context, RoundingMode roundingMode, RubyInteger num, RubyNumeric n, IRubyObject f) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyInteger.int_half_p_half_up(context, num, n, f);
            }
            case HALF_DOWN: {
                return RubyInteger.int_half_p_half_down(context, num, n, f);
            }
            case HALF_EVEN: {
                return RubyInteger.int_half_p_half_even(context, num, n, f);
            }
        }
        throw Error.argumentError(context, "invalid rounding mode: " + String.valueOf((Object)roundingMode));
    }

    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = Convert.toLong(context, RubyInteger.sites((ThreadContext)context).size.call(context, this, this));
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    protected static long int_round_half_even(long x, long y) {
        long z = (x + y / 2L) / y;
        if ((z * y - x) * 2L == y) {
            z &= 0xFFFFFFFFFFFFFFFEL;
        }
        return z * y;
    }

    protected static long int_round_half_up(long x, long y) {
        return (x + y / 2L) / y * y;
    }

    protected static long int_round_half_down(long x, long y) {
        return (x + y / 2L - 1L) / y * y;
    }

    protected static boolean int_half_p_half_even(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return Convert.toInteger(context, n.div(context, f)).odd_p(context).isTrue();
    }

    protected static boolean int_half_p_half_up(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return num.isPositiveNumber(context);
    }

    protected static boolean int_half_p_half_down(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return num.isNegativeNumber(context);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"rationalize"}, optional=1, checkArity=false)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return this.to_r(context);
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p(ThreadContext context) {
        return RubyInteger.op_mod_two(context, this) != 0L ? context.tru : context.fals;
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p(ThreadContext context) {
        return RubyInteger.op_mod_two(context, this) == 0L ? context.tru : context.fals;
    }

    private static long op_mod_two(ThreadContext context, RubyInteger self2) {
        return ((RubyInteger)RubyInteger.sites((ThreadContext)context).op_mod.call(context, (IRubyObject)self2, (IRubyObject)self2, (IRubyObject)Convert.asFixnum(context, 2))).asLong(context);
    }

    @JRubyMethod(name={"allbits?"})
    public IRubyObject allbits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = Convert.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).op_equal(context, mask);
    }

    @JRubyMethod(name={"anybits?"})
    public IRubyObject anybits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = Convert.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).isZero(context) ? context.fals : context.tru;
    }

    @JRubyMethod(name={"nobits?"})
    public IRubyObject nobits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = Convert.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).zero_p(context);
    }

    @JRubyMethod(name={"pred"})
    public IRubyObject pred(ThreadContext context) {
        return RubyInteger.numFuncall(context, this, RubyInteger.sites((ThreadContext)context).op_minus, RubyFixnum.one(context.runtime));
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        return Numeric.f_gcd(context, this, RubyInteger.intValue(context, other));
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject y) {
        IRubyObject gcd2;
        RubyInteger x = this;
        if (y instanceof RubyInteger && !Numeric.f_zero_p(context, y) && !Numeric.f_zero_p(context, gcd2 = this.gcd(context, y))) {
            x = (RubyInteger)x.idiv(context, gcd2);
            y = ((RubyInteger)y).idiv(context, gcd2);
        }
        return x.fdivDouble(context, y);
    }

    public abstract IRubyObject fdivDouble(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"lcm"})
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        return Numeric.f_lcm(context, this, RubyInteger.intValue(context, other));
    }

    @JRubyMethod(name={"gcdlcm"})
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        RubyInteger otherInt = RubyInteger.intValue(context, other);
        return Create.newArray(context, (IRubyObject)Numeric.f_gcd(context, this, otherInt), Numeric.f_lcm(context, this, otherInt));
    }

    static RubyInteger intValue(ThreadContext context, IRubyObject num) {
        RubyInteger i2 = RubyInteger.toInteger(context, num);
        if (i2 == null) {
            throw Error.typeError(context, "not an integer");
        }
        return i2;
    }

    static RubyInteger toInteger(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyInteger) {
            return (RubyInteger)num;
        }
        if (num instanceof RubyNumeric && !RubyInteger.integer_p_site(context).call(context, num, num).isTrue()) {
            return null;
        }
        if (num instanceof RubyString) {
            return null;
        }
        return (RubyInteger)num.checkCallMethod(context, RubyInteger.sites((ThreadContext)context).to_i_checked);
    }

    @JRubyMethod(name={"digits"})
    public RubyArray digits(ThreadContext context) {
        return this.digits(context, Convert.asFixnum(context, 10));
    }

    @JRubyMethod(name={"digits"})
    public abstract RubyArray digits(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    @Deprecated(since="10.0")
    public RubyString to_s() {
        return this.to_s(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public RubyString to_s(ThreadContext context) {
        throw new RuntimeException("all numeric types must override this method");
    }

    @Deprecated(since="10.0")
    public RubyString to_s(IRubyObject x) {
        return this.to_s(this.getCurrentContext(), x);
    }

    @JRubyMethod(name={"to_s"})
    public RubyString to_s(ThreadContext context, IRubyObject x) {
        throw Error.runtimeError(context, "integer type missing native to_s(ThreadContext, IRubyObject) impl");
    }

    @Override
    @JRubyMethod(name={"-@"})
    public abstract IRubyObject op_uminus(ThreadContext var1);

    @Override
    @JRubyMethod(name={"+"})
    public abstract IRubyObject op_plus(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_plus(ThreadContext context, long other) {
        return this.op_plus(context, Convert.asFixnum(context, other));
    }

    @Override
    @JRubyMethod(name={"-"})
    public abstract IRubyObject op_minus(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_minus(ThreadContext context, long other) {
        return this.op_minus(context, Convert.asFixnum(context, other));
    }

    @JRubyMethod(name={"*"})
    public abstract IRubyObject op_mul(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_mul(ThreadContext context, long other) {
        return this.op_mul(context, Convert.asFixnum(context, other));
    }

    @Override
    @JRubyMethod(name={"div"})
    public abstract IRubyObject idiv(ThreadContext var1, IRubyObject var2);

    public final IRubyObject div_div(ThreadContext context, IRubyObject other) {
        return this.div(context, other);
    }

    @JRubyMethod(name={"/"})
    public abstract IRubyObject op_div(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"%", "modulo"})
    public abstract IRubyObject op_mod(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.op_mod(context, Convert.asFixnum(context, other));
    }

    @JRubyMethod(name={"**"})
    public abstract IRubyObject op_pow(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"pow"})
    public IRubyObject pow(ThreadContext context, IRubyObject other) {
        return RubyInteger.sites((ThreadContext)context).op_pow.call(context, (IRubyObject)this, (IRubyObject)this, other);
    }

    @JRubyMethod(name={"pow"})
    public IRubyObject pow(ThreadContext context, IRubyObject b2, IRubyObject m) {
        boolean negaFlg = false;
        RubyInteger base = Convert.castAsInteger(context, b2, "Integer#pow() 2nd argument not allowed unless a 1st argument is integer");
        if (base.isNegativeNumber(context)) {
            throw Error.rangeError(context, "Integer#pow() 1st argument cannot be negative when 2nd argument specified");
        }
        RubyInteger pow2 = Convert.castAsInteger(context, m, "Integer#pow() 2nd argument not allowed unless all arguments are integers");
        if (pow2.isNegativeNumber(context)) {
            pow2 = pow2.negate(context);
            negaFlg = true;
        }
        if (!pow2.isPositiveNumber(context)) {
            throw context.runtime.newZeroDivisionError();
        }
        if (pow2 instanceof RubyFixnum) {
            RubyFixnum fixpow = (RubyFixnum)pow2;
            long mm = fixpow.value;
            if (mm == 1L) {
                return Convert.asFixnum(context, 0);
            }
            RubyFixnum modulo2 = (RubyFixnum)this.modulo(context, fixpow);
            return mm <= 0x80000000L ? modulo2.intPowTmp1(context, base, mm, negaFlg) : modulo2.intPowTmp2(context, base, mm, negaFlg);
        }
        if (pow2 instanceof RubyBignum) {
            RubyBignum bigpow = (RubyBignum)pow2;
            return ((RubyBignum)m).value == BigInteger.ONE ? Convert.asFixnum(context, 0) : ((RubyInteger)this.modulo(context, m)).intPowTmp3(context, base, bigpow, negaFlg);
        }
        throw new AssertionError((Object)("BUG: unexpected type " + String.valueOf(m.getType())));
    }

    protected IRubyObject intPowTmp3(ThreadContext context, RubyInteger y, RubyBignum m, boolean negaFlg) {
        BigInteger mn;
        BigInteger yn;
        BigInteger xn = this.asBigInteger(context);
        BigInteger zn = xn.modPow(yn = y.asBigInteger(context), mn = m.asBigInteger(context));
        if (negaFlg & zn.signum() == 1) {
            zn = zn.negate();
        }
        return RubyBignum.bignorm(context.runtime, zn);
    }

    @Override
    @JRubyMethod(name={"abs"})
    public abstract IRubyObject abs(ThreadContext var1);

    @Override
    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"==", "==="})
    public abstract IRubyObject op_equal(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"<=>"})
    public abstract IRubyObject op_cmp(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"~"})
    public abstract IRubyObject op_neg(ThreadContext var1);

    @JRubyMethod(name={"&"})
    public abstract IRubyObject op_and(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"|"})
    public abstract IRubyObject op_or(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"^"})
    public abstract IRubyObject op_xor(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject index2) {
        if (index2 instanceof RubyRange) {
            RubyRange range = (RubyRange)index2;
            IRubyObject beg = range.begin(context);
            IRubyObject end2 = range.end(context);
            boolean isExclusive = range.isExcludeEnd();
            if (!end2.isNil()) {
                end2 = Convert.toInteger(context, end2);
            }
            if (beg.isNil()) {
                if (!RubyInteger.negativeInt(context, end2)) {
                    RubyInteger mask;
                    if (!isExclusive) {
                        end2 = ((RubyInteger)end2).op_plus(context, Convert.asFixnum(context, 1));
                    }
                    if (((RubyInteger)this.op_and(context, mask = this.generateMask(context, end2))).isZero(context)) {
                        return Convert.asFixnum(context, 0);
                    }
                    throw Error.argumentError(context, "The beginless range for Integer#[] results in infinity");
                }
                return Convert.asFixnum(context, 0);
            }
            beg = Convert.toInteger(context, beg);
            IRubyObject num = this.op_rshift(context, beg);
            long cmp2 = RubyInteger.compareIndexes(context, beg, end2);
            if (!end2.isNil() && cmp2 < 0L) {
                IRubyObject length2 = ((RubyInteger)end2).op_minus(context, beg);
                if (!isExclusive) {
                    length2 = ((RubyInteger)length2).op_plus(context, Convert.asFixnum(context, 1));
                }
                RubyInteger mask = this.generateMask(context, length2);
                num = ((RubyInteger)num).op_and(context, mask);
                return num;
            }
            if (cmp2 == 0L) {
                if (isExclusive) {
                    return Convert.asFixnum(context, 0);
                }
                index2 = beg;
            } else {
                return num;
            }
        }
        return this.op_aref_subclass(context, index2);
    }

    private static long compareIndexes(ThreadContext context, IRubyObject beg, IRubyObject end2) {
        IRubyObject r = beg.callMethod(context, "<=>", end2);
        if (r.isNil()) {
            return Long.MAX_VALUE;
        }
        JavaSites.IntegerSites sites = RubyInteger.sites(context);
        return RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, r, beg, end2);
    }

    protected abstract IRubyObject op_aref_subclass(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject index2, IRubyObject length2) {
        IRubyObject num = this.op_rshift(context, index2);
        RubyInteger mask = this.generateMask(context, length2);
        return ((RubyInteger)num).op_and(context, mask);
    }

    RubyInteger generateMask(ThreadContext context, IRubyObject length2) {
        RubyFixnum one = Convert.asFixnum(context, 1);
        return (RubyInteger)((RubyInteger)one.op_lshift(context, length2)).op_minus(context, one);
    }

    @JRubyMethod(name={"<<"})
    public abstract IRubyObject op_lshift(ThreadContext var1, IRubyObject var2);

    public RubyInteger op_lshift(ThreadContext context, long other) {
        return (RubyInteger)this.op_lshift(context, Convert.asFixnum(context, other));
    }

    @JRubyMethod(name={">>"})
    public abstract IRubyObject op_rshift(ThreadContext var1, IRubyObject var2);

    public RubyInteger op_rshift(ThreadContext context, long other) {
        return (RubyInteger)this.op_rshift(context, Convert.asFixnum(context, other));
    }

    @JRubyMethod(name={"to_f"})
    public abstract IRubyObject to_f(ThreadContext var1);

    @JRubyMethod(name={"size"})
    public abstract IRubyObject size(ThreadContext var1);

    @Override
    @JRubyMethod(name={"zero?"})
    public abstract IRubyObject zero_p(ThreadContext var1);

    @JRubyMethod(name={"bit_length"})
    public abstract IRubyObject bit_length(ThreadContext var1);

    @Deprecated(since="10.0")
    boolean isOne() {
        return this.isOne(this.getCurrentContext());
    }

    boolean isOne(ThreadContext context) {
        return this.asBigInteger(context).equals(BigInteger.ONE);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_le(context, this, other);
    }

    @Override
    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject dividend) {
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public IRubyObject op_uminus() {
        return this.op_uminus(this.getCurrentContext());
    }

    @Deprecated(since="10.0")
    public IRubyObject op_neg() {
        return this.to_f(this.getCurrentContext());
    }

    @Deprecated(since="10.0")
    public IRubyObject op_aref(IRubyObject other) {
        return this.op_aref(this.getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject op_lshift(IRubyObject other) {
        return this.op_lshift(this.getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject op_rshift(IRubyObject other) {
        return this.op_rshift(this.getCurrentContext(), other);
    }

    @Deprecated(since="10.0")
    public IRubyObject to_f() {
        return this.to_f(this.getCurrentContext());
    }

    @Deprecated(since="10.0")
    public IRubyObject size() {
        return this.size(this.getCurrentContext());
    }

    private static CallSite integer_p_site(ThreadContext context) {
        return context.sites.Numeric.integer;
    }

    private static JavaSites.IntegerSites sites(ThreadContext context) {
        return context.sites.Integer;
    }

    @Deprecated
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (!(other instanceof RubyFloat) && !(other instanceof RubyRational)) {
            throw Error.typeError(context, "failed to convert ", other, " into Integer");
        }
        return other.callMethod(context, "to_i");
    }

    @Override
    @Deprecated
    public IRubyObject round() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject ceil() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject floor() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject truncate() {
        return this;
    }

    @Deprecated
    public final IRubyObject op_idiv(ThreadContext context, IRubyObject arg2) {
        return this.div(context, arg2);
    }

    static {
        int i2;
        SINGLE_CHAR_BYTES = new byte[256][];
        for (i2 = 0; i2 < 256; ++i2) {
            byte[] bytes2 = new byte[]{(byte)i2};
            RubyInteger.SINGLE_CHAR_BYTES[i2] = bytes2;
        }
        SINGLE_CHAR_USASCII_BYTELISTS = new ByteList[128];
        for (i2 = 0; i2 < 128; ++i2) {
            RubyInteger.SINGLE_CHAR_USASCII_BYTELISTS[i2] = new ByteList(SINGLE_CHAR_BYTES[i2], (Encoding)USASCIIEncoding.INSTANCE, false);
        }
        SINGLE_CHAR_ASCII8BIT_BYTELISTS = new ByteList[256];
        for (i2 = 0; i2 < 256; ++i2) {
            RubyInteger.SINGLE_CHAR_ASCII8BIT_BYTELISTS[i2] = new ByteList(SINGLE_CHAR_BYTES[i2], (Encoding)ASCIIEncoding.INSTANCE, false);
        }
        SINGLE_CHAR_UTF8_BYTELISTS = new ByteList[128];
        for (i2 = 0; i2 < 128; ++i2) {
            RubyInteger.SINGLE_CHAR_UTF8_BYTELISTS[i2] = new ByteList(SINGLE_CHAR_BYTES[i2], (Encoding)UTF8Encoding.INSTANCE, false);
        }
    }
}

