/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.backport9.buffer.Buffers;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.PosixFadvise;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.posix.Linux;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.FiberScheduler;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIOError;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.API;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ThreadedRunnable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.IOChannel;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.ChannelHelper;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.Getline;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.POSIXProcess;
import org.jruby.util.io.PopenExecutor;
import org.jruby.util.io.PosixShim;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.SelectExecutor;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject
implements IOEncodable,
Closeable,
Flushable {
    public static final ByteList PARAGRAPH_SEPARATOR = ByteList.create("\n\n");
    public static final String CLOSED_STREAM_MSG = "closed stream";
    public static final int FD_CLOEXEC = 1;
    private static final Getline.Callback<RubyIO, IRubyObject> GETLINE = new Getline.Callback<RubyIO, IRubyObject>(){

        @Override
        public IRubyObject getline(ThreadContext context, RubyIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            IRubyObject result2 = self2.getlineImpl(context, rs, limit2, chomp2);
            if (result2 != context.nil) {
                context.setLastLine(result2);
            }
            return result2;
        }
    };
    private static final Getline.Callback<RubyIO, RubyIO> GETLINE_YIELD = new Getline.Callback<RubyIO, RubyIO>(){

        @Override
        public RubyIO getline(ThreadContext context, RubyIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            IRubyObject line;
            if (limit2 == 0) {
                throw Error.argumentError(context, "invalid limit: 0 for foreach");
            }
            while ((line = self2.getlineImpl(context, rs, limit2, chomp2)) != context.nil) {
                block.yieldSpecific(context, line);
            }
            return self2;
        }
    };
    private static final Getline.Callback<RubyIO, RubyArray> GETLINE_ARY = new Getline.Callback<RubyIO, RubyArray>(){

        @Override
        public RubyArray getline(ThreadContext context, RubyIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            IRubyObject line;
            RubyArray<?> ary = Create.newArray(context);
            while ((line = self2.getlineImpl(context, rs, limit2, chomp2)) != context.nil) {
                ary.append(context, line);
            }
            return ary;
        }
    };
    private static final ByteList RECURSIVE_BYTELIST = ByteList.create("[...]");
    static final Set<String> ALL_SPAWN_OPTIONS;
    static final String[] UNSUPPORTED_SPAWN_OPTIONS;
    protected OpenFile openFile;
    protected boolean popenSpecial;

    public RubyIO(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public RubyIO(Ruby runtime2, OutputStream outputStream) {
        this(runtime2, outputStream, true);
    }

    public RubyIO(Ruby runtime2, OutputStream outputStream, boolean autoclose2) {
        super(runtime2, runtime2.getIO());
        if (outputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = this.MakeOpenFile();
        this.openFile.setFD(new ChannelFD(ChannelHelper.writableChannel(outputStream), runtime2.getPosix(), runtime2.getFilenoUtil()));
        this.openFile.setMode(66);
        this.openFile.setAutoclose(autoclose2);
    }

    public RubyIO(Ruby runtime2, InputStream inputStream) {
        super(runtime2, runtime2.getIO());
        if (inputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = this.MakeOpenFile();
        this.openFile.setFD(new ChannelFD(ChannelHelper.readableChannel(inputStream), runtime2.getPosix(), runtime2.getFilenoUtil()));
        this.openFile.setMode(1);
    }

    public RubyIO(Ruby runtime2, Channel channel) {
        this(runtime2, runtime2.getIO(), channel);
    }

    public RubyIO(Ruby runtime2, RubyClass klass, Channel channel) {
        super(runtime2, klass);
        ThreadContext context = runtime2.getCurrentContext();
        if (channel == null) {
            throw Error.runtimeError(context, "Opening null channel");
        }
        POSIX posix = runtime2.getPosix();
        this.initializeCommon(context, new ChannelFD(channel, posix, runtime2.getFilenoUtil()), (IRubyObject)Convert.asFixnum(context, ModeFlags.oflagsFrom(posix, channel)), context.nil);
    }

    public RubyIO(Ruby runtime2, ShellLauncher.POpenProcess process, IOOptions ioOptions) {
        super(runtime2, runtime2.getIO());
        ThreadContext context = runtime2.getCurrentContext();
        ioOptions = this.updateIOOptionsFromOptions(context, null, ioOptions);
        this.openFile = this.MakeOpenFile();
        this.setupPopen(context, ioOptions.getModeFlags(), process);
    }

    public static RubyIO prepStdio(Ruby runtime2, InputStream f, Channel c, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = RubyIO.prepIO(runtime2.getCurrentContext(), c, fmode | 0x10000 | EncodingUtils.DEFAULT_TEXTMODE, klass, path2);
        OpenFile fptr = io2.getOpenFileChecked();
        if ((!runtime2.getPosix().isNative() || Platform.IS_WINDOWS) && f == System.in) {
            fptr.fd().realFileno = 0;
        }
        RubyIO.prepStdioEcflags(fptr, fmode);
        fptr.stdio_file = f;
        return RubyIO.recheckTTY(runtime2, fptr, io2);
    }

    public static RubyIO prepStdio(Ruby runtime2, OutputStream f, Channel c, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = RubyIO.prepIO(runtime2.getCurrentContext(), c, fmode | 0x10000 | EncodingUtils.DEFAULT_TEXTMODE, klass, path2);
        OpenFile fptr = io2.getOpenFileChecked();
        if (!runtime2.getPosix().isNative() || Platform.IS_WINDOWS) {
            if (f == System.out) {
                fptr.fd().realFileno = 1;
            } else if (f == System.err) {
                fptr.fd().realFileno = 2;
            }
        }
        RubyIO.prepStdioEcflags(fptr, fmode);
        fptr.stdio_file = f;
        return RubyIO.recheckTTY(runtime2, fptr, io2);
    }

    private static RubyIO recheckTTY(Ruby runtime2, OpenFile fptr, RubyIO io2) {
        fptr.checkTTY();
        return io2;
    }

    private static void prepStdioEcflags(OpenFile fptr, int fmode) {
        boolean locked2 = fptr.lock();
        try {
            fptr.encs.ecflags |= EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR;
            if (EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0) {
                fptr.encs.ecflags |= EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE;
                if ((fmode & 1) != 0) {
                    fptr.encs.ecflags |= 0x100;
                }
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    private static RubyIO prepIO(ThreadContext context, Channel fd, int fmode, RubyClass klass, String path2) {
        RubyIO io2 = (RubyIO)klass.allocate(context);
        OpenFile fp = io2.MakeOpenFile();
        fp.setChannel(fd);
        fp.setMode(fmode);
        fp.checkTTY();
        if (path2 != null) {
            fp.setPath(path2);
        }
        return io2;
    }

    public static RubyIO newIO(Ruby runtime2, Channel channel) {
        return new RubyIO(runtime2, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    public OpenFile getOpenFileChecked() {
        this.checkInitialized();
        this.openFile.checkClosed();
        return this.openFile;
    }

    public OpenFile getOpenFileInitialized() {
        this.checkInitialized();
        return this.openFile;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FILE;
    }

    public static RubyClass createIOClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        RubyClass IO = (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "IO", Object2, RubyIO::new).reifiedClass(RubyIO.class)).kindOf(new RubyModule.JavaClassKindOf(RubyIO.class))).classIndex(ClassIndex.IO)).include(context, Enumerable)).defineMethods(context, RubyIO.class)).defineConstant(context, "SEEK_SET", Convert.asFixnum(context, 0))).defineConstant(context, "SEEK_CUR", Convert.asFixnum(context, 1))).defineConstant(context, "SEEK_END", Convert.asFixnum(context, 2))).defineConstant(context, "READABLE", Convert.asFixnum(context, IOEvent.IO_READABLE.getValue()))).defineConstant(context, "WRITABLE", Convert.asFixnum(context, IOEvent.IO_WRITABLE.getValue()))).defineConstant(context, "PRIORITY", Convert.asFixnum(context, IOEvent.IO_PRIORITY.getValue()));
        IO.defineModuleUnder(context, "WaitReadable");
        IO.defineModuleUnder(context, "WaitWritable");
        return IO;
    }

    public OutputStream getOutStream() {
        return new OutputStream(){
            final Ruby runtime;
            {
                this.runtime = RubyIO.this.getRuntime();
            }

            @Override
            public void write(int b2) throws IOException {
                RubyIO.this.write(this.runtime.getCurrentContext(), b2);
            }

            @Override
            public void write(byte[] b2) throws IOException {
                RubyIO.this.write(this.runtime.getCurrentContext(), b2, 0, b2.length, (Encoding)ASCIIEncoding.INSTANCE);
            }

            @Override
            public void write(byte[] b2, int off, int len) throws IOException {
                RubyIO.this.write(this.runtime.getCurrentContext(), b2, off, len, (Encoding)ASCIIEncoding.INSTANCE);
            }

            @Override
            public void flush() throws IOException {
                RubyIO.this.flush(this.runtime.getCurrentContext());
            }

            @Override
            public void close() throws IOException {
                RubyIO.this.close();
            }
        };
    }

    public InputStream getInStream() {
        return new InputStream(){
            final Ruby runtime;
            {
                this.runtime = RubyIO.this.getRuntime();
            }

            @Override
            public int read() throws IOException {
                return RubyIO.this.getByte(this.runtime.getCurrentContext());
            }

            @Override
            public int read(byte[] b2) throws IOException {
                return this.read(b2, 0, b2.length);
            }

            @Override
            public int read(byte[] b2, int off, int len) throws IOException {
                return RubyIO.this.read(this.runtime.getCurrentContext(), b2, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return RubyIO.this.doSeek(this.runtime.getCurrentContext(), n, 1);
            }

            @Override
            public int available() throws IOException {
                if (RubyIO.this instanceof RubyFile) {
                    ThreadContext context = this.runtime.getCurrentContext();
                    long size2 = ((RubyFile)RubyIO.this).getSize(context);
                    if (size2 == 0L) {
                        return 0;
                    }
                    if (size2 >= 0L) {
                        return (int)(size2 - RubyIO.this.pos(context).getValue());
                    }
                }
                return 0;
            }

            @Override
            public void close() throws IOException {
                RubyIO.this.close();
            }
        };
    }

    public Channel getChannel() {
        return this.getOpenFileChecked().channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RubyIO reopenIO(ThreadContext context, RubyIO nfile) {
        OpenFile orig;
        long pos2 = 0L;
        nfile = TypeConverter.ioGetIO(context.runtime, nfile);
        OpenFile fptr = this.getOpenFileChecked();
        if (fptr == (orig = nfile.getOpenFileChecked())) {
            return this;
        }
        if (fptr.IS_PREP_STDIO() && (fptr.stdio_file == System.in && !orig.isReadable() || fptr.stdio_file == System.out && !orig.isWritable() || fptr.stdio_file == System.err && !orig.isWritable())) {
            throw Error.argumentError(context, fptr.PREP_STDIO_NAME() + " can't change access mode from \"" + fptr.getModeAsString(context) + "\" to \"" + orig.getModeAsString(context) + "\"");
        }
        Ruby runtime2 = context.runtime;
        boolean locked2 = fptr.lock();
        try {
            if (fptr.isWritable()) {
                if (fptr.io_fflush(context) < 0) {
                    throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
                }
            } else {
                fptr.tell(context);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        locked2 = orig.lock();
        try {
            if (orig.isReadable()) {
                pos2 = orig.tell(context);
            }
            if (orig.isWritable() && orig.io_fflush(context) < 0) {
                throw runtime2.newErrnoFromErrno(orig.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                orig.unlock();
            }
        }
        locked2 = fptr.lock();
        boolean locked22 = orig.lock();
        try {
            fptr.setMode(orig.getMode() | fptr.getMode() & 0x10008);
            fptr.setProcess(orig.getProcess());
            fptr.setLineNumber(orig.getLineNumber());
            if (orig.getPath() != null) {
                fptr.setPath(orig.getPath());
            } else if (!fptr.IS_PREP_STDIO()) {
                fptr.setPath(null);
            }
            fptr.setFinalizer(orig.getFinalizer());
            ChannelFD fd = fptr.fd();
            ChannelFD fd2 = orig.fd();
            if (fd != fd2) {
                if (fptr.IS_PREP_STDIO() || fd.bestFileno() <= 2 || fptr.stdio_file == null) {
                    this.checkReopenCloexecDup2(runtime2, orig, fd2, fd);
                    fptr.setFD(fd);
                } else {
                    if (fptr.stdio_file != null) {
                        try {
                            fptr.stdio_file.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    fptr.clearStdio();
                    fptr.setFD(null);
                    this.checkReopenCloexecDup2(runtime2, orig, fd2, fd);
                    fptr.setFD(fd);
                }
                if (orig.isReadable() && pos2 >= 0L) {
                    fptr.checkReopenSeek(context, runtime2, pos2);
                    orig.checkReopenSeek(context, runtime2, pos2);
                }
            }
            if (fptr.isBinmode()) {
                this.setBinmode();
            }
        }
        finally {
            if (locked22) {
                orig.unlock();
            }
            if (locked2) {
                fptr.unlock();
            }
        }
        return this;
    }

    private void checkReopenCloexecDup2(Ruby runtime2, OpenFile orig, ChannelFD oldfd, ChannelFD newfd) {
        OpenFile.cloexecDup2(new PosixShim(runtime2), oldfd, newfd);
    }

    private void setBinmode() {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            if (fptr.readconv != null) {
                fptr.readconv.binmode();
            }
            if (fptr.writeconv != null) {
                fptr.writeconv.binmode();
            }
            fptr.setBinmode();
            fptr.clearTextMode();
            fptr.writeconvPreEcflags &= 0xFFFF80FF;
            if (OpenFlags.O_BINARY.defined()) {
                // empty if block
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1, checkArity=false)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        IRubyObject tmp;
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        Ruby runtime2 = context.runtime;
        IRubyObject nil = context.nil;
        RubyIO file2 = this;
        IRubyObject fname = nil;
        IRubyObject nmode = nil;
        IRubyObject opt = nil;
        int[] oflags_p = new int[]{0};
        switch (argc) {
            case 3: {
                opt = TypeConverter.checkHashType(runtime2, args2[2]);
                if (opt == nil) {
                    throw Error.argumentError(context, 3, 2);
                }
            }
            case 2: {
                if (opt == nil) {
                    opt = TypeConverter.checkHashType(runtime2, args2[1]);
                    if (opt == nil) {
                        nmode = args2[1];
                        opt = nil;
                    }
                } else {
                    nmode = args2[1];
                }
            }
            case 1: {
                fname = args2[0];
            }
        }
        if (argc == 1 && (tmp = TypeConverter.ioCheckIO(runtime2, fname)) != nil) {
            return file2.reopenIO(context, (RubyIO)tmp);
        }
        fname = RubyFile.get_path(context, fname);
        OpenFile fptr = file2.openFile;
        if (fptr == null) {
            fptr = file2.openFile = this.MakeOpenFile();
        }
        boolean locked2 = fptr.lock();
        try {
            IOEncodable convconfig;
            if (nmode != nil || opt != nil) {
                convconfig = new IOEncodable.ConvConfig();
                API.ModeAndPermission vmode_vperm = new API.ModeAndPermission(nmode, null);
                int[] fmode_p = new int[]{0};
                EncodingUtils.extractModeEncoding(context, convconfig, vmode_vperm, opt, oflags_p, fmode_p);
                if (fptr.IS_PREP_STDIO() && (fptr.getMode() & 3 & (fmode_p[0] & 3)) != (fptr.getMode() & 3)) {
                    throw Error.argumentError(context, fptr.PREP_STDIO_NAME() + " can't change access mode from \"" + fptr.getModeAsString(context) + "\" to \"" + OpenFile.getStringFromMode(fmode_p[0]));
                }
                fptr.setMode(fmode_p[0]);
                fptr.encs = convconfig;
            } else {
                oflags_p[0] = OpenFile.getModeFlagsAsIntFrom(fptr.getMode());
            }
            fptr.setPath(fname.toString());
            if (fptr.fd() == null) {
                fptr.setFD(RubyIO.sysopen(runtime2, fptr.getPath(), oflags_p[0], 438));
                fptr.clearStdio();
                convconfig = file2;
                return convconfig;
            }
            if (fptr.isWritable() && fptr.io_fflush(context) < 0) {
                throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            fptr.rbuf.len = 0;
            fptr.rbuf.off = 0;
            if (fptr.isStdio()) {
                fptr.setFD(RubyIO.sysopen(runtime2, fptr.getPath(), oflags_p[0], 438));
                OpenFile.fdFixCloexec(fptr.posix, fptr.fd().realFileno);
            } else {
                ChannelFD tmpfd = RubyIO.sysopen(runtime2, fptr.getPath(), oflags_p[0], 438);
                Errno err = null;
                if (OpenFile.cloexecDup2(fptr.posix, tmpfd, fptr.fd()) < 0) {
                    err = fptr.errno();
                }
                if (err != null) {
                    throw runtime2.newErrnoFromErrno(err, fptr.getPath());
                }
                fptr.setFD(tmpfd);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return file2;
    }

    public IRubyObject getline(ThreadContext context, IRubyObject separator) {
        return this.getlineImpl(context, separator, -1, false);
    }

    public IRubyObject getline(ThreadContext context, IRubyObject separator, long limit2) {
        return this.getlineImpl(context, separator, (int)limit2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject getlineImpl(ThreadContext context, IRubyObject rs, int limit2, boolean chomp2) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            Encoding enc;
            fptr.checkCharReadable(context);
            if (limit2 == 0) {
                RubyString rubyString = RubyString.newEmptyString(runtime2, fptr.readEncoding(runtime2));
                return rubyString;
            }
            RubyString str = null;
            if (rs == context.nil && limit2 < 0) {
                str = (RubyString)fptr.readAll(context, 0, context.nil);
                if (str.size() == 0) {
                    IRubyObject iRubyObject = context.nil;
                    return iRubyObject;
                }
                if (chomp2) {
                    str.chomp_bang(context, Access.globalVariables(context).getDefaultSeparator());
                }
            } else if (rs == Access.globalVariables(context).getDefaultSeparator() && limit2 < 0 && !fptr.needsReadConversion() && (enc = fptr.readEncoding(runtime2)).isAsciiCompatible()) {
                fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
                IRubyObject iRubyObject = fptr.getlineFast(context, enc, this, chomp2);
                return iRubyObject;
            }
            IRubyObject iRubyObject = this.getlineImplSlowPart(context, fptr, str, rs, limit2, chomp2);
            return iRubyObject;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    private IRubyObject getlineImplSlowPart(ThreadContext context, OpenFile fptr, RubyString str, IRubyObject rs, int limit2, boolean chomp2) {
        int c;
        Ruby runtime2 = context.runtime;
        boolean noLimit = false;
        int newline = -1;
        byte[] rsptrBytes = null;
        int rsptr = 0;
        int rslen = 0;
        boolean rspara = false;
        int extraLimit = 16;
        boolean chompCR = chomp2;
        fptr.SET_BINARY_MODE();
        Encoding enc = this.getReadEncoding();
        if (rs != context.nil) {
            RubyString rsStr = (RubyString)rs;
            ByteList rsByteList = rsStr.getByteList();
            rslen = rsByteList.getRealSize();
            if (rslen == 0) {
                rsptrBytes = PARAGRAPH_SEPARATOR.unsafeBytes();
                rsptr = PARAGRAPH_SEPARATOR.getBegin();
                rslen = 2;
                rspara = true;
                fptr.swallow(context, 10);
                rs = null;
                if (!enc.isAsciiCompatible()) {
                    rs = RubyString.newUsAsciiStringShared(runtime2, rsptrBytes, rsptr, rslen);
                    rs = EncodingUtils.strConvEnc(context, (RubyString)rs, null, enc);
                    rs.setFrozen(true);
                    rsStr = (RubyString)rs;
                    rsByteList = rsStr.getByteList();
                    rsptrBytes = rsByteList.getUnsafeBytes();
                    rsptr = rsByteList.getBegin();
                    rslen = rsByteList.getRealSize();
                }
                newline = 10;
            } else if (enc.minLength() == 1) {
                rsptr = rsByteList.begin();
                rsptrBytes = rsByteList.getUnsafeBytes();
                newline = Byte.toUnsignedInt(rsptrBytes[rsptr + rslen - 1]);
            } else {
                rs = rsStr.encode(context, Access.encodingService(context).convertEncodingToRubyEncoding(enc));
                rsStr = (RubyString)rs;
                rsByteList = rsStr.getByteList();
                rsptrBytes = rsByteList.getUnsafeBytes();
                rsptr = rsByteList.getBegin();
                rslen = rsByteList.getRealSize();
                int e = rsptr + rslen;
                int last2 = enc.prevCharHead(rsptrBytes, rsptr, e, e);
                int[] n = new int[]{0};
                newline = EncodingUtils.encCodepointLength(context, rsptrBytes, last2, e, n, enc);
                if (last2 + n[0] != e) {
                    throw Error.argumentError(context, "broken separator");
                }
            }
            chompCR = chomp2 && newline == 10 && rslen == enc.minLength();
        }
        ByteList[] strPtr = new ByteList[]{str != null ? str.getByteList() : null};
        int[] limit_p = new int[]{limit2};
        while ((c = fptr.appendline(context, newline, strPtr, limit_p, enc)) != -1) {
            int p2;
            int s2;
            byte[] strBytes = strPtr[0].getUnsafeBytes();
            int realSize = strPtr[0].getRealSize();
            int begin2 = strPtr[0].getBegin();
            if (c == newline) {
                int e;
                if (realSize < rslen || !RubyIO.atCharacterBoundary(enc, strBytes, s2 = begin2, p2 = (e = s2 + realSize) - rslen, e)) continue;
                if (!rspara) {
                    RubyIO.rscheck(context, rsptrBytes, rslen, rs);
                }
                if (ByteList.memcmp(strBytes, p2, rsptrBytes, rsptr, rslen) == 0) {
                    if (!chomp2) break;
                    if (chompCR && p2 > s2 && strBytes[p2 - 1] == 13) {
                        --p2;
                    }
                    strPtr[0].length(p2 - s2);
                    break;
                }
            }
            if (limit_p[0] != 0) continue;
            s2 = begin2;
            p2 = s2 + realSize;
            int pp = enc.prevCharHead(strBytes, s2, p2, p2);
            if (extraLimit != 0 && pp != -1 && StringSupport.MBCLEN_NEEDMORE_P(StringSupport.preciseLength(enc, strBytes, pp, p2))) {
                limit_p[0] = 1;
                --extraLimit;
                continue;
            }
            noLimit = true;
            break;
        }
        if (strPtr[0] != null) {
            if (str != null) {
                str.setValue(strPtr[0]);
            } else {
                str = runtime2.newString(strPtr[0]);
            }
        }
        if (rspara && c != -1) {
            fptr.swallow(context, 10);
        }
        if (str != null) {
            str.setEncoding(enc);
        }
        if (str != null && !noLimit) {
            fptr.incrementLineno(runtime2, this);
        }
        return str == null ? context.nil : str;
    }

    private static void rscheck(ThreadContext context, byte[] strBytes, int len, IRubyObject rs) {
        if (rs == null || rs.isNil()) {
            return;
        }
        if (((RubyString)rs).getByteList().getUnsafeBytes() != strBytes && ((RubyString)rs).getByteList().getRealSize() != len) {
            throw Error.runtimeError(context, "rs modified");
        }
    }

    private static boolean atCharacterBoundary(Encoding enc, byte[] strBytes, int s2, int p2, int e) {
        return enc.leftAdjustCharHead(strBytes, s2, p2, e) == p2;
    }

    @Override
    public Encoding getEnc() {
        return this.openFile.encs.enc;
    }

    public Encoding getReadEncoding() {
        return this.openFile.readEncoding(this.getRuntime());
    }

    @Override
    public Encoding getEnc2() {
        return this.openFile.encs.enc2;
    }

    public Encoding getInputEncoding() {
        return this.openFile.inputEncoding(this.getRuntime());
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true, keywords=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            RubyString className = RubyStringBuilder.types(context.runtime, (RubyModule)klass);
            Warn.warn(context, RubyStringBuilder.str(context.runtime, className, "::new() does not take block; use ", className, "::open() instead"));
        }
        return klass.newInstance(context, args2, block);
    }

    @JRubyMethod(rest=true, meta=true, keywords=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon(ThreadContext context, int fileno2, IRubyObject vmodeArg, IRubyObject opt) {
        ChannelFD fd;
        Ruby runtime2 = context.runtime;
        if (!FilenoUtil.isFake(fileno2)) {
            fd = runtime2.getFilenoUtil().getWrapperFromFileno(fileno2);
            if (fd == null) {
                if (runtime2.getPosix().isNative() && !Platform.IS_WINDOWS) {
                    fd = new ChannelFD((Channel)new NativeDeviceChannel(fileno2), runtime2.getPosix(), runtime2.getFilenoUtil());
                } else {
                    switch (fileno2) {
                        case 0: {
                            fd = new ChannelFD(Channels.newChannel(runtime2.getIn()), runtime2.getPosix(), runtime2.getFilenoUtil());
                            break;
                        }
                        case 1: {
                            fd = new ChannelFD(Channels.newChannel(runtime2.getOut()), runtime2.getPosix(), runtime2.getFilenoUtil());
                            break;
                        }
                        case 2: {
                            fd = new ChannelFD(Channels.newChannel(runtime2.getErr()), runtime2.getPosix(), runtime2.getFilenoUtil());
                            break;
                        }
                        default: {
                            fd = new ChannelFD((Channel)new NativeDeviceChannel(fileno2), runtime2.getPosix(), runtime2.getFilenoUtil());
                            break;
                        }
                    }
                }
            }
        } else {
            fd = runtime2.getFilenoUtil().getWrapperFromFileno(fileno2);
            if (fd == null) {
                throw runtime2.newErrnoEBADFError();
            }
        }
        if (!fd.ch.isOpen()) {
            throw runtime2.newErrnoEBADFError();
        }
        return this.initializeCommon(context, fd, vmodeArg, opt);
    }

    private IRubyObject initializeCommon(ThreadContext context, ChannelFD fd, IRubyObject vmodeArg, IRubyObject opt) {
        Ruby runtime2 = context.runtime;
        int[] oflags_p = new int[]{ModeFlags.RDONLY};
        if (!(opt == null || opt.isNil() || opt instanceof RubyHash || RubyIO.sites((ThreadContext)context).respond_to_to_hash.respondsTo(context, opt, opt))) {
            throw Error.argumentError(context, "last argument must be a hash!");
        }
        if (opt != null && !opt.isNil()) {
            opt = opt.convertToHash();
        }
        if (!fd.ch.isOpen()) {
            throw runtime2.newErrnoEBADFError();
        }
        RubyFixnum vperm = Convert.asFixnum(context, 0);
        API.ModeAndPermission pm = new API.ModeAndPermission(vmodeArg, vperm);
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        EncodingUtils.extractModeEncoding(context, (IOEncodable)convconfig, pm, opt, oflags_p, fmode_p);
        oflags_p[0] = ModeFlags.oflagsFrom(runtime2.getPosix(), fd.ch);
        int ofmode = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
        if (EncodingUtils.vmode(pm) == null || EncodingUtils.vmode(pm).isNil()) {
            fmode_p[0] = ofmode;
        } else if ((~ofmode & fmode_p[0] & 3) != 0) {
            throw runtime2.newErrnoEINVALError();
        }
        IRubyObject path2 = null;
        if (opt instanceof RubyHash) {
            RubyHash optHash = (RubyHash)opt;
            if (optHash.op_aref(context, Convert.asSymbol(context, "autoclose")) == context.fals) {
                fmode_p[0] = fmode_p[0] | 0x10000;
            }
            if (!(path2 = optHash.op_aref(context, Convert.asSymbol(context, "path"))).isNil()) {
                path2 = path2.convertToString().newFrozen();
            }
        }
        this.MakeOpenFile();
        this.openFile.setFD(fd);
        this.openFile.setMode(fmode_p[0]);
        this.openFile.encs = convconfig;
        this.openFile.clearCodeConversion();
        if (path2 != null) {
            this.openFile.setPath(path2.toString());
        }
        this.openFile.checkTTY();
        switch (fd.bestFileno()) {
            case 0: {
                this.openFile.stdio_file = System.in;
                break;
            }
            case 1: {
                this.openFile.stdio_file = System.out;
                break;
            }
            case 2: {
                this.openFile.stdio_file = System.err;
            }
        }
        if (this.openFile.isBOM()) {
            EncodingUtils.ioSetEncodingByBOM(context, this);
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, Block unused2) {
        return this.initializeCommon(context, Convert.toInt(context, fileNumber), null, context.nil);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, IRubyObject second2, Block unused2) {
        IRubyObject options2;
        int fileno2 = Convert.toInt(context, fileNumber);
        IRubyObject vmode = null;
        IRubyObject hashTest = TypeConverter.checkHashType(context.runtime, second2);
        if (hashTest instanceof RubyHash) {
            options2 = hashTest;
        } else {
            options2 = context.nil;
            vmode = second2;
        }
        return this.initializeCommon(context, fileno2, vmode, options2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unused2) {
        int callInfo = ThreadContext.resetCallInfo(context);
        int fileno2 = Convert.toInt(context, fileNumber);
        if (!(modeValue == null || modeValue.isNil() || modeValue instanceof RubyInteger || modeValue instanceof RubyString)) {
            throw Error.argumentError(context, 3, 1, 2);
        }
        if (!ThreadContext.hasKeywords(callInfo)) {
            throw Error.argumentError(context, 3, 1, 2);
        }
        return this.initializeCommon(context, fileno2, modeValue, options2);
    }

    protected IOOptions parseIOOptions(IRubyObject arg2) {
        Ruby runtime2 = this.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg2;
            return RubyIO.newIOOptions(runtime2, (int)fixnum.getValue());
        }
        String modeString = arg2.convertToString().toString();
        try {
            return new IOOptions(runtime2, modeString);
        }
        catch (InvalidValueException ive) {
            throw Error.argumentError(runtime2.getCurrentContext(), "invalid access mode " + modeString);
        }
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext context) {
        EncodingService encodingService = Access.encodingService(context);
        if (this.openFile.encs.enc2 != null) {
            return encodingService.getEncoding(this.openFile.encs.enc2);
        }
        if (this.openFile.isWritable()) {
            return this.openFile.encs.enc == null ? context.nil : encodingService.getEncoding(this.openFile.encs.enc);
        }
        return encodingService.getEncoding(this.getReadEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext context) {
        return this.openFile.encs.enc2 == null ? context.nil : Access.encodingService(context).getEncoding(this.getReadEncoding());
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingObj) {
        this.setEncoding(context, encodingObj, context.nil, context.nil);
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        IRubyObject opt = TypeConverter.checkHashType(context.runtime, internalEncoding);
        if (!opt.isNil()) {
            this.setEncoding(context, encodingString, context.nil, opt);
        } else {
            this.setEncoding(context, encodingString, internalEncoding, context.nil);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        this.setEncoding(context, encodingString, internalEncoding, options2);
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding_by_bom(ThreadContext context) {
        OpenFile fptr = this.getOpenFile();
        if (!fptr.isBinmode()) {
            throw Error.argumentError(context, "ASCII incompatible encoding needs binmode");
        }
        if (this.getEnc2() != null) {
            throw Error.argumentError(context, "encoding conversion is set");
        }
        if (this.getEnc() != null && this.getEnc() != ASCIIEncoding.INSTANCE) {
            throw Error.argumentError(context, "encoding is set to " + String.valueOf(this.getEnc()) + " already");
        }
        if (EncodingUtils.ioSetEncodingByBOM(context, this) == null) {
            return context.nil;
        }
        return Access.encodingService(context).getEncoding(this.getEnc());
    }

    public void setEncoding(ThreadContext context, IRubyObject v1, IRubyObject v2, IRubyObject opt) {
        IRubyObject nil = context.nil;
        IOEncodable.ConvConfig holder = new IOEncodable.ConvConfig();
        int ecflags = this.openFile.encs.ecflags;
        IRubyObject[] ecopts_p = new IRubyObject[]{nil};
        if (v2 != nil) {
            holder.enc2 = EncodingUtils.rbToEncoding(context, v1);
            tmp = v2.checkStringType();
            if (tmp != nil) {
                RubyString internalAsString = (RubyString)tmp;
                if (RubyIO.isDash(internalAsString)) {
                    holder.enc = holder.enc2;
                    holder.enc2 = null;
                } else {
                    holder.enc = EncodingUtils.rbToEncoding(context, internalAsString);
                }
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            } else {
                holder.enc = EncodingUtils.rbToEncoding(context, v2);
                if (holder.enc == holder.enc2) {
                    holder.enc2 = null;
                }
            }
            if (holder.enc2 == ASCIIEncoding.INSTANCE) {
                holder.enc = holder.enc2;
                holder.enc2 = null;
            }
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
        } else if (v1.isNil()) {
            EncodingUtils.ioExtIntToEncs(context, holder, null, null, 0);
            EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            ecopts_p[0] = context.nil;
        } else {
            tmp = v1.checkStringType();
            if (tmp != nil && EncodingUtils.encAsciicompat(EncodingUtils.encGet(context, tmp))) {
                EncodingUtils.parseModeEncoding(context, holder, tmp.asJavaString(), null);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
                ecflags = EncodingUtils.econvPrepareOptions(context, opt, ecopts_p, ecflags);
            } else {
                EncodingUtils.ioExtIntToEncs(context, holder, EncodingUtils.rbToEncoding(context, v1), null, 0);
                EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(holder.getEnc2(), ecflags);
            }
        }
        int[] fmode_p = new int[]{this.openFile.getMode()};
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, holder);
        this.openFile.setMode(fmode_p[0]);
        this.openFile.encs.enc = holder.enc;
        this.openFile.encs.enc2 = holder.enc2;
        this.openFile.encs.ecflags = ecflags;
        this.openFile.encs.ecopts = ecopts_p[0];
        this.openFile.clearCodeConversion();
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, meta=true, keywords=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject io2 = ((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        return RubyIO.ensureYieldClose(context, io2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ensureYieldClose(ThreadContext context, IRubyObject port, Block block) {
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, port);
                return iRubyObject;
            }
            finally {
                RubyIO.ioClose(context, port);
            }
        }
        return port;
    }

    @Deprecated
    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyIO.sysopen(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, checkArity=false, meta=true)
    public static IRubyObject sysopen(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2, Block block) {
        int oflags;
        IRubyObject vperm;
        int argc = Arity.checkArgumentCount(context, argv2, 1, 3);
        Ruby runtime2 = context.runtime;
        IRubyObject vmode = vperm = context.nil;
        switch (argc) {
            case 3: {
                vperm = argv2[2];
            }
            case 2: {
                vmode = argv2[1];
            }
        }
        IRubyObject fname = RubyFile.get_path(context, argv2[0]);
        if (vmode.isNil()) {
            oflags = OpenFlags.O_RDONLY.intValue();
        } else {
            IRubyObject intmode = Convert.checkToInteger(context, vmode);
            if (!intmode.isNil()) {
                oflags = ((RubyInteger)intmode).asInt(context);
            } else {
                vmode = vmode.convertToString();
                oflags = OpenFile.ioModestrOflags(context, vmode.toString());
            }
        }
        int perm = vperm.isNil() ? 438 : Convert.toInt(context, vperm);
        StringSupport.checkStringSafety(context.runtime, fname);
        fname = ((RubyString)fname).dupFrozen();
        ChannelFD fd = RubyIO.sysopen(runtime2, fname.toString(), oflags, perm);
        return Convert.asFixnum(context, fd.bestFileno(true));
    }

    protected static ChannelFD sysopen(Ruby runtime2, String fname, int oflags, int perm) {
        Sysopen data2 = new Sysopen();
        data2.fname = fname;
        data2.oflags = oflags;
        data2.perm = perm;
        ChannelFD fd = RubyIO.sysopenInternal(runtime2, data2);
        if (fd == null) {
            if (data2.errno != null) {
                throw runtime2.newErrnoFromErrno(data2.errno, fname);
            }
            throw runtime2.newSystemCallError(fname);
        }
        return fd;
    }

    private static ChannelFD sysopenInternal(Ruby runtime2, Sysopen data2) {
        ChannelFD fd = RubyIO.sysopenFunc(runtime2, data2);
        return fd;
    }

    private static ChannelFD sysopenFunc(Ruby runtime2, Sysopen data2) {
        return RubyIO.cloexecOpen(runtime2, data2);
    }

    public static ChannelFD cloexecOpen(Ruby runtime2, Sysopen data2) {
        PosixShim shim;
        Channel ret = null;
        if (OpenFlags.O_CLOEXEC.defined()) {
            data2.oflags |= OpenFlags.O_CLOEXEC.intValue();
        }
        if ((ret = (shim = new PosixShim(runtime2)).open(runtime2.getCurrentDirectory(), data2.fname, data2.oflags, data2.perm)) == null) {
            data2.errno = shim.getErrno();
            return null;
        }
        ChannelFD fd = new ChannelFD(ret, runtime2.getPosix(), runtime2.getFilenoUtil(), data2.oflags);
        if (fd.realFileno > 0 && runtime2.getPosix().isNative() && !Platform.IS_WINDOWS) {
            OpenFile.fdFixCloexec(shim, fd.realFileno);
        }
        return fd;
    }

    public boolean isAutoclose() {
        OpenFile fptr = this.getOpenFileChecked();
        return fptr.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.setAutoclose(autoclose2);
    }

    @JRubyMethod(name={"autoclose?"})
    public IRubyObject autoclose(ThreadContext context) {
        return Convert.asBoolean(context, this.isAutoclose());
    }

    @JRubyMethod(name={"autoclose="})
    public IRubyObject autoclose_set(ThreadContext context, IRubyObject autoclose2) {
        this.setAutoclose(autoclose2.isTrue());
        return context.nil;
    }

    @Deprecated(since="10.0")
    public IRubyObject binmode() {
        return this.binmode(this.getCurrentContext());
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode(ThreadContext context) {
        this.setAscii8bitBinmode();
        RubyIO write_io = this.GetWriteIO();
        if (write_io != this) {
            write_io.setAscii8bitBinmode();
        }
        return this;
    }

    @JRubyMethod(name={"binmode?"})
    public IRubyObject op_binmode(ThreadContext context) {
        return Convert.asBoolean(context, this.getOpenFileChecked().isBinmode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"syswrite"})
    public IRubyObject syswrite(ThreadContext context, IRubyObject str) {
        long n;
        if (!(str instanceof RubyString)) {
            str = str.asString();
        }
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            ByteList strByteList;
            fptr.checkWritable(context);
            str = str.convertToString().newFrozen();
            if (fptr.wbuf.len != 0) {
                Warn.warn(context, "syswrite for buffered IO");
            }
            if ((n = (long)OpenFile.writeInternal(context, fptr, (strByteList = ((RubyString)str).getByteList()).unsafeBytes(), strByteList.begin(), strByteList.getRealSize())) == -1L) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return Convert.asFixnum(context, n);
    }

    @JRubyMethod(name={"write_nonblock"})
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject arg0) {
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", arg0) != context.fals;
        return this.ioWriteNonblock(context, context.runtime, arg0, !exception2);
    }

    @JRubyMethod(name={"write_nonblock"})
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", arg1) != context.fals;
        return this.ioWriteNonblock(context, context.runtime, arg0, !exception2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject ioWriteNonblock(ThreadContext context, Ruby runtime2, IRubyObject str, boolean no_exception) {
        long n;
        if (!(str instanceof RubyString)) {
            str = str.asString();
        }
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkWritable(context);
            if (fptr.io_fflush(context) < 0) {
                throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            fptr.setNonblock(runtime2);
            ByteList strByteList = ((RubyString)str).getByteList();
            n = fptr.posix.write(fptr.fd(), strByteList.unsafeBytes(), strByteList.begin(), strByteList.getRealSize(), true);
            if (n == -1L) {
                if (fptr.posix.getErrno() == Errno.EWOULDBLOCK || fptr.posix.getErrno() == Errno.EAGAIN) {
                    if (no_exception) {
                        RubySymbol rubySymbol = Convert.asSymbol(context, "wait_writable");
                        return rubySymbol;
                    }
                    throw runtime2.newErrnoEAGAINWritableError("write would block");
                }
                throw runtime2.newErrnoFromErrno(fptr.posix.getErrno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return Convert.asFixnum(context, n);
    }

    public RubyIO GetWriteIO() {
        this.checkInitialized();
        RubyIO writeIO = this.openFile.tiedIOForWriting;
        if (writeIO != null) {
            return writeIO;
        }
        return this;
    }

    private void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject str) {
        return this.write(context, str, false);
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write2(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long acc = Convert.toLong(context, this.write(context, arg0, false));
        return Convert.asFixnum(context, acc += Convert.toLong(context, this.write(context, arg1, false)));
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write3(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long acc = Convert.toLong(context, this.write(context, arg0, false));
        acc += Convert.toLong(context, this.write(context, arg1, false));
        return Convert.asFixnum(context, acc += Convert.toLong(context, this.write(context, arg2, false)));
    }

    @JRubyMethod(name={"write"}, rest=true)
    public IRubyObject write(ThreadContext context, IRubyObject[] args2) {
        long acc = 0L;
        for (IRubyObject s2 : args2) {
            IRubyObject write2 = this.write(context, s2, false);
            long num2long = Convert.toLong(context, write2);
            acc += num2long;
        }
        return Convert.asFixnum(context, acc);
    }

    public final IRubyObject write(ThreadContext context, int ch) {
        RubyString str = Create.newSharedString(context, RubyInteger.singleCharByteList((byte)ch));
        return this.write(context, str, false);
    }

    public final void write(ThreadContext context, byte ch) {
        ByteList bytes2 = RubyInteger.singleCharByteList(ch);
        this.write(context, bytes2.unsafeBytes(), bytes2.begin(), bytes2.realSize(), bytes2.getEncoding(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject write(ThreadContext context, IRubyObject str, boolean nosync) {
        long n;
        RubyIO io2 = this.GetWriteIO();
        RubyString string2 = str.asString();
        IRubyObject tmp = TypeConverter.ioCheckIO(context.runtime, io2);
        if (tmp == context.nil) {
            return RubyIO.sites((ThreadContext)context).write.call(context, (IRubyObject)io2, (IRubyObject)io2, (IRubyObject)string2);
        }
        io2 = (RubyIO)tmp;
        if (string2.isEmpty()) {
            return Convert.asFixnum(context, 0);
        }
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr = io2.getOpenFileChecked();
            fptr.checkWritable(context);
            n = fptr.fwrite(context, string2, nosync);
            if (n == -1L) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return Convert.asFixnum(context, n);
    }

    public int write(ThreadContext context, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        return this.write(context, bytes2, start2, length2, encoding2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ThreadContext context, byte[] bytes2, int start2, int length2, Encoding encoding2, boolean nosync) {
        if (length2 == 0) {
            return 0;
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr = this.getOpenFileChecked();
            fptr.checkWritable(context);
            int n = fptr.fwrite(context, bytes2, start2, length2, encoding2, nosync);
            if (n == -1) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    public int write(byte[] bytes2, int start2, int length2, Encoding encoding2, boolean nosync) {
        return this.write(this.getRuntime().getCurrentContext(), bytes2, start2, length2, encoding2, nosync);
    }

    public int write(byte[] bytes2, int start2, int length2, Encoding encoding2) {
        return this.write(bytes2, start2, length2, encoding2, false);
    }

    public int write(byte[] bytes2, Encoding encoding2) {
        return this.write(bytes2, 0, bytes2.length, encoding2);
    }

    public void write(int bite) {
        this.write(this.getRuntime().getCurrentContext(), (byte)bite);
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        RubyIO.sites((ThreadContext)context).write.call(context, (IRubyObject)this, (IRubyObject)this, anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        return Convert.asFixnum(context, this.getOpenFileChecked().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return Convert.asFixnum(context, this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="})
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(Convert.toInt(context, newLineNumber));
        return Convert.asFixnum(context, this.getOpenFileChecked().getLineNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyBoolean sync(ThreadContext context) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.lock();
        try {
            RubyBoolean rubyBoolean = (fptr.getMode() & 8) != 0 ? context.tru : context.fals;
            return rubyBoolean;
        }
        finally {
            fptr.unlock();
        }
    }

    @JRubyMethod
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.nil;
        }
        long pid2 = myOpenFile.getPid();
        return Convert.asFixnum(context, pid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            long pos2 = fptr.tell(context);
            if (pos2 == -1L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            RubyFixnum rubyFixnum = Convert.asFixnum(context, pos2 -= (long)fptr.rbuf.len);
            return rubyFixnum;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"pos="})
    public RubyFixnum pos_set(ThreadContext context, IRubyObject offset2) {
        long pos2 = Convert.toLong(context, offset2);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            pos2 = fptr.seek(context, pos2, 0);
            if (pos2 == -1L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return Convert.asFixnum(context, pos2);
    }

    @JRubyMethod(rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.print(context, this, args2);
    }

    @JRubyMethod(reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context) {
        return RubyIO.print0(context, this);
    }

    @JRubyMethod
    public IRubyObject print(ThreadContext context, IRubyObject arg0) {
        return RubyIO.print1(context, this, arg0);
    }

    @JRubyMethod
    public IRubyObject print(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.print2(context, this, arg0, arg1);
    }

    @JRubyMethod
    public IRubyObject print(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.print3(context, this, arg0, arg1, arg2);
    }

    public static IRubyObject print(ThreadContext context, IRubyObject out, IRubyObject[] args2) {
        boolean fieldSeparatorNotNil;
        switch (args2.length) {
            case 0: {
                return RubyIO.print0(context, out);
            }
            case 1: {
                return RubyIO.print1(context, out, args2[0]);
            }
            case 2: {
                return RubyIO.print2(context, out, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.print3(context, out, args2[0], args2[1], args2[2]);
            }
        }
        int argc = args2.length;
        IRubyObject outputFS = Access.globalVariables(context).get("$,");
        boolean bl = fieldSeparatorNotNil = !outputFS.isNil();
        if (fieldSeparatorNotNil) {
            Warn.warnDeprecated(context, "$, is set to non-nil value");
        }
        for (int i2 = 0; i2 < argc; ++i2) {
            if (fieldSeparatorNotNil && i2 > 0) {
                RubyIO.write(context, out, outputFS);
            }
            RubyIO.write(context, out, args2[i2]);
        }
        RubyIO.writeRecordSeparator(context, out);
        return context.nil;
    }

    public static IRubyObject print0(ThreadContext context, IRubyObject out) {
        return RubyIO.print1(context, out, context.getLastLine());
    }

    public static IRubyObject print1(ThreadContext context, IRubyObject out, IRubyObject arg1) {
        RubyIO.write(context, out, arg1);
        RubyIO.writeRecordSeparator(context, out);
        return context.nil;
    }

    private static void writeRecordSeparator(ThreadContext context, IRubyObject out) {
        IRubyObject outputRS = Access.globalVariables(context).get("$\\");
        if (!outputRS.isNil()) {
            RubyIO.write(context, out, outputRS);
        }
    }

    public static IRubyObject print2(ThreadContext context, IRubyObject out, IRubyObject arg0, IRubyObject arg1) {
        boolean fieldSeparatorNotNil;
        IRubyObject outputFS = Access.globalVariables(context).get("$,");
        boolean bl = fieldSeparatorNotNil = !outputFS.isNil();
        if (fieldSeparatorNotNil) {
            Warn.warnDeprecated(context, "$, is set to non-nil value");
        }
        RubyIO.write(context, out, arg0);
        if (fieldSeparatorNotNil) {
            RubyIO.write(context, out, outputFS);
        }
        RubyIO.write(context, out, arg1);
        RubyIO.writeRecordSeparator(context, out);
        return context.nil;
    }

    public static IRubyObject print3(ThreadContext context, IRubyObject out, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        boolean fieldSeparatorNotNil;
        IRubyObject outputFS = Access.globalVariables(context).get("$,");
        boolean bl = fieldSeparatorNotNil = !outputFS.isNil();
        if (fieldSeparatorNotNil) {
            Warn.warnDeprecated(context, "$, is set to non-nil value");
        }
        RubyIO.write(context, out, arg0);
        if (fieldSeparatorNotNil) {
            RubyIO.write(context, out, outputFS);
        }
        RubyIO.write(context, out, arg1);
        if (fieldSeparatorNotNil) {
            RubyIO.write(context, out, outputFS);
        }
        RubyIO.write(context, out, arg2);
        RubyIO.writeRecordSeparator(context, out);
        return context.nil;
    }

    @JRubyMethod(required=1, rest=true, checkArity=false)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.printf(context, this, args2);
    }

    public static IRubyObject printf(ThreadContext context, IRubyObject out, IRubyObject[] args2) {
        RubyIO.write(context, out, RubyKernel.sprintf(context, out, args2));
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject putc(ThreadContext context, IRubyObject ch) {
        IRubyObject iRubyObject;
        if (ch instanceof RubyString) {
            RubyString chStr = (RubyString)ch;
            iRubyObject = chStr.substr(context, 0, 1);
        } else {
            iRubyObject = Create.newSharedString(context, RubyInteger.singleCharByteList(Convert.toByte(context, ch)));
        }
        RubyString str = iRubyObject;
        RubyIO.sites((ThreadContext)context).write.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)str);
        return ch;
    }

    public static IRubyObject putc(ThreadContext context, IRubyObject maybeIO, IRubyObject object) {
        if (maybeIO instanceof RubyIO) {
            RubyIO io2 = (RubyIO)maybeIO;
            io2.putc(context, object);
        } else {
            RubyString str = Create.newSharedString(context, RubyInteger.singleCharByteList(Convert.toByte(context, object)));
            RubyIO.sites((ThreadContext)context).write.call(context, maybeIO, maybeIO, (IRubyObject)str);
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        if (args2.length > 1) {
            return this.seek(context, args2[0], args2[1]);
        }
        return this.seek(context, args2[0]);
    }

    @JRubyMethod
    public RubyFixnum seek(ThreadContext context, IRubyObject off) {
        return Convert.asFixnum(context, this.doSeek(context, Convert.toLong(context, off), 0));
    }

    @JRubyMethod
    public RubyFixnum seek(ThreadContext context, IRubyObject off, IRubyObject whence) {
        return Convert.asFixnum(context, this.doSeek(context, Convert.toLong(context, off), RubyIO.interpretSeekWhence(context, whence)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doSeek(ThreadContext context, long pos2, int whence) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            pos2 = fptr.seek(context, pos2, whence);
            if (pos2 < 0L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, checkArity=false)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject offset2 = context.nil;
        int whence = 0;
        switch (argc) {
            case 2: {
                IRubyObject ptrname = args2[1];
                whence = RubyIO.interpretSeekWhence(context, ptrname);
            }
            case 1: {
                offset2 = args2[0];
            }
        }
        long pos2 = Convert.toLong(context, offset2);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            if (fptr.isReadable() && (fptr.READ_DATA_BUFFERED() || fptr.READ_CHAR_PENDING())) {
                throw context.runtime.newIOError("sysseek for buffered IO");
            }
            if (fptr.isWritable() && fptr.wbuf.len != 0) {
                Warn.warn(context, "sysseek for buffered IO");
            }
            fptr.errno(null);
            pos2 = fptr.posix.lseek(fptr.fd(), pos2, whence);
            if (pos2 == -1L && fptr.errno() != null) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return Convert.asFixnum(context, pos2);
    }

    private static int interpretSeekWhence(ThreadContext context, IRubyObject whence) {
        if (whence instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)whence;
            switch (sym.idString()) {
                case "SET": {
                    return 0;
                }
                case "CUR": {
                    return 1;
                }
                case "END": {
                    return 2;
                }
            }
        }
        return Convert.toInt(context, whence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyFixnum rewind(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            if (fptr.seek(context, 0L, 0) == -1L && fptr.errno() != null) {
                throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
            if (RubyArgsFile.ArgsFileData.getArgsFileData(runtime2).isCurrentFile(this)) {
                runtime2.setCurrentLine(runtime2.getCurrentLine() - fptr.getLineNumber());
            }
            fptr.setLineNumber(0);
            if (fptr.readconv != null) {
                fptr.clearReadConversion();
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return RubyFixnum.zero(runtime2);
    }

    @JRubyMethod
    public RubyFixnum fsync(ThreadContext context) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        if (fptr.io_fflush(context) < 0) {
            throw context.runtime.newSystemCallError("");
        }
        if (!Platform.IS_WINDOWS) {
            try {
                POSIX posix;
                if (fptr.fileChannel() != null) {
                    fptr.fileChannel().force(true);
                }
                if (fptr.fd().chNative != null && (posix = context.runtime.getPosix()).fsync(fptr.fd().chNative.getFD()) < 0) {
                    throw context.runtime.newErrnoFromInt(posix.errno());
                }
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
        }
        return Convert.asFixnum(context, 0);
    }

    @Deprecated(since="10.0")
    public IRubyObject sync_set(IRubyObject sync2) {
        return this.sync_set(this.getCurrentContext(), sync2);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject sync_set(ThreadContext context, IRubyObject sync2) {
        this.setSync(sync2.isTrue());
        return sync2;
    }

    public void setSync(boolean sync2) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.setSync(sync2);
    }

    public boolean getSync() {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        return fptr.isSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            if (fptr.READ_CHAR_PENDING()) {
                RubyBoolean rubyBoolean = context.fals;
                return rubyBoolean;
            }
            if (fptr.READ_DATA_PENDING()) {
                RubyBoolean rubyBoolean = context.fals;
                return rubyBoolean;
            }
            fptr.READ_CHECK(context);
            if (fptr.fillbuf(context) < 0) {
                RubyBoolean rubyBoolean = context.tru;
                return rubyBoolean;
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.fals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        fptr.lock();
        try {
            if (posix.isNative() && fptr.fd().realFileno != -1) {
                RubyBoolean rubyBoolean = posix.libc().isatty(fptr.getFileno()) == 0 ? runtime2.getFalse() : runtime2.getTrue();
                return rubyBoolean;
            }
            if (fptr.isStdio()) {
                RubyBoolean rubyBoolean = runtime2.getTrue();
                return rubyBoolean;
            }
        }
        finally {
            fptr.unlock();
        }
        return runtime2.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject _io) {
        RubyIO write_io;
        RubyIO dest = this;
        RubyIO io2 = TypeConverter.ioGetIO(context.runtime, _io);
        if (!RubyIO.OBJ_INIT_COPY(dest, io2)) {
            return dest;
        }
        OpenFile orig = io2.getOpenFileChecked();
        OpenFile fptr = dest.MakeOpenFile();
        boolean locked1 = orig.lock();
        boolean locked2 = fptr.lock();
        try {
            io2.flush(context);
            fptr.setMode(orig.getMode() & 0xFFFEFFFF);
            fptr.encs = orig.encs;
            fptr.setProcess(orig.getProcess());
            fptr.setLineNumber(orig.getLineNumber());
            if (orig.getPath() != null) {
                fptr.setPath(orig.getPath());
            }
            fptr.setFinalizer(orig.getFinalizer());
            ChannelFD fd = orig.fd().dup();
            fptr.setFD(fd);
            long pos2 = orig.tell(context);
            if (0L <= pos2) {
                fptr.seek(context, pos2, 0);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
            if (locked1) {
                orig.unlock();
            }
        }
        if (fptr.isBinmode()) {
            dest.setBinmode();
        }
        if (io2 != (write_io = io2.GetWriteIO())) {
            fptr.tiedIOForWriting = write_io = (RubyIO)write_io.dup();
            dest.getInstanceVariables().setInstanceVariable("@tied_io_for_writing", write_io);
        }
        return dest;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isClosed());
    }

    public boolean isClosed() {
        OpenFile write_fptr;
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io && (write_fptr = write_io.openFile) != null && write_fptr.fd() != null) {
            return false;
        }
        OpenFile fptr = this.openFile;
        this.checkInitialized();
        return fptr.fd() == null;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        if (this.isClosed()) {
            return context.nil;
        }
        return this.rbIoClose(context);
    }

    @Override
    public final void close() {
        this.close(this.getRuntime().getCurrentContext());
    }

    protected static IRubyObject ioClose(ThreadContext context, IRubyObject io2) {
        JavaSites.IOSites sites = RubyIO.sites(context);
        IRubyObject closed = io2.checkCallMethod(context, sites.closed_checked);
        if (closed != null && closed.isTrue()) {
            return io2;
        }
        IRubyObject oldExc = context.getErrorInfo();
        try {
            closed = io2.checkCallMethod(context, sites.close_checked);
            return Convert.asBoolean(context, closed != null && closed.isTrue());
        }
        catch (RaiseException re) {
            if (re.getMessage().contains(CLOSED_STREAM_MSG)) {
                context.setErrorInfo(oldExc);
                return context.nil;
            }
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject rbIoClose(ThreadContext context) {
        boolean locked2;
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io) {
            OpenFile write_fptr = write_io.openFile;
            locked2 = write_fptr.lock();
            try {
                if (write_fptr != null && write_fptr.fd() != null) {
                    write_fptr.cleanup(context.runtime, true);
                }
            }
            finally {
                if (locked2) {
                    write_fptr.unlock();
                }
            }
        }
        OpenFile fptr = this.openFile;
        locked2 = fptr.lock();
        try {
            if (fptr == null) {
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            if (fptr.fd() == null) {
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            Ruby runtime2 = context.runtime;
            fptr.finalizeFlush(context, false);
            fptr.interruptBlockingThreads(context);
            try {
                fptr.unlock();
                fptr.waitForBlockingThreads(context);
            }
            finally {
                fptr.lock();
            }
            fptr.cleanup(runtime2, false);
            if (fptr.getProcess() != null) {
                context.setLastExitStatus(context.nil);
                if (runtime2.getPosix().isNative() && fptr.getProcess() instanceof POSIXProcess) {
                    RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime2, ((POSIXProcess)fptr.getProcess()).status(), fptr.getPid());
                    context.setLastExitStatus(processResult);
                } else if (!this.popenSpecial) {
                    RubyIO.obliterateProcess(fptr.getProcess());
                    RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime2, fptr.getProcess().exitValue() << 8, fptr.getPid());
                    context.setLastExitStatus(processResult);
                }
                fptr.setProcess(null);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyIO write_io = this.GetWriteIO();
        OpenFile fptr = write_io.getOpenFileInitialized();
        if (!fptr.isOpen()) {
            return context.nil;
        }
        boolean locked2 = fptr.lock();
        try {
            if (fptr.socketChannel() != null) {
                try {
                    fptr.socketChannel().shutdownOutput();
                }
                catch (IOException ioe) {
                    throw runtime2.newErrnoFromErrno(Helpers.errnoFromException(ioe), fptr.getPath());
                }
                fptr.setMode(fptr.getMode() & 0xFFFFFFFD);
                if (!fptr.isReadable()) {
                    IRubyObject iRubyObject = write_io.rbIoClose(context);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            if (fptr.isReadable() && !fptr.isDuplex()) {
                throw runtime2.newIOError("closing non-duplex IO for writing");
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        if (this != write_io) {
            fptr = this.getOpenFileInitialized();
            locked2 = fptr.lock();
            try {
                fptr.tiedIOForWriting = null;
            }
            finally {
                if (locked2) {
                    fptr.unlock();
                }
            }
        }
        write_io.rbIoClose(context);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileInitialized();
        if (!fptr.isOpen()) {
            return context.nil;
        }
        boolean locked2 = fptr.lock();
        if (fptr.socketChannel() != null) {
            try {
                fptr.socketChannel().socket().shutdownInput();
            }
            catch (IOException ioe) {
                throw runtime2.newErrnoFromErrno(Helpers.errnoFromException(ioe), fptr.getPath());
            }
            fptr.setMode(fptr.getMode() & 0xFFFFFFFE);
            if (!fptr.isWritable()) {
                IRubyObject ioe = this.rbIoClose(context);
                return ioe;
            }
            IRubyObject ioe = context.nil;
            return ioe;
        }
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io) {
            OpenFile wfptr = write_io.getOpenFileInitialized();
            boolean locked22 = wfptr.lock();
            try {
                wfptr.setProcess(fptr.getProcess());
                wfptr.setPid(fptr.getPid());
                fptr.setProcess(null);
                fptr.setPid(-1L);
                this.openFile = wfptr;
                fptr.tiedIOForWriting = null;
                write_io.openFile = fptr;
                fptr.cleanup(runtime2, false);
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            finally {
                if (locked22) {
                    wfptr.unlock();
                }
            }
        }
        if (!fptr.isWritable() || fptr.isDuplex()) return this.rbIoClose(context);
        throw runtime2.newIOError("closing non-duplex IO for reading");
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod(name={"close_on_exec="})
    public IRubyObject close_on_exec_set(ThreadContext context, IRubyObject arg2) {
        int ret;
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        int fd = -1;
        if (fptr == null || (fd = fptr.fd().realFileno) == -1 || !posix.isNative() || Platform.IS_WINDOWS) {
            runtime2.getWarnings().warningDeprecated("close_on_exec may not be implemented on this platform for this stream type: " + fptr.fd().ch.getClass().getSimpleName());
            return context.nil;
        }
        int flag = arg2.isTrue() ? 1 : 0;
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io && (fptr = write_io.getOpenFileChecked()) != null && 0 <= (fd = fptr.fd().realFileno)) {
            ret = posix.fcntl(fd, Fcntl.F_GETFD);
            if (ret == -1) {
                return API.sysFailWithPath(context, fptr.getPath());
            }
            if ((ret & 1) != flag) {
                ret = ret & 0xFFFFFFFE | flag;
                if ((ret = posix.fcntlInt(fd, Fcntl.F_SETFD, ret)) == -1) {
                    API.sysFailWithPath(context, fptr.getPath());
                }
            }
        }
        if ((fptr = this.getOpenFileChecked()) != null && 0 <= (fd = fptr.fd().realFileno)) {
            ret = posix.fcntl(fd, Fcntl.F_GETFD);
            if (ret == -1) {
                API.sysFailWithPath(context, fptr.getPath());
            }
            if ((ret & 1) != flag) {
                ret = ret & 0xFFFFFFFE | flag;
                if ((ret = posix.fcntlInt(fd, Fcntl.F_SETFD, ret)) == -1) {
                    API.sysFailWithPath(context, fptr.getPath());
                }
            }
        }
        return context.nil;
    }

    @JRubyMethod(name={"close_on_exec?", "close_on_exec"})
    public IRubyObject close_on_exec_p(ThreadContext context) {
        int ret;
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        int fd = -1;
        if (fptr == null || (fd = fptr.fd().realFileno) == -1 || !posix.isNative()) {
            return context.fals;
        }
        RubyIO write_io = this.GetWriteIO();
        if (this != write_io && (fptr = write_io.getOpenFileChecked()) != null && 0 <= (fd = fptr.fd().realFileno)) {
            ret = posix.fcntl(fd, Fcntl.F_GETFD);
            if (ret == -1) {
                API.sysFailWithPath(context, fptr.getPath());
            }
            if ((ret & 1) == 0) {
                return context.fals;
            }
        }
        if ((fptr = this.getOpenFileChecked()) != null && 0 <= (fd = fptr.fd().realFileno)) {
            ret = posix.fcntl(fd, Fcntl.F_GETFD);
            if (ret == -1) {
                API.sysFailWithPath(context, fptr.getPath());
            }
            if ((ret & 1) == 0) {
                return context.fals;
            }
        }
        return context.tru;
    }

    @JRubyMethod
    public RubyIO flush(ThreadContext context) {
        return this.flushRaw(context, true);
    }

    @Override
    public void flush() {
        this.flush(this.getRuntime().getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RubyIO flushRaw(ThreadContext context, boolean sync2) {
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            if ((fptr.getMode() & 2) != 0 && fptr.io_fflush(context) < 0) {
                throw context.runtime.newErrnoFromErrno(fptr.errno(), "");
            }
            if ((fptr.getMode() & 1) != 0) {
                fptr.unread(context);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return io2;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context) {
        return Getline.getlineCall(context, GETLINE, this, this.getReadEncoding(context));
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject gets(ThreadContext context, IRubyObject arg2) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE, this, this.getReadEncoding(context), arg2, keywords);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject gets(ThreadContext context, IRubyObject rs, IRubyObject limit_arg) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE, this, this.getReadEncoding(context), rs, limit_arg, keywords);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject gets(ThreadContext context, IRubyObject rs, IRubyObject limit_arg, IRubyObject opt) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE, this, this.getReadEncoding(context), rs, limit_arg, opt, keywords);
    }

    public boolean getBlocking() {
        return this.openFile.isBlocking();
    }

    public void setBlocking(boolean blocking2) {
        this.openFile.setBlocking(this.getRuntime(), blocking2);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd) {
        return this.ctl(context, cmd, null);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context, cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1, checkArity=false)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = argc == 2 ? args2[1] : context.nil;
        return this.ctl(context, cmd, arg2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IRubyObject ctl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        long realCmd = Convert.toLong(context, cmd);
        long nArg = 0L;
        if (realCmd == (long)Fcntl.F_GETFL.intValue()) {
            OpenFile myOpenFile = this.getOpenFileChecked();
            return Convert.asFixnum(context, OpenFile.ioFmodeOflags(myOpenFile.getMode()));
        }
        if (arg2 == null || arg2.isNil() || arg2 == context.fals) {
            nArg = 0L;
        } else if (arg2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg2;
            nArg = fixnum.getValue();
        } else {
            if (arg2 != context.tru) throw runtime2.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
            nArg = 1L;
        }
        OpenFile fptr = this.getOpenFileChecked();
        if (realCmd == 1L) {
            this.close_on_exec_set(context, context.tru);
            return Convert.asFixnum(context, 0);
        } else if (realCmd == (long)Fcntl.F_SETFD.intValue()) {
            if (arg2 == null || (nArg & 1L) != 1L) throw runtime2.newNotImplementedError("F_SETFD only supports FD_CLOEXEC");
            this.close_on_exec_set(context, arg2);
            return Convert.asFixnum(context, 0);
        } else {
            if (realCmd == (long)Fcntl.F_GETFD.intValue()) {
                return Convert.asFixnum(context, this.close_on_exec_p(context).isTrue() ? 1 : 0);
            }
            if (realCmd == (long)Fcntl.F_SETFL.intValue()) {
                if ((nArg & (long)OpenFlags.O_NONBLOCK.intValue()) != 0L) {
                    fptr.setBlocking(runtime2, false);
                } else {
                    fptr.setBlocking(runtime2, true);
                }
                if ((nArg & (long)OpenFlags.O_CLOEXEC.intValue()) != 0L) {
                    this.close_on_exec_set(context, context.tru);
                    return Convert.asFixnum(context, 0);
                } else {
                    this.close_on_exec_set(context, context.fals);
                }
                return Convert.asFixnum(context, 0);
            } else {
                if (realCmd != (long)Fcntl.F_GETFL.intValue()) throw runtime2.newNotImplementedError("JRuby only supports F_SETFL and F_GETFL with NONBLOCK for fcntl/ioctl");
                return Convert.asFixnum(context, (fptr.isBlocking() ? 0 : OpenFlags.O_NONBLOCK.intValue()) | (this.close_on_exec_p(context).isTrue() ? 1 : 0));
            }
        }
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context) {
        return RubyIO.puts0(context, this);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0) {
        return RubyIO.puts1(context, this, arg0);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.puts2(context, this, arg0, arg1);
    }

    @JRubyMethod(name={"puts"})
    public IRubyObject puts(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.puts3(context, this, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    public static IRubyObject puts0(ThreadContext context, IRubyObject maybeIO) {
        return RubyIO.writeSeparator(context, maybeIO);
    }

    public static IRubyObject puts1(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0) {
        Ruby runtime2 = context.runtime;
        assert (Access.globalVariables(context).getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)Access.globalVariables(context).getDefaultSeparator();
        RubyIO.putsSingle(context, runtime2, maybeIO, arg0, separator);
        return context.nil;
    }

    public static IRubyObject puts2(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.runtime;
        assert (Access.globalVariables(context).getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)Access.globalVariables(context).getDefaultSeparator();
        RubyIO.putsSingle(context, runtime2, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime2, maybeIO, arg1, separator);
        return context.nil;
    }

    public static IRubyObject puts3(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        assert (Access.globalVariables(context).getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)Access.globalVariables(context).getDefaultSeparator();
        RubyIO.putsSingle(context, runtime2, maybeIO, arg0, separator);
        RubyIO.putsSingle(context, runtime2, maybeIO, arg1, separator);
        RubyIO.putsSingle(context, runtime2, maybeIO, arg2, separator);
        return context.nil;
    }

    public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject ... args2) {
        if (args2.length == 0) {
            return RubyIO.writeSeparator(context, maybeIO);
        }
        return RubyIO.putsArray(context, maybeIO, args2);
    }

    private static IRubyObject writeSeparator(ThreadContext context, IRubyObject maybeIO) {
        Ruby runtime2 = context.runtime;
        assert (Access.globalVariables(context).getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)Access.globalVariables(context).getDefaultSeparator();
        RubyIO.write(context, maybeIO, separator);
        return context.nil;
    }

    private static IRubyObject putsArray(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        assert (Access.globalVariables(context).getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)Access.globalVariables(context).getDefaultSeparator();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyIO.putsSingle(context, runtime2, maybeIO, args2[i2], separator);
        }
        return context.nil;
    }

    private static void putsSingle(ThreadContext context, Ruby runtime2, IRubyObject maybeIO, IRubyObject arg2, RubyString separator) {
        boolean writeSeparator;
        RubyString string2;
        ByteList line;
        if (arg2.isNil()) {
            line = ByteList.EMPTY_BYTELIST;
            string2 = null;
        } else if (runtime2.isInspecting(arg2)) {
            line = RECURSIVE_BYTELIST;
            string2 = null;
        } else {
            if (arg2 instanceof RubyArray) {
                RubyIO.inspectPuts(context, maybeIO, (RubyArray)arg2);
                return;
            }
            string2 = arg2.asString();
            line = string2.getByteList();
        }
        boolean bl = writeSeparator = line.length() == 0 || !line.endsWith(separator.getByteList());
        if (string2 != null) {
            if (writeSeparator) {
                RubyIO.write(context, maybeIO, string2, (IRubyObject)separator);
            } else {
                RubyIO.write(context, maybeIO, string2);
            }
        } else if (writeSeparator) {
            RubyIO.write(context, maybeIO, line, (IRubyObject)separator);
        } else {
            RubyIO.write(context, maybeIO, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array2) {
        try {
            context.runtime.registerInspecting(array2);
            IRubyObject iRubyObject = RubyIO.putsArray(context, maybeIO, array2.toJavaArrayMaybeUnsafe());
            return iRubyObject;
        }
        finally {
            context.runtime.unregisterInspecting(array2);
        }
    }

    protected static IRubyObject write(ThreadContext context, IRubyObject maybeIO, ByteList byteList) {
        return RubyIO.write(context, maybeIO, Create.newSharedString(context, byteList));
    }

    protected static IRubyObject write(ThreadContext context, IRubyObject maybeIO, ByteList byteList, IRubyObject sep) {
        return RubyIO.write(context, maybeIO, Create.newSharedString(context, byteList), sep);
    }

    public static IRubyObject write(ThreadContext context, IRubyObject maybeIO, IRubyObject str) {
        return RubyIO.sites((ThreadContext)context).write.call(context, maybeIO, maybeIO, str);
    }

    public static IRubyObject write(ThreadContext context, IRubyObject maybeIO, IRubyObject arg0, IRubyObject arg1) {
        CachingCallSite write2 = RubyIO.sites((ThreadContext)context).write;
        if (write2.retrieveCache((RubyClass)maybeIO.getMetaClass()).method.getSignature().isOneArgument()) {
            Ruby runtime2 = context.runtime;
            if (runtime2.isVerbose() && maybeIO != Access.globalVariables(context).get("$stderr")) {
                RubyIO.warnWrite(context, maybeIO);
            }
            write2.call(context, maybeIO, maybeIO, arg0);
            write2.call(context, maybeIO, maybeIO, arg1);
            return arg0;
        }
        return write2.call(context, maybeIO, maybeIO, arg0, arg1);
    }

    public static IRubyObject writev(ThreadContext context, IRubyObject io2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyIO.writev(context, io2);
            }
            case 1: {
                return RubyIO.writev(context, io2, args2[0]);
            }
            case 2: {
                return RubyIO.writev(context, io2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.writev(context, io2, args2[0], args2[1], args2[2]);
            }
        }
        CachingCallSite write2 = RubyIO.sites((ThreadContext)context).write;
        if (args2.length > 1 && write2.retrieveCache((IRubyObject)io2).method.getSignature() == Signature.ONE_ARGUMENT) {
            RubyIO.warnWrite(context, io2);
            for (IRubyObject arg2 : args2) {
                write2.call(context, io2, io2, arg2);
            }
            return context.nil;
        }
        return write2.call(context, io2, io2, args2);
    }

    public static IRubyObject writev(ThreadContext context, IRubyObject io2) {
        return RubyIO.sites((ThreadContext)context).write.call(context, io2, io2);
    }

    public static IRubyObject writev(ThreadContext context, IRubyObject io2, IRubyObject arg0) {
        return RubyIO.sites((ThreadContext)context).write.call(context, io2, io2, arg0);
    }

    public static IRubyObject writev(ThreadContext context, IRubyObject io2, IRubyObject arg0, IRubyObject arg1) {
        CachingCallSite write2 = RubyIO.sites((ThreadContext)context).write;
        if (write2.retrieveCache((IRubyObject)io2).method.getSignature() == Signature.ONE_ARGUMENT) {
            RubyIO.warnWrite(context, io2);
            write2.call(context, io2, io2, arg0);
            write2.call(context, io2, io2, arg1);
            return context.nil;
        }
        return write2.call(context, io2, io2, arg0, arg1);
    }

    public static IRubyObject writev(ThreadContext context, IRubyObject io2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        CachingCallSite write2 = RubyIO.sites((ThreadContext)context).write;
        if (write2.retrieveCache((IRubyObject)io2).method.getSignature() == Signature.ONE_ARGUMENT) {
            RubyIO.warnWrite(context, io2);
            write2.call(context, io2, io2, arg0);
            write2.call(context, io2, io2, arg1);
            write2.call(context, io2, io2, arg2);
            return context.nil;
        }
        return write2.call(context, io2, io2, arg0, arg1, arg2);
    }

    private static void warnWrite(ThreadContext context, IRubyObject maybeIO) {
        if (maybeIO != Access.globalVariables(context).get("$stderr") && context.runtime.isVerbose()) {
            char sep;
            IRubyObject klass = maybeIO.getMetaClass();
            if (((RubyClass)klass).isSingleton()) {
                klass = maybeIO;
                sep = '.';
            } else {
                sep = '#';
            }
            Warn.warningDeprecated(context, klass.toString() + sep + "write is outdated interface which accepts just one argument");
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        OpenFile openFile = this.openFile;
        if (openFile == null) {
            return super.inspect(context);
        }
        String className = this.getMetaClass().getRealClass().getName(context);
        Object path2 = openFile.getPath();
        String status2 = "";
        if (path2 == null || path2 == "") {
            if (openFile.fd() == null) {
                path2 = "";
                status2 = "(closed)";
            } else {
                path2 = "fd " + openFile.fd().bestFileno();
            }
        } else if (!openFile.isOpen()) {
            status2 = " (closed)";
        }
        return Create.newString(context, "#<" + className + ":" + (String)path2 + status2 + ">");
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject line = this.gets(context);
        if (line == context.nil) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject readline(ThreadContext context, IRubyObject separator) {
        IRubyObject line = this.gets(context, separator);
        if (line == context.nil) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject readline(ThreadContext context, IRubyObject separator, IRubyObject limit2) {
        IRubyObject line = this.gets(context, separator, limit2);
        if (line == context.nil) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE}, keywords=true)
    public IRubyObject readline(ThreadContext context, IRubyObject separator, IRubyObject limit2, IRubyObject opts) {
        IRubyObject line = this.gets(context, separator, limit2, opts);
        if (line == context.nil) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @Deprecated
    public IRubyObject getc() {
        return this.getbyte(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject readchar(ThreadContext context) {
        IRubyObject c = this.getc(context);
        if (c == context.nil) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject getbyte(ThreadContext context) {
        int c = this.getByte(context);
        return c == -1 ? context.nil : Convert.asFixnum(context, c & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getByte(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            fptr.READ_CHECK(context);
            if (fptr.fillbuf(context) < 0) {
                int n = -1;
                return n;
            }
            ++fptr.rbuf.off;
            --fptr.rbuf.len;
            int n = fptr.rbuf.ptr[fptr.rbuf.off - 1] & 0xFF;
            return n;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod
    public IRubyObject readbyte(ThreadContext context) {
        IRubyObject c = this.getbyte(context);
        if (c == context.nil) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            Encoding enc = fptr.inputEncoding(runtime2);
            fptr.READ_CHECK(context);
            IRubyObject iRubyObject = fptr.getc(context, enc);
            return iRubyObject;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext context, IRubyObject b2) {
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (b2.isNil()) {
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            if (b2 instanceof RubyInteger) {
                RubyInteger bint = (RubyInteger)b2;
                byte cc = (byte)((RubyInteger)bint.op_mod(context, 256L)).asInt(context);
                b2 = RubyString.newStringNoCopy(context.runtime, new byte[]{cc});
            } else {
                b2 = b2.convertToString();
            }
            fptr.ungetbyte(context, b2);
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject ungetc(ThreadContext context, IRubyObject c) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            c = c instanceof RubyInteger ? EncodingUtils.encUintChr(context, (int)((RubyInteger)c).asLong(context), fptr.readEncoding(runtime2)) : c.convertToString();
            if (fptr.needsReadConversion()) {
                fptr.SET_BINARY_MODE();
                int len = ((RubyString)c).size();
                fptr.makeReadConversion(context, len);
                if (fptr.cbuf.capa - fptr.cbuf.len < len) {
                    throw runtime2.newIOError("ungetc failed");
                }
                if (fptr.cbuf.off < len) {
                    System.arraycopy(fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.ptr, fptr.cbuf.capa - fptr.cbuf.len, fptr.cbuf.len);
                    fptr.cbuf.off = fptr.cbuf.capa - fptr.cbuf.len;
                }
                fptr.cbuf.off -= len;
                fptr.cbuf.len += len;
                ByteList cByteList = ((RubyString)c).getByteList();
                System.arraycopy(cByteList.unsafeBytes(), cByteList.begin(), fptr.cbuf.ptr, fptr.cbuf.off, len);
            } else {
                fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
                fptr.ungetbyte(context, c);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    @JRubyMethod(name={"read_nonblock"})
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject arg0) {
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", arg0) != context.fals;
        return this.doReadNonblock(context, arg0, exception2);
    }

    @JRubyMethod(name={"read_nonblock"})
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", arg1) != context.fals;
        return this.doReadNonblock(context, arg0, arg1, exception2);
    }

    @JRubyMethod(name={"read_nonblock"})
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", arg2) != context.fals;
        return this.doReadNonblock(context, arg0, arg1, arg2, exception2);
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject arg0, boolean exception2) {
        IRubyObject ret = this.getPartial(context, arg0, true, !exception2);
        return ret == context.nil ? RubyIO.nonblockEOF(context.runtime, !exception2) : ret;
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject arg0, IRubyObject arg1, boolean exception2) {
        IRubyObject ret = this.getPartial(context, arg0, arg1, true, !exception2);
        return ret == context.nil ? RubyIO.nonblockEOF(context.runtime, !exception2) : ret;
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, boolean exception2) {
        IRubyObject ret = this.getPartial(context, arg0, arg1, arg2, true, !exception2);
        return ret == context.nil ? RubyIO.nonblockEOF(context.runtime, !exception2) : ret;
    }

    public IRubyObject doReadNonblock(ThreadContext context, IRubyObject[] args2, boolean exception2) {
        IRubyObject ret = this.getPartial(context, args2, true, !exception2);
        return ret == context.nil ? RubyIO.nonblockEOF(context.runtime, !exception2) : ret;
    }

    static IRubyObject nonblockEOF(Ruby runtime2, boolean noException) {
        if (noException) {
            return runtime2.getNil();
        }
        throw runtime2.newEOFError();
    }

    @JRubyMethod(name={"readpartial"})
    public IRubyObject readpartial(ThreadContext context, IRubyObject arg0) {
        IRubyObject value2 = this.getPartial(context, arg0, false, false);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    @JRubyMethod(name={"readpartial"})
    public IRubyObject readpartial(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject value2 = this.getPartial(context, arg0, arg1 = arg1.convertToString(), false, false);
        if (value2.isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    IRubyObject getPartial(ThreadContext context, boolean nonblock2, boolean noException) {
        return this.getPartialCommon(context, context.runtime, context.nil, context.nil, nonblock2, noException);
    }

    IRubyObject getPartial(ThreadContext context, IRubyObject arg0, boolean nonblock2, boolean noException) {
        return this.getPartialCommon(context, context.runtime, arg0, context.nil, nonblock2, noException);
    }

    IRubyObject getPartial(ThreadContext context, IRubyObject arg0, IRubyObject arg1, boolean nonblock2, boolean noException) {
        Ruby runtime2 = context.runtime;
        IRubyObject str = TypeConverter.checkHashType(runtime2, arg1).isNil() ? arg1 : context.nil;
        return this.getPartialCommon(context, runtime2, arg0, str, nonblock2, noException);
    }

    IRubyObject getPartial(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, boolean nonblock2, boolean noException) {
        arg2.convertToHash();
        return this.getPartialCommon(context, context.runtime, arg0, arg1, nonblock2, noException);
    }

    IRubyObject getPartial(ThreadContext context, IRubyObject[] args2, boolean nonblock2, boolean noException) {
        switch (args2.length) {
            case 3: {
                return this.getPartial(context, args2[0], args2[1], args2[2], nonblock2, noException);
            }
            case 2: {
                return this.getPartial(context, args2[0], args2[1], nonblock2, noException);
            }
            case 1: {
                return this.getPartial(context, args2[0], nonblock2, noException);
            }
        }
        return this.getPartial(context, nonblock2, noException);
    }

    /*
     * Exception decompiling
     */
    private IRubyObject getPartialCommon(ThreadContext context, Ruby runtime, IRubyObject length, IRubyObject str, boolean nonblock, boolean noException) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @JRubyMethod(name={"sysread"})
    public IRubyObject sysread(ThreadContext context, IRubyObject _length) {
        return this.sysreadCommon(context, context.runtime, _length, context.nil);
    }

    @JRubyMethod(name={"sysread"})
    public IRubyObject sysread(ThreadContext context, IRubyObject _length, IRubyObject _str) {
        return this.sysreadCommon(context, context.runtime, _length, _str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyString sysreadCommon(ThreadContext context, Ruby runtime2, IRubyObject _length, IRubyObject _str) {
        int n;
        int length2 = Convert.toInt(context, _length);
        RubyString str = EncodingUtils.setStrBuf(runtime2, _str, length2);
        if (length2 == 0) {
            return str;
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (fptr.READ_DATA_BUFFERED()) {
                throw runtime2.newIOError("sysread for buffered IO");
            }
            context.getThread().select(fptr.channel(), fptr, 1);
            fptr.checkClosed();
            ByteList strByteList = str.getByteList();
            n = OpenFile.readInternal(context, fptr, fptr.fd(), strByteList.unsafeBytes(), strByteList.begin(), length2);
            if (n == -1) {
                throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        if (n == 0 && length2 > 0) {
            throw runtime2.newEOFError();
        }
        str.setReadLength(n);
        return str;
    }

    @Deprecated(since="10.0")
    public IRubyObject read(IRubyObject[] args2) {
        return this.read(this.getCurrentContext(), args2);
    }

    public IRubyObject read(ThreadContext context, IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.read(context);
            case 1 -> this.read(context, args2[0]);
            case 2 -> this.read(context, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 2);
        };
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        return this.read(context, context.nil, context.nil);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject length2) {
        return this.read(context, length2, context.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject length2, IRubyObject maybeStr) {
        if (length2 == context.nil) {
            OpenFile fptr = this.getOpenFileChecked();
            boolean locked2 = fptr.lock();
            try {
                fptr.checkCharReadable(context);
                IRubyObject iRubyObject = fptr.readAll(context, fptr.remainSize(), maybeStr);
                return iRubyObject;
            }
            finally {
                if (locked2) {
                    fptr.unlock();
                }
            }
        }
        int len = Convert.toInt(context, length2);
        this.checkLength(context, len);
        RubyString str = EncodingUtils.setStrBuf(context.runtime, maybeStr, len);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked3 = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            if (len == 0) {
                str.setReadLength(0);
                RubyString rubyString = str;
                return rubyString;
            }
            ByteList strByteList = str.getByteList();
            len = RubyIO.doRead(context, fptr, strByteList.unsafeBytes(), strByteList.begin(), len);
        }
        finally {
            if (locked3) {
                fptr.unlock();
            }
        }
        str.setReadLength(len);
        if (len == 0) {
            return context.nil;
        }
        return str;
    }

    protected void checkLength(ThreadContext context, int len) {
        if (len < 0) {
            throw Error.argumentError(context, "negative length " + len + " given");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ThreadContext context, byte[] buffer, int start2, int len) {
        this.checkLength(context, len);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkByteReadable(context);
            len = RubyIO.doRead(context, fptr, buffer, start2, len);
            if (len == 0) {
                int n = -1;
                return n;
            }
            int n = len;
            return n;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    protected static int doRead(ThreadContext context, OpenFile fptr, byte[] buffer, int start2, int len) {
        if (len == 0) {
            return len;
        }
        fptr.READ_CHECK(context);
        return fptr.fread(context, buffer, start2, len);
    }

    @Deprecated
    public IRubyObject readchar() {
        return this.readchar(this.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            int realFileno;
            fptr.checkClosed();
            if (runtime2.getPosix().isNative() && (realFileno = fptr.fd().realFileno) != -1) {
                RubyFileStat rubyFileStat = RubyFileStat.newFileStat(runtime2, realFileno);
                return rubyFileStat;
            }
            RubyFileStat rubyFileStat = context.runtime.newFileStat(fptr.getPath(), false);
            return rubyFileStat;
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject each_byteInternal(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            while (true) {
                if (fptr.rbuf.len > 0) {
                    int p2;
                    byte[] pBytes = fptr.rbuf.ptr;
                    ++fptr.rbuf.off;
                    --fptr.rbuf.len;
                    block.yield(context, Convert.asFixnum(context, pBytes[p2] & 0xFF));
                    fptr.errno(null);
                    continue;
                }
                fptr.checkByteReadable(context);
                fptr.READ_CHECK(context);
                if (fptr.fillbuf(context) < 0) break;
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byteInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @Deprecated(since="10.0")
    public IRubyObject bytes(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#bytes is deprecated; use #each_byte instead");
        return this.each_byte(context, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            IRubyObject c;
            fptr.checkCharReadable(context);
            Encoding enc = fptr.inputEncoding(runtime2);
            fptr.READ_CHECK(context);
            while (!(c = fptr.getc(context, enc)).isNil()) {
                block.yield(context, c);
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return this;
    }

    @JRubyMethod(name={"each_char"})
    public IRubyObject each_char(ThreadContext context, Block block) {
        return this.each_charInternal(context, block);
    }

    @Deprecated(since="10.0")
    public IRubyObject chars(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#chars is deprecated; use #each_char instead");
        return this.each_charInternal(context, block);
    }

    @Deprecated(since="10.0")
    public IRubyObject codepoints(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#codepoints is deprecated; use #each_codepoint instead");
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject eachCodePointCommon(ThreadContext context, Block block, String methodName) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, methodName);
        }
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            fptr.checkCharReadable(context);
            fptr.READ_CHECK(context);
            if (fptr.needsReadConversion()) {
                fptr.SET_BINARY_MODE();
                int r = 1;
                while (true) {
                    block20: {
                        fptr.makeReadConversion(context);
                        do {
                            if (fptr.cbuf.len == 0) continue;
                            r = fptr.encs.enc != null ? StringSupport.preciseLength(fptr.encs.enc, fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.off + fptr.cbuf.len) : StringSupport.CONSTRUCT_MBCLEN_CHARFOUND(1);
                            if (StringSupport.MBCLEN_NEEDMORE_P(r)) {
                                if (fptr.cbuf.len != fptr.cbuf.capa) continue;
                                throw context.runtime.newIOError("too long character");
                            }
                            break block20;
                        } while (fptr.moreChar(context) != 1);
                        fptr.clearReadConversion();
                        if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                            throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(fptr.encs.enc));
                        }
                        RubyIO rubyIO = this;
                        return rubyIO;
                    }
                    if (StringSupport.MBCLEN_INVALID_P(r)) {
                        throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(fptr.encs.enc));
                    }
                    int n = StringSupport.MBCLEN_CHARFOUND_LEN(r);
                    int c = fptr.encs.enc != null ? StringSupport.codePoint(context, fptr.encs.enc, fptr.cbuf.ptr, fptr.cbuf.off, fptr.cbuf.off + fptr.cbuf.len) : fptr.cbuf.ptr[fptr.cbuf.off] & 0xFF;
                    fptr.cbuf.off += n;
                    fptr.cbuf.len -= n;
                    block.yield(context, Convert.asFixnum(context, c & 0xFFFFFFFF));
                }
            }
            fptr.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
            Encoding enc = fptr.inputEncoding(context.runtime);
            while (fptr.fillbuf(context) >= 0) {
                int c;
                int n;
                int r = StringSupport.preciseLength(enc, fptr.rbuf.ptr, fptr.rbuf.off, fptr.rbuf.off + fptr.rbuf.len);
                if (StringSupport.MBCLEN_CHARFOUND_P(r) && (n = StringSupport.MBCLEN_CHARFOUND_LEN(r)) <= fptr.rbuf.len) {
                    c = StringSupport.codePoint(context, enc, fptr.rbuf.ptr, fptr.rbuf.off, fptr.rbuf.off + fptr.rbuf.len);
                    fptr.rbuf.off += n;
                    fptr.rbuf.len -= n;
                    block.yield(context, Convert.asFixnum(context, c & 0xFFFFFFFF));
                    continue;
                }
                if (StringSupport.MBCLEN_INVALID_P(r)) {
                    throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
                }
                if (!StringSupport.MBCLEN_NEEDMORE_P(r)) continue;
                byte[] cbuf = new byte[8];
                int p2 = 0;
                int more = StringSupport.MBCLEN_NEEDMORE_LEN(r);
                if (more > cbuf.length) {
                    throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
                }
                n = fptr.rbuf.len;
                if ((more += n) > cbuf.length) {
                    throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
                }
                while ((n = fptr.readBufferedData(cbuf, p2, more)) > 0) {
                    p2 += n;
                    if ((more -= n) <= 0) break;
                    if (fptr.fillbuf(context) < 0) {
                        throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
                    }
                    n = fptr.rbuf.len;
                    if (n <= more) continue;
                    n = more;
                }
                if (!StringSupport.MBCLEN_CHARFOUND_P(r = enc.length(cbuf, 0, p2))) {
                    throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
                }
                c = enc.mbcToCode(cbuf, 0, p2);
                block.yield(context, Convert.asFixnum(context, c));
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), block);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each(ThreadContext context, IRubyObject arg0, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, block, keywords);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, arg1, block, keywords);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, arg1, arg2, block, keywords);
    }

    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.each(context, block);
            }
            case 1: {
                return this.each(context, args2[0], block);
            }
            case 2: {
                return this.each(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.each(context, args2[0], args2[1], args2[2], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod
    public IRubyObject each_line(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), block);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0);
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, block, keywords);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0, arg1);
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, arg1, block, keywords);
    }

    @JRubyMethod(keywords=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0, arg1, arg2);
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getReadEncoding(context), arg0, arg1, arg2, block, keywords);
    }

    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.each_line(context, block);
            }
            case 1: {
                return this.each_line(context, args2[0], block);
            }
            case 2: {
                return this.each_line(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.each_line(context, args2[0], args2[1], args2[2], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @Deprecated(since="10.0")
    public IRubyObject lines(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("IO#lines is deprecated; use #each_line instead");
        return this.each_line(context, block);
    }

    @JRubyMethod(name={"readlines"})
    public RubyArray readlines(ThreadContext context) {
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getReadEncoding(context));
    }

    @JRubyMethod(name={"readlines"}, keywords=true)
    public RubyArray readlines(ThreadContext context, IRubyObject arg0) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getReadEncoding(context), arg0, keywords);
    }

    @JRubyMethod(name={"readlines"}, keywords=true)
    public RubyArray readlines(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getReadEncoding(context), arg0, arg1, keywords);
    }

    @JRubyMethod(name={"readlines"}, keywords=true)
    public RubyArray readlines(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getReadEncoding(context), arg0, arg1, arg2, keywords);
    }

    private Encoding getReadEncoding(ThreadContext context) {
        return this.getOpenFileChecked().readEncoding(context.runtime);
    }

    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.readlines(context);
            }
            case 1: {
                return this.readlines(context, args2[0]);
            }
            case 2: {
                return this.readlines(context, args2[0], args2[1]);
            }
            case 3: {
                return this.readlines(context, args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return this.inspect(this.getRuntime().getCurrentContext()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IRubyObject foreachInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, boolean keywords, Block block) {
        IRubyObject nil;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        RubyIO io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);
        if (io2 == (nil = context.nil)) {
            return io2;
        }
        try {
            switch (args2.length) {
                case 1: {
                    Getline.getlineCall(context, GETLINE_YIELD, io2, io2.getReadEncoding(context), block);
                    return nil;
                }
                case 2: {
                    Getline.getlineCall(context, GETLINE_YIELD, io2, io2.getReadEncoding(context), args2[1], block, keywords);
                    return nil;
                }
                case 3: {
                    Getline.getlineCall(context, GETLINE_YIELD, io2, io2.getReadEncoding(context), args2[1], args2[2], block, keywords);
                    return nil;
                }
                case 4: {
                    Getline.getlineCall(context, GETLINE_YIELD, io2, io2.getReadEncoding(context), args2[1], args2[2], args2[3], block, keywords);
                    return nil;
                }
                default: {
                    Arity.checkArgumentCount(context, args2.length - (keywords ? 1 : 0), 1, 3);
                    return nil;
                }
            }
        }
        finally {
            io2.close();
            context.setLastLine(nil);
        }
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=3, checkArity=false, meta=true, writes={FrameField.LASTLINE}, keywords=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        boolean keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        Arity.checkArgumentCount(context, args2.length - (keywords ? 1 : 0), 1, 4);
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "foreach", args2);
        }
        return RubyIO.foreachInternal(context, recv2, args2, keywords, block);
    }

    public static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        return TypeConverter.ioGetIO(context.runtime, obj);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, checkArity=false, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2) {
        Long timeout2;
        IRubyObject _timeout;
        IRubyObject result2;
        IRubyObject scheduler;
        if (((Boolean)Options.FIBER_SCHEDULER.load()).booleanValue() && !(scheduler = context.getFiberCurrentThread().getSchedulerCurrent()).isNil() && (result2 = FiberScheduler.ioSelectv(context, scheduler, argv2)) != UNDEF) {
            return result2;
        }
        int argc = Arity.checkArgumentCount(context, argv2, 1, 4);
        IRubyObject except2 = _timeout = context.nil;
        IRubyObject write2 = _timeout;
        IRubyObject read2 = _timeout;
        switch (argc) {
            case 4: {
                _timeout = argv2[3];
            }
            case 3: {
                except2 = argv2[2];
            }
            case 2: {
                write2 = argv2[1];
            }
            case 1: {
                read2 = argv2[0];
            }
        }
        if (_timeout.isNil()) {
            timeout2 = null;
        } else {
            try {
                _timeout = RubyIO.sites((ThreadContext)context).to_f.call(context, _timeout, _timeout);
            }
            catch (RaiseException e) {
                TypeConverter.handleUncoercibleObject(context.runtime, _timeout, Access.floatClass(context), true);
                throw e;
            }
            double t = _timeout.convertToFloat().asDouble(context);
            if (t < 0.0) {
                throw Error.argumentError(context, "negative timeout");
            }
            timeout2 = (long)(t * 1000.0);
        }
        SelectExecutor args2 = new SelectExecutor(read2, write2, except2, timeout2);
        return args2.go(context);
    }

    @JRubyMethod(optional=1)
    public IRubyObject wait_readable(ThreadContext context, IRubyObject[] argv2) {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.checkReadable(context);
        long tv = RubyIO.prepareTimeout(context, argv2);
        if (fptr.readPending() != 0) {
            return context.tru;
        }
        return this.doWait(context, fptr, tv, 17);
    }

    @JRubyMethod(optional=1)
    public IRubyObject wait_writable(ThreadContext context, IRubyObject[] argv2) {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.checkWritable(context);
        long tv = RubyIO.prepareTimeout(context, argv2);
        return this.doWait(context, fptr, tv, 12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(optional=2)
    public IRubyObject wait(ThreadContext context, IRubyObject[] argv2) {
        OpenFile fptr = this.getOpenFileChecked();
        int ops = 0;
        if (argv2.length == 2) {
            if (argv2[1] instanceof RubySymbol) {
                RubySymbol sym = (RubySymbol)argv2[1];
                switch (sym.asJavaString()) {
                    case "r": 
                    case "read": 
                    case "readable": {
                        ops |= 0x11;
                        break;
                    }
                    case "w": 
                    case "write": 
                    case "writable": {
                        ops |= 0xC;
                        break;
                    }
                    case "rw": 
                    case "read_write": 
                    case "readable_writable": {
                        ops |= 0x1D;
                        break;
                    }
                    default: {
                        throw Error.argumentError(context, "unsupported mode: " + String.valueOf(sym));
                    }
                }
            } else {
                IRubyObject sym = argv2[1];
                if (!(sym instanceof RubyFixnum)) throw Error.argumentError(context, "unsupported mode: " + String.valueOf(argv2[1].getType()));
                RubyFixnum fix2 = (RubyFixnum)sym;
                int fixint = fix2.asInt(context);
                if ((fixint & IOEvent.IO_READABLE.value) != 0) {
                    ops |= 0x11;
                }
                if ((fixint & IOEvent.IO_WRITABLE.value) != 0) {
                    ops |= 0xC;
                }
            }
        } else {
            ops |= 0x11;
        }
        if ((ops & 1) == 1 && fptr.readPending() != 0) {
            return context.tru;
        }
        long tv = RubyIO.prepareTimeout(context, argv2);
        return this.doWait(context, fptr, tv, ops);
    }

    private IRubyObject doWait(ThreadContext context, OpenFile fptr, long tv, int ops) {
        boolean ready = fptr.ready(context.runtime, context.getThread(), ops, tv);
        fptr.checkClosed();
        if (ready) {
            return this;
        }
        return context.nil;
    }

    private static long prepareTimeout(ThreadContext context, IRubyObject[] argv2) {
        long tv;
        IRubyObject timeout2 = switch (argv2.length) {
            case 1, 2 -> argv2[0];
            default -> context.nil;
        };
        if (timeout2.isNil()) {
            tv = -1L;
        } else {
            tv = (long)(RubyTime.convertTimeInterval(context, timeout2) * 1000.0);
            if (tv < 0L) {
                throw Error.argumentError(context, "time interval must be positive");
            }
        }
        return tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=2, checkArity=false)
    public IRubyObject advise(ThreadContext context, IRubyObject[] argv2) {
        IRubyObject len;
        IRubyObject offset2 = len = context.nil;
        IRubyObject advice = len;
        switch (argv2.length) {
            case 3: {
                len = argv2[2];
            }
            case 2: {
                offset2 = argv2[1];
            }
            case 1: {
                advice = argv2[0];
                break;
            }
            default: {
                Arity.raiseArgumentError(context, argv2, 1, 3);
            }
        }
        PosixFadvise fadvise = RubyIO.adviceArgCheck(context, advice);
        int off = offset2.isNil() ? 0 : Convert.toInt(context, offset2);
        int l = len.isNil() ? 0 : Convert.toInt(context, len);
        POSIX posix = context.runtime.getNativePosix();
        RubyIO io2 = this.GetWriteIO();
        OpenFile fptr = io2.getOpenFileChecked();
        if (!(posix instanceof Linux)) {
            return context.nil;
        }
        int fd = fptr.fd().realFileno;
        if (fd == -1) {
            return context.nil;
        }
        boolean locked2 = fptr.lock();
        try {
            int res = ((Linux)posix).posix_fadvise(fd, (long)off, (long)l, fadvise);
            if (res != 0) {
                throw context.runtime.newErrnoFromInt(posix.errno(), "posix_fadvise");
            }
        }
        finally {
            if (locked2) {
                fptr.unlock();
            }
        }
        return context.nil;
    }

    static PosixFadvise adviceArgCheck(ThreadContext context, IRubyObject advice) {
        String adviceStr;
        if (!(advice instanceof RubySymbol)) {
            throw Error.typeError(context, "advise must be a symbol");
        }
        switch (adviceStr = advice.asJavaString()) {
            default: {
                throw context.runtime.newNotImplementedError(RubyIO.rbInspect(context, advice).toString());
            }
            case "normal": 
            case "sequential": 
            case "random": 
            case "willneed": 
            case "dontneed": 
            case "noreuse": 
        }
        return PosixFadvise.valueOf((String)("POSIX_FADV_" + adviceStr.toUpperCase()));
    }

    public static void failIfDirectory(Ruby runtime2, RubyString pathStr) {
        if (RubyFileTest.directory_p(runtime2.getCurrentContext(), (IRubyObject)pathStr).isTrue()) {
            if (Platform.IS_WINDOWS) {
                throw runtime2.newErrnoEACCESError(pathStr.asJavaString());
            }
            throw runtime2.newErrnoEISDirError(pathStr.asJavaString());
        }
    }

    private static RubyIO openKeyArgs(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2, IRubyObject opt) {
        IRubyObject vmode = context.nil;
        IRubyObject vperm = context.nil;
        RubyString path2 = RubyFile.get_path(context, argv2[0]);
        RubyIO.failIfDirectory(context.runtime, path2);
        if (opt == context.nil) {
            vmode = Convert.asFixnum(context, ModeFlags.RDONLY);
            vperm = Convert.asFixnum(context, 438);
        } else {
            IRubyObject v = ((RubyHash)opt).op_aref(context, Convert.asSymbol(context, "open_args"));
            if (v != context.nil) {
                RubyArray vAry = v.convertToArray();
                int n = vAry.size();
                Arity.checkArgumentCount(context, n, 0, 3);
                opt = ArgsUtil.getOptionsArg(context.runtime, vAry.toJavaArrayMaybeUnsafe());
                if (opt != context.nil) {
                    --n;
                }
                switch (n) {
                    case 2: {
                        vperm = vAry.eltOk(1L);
                    }
                    case 1: {
                        vmode = vAry.eltOk(0L);
                    }
                }
            }
        }
        return RubyIO.ioOpen(context, recv2, path2, vmode, vperm, opt);
    }

    public static IRubyObject ioOpen(ThreadContext context, IRubyObject recv2, IRubyObject filename2, IRubyObject vmode, IRubyObject vperm, IRubyObject opt) {
        return RubyIO.ioOpen(context, recv2, filename2.asString(), vmode, vperm, opt);
    }

    static RubyIO ioOpen(ThreadContext context, IRubyObject recv2, RubyString filename2, IRubyObject vmode, IRubyObject vperm, IRubyObject opt) {
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convConfig = new IOEncodable.ConvConfig();
        API.ModeAndPermission pm = new API.ModeAndPermission(vmode, vperm);
        EncodingUtils.extractModeEncoding(context, (IOEncodable)convConfig, pm, opt, oflags_p, fmode_p);
        vperm = EncodingUtils.vperm(pm);
        int perm = vperm == null || vperm == context.nil ? 438 : Convert.toInt(context, vperm);
        return RubyIO.ioOpenGeneric(context, recv2, filename2, oflags_p[0], fmode_p[0], convConfig, perm);
    }

    private static RubyIO ioOpenGeneric(ThreadContext context, IRubyObject recv2, IRubyObject filename2, int oflags, int fmode, IOEncodable convconfig, int perm) {
        IRubyObject cmd;
        RubyString name2;
        if (filename2 instanceof RubyString && (name2 = (RubyString)filename2).isEmpty()) {
            throw context.runtime.newErrnoENOENTError();
        }
        if (recv2 == Access.ioClass(context) && (cmd = PopenExecutor.checkPipeCommand(context, filename2)) != context.nil) {
            Warn.warnDeprecated(context, "IO process creation with a leading '|' is deprecated and will be removed in Ruby 4.0; use IO.popen instead");
            if (PopenExecutor.nativePopenAvailable(context.runtime)) {
                return (RubyIO)PopenExecutor.pipeOpen(context, cmd, OpenFile.ioOflagsModestr(context, oflags), fmode, convconfig);
            }
            throw Error.argumentError(context, "pipe open is not supported without native subprocess logic");
        }
        return (RubyIO)((RubyFile)Access.fileClass(context).allocate(context)).fileOpenGeneric(context, filename2, oflags, fmode, convconfig, perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=1, optional=2, checkArity=false)
    public static IRubyObject binread(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        RubyString path2 = RubyFile.get_path(context, args2[0]);
        IRubyObject length2 = context.nil;
        IRubyObject offset2 = context.nil;
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        int fmode = 5;
        OpenFlags oBinary = OpenFlags.O_BINARY;
        int oflags = OpenFlags.O_RDONLY.intValue() | (oBinary.defined() ? oBinary.intValue() : 0);
        if (argc > 2) {
            offset2 = args2[2];
            length2 = args2[1];
        } else if (argc > 1) {
            length2 = args2[1];
        }
        convconfig.setEnc((Encoding)ASCIIEncoding.INSTANCE);
        RubyIO file2 = RubyIO.ioOpenGeneric(context, recv2, path2, oflags, fmode, convconfig, 0);
        if (file2.isNil()) {
            return context.nil;
        }
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.read(context, length2);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, required=1, optional=3, checkArity=false, keywords=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        long off;
        IRubyObject options2;
        IRubyObject keywords = IRRuntimeHelpers.receiveKeywords(context, args2, false, true, false);
        int argc = Arity.checkArgumentCount(context, args2, 1, 4);
        IRubyObject path2 = args2[0];
        IRubyObject offset2 = options2 = context.nil;
        IRubyObject length2 = options2;
        if (argc > 3) {
            if (!(keywords instanceof RubyHash)) {
                throw Error.argumentError(context, args2.length, 1, 4);
            }
            options2 = args2[3];
            offset2 = args2[2];
            length2 = args2[1];
        } else if (argc > 2) {
            if (keywords instanceof RubyHash) {
                options2 = keywords;
            } else {
                offset2 = args2[2];
            }
            length2 = args2[1];
        } else if (argc > 1) {
            if (keywords instanceof RubyHash) {
                options2 = keywords;
            } else {
                length2 = args2[1];
            }
        }
        if (options2 == null) {
            options2 = Create.newHash(context);
        }
        if (!offset2.isNil() && (off = Convert.toLong(context, offset2)) < 0L) {
            throw Error.argumentError(context, "negative offset " + off + " given");
        }
        try (RubyIO file2 = RubyIO.openKeyArgs(context, recv2, new IRubyObject[]{path2, length2, offset2}, options2);){
            if (offset2 != context.nil) {
                file2.seek(context, offset2);
            }
            IRubyObject iRubyObject = file2.read(context, length2);
            return iRubyObject;
        }
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.read(context, recv2, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true, required=2, optional=2, checkArity=false, keywords=true)
    public static IRubyObject binwrite(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.ioStaticWrite(context, recv2, args2, true);
    }

    @JRubyMethod(name={"write"}, meta=true, required=2, optional=2, checkArity=false, keywords=true)
    public static IRubyObject write(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2) {
        return RubyIO.ioStaticWrite(context, recv2, argv2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ioStaticWrite(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2, boolean binary) {
        RubyIO _io;
        IRubyObject opt;
        IRubyObject keywords = IRRuntimeHelpers.receiveKeywords(context, argv2, false, true, false);
        Ruby runtime2 = context.runtime;
        IRubyObject offset2 = opt = context.nil;
        IRubyObject string2 = opt;
        switch (argv2.length) {
            case 4: {
                if (!(keywords instanceof RubyHash)) {
                    throw runtime2.newArgumentError(argv2.length, 2, 3);
                }
                opt = keywords;
                offset2 = argv2[2];
                string2 = argv2[1];
                break;
            }
            case 3: {
                if (keywords instanceof RubyHash) {
                    opt = keywords;
                } else {
                    offset2 = argv2[2];
                }
                string2 = argv2[1];
                break;
            }
            case 2: {
                string2 = argv2[1];
                break;
            }
            default: {
                Arity.raiseArgumentError(context, argv2.length, 2, 4);
            }
        }
        RubyHash optHash = opt == context.nil ? Create.newHash(context) : ((RubyHash)opt).dupFast(context);
        RubySymbol modeSym = Convert.asSymbol(context, "mode");
        if (optHash.op_aref(context, modeSym) == context.nil) {
            int mode2 = OpenFlags.O_WRONLY.intValue() | OpenFlags.O_CREAT.intValue();
            if (OpenFlags.O_BINARY.defined() && binary) {
                mode2 |= OpenFlags.O_BINARY.intValue();
            }
            if (offset2 == context.nil) {
                mode2 |= OpenFlags.O_TRUNC.intValue();
            }
            optHash.op_aset(context, modeSym, Convert.asFixnum(context, mode2));
        }
        if ((_io = RubyIO.openKeyArgs(context, recv2, argv2, optHash)) == context.nil) {
            return context.nil;
        }
        RubyIO io2 = _io;
        if (!OpenFlags.O_BINARY.defined() && binary) {
            io2.binmode();
        }
        if (offset2 != context.nil) {
            RubyIO.seekBeforeAccess(context, io2, offset2);
        }
        try {
            IRubyObject iRubyObject = io2.write(context, string2, false);
            return iRubyObject;
        }
        finally {
            RubyIO.ioClose(context, io2);
        }
    }

    static IRubyObject seekBeforeAccess(ThreadContext context, RubyIO io2, IRubyObject offset2) {
        io2.setBinmode();
        return io2.seek(context, offset2);
    }

    @JRubyMethod(name={"readlines"}, required=1, optional=2, checkArity=false, meta=true, keywords=true)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        int callInfo = context.callInfo;
        IRubyObject opt = ArgsUtil.getOptionsArg(context.runtime, args2);
        context.callInfo = callInfo;
        try (RubyIO io2 = RubyIO.openKeyArgs(context, recv2, args2, opt);){
            switch (args2.length) {
                case 1: {
                    RubyArray rubyArray = io2.readlines(context);
                    return rubyArray;
                }
                case 2: {
                    RubyArray rubyArray = io2.readlines(context, args2[1]);
                    return rubyArray;
                }
                case 3: {
                    RubyArray rubyArray = io2.readlines(context, args2[1], args2[2]);
                    return rubyArray;
                }
                case 4: {
                    RubyArray rubyArray = io2.readlines(context, args2[1], args2[2], args2[3]);
                    return rubyArray;
                }
            }
            Arity.raiseArgumentError(context, args2.length, 1, 3);
            throw new AssertionError((Object)"BUG");
        }
    }

    private void setupPopen(ThreadContext context, ModeFlags modes, ShellLauncher.POpenProcess process) throws RaiseException {
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        if (this.openFile.isReadable()) {
            ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
            ChannelFD main2 = new ChannelFD(inChannel, context.runtime.getPosix(), context.runtime.getFilenoUtil());
            this.openFile.setFD(main2);
        }
        if (this.openFile.isWritable() && process.hasOutput()) {
            WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
            ChannelFD pipe2 = new ChannelFD(outChannel, context.runtime.getPosix(), context.runtime.getFilenoUtil());
            if (this.openFile.isReadable()) {
                RubyIO writeIO = new RubyIO(context.runtime, Access.ioClass(context));
                writeIO.initializeCommon(context, pipe2, (IRubyObject)Convert.asFixnum(context, OpenFlags.O_WRONLY.longValue()), context.nil);
                this.openFile.tiedIOForWriting = writeIO;
                this.setInstanceVariable("@tied_io_for_writing", writeIO);
            } else {
                this.openFile.setFD(pipe2);
            }
        }
    }

    @JRubyMethod(name={"popen"}, required=1, optional=2, checkArity=false, meta=true)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject tmp;
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        Ruby runtime2 = context.runtime;
        if (PopenExecutor.nativePopenAvailable(runtime2)) {
            return PopenExecutor.popen(context, args2, (RubyClass)recv2, block);
        }
        IRubyObject pmode = null;
        RubyHash options2 = null;
        int firstArg = 0;
        if (argc > 0 && !TypeConverter.checkHashType(runtime2, args2[0]).isNil()) {
            ++firstArg;
            --argc;
        }
        if (argc > 0 && !(tmp = TypeConverter.checkHashType(runtime2, args2[argc - 1])).isNil()) {
            options2 = (RubyHash)tmp;
            --argc;
        }
        if (argc > 1) {
            pmode = args2[firstArg + 1];
        }
        RubyIO io2 = new RubyIO(runtime2, (RubyClass)recv2);
        io2.MakeOpenFile();
        RubyFixnum vperm = Convert.asFixnum(context, 0);
        API.ModeAndPermission pm = new API.ModeAndPermission(pmode, vperm);
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        EncodingUtils.extractModeEncoding(context, (IOEncodable)io2, pm, (IRubyObject)options2, oflags_p, fmode_p);
        ModeFlags modes = ModeFlags.createModeFlags(oflags_p[0]);
        if (argc > 1 && args2[argc - 1] instanceof RubyHash) {
            options2 = (RubyHash)args2[argc - 1];
            args2 = ArraySupport.newCopy(args2, 0, argc - 1);
        }
        RubyPOpen pOpen = new RubyPOpen(context, args2);
        if (RubyIO.isDash(pOpen.cmd)) {
            throw runtime2.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        try {
            ShellLauncher.POpenProcess process = pOpen.cmdPlusArgs == null ? ShellLauncher.popen(runtime2, (IRubyObject)pOpen.cmd, modes) : ShellLauncher.popen(runtime2, pOpen.cmdPlusArgs, (Map)pOpen.env, modes);
            if (options2 != null) {
                RubyIO.checkUnsupportedOptions(context, options2, UNSUPPORTED_SPAWN_OPTIONS, "unsupported popen option");
            }
            io2.setupPopen(context, modes, process);
            if (block.isGiven()) {
                IRubyObject returnedBlock = RubyIO.ensureYieldClose(context, io2, block);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor() << 8, ShellLauncher.getPidFromProcess(process)));
                return returnedBlock;
            }
            return io2;
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) {
        return RubyIO.pipe(context, recv2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject klass, Block block) {
        return RubyIO.pipe(context, klass, context.nil, context.nil, context.nil, block);
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject klass, IRubyObject arg0, Block block) {
        IRubyObject opt = TypeConverter.checkHashType(context.runtime, arg0);
        return RubyIO.pipe(context, klass, opt.isNil() ? arg0 : context.nil, context.nil, opt, block);
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject klass, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject opt = TypeConverter.checkHashType(context.runtime, arg1);
        return RubyIO.pipe(context, klass, arg0, !opt.isNil() ? context.nil : arg1, opt, block);
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject klass, IRubyObject v1, IRubyObject v2, IRubyObject opt, Block block) {
        Ruby runtime2 = context.runtime;
        int[] fmode_p = new int[]{0};
        PosixShim posix = new PosixShim(runtime2);
        Channel[] fds = posix.pipe();
        if (fds == null) {
            throw runtime2.newErrnoFromErrno(posix.getErrno(), "opening pipe");
        }
        RubyIO r = new RubyIO(runtime2, (RubyClass)klass);
        r.initializeCommon(context, new ChannelFD(fds[0], runtime2.getPosix(), runtime2.getFilenoUtil()), (IRubyObject)Convert.asFixnum(context, OpenFlags.O_RDONLY.longValue()), context.nil);
        OpenFile fptr = r.getOpenFileChecked();
        r.setEncoding(context, v1, v2, opt);
        RubyIO w = new RubyIO(runtime2, (RubyClass)klass);
        w.initializeCommon(context, new ChannelFD(fds[1], runtime2.getPosix(), runtime2.getFilenoUtil()), (IRubyObject)Convert.asFixnum(context, OpenFlags.O_WRONLY.longValue()), context.nil);
        OpenFile fptr2 = w.getOpenFileChecked();
        fptr2.setSync(true);
        EncodingUtils.extractBinmode(context, opt, fmode_p);
        if (EncodingUtils.DEFAULT_TEXTMODE != 0) {
            if ((fptr.getMode() & 0x1000) != 0 && (fmode_p[0] & 4) != 0) {
                fptr.setMode(fptr.getMode() & 0xFFFFEFFF);
            }
            if (Platform.IS_WINDOWS && (fptr.encs.ecflags & EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
                fptr.encs.ecflags |= 0x100;
            }
        }
        fptr.setMode(fptr.getMode() | fmode_p[0]);
        if (EncodingUtils.DEFAULT_TEXTMODE != 0 && (fptr2.getMode() & 0x1000) != 0 && (fmode_p[0] & 4) != 0) {
            fptr2.setMode(fptr2.getMode() & 0xFFFFEFFF);
        }
        fptr2.setMode(fptr2.getMode() | fmode_p[0]);
        RubyArray<?> ret = Create.newArray(context, (IRubyObject)r, (IRubyObject)w);
        return block.isGiven() ? RubyIO.ensureYieldClosePipes(context, ret, r, w, block) : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ensureYieldClosePipes(ThreadContext context, IRubyObject obj, RubyIO r, RubyIO w, Block block) {
        try {
            IRubyObject iRubyObject = block.yield(context, obj);
            return iRubyObject;
        }
        finally {
            RubyIO.pipePairClose(context, r, w);
        }
    }

    private static void pipePairClose(ThreadContext context, RubyIO r, RubyIO w) {
        try {
            RubyIO.ioClose(context, r);
        }
        finally {
            RubyIO.ioClose(context, w);
        }
    }

    @JRubyMethod(name={"copy_stream"}, meta=true)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.copyStreamCommon(context, arg0, arg1, null, null);
    }

    @JRubyMethod(name={"copy_stream"}, meta=true)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        RubyInteger length2 = arg2.isNil() ? null : RubyInteger.toInteger(context, arg2);
        return RubyIO.copyStreamCommon(context, arg0, arg1, length2, null);
    }

    @JRubyMethod(name={"copy_stream"}, required=2, optional=2, checkArity=false, meta=true)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 4);
        RubyInteger length2 = argc >= 3 && !args2[2].isNil() ? RubyInteger.toInteger(context, args2[2]) : null;
        RubyInteger offset2 = argc == 4 && !args2[3].isNil() ? RubyInteger.toInteger(context, args2[3]) : null;
        return RubyIO.copyStreamCommon(context, args2[0], args2[1], length2, offset2);
    }

    /*
     * Exception decompiling
     */
    private static RubyFixnum copyStreamCommon(ThreadContext context, IRubyObject arg1, IRubyObject arg2, RubyInteger length, RubyInteger offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long transfer(ThreadContext context, ReadableByteChannel from, FileChannel to, long length2, long position) throws IOException {
        int ret;
        long chunkSize = 0x8000000L;
        long transferred = 0L;
        long startPosition = to.position();
        if (position != -1L && from instanceof NativeSelectableChannel && (ret = context.runtime.getPosix().lseek(((NativeSelectableChannel)from).getFD(), position, 0)) == -1) {
            throw context.runtime.newErrnoFromErrno(Errno.valueOf((long)context.runtime.getPosix().errno()), from.toString());
        }
        if (length2 > 0L) {
            long bytes2;
            while ((bytes2 = to.transferFrom(from, startPosition + transferred, Math.min(chunkSize, length2))) > 0L) {
                transferred += bytes2;
                length2 -= bytes2;
            }
        } else {
            long bytes3;
            while ((bytes3 = to.transferFrom(from, startPosition + transferred, chunkSize)) > 0L) {
                transferred += bytes3;
            }
        }
        to.position(startPosition + transferred);
        return transferred;
    }

    private static long transfer(FileChannel from, WritableByteChannel to, long remaining, long position) throws IOException {
        long count2;
        long n;
        long chunkSize = 0x8000000L;
        long transferred = 0L;
        if (remaining < 0L) {
            remaining = from.size();
        }
        while (remaining > 0L && (n = from.transferTo(position, count2 = Math.min(remaining, chunkSize), to)) != 0L) {
            position += n;
            remaining -= n;
            transferred += n;
        }
        return transferred;
    }

    private static long transfer(ThreadContext context, ReadableByteChannel from, WritableByteChannel to, long length2, long position) throws IOException {
        long n;
        int chunkSize = 8192;
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
        long transferred = 0L;
        if (position != -1L) {
            if (from instanceof NativeSelectableChannel) {
                NativeSelectableChannel nativeSelectableChannel = (NativeSelectableChannel)from;
                int ret = context.runtime.getPosix().lseek(nativeSelectableChannel.getFD(), position, 0);
                if (ret == -1) {
                    throw context.runtime.newErrnoFromErrno(Errno.valueOf((long)context.runtime.getPosix().errno()), from.toString());
                }
            } else if (from instanceof SeekableByteChannel) {
                SeekableByteChannel seekableByteChannel = (SeekableByteChannel)from;
                seekableByteChannel.position(position);
            } else {
                throw context.runtime.newErrnoESPIPEError();
            }
        }
        do {
            long w;
            context.blockingThreadPoll();
            if (length2 > 0L && length2 < (long)chunkSize) {
                Buffers.limitBuffer((Buffer)buffer, (int)((int)length2));
            }
            if ((n = (long)from.read(buffer)) == -1L) break;
            Buffers.flipBuffer((Buffer)buffer);
            for (w = 0L; w < n; w += (long)to.write(buffer)) {
                if (!(to instanceof IOChannel)) continue;
            }
            Buffers.clearBuffer((Buffer)buffer);
            transferred += w;
        } while ((length2 <= 0L || (length2 -= n) > 0L) && from.isOpen());
        return transferred;
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject tryConvert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return arg2 instanceof RubyObject && RubyIO.sites((ThreadContext)context).respond_to_to_io.respondsTo(context, arg2, arg2, true) ? RubyIO.convertToIO(context, arg2) : context.nil;
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext context, IRubyObject len, IRubyObject offset2) {
        return this.pread(context, len, offset2, null);
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext context, IRubyObject _length, IRubyObject _from, IRubyObject str) {
        int length2 = Convert.toInt(context, _length);
        int from = Convert.toInt(context, _from);
        RubyString string2 = EncodingUtils.setStrBuf(context.runtime, str, length2);
        if (length2 == 0) {
            return string2;
        }
        OpenFile fptr = this.getOpenFile();
        fptr.checkByteReadable(context);
        ChannelFD fd = fptr.fd();
        fptr.checkClosed();
        ByteList strByteList = string2.getByteList();
        ByteBuffer wrap2 = ByteBuffer.wrap(strByteList.unsafeBytes(), strByteList.begin(), length2);
        int read2 = OpenFile.preadInternal(context, fptr, fd, wrap2, from, length2);
        string2.setReadLength(read2);
        return string2;
    }

    @JRubyMethod(name={"pwrite"})
    public IRubyObject pwrite(ThreadContext context, IRubyObject str, IRubyObject offset2) {
        RubyString str2;
        RubyString string2 = str instanceof RubyString ? (str2 = (RubyString)str) : str.convertToString();
        int off = Convert.toInt(context, offset2);
        OpenFile fptr = this.GetWriteIO().getOpenFile();
        fptr.checkWritable(context);
        ChannelFD fd = fptr.fd();
        RubyString buf = string2.newFrozen();
        ByteList strByteList = buf.getByteList();
        int length2 = strByteList.realSize();
        ByteBuffer wrap2 = ByteBuffer.wrap(strByteList.unsafeBytes(), strByteList.begin(), length2);
        int written = OpenFile.pwriteInternal(context, fptr, fd, wrap2, off, length2);
        return Convert.asFixnum(context, written);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_readable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        long tv = RubyIO.prepareTimeout(context, argv2);
        if (fptr.readPending() != 0) {
            return context.tru;
        }
        return RubyIO.doWait(context, io2, fptr, tv, 17);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_writable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkWritable(context);
        long tv = RubyIO.prepareTimeout(context, argv2);
        return RubyIO.doWait(context, io2, fptr, tv, 12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(optional=2)
    public static IRubyObject wait(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        int ops = 0;
        if (argv2.length == 2) {
            if (!(argv2[1] instanceof RubySymbol)) throw Error.argumentError(context, "unsupported mode: " + String.valueOf(argv2[1].getType()));
            RubySymbol sym = (RubySymbol)argv2[1];
            switch (sym.asJavaString()) {
                case "r": 
                case "read": 
                case "readable": {
                    ops |= 0x11;
                    break;
                }
                case "w": 
                case "write": 
                case "writable": {
                    ops |= 0xC;
                    break;
                }
                case "rw": 
                case "read_write": 
                case "readable_writable": {
                    ops |= 0x1D;
                    break;
                }
                default: {
                    throw Error.argumentError(context, "unsupported mode: " + String.valueOf(sym));
                }
            }
        } else {
            ops |= 0x11;
        }
        if ((ops & 1) == 1 && fptr.readPending() != 0) {
            return context.tru;
        }
        long tv = RubyIO.prepareTimeout(context, argv2);
        return RubyIO.doWait(context, io2, fptr, tv, ops);
    }

    private static IRubyObject doWait(ThreadContext context, RubyIO io2, OpenFile fptr, long tv, int ops) {
        boolean ready = fptr.ready(context.runtime, context.getThread(), ops, tv);
        fptr.checkClosed();
        if (ready) {
            return io2;
        }
        return context.nil;
    }

    @JRubyMethod(name={"path", "to_path"})
    public IRubyObject path(ThreadContext context) {
        String path2 = this.getPath();
        return path2 != null ? Create.newString(context, path2) : context.nil;
    }

    public String getPath() {
        if (this.openFile == null) {
            return null;
        }
        return this.openFile.getPath();
    }

    protected void setPath(String path2) {
        if (this.openFile == null) {
            return;
        }
        this.openFile.setPath(path2);
    }

    public void addBlockingThread(RubyThread thread2) {
        OpenFile fptr = this.openFile;
        if (fptr != null) {
            fptr.addBlockingThread(thread2);
        }
    }

    public void removeBlockingThread(RubyThread thread2) {
        OpenFile fptr = this.openFile;
        if (fptr != null) {
            fptr.removeBlockingThread(thread2);
        }
    }

    protected IOOptions updateIOOptionsFromOptions(ThreadContext context, RubyHash options2, IOOptions ioOptions) {
        IRubyObject open_args;
        RubySymbol binmode2;
        if (options2 == null || options2 == context.nil) {
            return ioOptions;
        }
        Ruby runtime2 = context.runtime;
        IRubyObject mode2 = options2.fastARef(Convert.asSymbol(context, "mode"));
        if (mode2 != null) {
            ioOptions = this.parseIOOptions(mode2);
        }
        if (RubyIO.isTrue(options2.fastARef(binmode2 = Convert.asSymbol(context, "binmode")))) {
            ioOptions = RubyIO.newIOOptions(runtime2, ioOptions, ModeFlags.BINARY);
        }
        if (RubyIO.isTrue(options2.fastARef(binmode2))) {
            ioOptions = RubyIO.newIOOptions(runtime2, ioOptions, ModeFlags.BINARY);
        }
        if (RubyIO.isTrue(options2.fastARef(Convert.asSymbol(context, "textmode")))) {
            ioOptions = RubyIO.newIOOptions(runtime2, ioOptions, 0x10000000);
        }
        if ((open_args = options2.fastARef(Convert.asSymbol(context, "open_args"))) != null) {
            RubyArray openArgs = open_args.convertToArray();
            for (int i2 = 0; i2 < openArgs.size(); ++i2) {
                Object arg2 = openArgs.eltInternal(i2);
                if (arg2 instanceof RubyString) {
                    ioOptions = RubyIO.newIOOptions(runtime2, arg2.asJavaString());
                    continue;
                }
                if (arg2 instanceof RubyFixnum) {
                    RubyFixnum fixnum = (RubyFixnum)arg2;
                    ioOptions = RubyIO.newIOOptions(runtime2, fixnum.getValue());
                    continue;
                }
                if (!(arg2 instanceof RubyHash)) continue;
                RubyHash hash2 = (RubyHash)arg2;
                ioOptions = this.updateIOOptionsFromOptions(context, hash2, ioOptions);
            }
        }
        EncodingUtils.ioExtractEncodingOption(context, this, options2, null);
        return ioOptions;
    }

    private static boolean isTrue(IRubyObject val) {
        return val != null && val.isTrue();
    }

    @Deprecated
    public static void checkExecOptions(IRubyObject options2) {
        if (options2 instanceof RubyHash) {
            RubyHash opts = (RubyHash)options2;
            ThreadContext context = opts.getRuntime().getCurrentContext();
            RubyIO.checkValidSpawnOptions(context, opts);
            RubyIO.checkUnsupportedOptions(context, opts, UNSUPPORTED_SPAWN_OPTIONS, "unsupported exec option");
        }
    }

    @Deprecated
    public static void checkSpawnOptions(IRubyObject options2) {
        if (options2 instanceof RubyHash) {
            RubyHash opts = (RubyHash)options2;
            ThreadContext context = opts.getRuntime().getCurrentContext();
            RubyIO.checkValidSpawnOptions(context, opts);
            RubyIO.checkUnsupportedOptions(context, opts, UNSUPPORTED_SPAWN_OPTIONS, "unsupported spawn option");
        }
    }

    @Deprecated
    public static void checkPopenOptions(IRubyObject options2) {
        if (options2 instanceof RubyHash) {
            RubyHash opts = (RubyHash)options2;
            ThreadContext context = opts.getRuntime().getCurrentContext();
            RubyIO.checkUnsupportedOptions(context, opts, UNSUPPORTED_SPAWN_OPTIONS, "unsupported popen option");
        }
    }

    static void checkUnsupportedOptions(ThreadContext context, RubyHash opts, String[] unsupported, String error2) {
        for (String key2 : unsupported) {
            if (opts.fastARef(Convert.asSymbol(context, key2)) == null) continue;
            Warn.warn(context, error2 + ": " + key2);
        }
    }

    static void checkValidSpawnOptions(ThreadContext context, RubyHash opts) {
        for (Object opt : opts.directKeySet()) {
            if (opt instanceof RubySymbol) {
                if (ALL_SPAWN_OPTIONS.contains(((RubySymbol)opt).idString())) continue;
                throw Error.argumentError(context, "wrong exec option symbol: " + String.valueOf(opt));
            }
            if (!(opt instanceof RubyString) || ALL_SPAWN_OPTIONS.contains(((RubyString)opt).toString())) continue;
            throw Error.argumentError(context, "wrong exec option: " + String.valueOf(opt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obliterateProcess(Process process) {
        int i2 = 0;
        Object waitLock = new Object();
        while (true) {
            if (i2 >= 1000) {
                return;
            }
            process.destroy();
            try {
                process.exitValue();
                break;
            }
            catch (IllegalThreadStateException itse) {
                ++i2;
                Object object = waitLock;
                synchronized (object) {
                    try {
                        waitLock.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime2, long mode2) {
        return RubyIO.newModeFlags(runtime2, (int)mode2);
    }

    public static ModeFlags newModeFlags(Ruby runtime2, int mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    public static ModeFlags newModeFlags(Ruby runtime2, String mode2) {
        try {
            return new ModeFlags(mode2);
        }
        catch (InvalidValueException ive) {
            throw Error.argumentError(runtime2.getCurrentContext(), "illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime2, ModeFlags modeFlags) {
        return new IOOptions(modeFlags);
    }

    public static IOOptions newIOOptions(Ruby runtime2, long mode2) {
        return RubyIO.newIOOptions(runtime2, (int)mode2);
    }

    public static IOOptions newIOOptions(Ruby runtime2, int mode2) {
        try {
            ModeFlags modeFlags = new ModeFlags(mode2);
            return new IOOptions(modeFlags);
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    public static IOOptions newIOOptions(Ruby runtime2, String mode2) {
        try {
            return new IOOptions(runtime2, mode2);
        }
        catch (InvalidValueException ive) {
            throw Error.argumentError(runtime2.getCurrentContext(), "illegal access mode " + mode2);
        }
    }

    public static IOOptions newIOOptions(Ruby runtime2, IOOptions oldFlags, int orOflags) {
        try {
            return new IOOptions(new ModeFlags(oldFlags.getModeFlags().getFlags() | orOflags));
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    @Deprecated
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.readline(context) : this.readline(context, args2[0]);
    }

    @Override
    public void setEnc2(Encoding enc2) {
        this.openFile.encs.enc2 = enc2;
    }

    @Override
    public void setEnc(Encoding enc) {
        this.openFile.encs.enc = enc;
    }

    @Override
    public void setEcflags(int ecflags) {
        this.openFile.encs.ecflags = ecflags;
    }

    @Override
    public int getEcflags() {
        return this.openFile.encs.ecflags;
    }

    @Override
    public void setEcopts(IRubyObject ecopts) {
        this.openFile.encs.ecopts = ecopts;
    }

    @Override
    public IRubyObject getEcopts() {
        return this.openFile.encs.ecopts;
    }

    @Override
    public void setBOM(boolean bom) {
        this.openFile.setBOM(bom);
    }

    @Override
    public boolean getBOM() {
        return this.openFile.isBOM();
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == InputStream.class) {
            this.getOpenFile().checkReadable(this.getRuntime().getCurrentContext());
            return target2.cast(this.getInStream());
        }
        if (target2 == OutputStream.class) {
            this.getOpenFile().checkWritable(this.getRuntime().getCurrentContext());
            return target2.cast(this.getOutStream());
        }
        return super.toJava(target2);
    }

    protected RubyIO setAscii8bitBinmode() {
        OpenFile fptr = this.getOpenFileChecked();
        fptr.ascii8bitBinmode(this.getRuntime());
        return this;
    }

    private static boolean isDash(RubyString str) {
        return str.size() == 1 && str.getByteList().get(0) == 45;
    }

    public final OpenFile MakeOpenFile() {
        Ruby runtime2 = this.getRuntime();
        if (this.openFile != null) {
            this.rbIoClose(runtime2.getCurrentContext());
            RubyIO.rb_io_fptr_finalize(runtime2, this.openFile);
            this.openFile = null;
        }
        this.openFile = new OpenFile(this, runtime2.getNil());
        runtime2.addInternalFinalizer(this.openFile);
        return this.openFile;
    }

    private static int rb_io_fptr_finalize(Ruby runtime2, OpenFile fptr) {
        if (fptr == null) {
            return 0;
        }
        fptr.setPath(null);
        if (fptr.fd() != null) {
            fptr.cleanup(runtime2, true);
        }
        fptr.write_lock = null;
        if (fptr.rbuf.ptr != null) {
            fptr.rbuf.ptr = null;
        }
        if (fptr.wbuf.ptr != null) {
            fptr.wbuf.ptr = null;
        }
        fptr.clearCodeConversion();
        return 1;
    }

    private static JavaSites.IOSites sites(ThreadContext context) {
        return context.sites.IO;
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime2, ByteList separator) {
        return this.getline(runtime2.getCurrentContext(), runtime2.newString(separator), -1L);
    }

    @Deprecated
    public IRubyObject getline(Ruby runtime2, ByteList separator, long limit2) {
        return this.getline(runtime2.getCurrentContext(), runtime2.newString(separator), limit2);
    }

    @Deprecated
    public IRubyObject getline(ThreadContext context, ByteList separator) {
        return this.getline(context, Create.newString(context, separator), -1L);
    }

    @Deprecated
    public IRubyObject getline(ThreadContext context, ByteList separator, long limit2) {
        return this.getline(context, Create.newString(context, separator), limit2);
    }

    @Deprecated
    public RubyIO(Ruby runtime2, STDIO stdio) {
        super(runtime2, runtime2.getIO());
        RubyIO tmp = null;
        switch (stdio) {
            case IN: {
                tmp = RubyIO.prepStdio(runtime2, runtime2.getIn(), (Channel)Channels.newChannel(runtime2.getIn()), 1, runtime2.getIO(), "<STDIN>");
                break;
            }
            case OUT: {
                tmp = RubyIO.prepStdio(runtime2, runtime2.getOut(), (Channel)Channels.newChannel(runtime2.getOut()), 2, runtime2.getIO(), "<STDOUT>");
                break;
            }
            case ERR: {
                tmp = RubyIO.prepStdio(runtime2, runtime2.getErr(), (Channel)Channels.newChannel(runtime2.getErr()), 10, runtime2.getIO(), "<STDERR>");
            }
        }
        this.openFile = tmp.openFile;
        tmp.openFile = null;
    }

    @Deprecated
    public RubyIO(Ruby runtime2, RubyClass cls, ShellLauncher.POpenProcess process, RubyHash options2, IOOptions ioOptions) {
        super(runtime2, cls);
        ThreadContext context = runtime2.getCurrentContext();
        ioOptions = this.updateIOOptionsFromOptions(context, options2, ioOptions);
        this.openFile = this.MakeOpenFile();
        this.setupPopen(context, ioOptions.getModeFlags(), process);
    }

    @Deprecated
    public static ModeFlags getIOModes(Ruby runtime2, String modesString) {
        return RubyIO.newModeFlags(runtime2, modesString);
    }

    @Deprecated
    public static int getIOModesIntFromString(Ruby runtime2, String modesString) {
        try {
            return ModeFlags.getOFlagsFromString(modesString);
        }
        catch (InvalidValueException ive) {
            throw Error.argumentError(runtime2.getCurrentContext(), "illegal access mode");
        }
    }

    @Deprecated
    public static IRubyObject writeStatic(ThreadContext context, IRubyObject recv2, IRubyObject[] argv2, Block unusedBlock) {
        return RubyIO.write(context, recv2, argv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @JRubyMethod(name={"popen3"}, rest=true, meta=true)
    public static IRubyObject popen3(final ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyThread[] waitThread;
        final Ruby runtime2 = context.runtime;
        if (args2.length > 0 && args2[args2.length - 1] instanceof RubyHash) {
            args2 = ArraySupport.newCopy(args2, args2.length - 1);
        }
        final POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        final long pid2 = ShellLauncher.getPidFromProcess(tuple.process);
        waitThread = new RubyThread[]{new RubyThread(runtime2, (RubyClass)runtime2.getProcess().getConstantAt(context, "WaitThread"), new ThreadedRunnable(){
            volatile Thread javaThread;

            @Override
            public Thread getJavaThread() {
                return this.javaThread;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RubyThread rubyThread;
                this.javaThread = Thread.currentThread();
                while ((rubyThread = waitThread[0]) == null) {
                    Thread.yield();
                }
                runtime2.getThreadService().registerNewThread(rubyThread);
                rubyThread.op_aset(Convert.asSymbol(context, "pid"), Convert.asFixnum(context, pid2));
                try {
                    int exitValue = tuple.process.waitFor();
                    RubyProcess.RubyStatus status2 = RubyProcess.RubyStatus.newProcessStatus(runtime2, exitValue << 8, pid2);
                    rubyThread.cleanTerminate(status2);
                }
                catch (Throwable t) {
                    rubyThread.exceptionRaised(t);
                }
                finally {
                    rubyThread.dispose();
                }
            }
        })};
        RubyArray<?> yieldArgs = RubyArray.newArrayLight(runtime2, tuple.output, tuple.input, tuple.error, waitThread[0]);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, yieldArgs);
                return iRubyObject;
            }
            finally {
                RubyIO.cleanupPOpen(tuple);
                IRubyObject status2 = waitThread[0].join(context);
                context.setLastExitStatus(status2);
            }
        }
        return yieldArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static IRubyObject popen4(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Ruby runtime2 = context.runtime;
        POpenTuple tuple = RubyIO.popenSpecial(context, args2);
        RubyArray<?> yieldArgs = RubyArray.newArrayLight(runtime2, Convert.asFixnum(context, ShellLauncher.getPidFromProcess(tuple.process)), tuple.output, tuple.input, tuple.error);
        if (!block.isGiven()) return yieldArgs;
        try {
            iRubyObject = block.yield(context, yieldArgs);
        }
        catch (Throwable throwable) {
            try {
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor() << 8, ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            catch (InterruptedException e) {
                throw runtime2.newThreadError("unexpected interrupt");
            }
        }
        RubyIO.cleanupPOpen(tuple);
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor() << 8, ShellLauncher.getPidFromProcess(tuple.process)));
        return iRubyObject;
    }

    @Deprecated
    private static void cleanupPOpen(POpenTuple tuple) {
        if (tuple.input.openFile.isOpen()) {
            try {
                tuple.input.close();
            }
            catch (RaiseException raiseException) {
                // empty catch block
            }
        }
        if (tuple.output.openFile.isOpen()) {
            try {
                tuple.output.close();
            }
            catch (RaiseException raiseException) {
                // empty catch block
            }
        }
        if (tuple.error.openFile.isOpen()) {
            try {
                tuple.error.close();
            }
            catch (RaiseException raiseException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static POpenTuple popenSpecial(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        try {
            ShellLauncher.POpenProcess process = ShellLauncher.popen3(runtime2, args2, false);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime2, process.getInput()) : new RubyIO(runtime2, process.getInputStream());
            RubyIO output = process.getOutput() != null ? new RubyIO(runtime2, process.getOutput()) : new RubyIO(runtime2, process.getOutputStream());
            RubyIO error2 = process.getError() != null ? new RubyIO(runtime2, process.getError()) : new RubyIO(runtime2, process.getErrorStream());
            input.getOpenFile().setProcess(process);
            output.getOpenFile().setProcess(process);
            error2.getOpenFile().setProcess(process);
            input.popenSpecial = true;
            output.popenSpecial = true;
            error2.popenSpecial = true;
            return new POpenTuple(input, output, error2, process);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @Deprecated
    public IRubyObject doWriteNonblock(ThreadContext context, IRubyObject[] argv2, boolean useException) {
        return this.write_nonblock(context, argv2);
    }

    @Deprecated
    public static IRubyObject select_static(ThreadContext context, Ruby runtime2, IRubyObject[] args2) {
        return RubyIO.select(context, Access.ioClass(context), args2);
    }

    @Deprecated
    public static RubyArray checkExecEnv(ThreadContext context, RubyHash hash2) {
        return PopenExecutor.checkExecEnv(context, hash2, null);
    }

    @Deprecated
    public static IRubyObject ioOpen(ThreadContext context, IRubyObject filename2, IRubyObject vmode, IRubyObject vperm, IRubyObject opt) {
        return RubyIO.ioOpen(context, (IRubyObject)Access.ioClass(context), filename2, vmode, vperm, opt);
    }

    @Deprecated
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject[] argv2) {
        switch (argv2.length) {
            case 1: {
                return this.write_nonblock(context, argv2[0]);
            }
            case 2: {
                return this.write_nonblock(context, argv2[0], argv2[1]);
            }
        }
        throw Error.argumentError(context, argv2.length, 1, 2);
    }

    @Deprecated
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 3);
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", args2) != context.fals;
        return this.doReadNonblock(context, args2, exception2);
    }

    @Deprecated
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2;
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        if (argc == 2) {
            args2[1] = args2[1].convertToString();
        }
        if ((value2 = this.getPartial(context, args2, false, false)).isNil()) {
            throw context.runtime.newEOFError();
        }
        return value2;
    }

    @Deprecated
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        Ruby runtime2 = context.runtime;
        IRubyObject _length = argc >= 1 ? args2[0] : context.nil;
        IRubyObject _str = argc >= 2 ? args2[1] : context.nil;
        return this.sysreadCommon(context, runtime2, _length, _str);
    }

    @Deprecated
    public static IRubyObject pipe(ThreadContext context, IRubyObject klass, IRubyObject[] argv2, Block block) {
        switch (argv2.length) {
            case 0: {
                return RubyIO.pipe(context, klass, block);
            }
            case 1: {
                return RubyIO.pipe(context, klass, argv2[0], block);
            }
            case 2: {
                return RubyIO.pipe(context, klass, argv2[0], argv2[1], block);
            }
            case 3: {
                return RubyIO.pipe(context, klass, argv2[0], argv2[1], argv2[2], block);
            }
        }
        throw Error.argumentError(context, argv2.length, 0, 3);
    }

    static {
        String[] SPAWN_OPTIONS = new String[]{"unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"};
        UNSUPPORTED_SPAWN_OPTIONS = new String[]{"unsetenv_others", "prgroup", "new_pgroup", "rlimit_resourcename", "chdir", "umask", "in", "out", "err", "close_others"};
        ALL_SPAWN_OPTIONS = new HashSet<String>(Arrays.asList(SPAWN_OPTIONS));
    }

    public static enum IOEvent {
        IO_READABLE(1),
        IO_PRIORITY(2),
        IO_WRITABLE(4);

        final int value;

        private IOEvent(int value2) {
            this.value = value2;
        }

        int getValue() {
            return this.value;
        }
    }

    public static class Sysopen {
        public String fname;
        public int oflags;
        public int perm;
        public Errno errno;
    }

    private static final class RubyPOpen {
        final RubyString cmd;
        final IRubyObject[] cmdPlusArgs;
        final RubyHash env;

        RubyPOpen(ThreadContext context, IRubyObject[] args2) {
            IRubyObject _cmd;
            IRubyObject[] _cmdPlusArgs;
            IRubyObject _env;
            int firstArg = 0;
            int argc = args2.length;
            if (argc > 0 && !(_env = TypeConverter.checkHashType(context.runtime, args2[0])).isNil()) {
                if (argc < 2) {
                    throw Error.argumentError(context, 1, 2);
                }
                ++firstArg;
                --argc;
            } else {
                _env = null;
            }
            IRubyObject arg0 = args2[firstArg].checkArrayType();
            if (arg0.isNil()) {
                arg0 = TypeConverter.checkStringType(context.runtime, args2[firstArg]);
                if (arg0.isNil()) {
                    throw Error.typeError(context, args2[firstArg], "String");
                }
                _cmdPlusArgs = null;
                _cmd = arg0;
            } else {
                RubyArray arg0Ary = (RubyArray)arg0;
                if (arg0Ary.isEmpty()) {
                    throw Error.argumentError(context, "wrong number of arguments");
                }
                if (arg0Ary.eltOk(0L) instanceof RubyHash) {
                    _env = arg0Ary.delete_at(context, 0);
                }
                if (arg0Ary.isEmpty()) {
                    throw Error.argumentError(context, "wrong number of arguments");
                }
                if (arg0Ary.size() > 1 && arg0Ary.eltOk(arg0Ary.size() - 1) instanceof RubyHash) {
                    _env = arg0Ary.eltOk(arg0Ary.size() - 1);
                }
                _cmdPlusArgs = arg0Ary.toJavaArray(context);
                _cmd = _cmdPlusArgs[0];
            }
            if (Platform.IS_WINDOWS) {
                String commandString = _cmd.convertToString().toString().replace('/', '\\');
                _cmd = Create.newString(context, commandString);
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            } else {
                _cmd = _cmd.convertToString();
                if (_cmdPlusArgs != null) {
                    _cmdPlusArgs[0] = _cmd;
                }
            }
            this.cmd = (RubyString)_cmd;
            this.cmdPlusArgs = _cmdPlusArgs;
            this.env = (RubyHash)_env;
        }
    }

    @Deprecated
    private static class POpenTuple {
        public final RubyIO input;
        public final RubyIO output;
        public final RubyIO error;
        public final Process process;

        public POpenTuple(RubyIO i2, RubyIO o, RubyIO e, Process p2) {
            this.input = i2;
            this.output = o;
            this.error = e;
            this.process = p2;
        }
    }

    @JRubyClass(name={"TimeoutError"}, parent="IOError")
    public static class RubyIOTimeoutError
    extends RubyIOError {
        protected RubyIOTimeoutError(Ruby runtime2, RubyClass exceptionClass) {
            super(runtime2, exceptionClass);
        }

        static RubyClass define(ThreadContext context, RubyClass IO, RubyClass IOError2) {
            return IO.defineClassUnder(context, "TimeoutError", IOError2, RubyIOTimeoutError::new);
        }

        @Override
        protected TimeoutError constructThrowable(String message2) {
            return new TimeoutError(message2, this);
        }

        public static RubyIOTimeoutError newIOTimeoutError(Ruby runtime2, String message2) {
            return (RubyIOTimeoutError)((RubyClass)runtime2.getClassFromPath("IO::TimeoutError")).newInstance(runtime2.getCurrentContext(), RubyString.newString(runtime2, message2));
        }
    }

    public static class TimeoutError
    extends IOError {
        public TimeoutError(String message2, RubyIOTimeoutError exception2) {
            super(message2, exception2);
        }
    }
}

