/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;

public abstract class Type {
    public static final Type VOID = Type.builtin(0);
    public static final Type FLOAT = Type.builtin(2);
    public static final Type DOUBLE = Type.builtin(3);
    public static final Type LONGDOUBLE = Type.builtin(4);
    public static final Type UINT8 = Type.builtin(5);
    public static final Type SINT8 = Type.builtin(6);
    public static final Type UINT16 = Type.builtin(7);
    public static final Type SINT16 = Type.builtin(8);
    public static final Type UINT32 = Type.builtin(9);
    public static final Type SINT32 = Type.builtin(10);
    public static final Type UINT64 = Type.builtin(11);
    public static final Type SINT64 = Type.builtin(12);
    public static final Type POINTER = Type.builtin(14);
    public static final Type UCHAR = Type.alias(101, UINT8);
    public static final Type SCHAR = Type.alias(102, SINT8);
    public static final Type USHORT = Type.alias(103, UINT16, UINT32);
    public static final Type SSHORT = Type.alias(104, SINT16, SINT32);
    public static final Type UINT = Type.alias(105, UINT32, UINT64);
    public static final Type SINT = Type.alias(106, SINT32, SINT64);
    public static final Type ULONG = Type.alias(107, UINT32, UINT64);
    public static final Type SLONG = Type.alias(108, SINT32, SINT64);
    protected final int type;
    protected final int size;
    protected final int align;
    protected final long handle;

    Type(long handle) {
        if (handle == 0L) {
            throw new NullPointerException("Invalid ffi_type handle");
        }
        this.handle = handle;
        this.type = Foreign.getInstance().getTypeType(handle);
        this.size = Foreign.getInstance().getTypeSize(handle);
        this.align = Foreign.getInstance().getTypeAlign(handle);
    }

    public int type() {
        return this.type;
    }

    final long handle() {
        return this.handle;
    }

    public final int size() {
        return this.size;
    }

    public final int alignment() {
        return this.align;
    }

    public boolean equals(Object obj) {
        return obj instanceof Type && ((Type)obj).handle == this.handle;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (int)(this.handle ^ this.handle >>> 32);
        return hash;
    }

    static final long[] nativeHandles(Type[] types) {
        long[] nativeTypes = new long[types.length];
        for (int i = 0; i < types.length; ++i) {
            nativeTypes[i] = types[i].handle();
        }
        return nativeTypes;
    }

    private static final Type builtin(int type) {
        return new Builtin(type);
    }

    private static final Type alias(int type, Type ... existing) {
        long h = Foreign.getInstance().lookupBuiltinType(type);
        for (Type t : existing) {
            if (t.handle != h) continue;
            return t;
        }
        return new Builtin(type);
    }

    static final class Builtin
    extends Type {
        private Builtin(int type) {
            super(Foreign.getInstance().lookupBuiltinType(type));
        }
    }
}

