/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;

public final class HeapInvocationBuffer
implements InvocationBuffer {
    private static final int PARAM_SIZE = 8;
    private static final Encoder encoder = HeapInvocationBuffer.getEncoder();
    private final byte[] buffer;
    private ObjectBuffer objectBuffer = null;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(int paramCount) {
        this.buffer = new byte[paramCount * 8];
    }

    public HeapInvocationBuffer(Function function) {
        this.buffer = new byte[encoder.getBufferSize(function)];
    }

    byte[] array() {
        return this.buffer;
    }

    ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putInt8(int value) {
        this.paramOffset += encoder.putInt8(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt16(int value) {
        this.paramOffset += encoder.putInt16(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt32(int value) {
        this.paramOffset += encoder.putInt32(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt64(long value) {
        this.paramOffset += encoder.putInt64(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putFloat(float value) {
        this.paramOffset += encoder.putFloat32(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putDouble(double value) {
        this.paramOffset += encoder.putFloat64(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putAddress(long value) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putArray(byte[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        this.objectBuffer.putArray(this.paramIndex++, array, offset, length, flags);
    }

    private static final Encoder getEncoder() {
        switch (Platform.getArch()) {
            case I386: {
                return Foreign.getInstance().isRawParameterPackingEnabled() ? HeapInvocationBuffer.newI386RawEncoder() : HeapInvocationBuffer.newLE32Encoder();
            }
            case X86_64: {
                return HeapInvocationBuffer.newLE64Encoder();
            }
            case PPC: {
                return HeapInvocationBuffer.newBE32Encoder();
            }
            case SPARC: {
                return HeapInvocationBuffer.newBE32Encoder();
            }
            case SPARCV9: {
                return HeapInvocationBuffer.newBE64Encoder();
            }
        }
        throw new RuntimeException("Unsupported arch " + (Object)((Object)Platform.getArch()));
    }

    private static final Encoder newI386RawEncoder() {
        return new I386RawEncoder();
    }

    private static final Encoder newLE32Encoder() {
        return new DefaultEncoder(LE32ArrayIO.INSTANCE);
    }

    private static final Encoder newLE64Encoder() {
        return new DefaultEncoder(LE64ArrayIO.INSTANCE);
    }

    private static final Encoder newBE32Encoder() {
        return new DefaultEncoder(BE32ArrayIO.INSTANCE);
    }

    private static final Encoder newBE64Encoder() {
        return new DefaultEncoder(BE64ArrayIO.INSTANCE);
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public final void putInt8(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)value;
        }

        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }

        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)value;
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final void putInt8(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
        }

        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }
    }

    private static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putInt8(byte[] var1, int var2, int var3);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public final void putFloat32(byte[] buffer, int offset, float value) {
            this.putInt32(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final void putFloat64(byte[] buffer, int offset, double value) {
            this.putInt64(buffer, offset, Double.doubleToRawLongBits(value));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);
    }

    private static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO io) {
            this.io = io;
        }

        public final int getBufferSize(Function function) {
            return function.getParameterCount() * 8;
        }

        public final int putInt8(byte[] buffer, int offset, int value) {
            this.io.putInt8(buffer, offset, value);
            return 8;
        }

        public final int putInt16(byte[] buffer, int offset, int value) {
            this.io.putInt16(buffer, offset, value);
            return 8;
        }

        public final int putInt32(byte[] buffer, int offset, int value) {
            this.io.putInt32(buffer, offset, value);
            return 8;
        }

        public final int putInt64(byte[] buffer, int offset, long value) {
            this.io.putInt64(buffer, offset, value);
            return 8;
        }

        public final int putFloat32(byte[] buffer, int offset, float value) {
            this.io.putFloat32(buffer, offset, value);
            return 8;
        }

        public final int putFloat64(byte[] buffer, int offset, double value) {
            this.io.putFloat64(buffer, offset, value);
            return 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            this.io.putAddress(buffer, offset, value);
            return 8;
        }
    }

    private static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final int getBufferSize(Function function) {
            return function.getRawParameterSize();
        }

        public final int putInt8(byte[] buffer, int offset, int value) {
            IO.putInt8(buffer, offset, value);
            return 4;
        }

        public final int putInt16(byte[] buffer, int offset, int value) {
            IO.putInt16(buffer, offset, value);
            return 4;
        }

        public final int putInt32(byte[] buffer, int offset, int value) {
            IO.putInt32(buffer, offset, value);
            return 4;
        }

        public final int putInt64(byte[] buffer, int offset, long value) {
            IO.putInt64(buffer, offset, value);
            return 8;
        }

        public final int putFloat32(byte[] buffer, int offset, float value) {
            IO.putFloat32(buffer, offset, value);
            return 4;
        }

        public final int putFloat64(byte[] buffer, int offset, double value) {
            IO.putFloat64(buffer, offset, value);
            return 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            IO.putAddress(buffer, offset, value);
            return 4;
        }
    }

    private static abstract class Encoder {
        private Encoder() {
        }

        public abstract int getBufferSize(Function var1);

        public abstract int putInt8(byte[] var1, int var2, int var3);

        public abstract int putInt16(byte[] var1, int var2, int var3);

        public abstract int putInt32(byte[] var1, int var2, int var3);

        public abstract int putInt64(byte[] var1, int var2, long var3);

        public abstract int putFloat32(byte[] var1, int var2, float var3);

        public abstract int putFloat64(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);
    }
}

