/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.reflect.Method;

public class ClosureManager {
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static final ClosureManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ClosureManager() {
    }

    public final Closure.Handle newClosure(Closure closure, Type returnType, Type[] parameterTypes, CallingConvention convention) {
        Proxy proxy = new Proxy(closure);
        int[] nativeParamTypes = new int[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            nativeParamTypes[i] = parameterTypes[i].value();
        }
        return new Handle(Foreign.getInstance().newClosure(proxy, Proxy.METHOD, returnType.value(), nativeParamTypes, 0));
    }

    private static final class DirectBuffer
    implements Closure.Buffer {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private static final int PARAM_SIZE = Platform.getPlatform().addressSize() / 8;
        private final long retval;
        private final long parameters;

        public DirectBuffer(long retval, long parameters) {
            this.retval = retval;
            this.parameters = parameters;
        }

        public int getInt8(int index) {
            return IO.getByte(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public int getInt16(int index) {
            return IO.getShort(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public int getInt32(int index) {
            return IO.getInt(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public long getInt64(int index) {
            return IO.getLong(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public float getFloat(int index) {
            return IO.getFloat(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public double getDouble(int index) {
            return IO.getDouble(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public long getAddress(int index) {
            return IO.getAddress(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE))) & ADDRESS_MASK;
        }

        public void setInt8Return(int value) {
            IO.putByte(this.retval, (byte)value);
        }

        public void setInt16Return(int value) {
            IO.putShort(this.retval, (short)value);
        }

        public void setInt32Return(int value) {
            IO.putInt(this.retval, value);
        }

        public void setInt64Return(long value) {
            IO.putLong(this.retval, value);
        }

        public void setFloatReturn(float value) {
            IO.putFloat(this.retval, value);
        }

        public void setDoubleReturn(double value) {
            IO.putDouble(this.retval, value);
        }

        public void setAddressReturn(long address) {
            IO.putAddress(this.retval, address);
        }
    }

    private static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final Closure closure;

        private static final Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        Proxy(Closure closure) {
            this.closure = closure;
        }

        void invoke(long retvalAddress, long paramAddress) {
            this.closure.invoke(new DirectBuffer(retvalAddress, paramAddress));
        }
    }

    private static final class Handle
    implements Closure.Handle {
        private static final MemoryIO IO = MemoryIO.getInstance();
        final long handle;
        final long cbAddress;

        Handle(long handle) {
            this.handle = handle;
            this.cbAddress = IO.getAddress(handle);
        }

        public long getAddress() {
            return this.cbAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                Foreign.getInstance().freeClosure(this.handle);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class SingletonHolder {
        static final ClosureManager INSTANCE = new ClosureManager();

        private SingletonHolder() {
        }
    }
}

