/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Pointer;
import com.kenai.jffi.MemoryIO;

public class JFFIPointer
extends Number
implements Pointer {
    static final MemoryIO IO = MemoryIO.getInstance();
    final long address;

    JFFIPointer(long address) {
        this.address = address;
    }

    public final byte getByte(long offset) {
        return IO.getByte(this.address + offset);
    }

    public final short getShort(long offset) {
        return IO.getShort(this.address + offset);
    }

    public final int getInt(long offset) {
        return IO.getInt(this.address + offset);
    }

    public final long getLong(long offset) {
        return IO.getLong(this.address + offset);
    }

    public final float getFloat(long offset) {
        return IO.getFloat(this.address + offset);
    }

    public final double getDouble(long offset) {
        return IO.getDouble(this.address + offset);
    }

    public final void putByte(long offset, byte value) {
        IO.putByte(this.address + offset, value);
    }

    public final void putShort(long offset, short value) {
        IO.putShort(this.address + offset, value);
    }

    public final void putInt(long offset, int value) {
        IO.putInt(this.address + offset, value);
    }

    public final void putLong(long offset, long value) {
        IO.putLong(this.address + offset, value);
    }

    public final void putFloat(long offset, float value) {
        IO.putFloat(this.address + offset, value);
    }

    public final void putDouble(long offset, double value) {
        IO.putDouble(this.address + offset, value);
    }

    public final void get(long offset, byte[] dst, int off, int len) {
        IO.getByteArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, byte[] src, int off, int len) {
        IO.putByteArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, short[] dst, int off, int len) {
        IO.getShortArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, short[] src, int off, int len) {
        IO.putShortArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, int[] dst, int off, int len) {
        IO.getIntArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, int[] src, int off, int len) {
        IO.putIntArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, long[] dst, int off, int len) {
        IO.getLongArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, long[] src, int off, int len) {
        IO.putLongArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, float[] dst, int off, int len) {
        IO.getFloatArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, float[] src, int off, int len) {
        IO.putFloatArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, double[] dst, int off, int len) {
        IO.getDoubleArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, double[] src, int off, int len) {
        IO.putDoubleArray(this.address + offset, src, off, len);
    }

    public Pointer getPointer(long offset) {
        long ptr = IO.getAddress(this.address + offset);
        return ptr != 0L ? new JFFIPointer(ptr) : null;
    }

    public void putPointer(long offset, Pointer value) {
        if (value == null) {
            IO.putAddress(this.address + offset, 0L);
        } else if (value instanceof JFFIPointer) {
            IO.putAddress(this.address + offset, ((JFFIPointer)value).address);
        }
        throw new IllegalArgumentException("Invalid Pointer");
    }

    public String getString(long offset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int intValue() {
        return (int)this.address;
    }

    public long longValue() {
        return this.address;
    }

    public float floatValue() {
        return this.address;
    }

    public double doubleValue() {
        return this.address;
    }
}

