/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.IgnoreError;
import com.kenai.jaffl.annotations.SaveError;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.Buffer;

final class InvokerUtil {
    InvokerUtil() {
    }

    static final Type getNativeReturnType(Method method) {
        Class<?> type = method.getReturnType();
        if (Void.class.isAssignableFrom(type) || Void.TYPE == type) {
            return Type.VOID;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return Type.SINT32;
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return Type.DOUBLE;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported return type: " + type);
    }

    static final Type getNativeParameterType(Class type) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return Type.SINT8;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return Type.SINT16;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return Type.SINT32;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return Type.SINT64;
        }
        if (NativeLong.class.isAssignableFrom(type)) {
            return Platform.getPlatform().longSize() == 32 ? Type.SINT32 : Type.SINT64;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return Type.FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return Type.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return Type.SINT32;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Type.SINT32;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (ByReference.class.isAssignableFrom(type)) {
            return Type.POINTER;
        }
        if (type.isArray()) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type);
    }

    public static final boolean requiresErrno(Method method) {
        boolean saveError = true;
        for (Annotation a : method.getAnnotations()) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        return saveError;
    }
}

