/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.util.BufferUtil;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class StringIO {
    private static final ThreadLocal<SoftReference<StringIO>> localData = new ThreadLocal<SoftReference<StringIO>>(){

        @Override
        protected synchronized SoftReference<StringIO> initialValue() {
            return new SoftReference<StringIO>(new StringIO());
        }
    };
    private static final Charset defaultCharset = Charset.defaultCharset();
    public final CharsetEncoder encoder = defaultCharset.newEncoder();
    public final CharsetDecoder decoder = defaultCharset.newDecoder();
    public final int nulByteCount = Math.round(this.encoder.maxBytesPerChar());

    public static final StringIO getStringIO() {
        StringIO io = localData.get().get();
        if (io == null) {
            io = new StringIO();
            localData.set(new SoftReference<StringIO>(io));
        }
        return io;
    }

    public StringIO() {
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public final ByteBuffer toNative(CharSequence value, int minSize, boolean copyIn) {
        int len = (int)(((float)Math.max(minSize, value.length()) + 1.0f) * this.encoder.maxBytesPerChar());
        ByteBuffer buf = ByteBuffer.allocate(len);
        if (copyIn) {
            this.toNative(value, buf);
        }
        return buf;
    }

    public final ByteBuffer toNative(CharSequence value, ByteBuffer buf) {
        buf.mark();
        this.encoder.reset();
        this.encoder.encode(CharBuffer.wrap(value), buf, true);
        this.encoder.flush(buf);
        this.nulTerminate(buf);
        buf.reset();
        return buf;
    }

    public final CharSequence fromNative(ByteBuffer buf, int maxSize) {
        int end = BufferUtil.indexOf(buf, (byte)0);
        if (end < 0 || end > maxSize) {
            end = maxSize;
        }
        buf.rewind().limit(end);
        try {
            return this.decoder.reset().decode(buf);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public final CharSequence fromNative(ByteBuffer buf) {
        try {
            return this.decoder.reset().decode(buf);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public final void nulTerminate(ByteBuffer buf) {
        int nulSize;
        for (nulSize = this.nulByteCount; nulSize >= 4; nulSize -= 4) {
            buf.putInt(0);
        }
        if (nulSize >= 2) {
            buf.putShort((short)0);
            nulSize -= 2;
        }
        if (nulSize >= 1) {
            buf.put((byte)0);
        }
    }
}

