/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.constantine.platform;

import com.kenai.constantine.Constant;
import com.kenai.constantine.ConstantSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private Constant[] cache = null;
    private volatile int guard;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> enumType) {
        this.enumType = enumType;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constant getConstant(E e) {
        Constant c;
        if (this.guard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
            return c;
        }
        Object object = this.modLock;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new Constant[EnumSet.allOf(this.enumType).size()];
            }
            this.cache[((Enum)e).ordinal()] = c = this.getConstant(((Enum)e).name());
            ++this.guard;
        }
        return c;
    }

    final int intValue(E e) {
        return this.getConstant(e).value();
    }

    final String description(E e) {
        return this.getConstant(e).toString();
    }

    final E valueOf(int value) {
        Enum e = (Enum)this.reverseLookupMap.get(value);
        if (e != null) {
            return (E)e;
        }
        for (Constant c : this.getConstants()) {
            if (c.value() != value) continue;
            try {
                e = Enum.valueOf(this.enumType, c.name());
                this.reverseLookupMap.put(value, e);
                return (E)e;
            }
            catch (IllegalArgumentException ex) {
            }
        }
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final Constant getConstant(String name) {
        Constant c = this.getConstants().getConstant(name);
        if (c == null) {
            throw new RuntimeException("No platform value for " + name);
        }
        return c;
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }
}

