/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<T> {
    private static int INITIAL_SIZE = 4;
    private Map<T, Vertex<T>> vertices = new HashMap<T, Vertex<T>>();
    private Edge<T>[] edges = new Edge[INITIAL_SIZE];
    private int edgeLength = 0;
    private ArrayList inOrderVerticeData = new ArrayList();
    int vertexIDCounter = 0;

    protected Edge<T>[] growEdges(Edge<T>[] array, int realLength) {
        int newLength = array.length == 0 ? 2 : array.length * 2;
        Edge[] newEdges = new Edge[newLength];
        System.arraycopy(array, 0, newEdges, 0, realLength);
        return newEdges;
    }

    protected Edge<T>[] getEdges() {
        return this.edges;
    }

    protected Edge<T> addEdge(Edge<T> newEdge) {
        for (int i = 0; i < this.edgeLength; ++i) {
            if (!this.edges[i].equals(newEdge)) continue;
            return newEdge;
        }
        if (this.edgeLength >= this.edges.length) {
            this.edges = this.growEdges(this.edges, this.edgeLength);
        }
        this.edges[this.edgeLength++] = newEdge;
        return newEdge;
    }

    public void removeEdge(Edge<T> edge) {
        int splitPoint = -1;
        for (int i = 0; i < this.edgeLength; ++i) {
            if (!this.edges[i].equals(edge)) continue;
            splitPoint = i;
            break;
        }
        if (splitPoint != -1) {
            Edge<T> edgeToRemove = this.edges[splitPoint];
            if (splitPoint < this.edgeLength - 1) {
                System.arraycopy(this.edges, splitPoint + 1, this.edges, splitPoint, this.edgeLength - 1 - splitPoint);
            }
            this.edges[this.edgeLength - 1] = null;
            --this.edgeLength;
            edge.getSource().removeOutgoingEdge(edgeToRemove);
            edge.getDestination().removeIncomingEdge(edgeToRemove);
        }
    }

    public Collection<Vertex<T>> vertices() {
        return this.vertices.values();
    }

    public Collection<Edge<T>> edges() {
        return Arrays.asList(Arrays.copyOf(this.edges, this.edgeLength));
    }

    public Iterable<Edge<T>> edgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.edges(), type);
    }

    public Collection<T> allData() {
        return this.vertices.keySet();
    }

    public Collection<T> getInorderData() {
        return this.inOrderVerticeData;
    }

    public void addEdge(T source, T destination, Object type) {
        this.findOrCreateVertexFor(source).addEdgeTo(destination, type);
    }

    public void removeEdge(T source, T destination) {
        if (this.findVertexFor(source) != null) {
            for (Edge<T> edge : this.findOrCreateVertexFor(source).getOutgoingEdges()) {
                if (edge.getDestination().getData() != destination) continue;
                this.findOrCreateVertexFor(source).removeEdgeTo(edge.getDestination());
                return;
            }
        }
    }

    public Vertex<T> findVertexFor(T data) {
        return this.vertices.get(data);
    }

    public Vertex<T> findOrCreateVertexFor(T data) {
        Vertex<T> vertex = this.vertices.get(data);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex<T>(this, data, this.vertexIDCounter++);
        this.inOrderVerticeData.add(data);
        this.vertices.put(data, vertex);
        return vertex;
    }

    public void removeVertexFor(T data) {
        if (this.findVertexFor(data) != null) {
            Vertex<T> vertex = this.findOrCreateVertexFor(data);
            this.vertices.remove(data);
            this.inOrderVerticeData.remove(data);
            vertex.removeAllEdges();
        }
    }

    public int size() {
        return this.allData().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<Vertex<T>> verts = new ArrayList<Vertex<T>>(this.vertices.values());
        Collections.sort(verts);
        for (Vertex<T> vertex : verts) {
            buf.append(vertex);
        }
        return buf.toString();
    }
}

