/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.AbstractProcessesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsProcessesService
extends AbstractProcessesService {
    @Override
    protected List<Map<String, String>> parseList(String rawData) {
        ArrayList<Map<String, String>> processesDataList = new ArrayList<Map<String, String>>();
        String[] dataStringLines = rawData.split("\\r?\\n");
        HashMap<String, String> processMap = null;
        for (String dataLine : dataStringLines) {
            String[] dataStringInfo;
            if (dataLine.trim().length() <= 0) continue;
            if (dataLine.startsWith("Caption")) {
                if (processMap != null && processMap.size() > 0) {
                    processesDataList.add(processMap);
                }
                processMap = new HashMap<String, String>();
            }
            if (processMap == null || (dataStringInfo = dataLine.split(":")).length != 2) continue;
            processMap.put(this.normalizeKey(dataStringInfo[0].trim()), this.normalizeValue(dataStringInfo[0].trim(), dataStringInfo[1].trim()));
        }
        return processesDataList;
    }

    @Override
    protected String getProcessesData() {
        return WMI4Java.get().VBSEngine().getRawWMIObjectOutput(WMIClass.WIN32_PROCESS);
    }

    @Override
    protected int kill(int pid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String normalizeKey(String origKey) {
        if ("Name".equals(origKey)) {
            return "proc_name";
        }
        if ("ProcessId".equals(origKey)) {
            return "pid";
        }
        if ("UserModeTime".equals(origKey)) {
            return "proc_time";
        }
        return origKey;
    }

    private String normalizeValue(String origKey, String origValue) {
        if ("UserModeTime".equals(origKey)) {
            long longOrigValue = Long.valueOf(origValue);
            long seconds = longOrigValue * 100L / 1000000L / 1000L;
            return this.nomalizeTime(seconds);
        }
        return origValue;
    }

    private String nomalizeTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

