/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.SaslHandshakeRequest;
import org.joyqueue.broker.kafka.command.SaslHandshakeResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class SaslHandshakeCodec
implements KafkaPayloadCodec<SaslHandshakeResponse>,
Type {
    public SaslHandshakeRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        String mechanism = Serializer.readString((ByteBuf)buffer, (int)2);
        SaslHandshakeRequest request = new SaslHandshakeRequest();
        request.setMechanism(mechanism);
        return request;
    }

    public void encode(SaslHandshakeResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort((int)payload.getErrorCode());
        buffer.writeInt(payload.getMechanisms().size());
        for (String mechanism : payload.getMechanisms()) {
            Serializer.write((String)mechanism, (ByteBuf)buffer, (int)2);
        }
    }

    public int type() {
        return KafkaCommandType.SASL_HANDSHAKE.getCode();
    }
}

