/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.ProduceRequest;
import org.joyqueue.broker.kafka.command.ProduceResponse;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionIdManager;
import org.joyqueue.broker.kafka.model.ProducePartitionGroupRequest;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.message.BrokerRollback;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.message.SourceType;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProduceHandler {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionProduceHandler.class);
    private KafkaConfig config;
    private Produce produce;
    private TransactionCoordinator transactionCoordinator;
    private TransactionIdManager transactionIdManager;

    public TransactionProduceHandler(KafkaConfig config, Produce produce, TransactionCoordinator transactionCoordinator, TransactionIdManager transactionIdManager) {
        this.config = config;
        this.produce = produce;
        this.transactionCoordinator = transactionCoordinator;
        this.transactionIdManager = transactionIdManager;
    }

    public void produceMessage(ProduceRequest request, String transactionalId, long producerId, short producerEpoch, QosLevel qosLevel, Producer producer, ProducePartitionGroupRequest partitionGroupRequest, EventListener<ProduceResponse.PartitionResponse> listener) {
        short[] code = new short[]{KafkaErrorCode.NONE.getCode()};
        CountDownLatch latch = new CountDownLatch(partitionGroupRequest.getMessageMap().size());
        for (Map.Entry<Integer, List<BrokerMessage>> entry : partitionGroupRequest.getMessageMap().entrySet()) {
            try {
                int partition = entry.getKey();
                List<BrokerMessage> messages = entry.getValue();
                String txId = this.generateTxId(producer, partition, transactionalId, producerId, producerEpoch);
                TransactionId transaction = this.tryPrepare(producer, txId);
                this.fillTxId(messages, transaction.getTxId());
                this.produce.putMessageAsync(producer, messages, qosLevel, writeResult -> {
                    if (!writeResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                        logger.error("produce message failed, topic: {}, code: {}", (Object)producer.getTopic(), (Object)writeResult.getCode());
                    }
                    code[0] = KafkaErrorCode.joyQueueCodeFor(writeResult.getCode().getCode());
                    latch.countDown();
                });
            }
            catch (Exception e) {
                logger.error("produce message failed, topic: {}", (Object)producer.getTopic(), (Object)e);
                code[0] = KafkaErrorCode.exceptionFor(e);
                latch.countDown();
            }
        }
        try {
            if (!latch.await(Math.min(request.getAckTimeoutMs(), this.config.getProduceTimeout()), TimeUnit.MILLISECONDS)) {
                logger.warn("produce message timeout, topic: {}, request: {}", (Object)producer.getTopic(), (Object)partitionGroupRequest);
                code[0] = KafkaErrorCode.KAFKA_STORAGE_ERROR.getCode();
            }
        }
        catch (InterruptedException e) {
            logger.error("produce message failed, topic: {}", (Object)producer.getTopic(), (Object)e);
            code[0] = KafkaErrorCode.KAFKA_STORAGE_ERROR.getCode();
        }
        listener.onEvent((Object)new ProduceResponse.PartitionResponse(0L, code[0]));
    }

    protected String generateTxId(Producer producer, int partition, String transactionalId, long producerId, short producerEpoch) {
        return this.transactionIdManager.generateId(producer.getTopic(), partition, producer.getApp(), transactionalId, producerId, producerEpoch);
    }

    protected TransactionId tryPrepare(Producer producer, String txId) throws Exception {
        TransactionId transaction = this.produce.getTransaction(producer, txId);
        if (transaction == null) {
            transaction = this.prepare(producer, txId);
        }
        return transaction;
    }

    protected TransactionId prepare(Producer producer, String txId) throws Exception {
        BrokerPrepare brokerPrepare = new BrokerPrepare();
        brokerPrepare.setTopic(producer.getTopic());
        brokerPrepare.setApp(producer.getApp());
        brokerPrepare.setTxId(txId);
        brokerPrepare.setTimeout((long)this.config.getTransactionTimeout());
        brokerPrepare.setSource(SourceType.KAFKA.getValue());
        return this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerPrepare);
    }

    protected TransactionId rollback(Producer producer, String txId) throws Exception {
        BrokerRollback brokerRollback = new BrokerRollback();
        brokerRollback.setTopic(producer.getTopic());
        brokerRollback.setApp(producer.getApp());
        brokerRollback.setTxId(txId);
        return this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerRollback);
    }

    protected void fillTxId(List<BrokerMessage> messages, String txId) {
        for (BrokerMessage message : messages) {
            message.setTxId(txId);
        }
    }
}

