/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.command.OffsetCommitRequest;
import org.joyqueue.broker.kafka.command.OffsetCommitResponse;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.kafka.model.OffsetMetadataAndError;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetCommitRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(OffsetCommitRequestHandler.class);
    private GroupCoordinator groupCoordinator;
    private KafkaConfig config;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
        this.config = kafkaContext.getConfig();
    }

    public Command handle(Transport transport, Command command) {
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)command.getPayload();
        String groupId = KafkaClientHelper.parseClient(offsetCommitRequest.getClientId());
        Map<String, List<OffsetMetadataAndError>> result = this.groupCoordinator.handleCommitOffsets(groupId, offsetCommitRequest.getMemberId(), offsetCommitRequest.getGroupGenerationId(), offsetCommitRequest.getOffsets());
        if (this.config.getLogDetail(offsetCommitRequest.getClientId())) {
            logger.info("offset commit request with correlation id {} from transport: {}, client {}, request: {}, result: {}", new Object[]{transport, offsetCommitRequest.getCorrelationId(), offsetCommitRequest.getGroupId(), offsetCommitRequest, result});
        }
        OffsetCommitResponse offsetCommitResponse = new OffsetCommitResponse(result);
        return new Command((Object)offsetCommitResponse);
    }

    public int type() {
        return KafkaCommandType.OFFSET_COMMIT.getCode();
    }
}

