/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.SaslAuthenticateRequest;
import org.joyqueue.broker.kafka.command.SaslAuthenticateResponse;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.network.helper.KafkaSessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.response.BooleanResponse;
import org.joyqueue.security.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticateHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(SaslAuthenticateHandler.class);
    private KafkaConfig config;
    private SessionManager sessionManager;
    private Authentication authentication;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.config = kafkaContext.getConfig();
        this.sessionManager = kafkaContext.getBrokerContext().getSessionManager();
        this.authentication = kafkaContext.getBrokerContext().getAuthentication();
    }

    public Command handle(Transport transport, Command command) {
        SaslAuthenticateRequest request = (SaslAuthenticateRequest)command.getPayload();
        SaslAuthenticateRequest.SaslAuthenticateData authData = request.getData();
        SaslAuthenticateResponse response = null;
        try {
            BooleanResponse authResponse = this.authentication.auth(authData.getApp(), authData.getToken());
            if (authResponse.isSuccess()) {
                KafkaSessionHelper.setIsAuth(transport, true);
                response = new SaslAuthenticateResponse(KafkaErrorCode.NONE.getCode(), null, request.getAuthBytes(), 0L);
            } else {
                logger.error("sasl authentication failed, transport: {}, request: {}, code: {}", new Object[]{transport, request, authResponse.getJoyQueueCode()});
                response = new SaslAuthenticateResponse(KafkaErrorCode.SASL_AUTHENTICATION_FAILED.getCode(), authResponse.getJoyQueueCode().name(), request.getAuthBytes(), 0L);
            }
        }
        catch (Exception e) {
            logger.error("sasl authentication exception, transport: {}, request: {}", new Object[]{transport, request, e});
            response = new SaslAuthenticateResponse(KafkaErrorCode.SASL_AUTHENTICATION_FAILED.getCode(), "SASL Authentication failed", request.getAuthBytes(), 0L);
        }
        return new Command((Object)response);
    }

    public int type() {
        return KafkaCommandType.SASL_AUTHENTICATE.getCode();
    }
}

