/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction.completion;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.transaction.completion.TransactionCompletionHandler;
import org.joyqueue.broker.kafka.coordinator.transaction.completion.TransactionCompletionThread;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCompletionScheduler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionCompletionScheduler.class);
    private KafkaConfig config;
    private TransactionCompletionHandler transactionCompletionHandler;
    private ScheduledExecutorService executor;

    public TransactionCompletionScheduler(KafkaConfig config, TransactionCompletionHandler transactionCompletionHandler) {
        this.config = config;
        this.transactionCompletionHandler = transactionCompletionHandler;
    }

    protected void validate() throws Exception {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("joyqueue-transaction-compensate"));
    }

    protected void doStart() throws Exception {
        this.executor.scheduleAtFixedRate(new TransactionCompletionThread(this.transactionCompletionHandler), this.config.getTransactionLogInterval(), this.config.getTransactionLogInterval(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

