/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.protocol;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.List;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.broker.kafka.network.protocol.KafkaDecoder;
import org.joyqueue.broker.kafka.network.protocol.KafkaEncoder;
import org.joyqueue.broker.kafka.network.protocol.KafkaHeaderCodec;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.codec.Decoder;
import org.joyqueue.network.transport.codec.Encoder;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.codec.support.DefaultCodec;

public class KafkaCodecFactory
implements CodecFactory {
    private PayloadCodecFactory payloadCodecFactory = this.initPayloadCodecFactory();

    protected PayloadCodecFactory initPayloadCodecFactory() {
        PayloadCodecFactory payloadCodecFactory = new PayloadCodecFactory();
        List<KafkaPayloadCodec> payloadCodecs = this.loadPayloadCodecs();
        for (KafkaPayloadCodec payloadCodec : payloadCodecs) {
            payloadCodecFactory.register((PayloadCodec)payloadCodec);
        }
        return payloadCodecFactory;
    }

    protected List<KafkaPayloadCodec> loadPayloadCodecs() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(KafkaPayloadCodec.class));
    }

    public Codec getCodec() {
        KafkaHeaderCodec headerCodec = new KafkaHeaderCodec();
        return new DefaultCodec((Decoder)new KafkaDecoder(headerCodec, this.payloadCodecFactory), (Encoder)new KafkaEncoder(headerCodec, this.payloadCodecFactory));
    }
}

