/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.protocol;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.List;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.support.DefaultCommandHandlerFactory;

public class KafkaCommandHandlerFactory
extends DefaultCommandHandlerFactory {
    private KafkaContext kafkaContext;
    private List<KafkaCommandHandler> commandHandlers;

    public KafkaCommandHandlerFactory(KafkaContext kafkaContext) {
        this.kafkaContext = kafkaContext;
        this.commandHandlers = this.loadCommandHandlers();
        this.initCommandHandlers(this.commandHandlers);
        this.registerCommandHandlers(this.commandHandlers);
    }

    protected List<KafkaCommandHandler> loadCommandHandlers() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(KafkaCommandHandler.class));
    }

    protected void initCommandHandlers(List<KafkaCommandHandler> commandHandlers) {
        for (KafkaCommandHandler commandHandler : commandHandlers) {
            if (commandHandler instanceof BrokerContextAware) {
                ((BrokerContextAware)commandHandler).setBrokerContext(this.kafkaContext.getBrokerContext());
            }
            if (!(commandHandler instanceof KafkaContextAware)) continue;
            ((KafkaContextAware)((Object)commandHandler)).setKafkaContext(this.kafkaContext);
        }
    }

    protected void registerCommandHandlers(List<KafkaCommandHandler> commandHandlers) {
        for (KafkaCommandHandler commandHandler : commandHandlers) {
            this.register(commandHandler);
        }
    }

    public void register(CommandHandler commandHandler) {
        super.register(commandHandler);
    }

    public void register(int type, CommandHandler commandHandler) {
        super.register(type, commandHandler);
    }
}

