/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.TxnOffsetCommitRequest;
import org.joyqueue.broker.kafka.command.TxnOffsetCommitResponse;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class TxnOffsetCommitCodec
implements KafkaPayloadCodec<TxnOffsetCommitResponse>,
Type {
    public TxnOffsetCommitRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        String transactionId = Serializer.readString((ByteBuf)buffer, (int)2);
        String groupId = Serializer.readString((ByteBuf)buffer, (int)2);
        long producerId = buffer.readLong();
        short producerEpoch = buffer.readShort();
        int topicSize = Math.max(buffer.readInt(), 0);
        HashMap partittions = Maps.newHashMapWithExpectedSize((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = Math.max(buffer.readInt(), 0);
            ArrayList offsetAndMetadataList = Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata();
                offsetAndMetadata.setPartition(buffer.readInt());
                offsetAndMetadata.setOffset(buffer.readLong());
                if (header.getVersion() >= 2) {
                    offsetAndMetadata.setLeaderEpoch(buffer.readInt());
                }
                offsetAndMetadata.setMetadata(Serializer.readString((ByteBuf)buffer, (int)2));
                offsetAndMetadataList.add(offsetAndMetadata);
            }
            partittions.put(topic, offsetAndMetadataList);
        }
        TxnOffsetCommitRequest txnOffsetCommitRequest = new TxnOffsetCommitRequest();
        txnOffsetCommitRequest.setTransactionId(transactionId);
        txnOffsetCommitRequest.setGroupId(groupId);
        txnOffsetCommitRequest.setProducerId(producerId);
        txnOffsetCommitRequest.setProducerEpoch(producerEpoch);
        txnOffsetCommitRequest.setPartitions(partittions);
        return txnOffsetCommitRequest;
    }

    public void encode(TxnOffsetCommitResponse payload, ByteBuf buffer) throws Exception {
        Map<String, List<PartitionMetadataAndError>> partitions = payload.getPartitions();
        buffer.writeInt(payload.getThrottleTimeMs());
        buffer.writeInt(partitions.size());
        for (Map.Entry<String, List<PartitionMetadataAndError>> entry : partitions.entrySet()) {
            Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            buffer.writeInt(entry.getValue().size());
            for (PartitionMetadataAndError partitionMetadataAndError : entry.getValue()) {
                buffer.writeInt(partitionMetadataAndError.getPartition());
                buffer.writeShort((int)partitionMetadataAndError.getError());
            }
        }
    }

    public int type() {
        return KafkaCommandType.TXN_OFFSET_COMMIT.getCode();
    }
}

