/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.OffsetFetchRequest;
import org.joyqueue.broker.kafka.command.OffsetFetchResponse;
import org.joyqueue.broker.kafka.model.OffsetMetadataAndError;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class OffsetFetchCodec
implements KafkaPayloadCodec<OffsetFetchResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        OffsetFetchRequest offsetFetchRequest = new OffsetFetchRequest();
        offsetFetchRequest.setGroupId(Serializer.readString((ByteBuf)buffer, (int)2));
        int topicCount = buffer.readInt();
        HashMap topicAndPartitions = Maps.newHashMapWithExpectedSize((int)topicCount);
        for (int i = 0; i < topicCount; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionCount = buffer.readInt();
            ArrayList partitions = Lists.newArrayListWithCapacity((int)partitionCount);
            topicAndPartitions.put(topic, partitions);
            for (int j = 0; j < partitionCount; ++j) {
                int partition = buffer.readInt();
                partitions.add(partition);
            }
        }
        offsetFetchRequest.setTopicAndPartitions(topicAndPartitions);
        return offsetFetchRequest;
    }

    public void encode(OffsetFetchResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        if (version >= 3) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        Map<String, List<OffsetMetadataAndError>> topicOffsetMetadataAndErrors = payload.getTopicMetadataAndErrors();
        buffer.writeInt(topicOffsetMetadataAndErrors.size());
        for (Map.Entry<String, List<OffsetMetadataAndError>> entry : topicOffsetMetadataAndErrors.entrySet()) {
            Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            buffer.writeInt(entry.getValue().size());
            for (OffsetMetadataAndError offsetMetadataAndError : entry.getValue()) {
                buffer.writeInt(offsetMetadataAndError.getPartition());
                buffer.writeLong(offsetMetadataAndError.getOffset());
                Serializer.write((String)offsetMetadataAndError.getMetadata(), (ByteBuf)buffer, (int)2);
                buffer.writeShort((int)offsetMetadataAndError.getError());
            }
        }
        if (version >= 2) {
            buffer.writeShort((int)KafkaErrorCode.NONE.getCode());
        }
    }

    public int type() {
        return KafkaCommandType.OFFSET_FETCH.getCode();
    }
}

