/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.FetchRequest;
import org.joyqueue.broker.kafka.command.FetchResponse;
import org.joyqueue.broker.kafka.message.KafkaMessageSerializer;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;

public class FetchCodec
implements KafkaPayloadCodec<FetchResponse>,
Type {
    public FetchRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        FetchRequest fetchRequest = new FetchRequest();
        fetchRequest.setReplicaId(buffer.readInt());
        fetchRequest.setMaxWait(buffer.readInt());
        fetchRequest.setMinBytes(buffer.readInt());
        if (header.getApiVersion() >= 3) {
            fetchRequest.setMaxBytes(buffer.readInt());
        }
        if (header.getApiVersion() >= 4) {
            fetchRequest.setIsolationLevel(buffer.readByte());
        }
        int topicSize = Math.max(buffer.readInt(), 0);
        HashMap partitionRequestMap = Maps.newHashMapWithExpectedSize((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = Math.max(buffer.readInt(), 0);
            List partitionRequests = (List)partitionRequestMap.get(topic);
            if (partitionRequests == null) {
                partitionRequests = Lists.newArrayListWithCapacity((int)partitionSize);
                partitionRequestMap.put(topic, partitionRequests);
            }
            for (int j = 0; j < partitionSize; ++j) {
                int partitionId = buffer.readInt();
                long offset = buffer.readLong();
                long logStartOffset = 0L;
                if (header.getApiVersion() >= 5) {
                    logStartOffset = buffer.readLong();
                }
                int partitionMaxBytes = buffer.readInt();
                FetchRequest.PartitionRequest partitionRequest = new FetchRequest.PartitionRequest();
                partitionRequest.setPartition(partitionId);
                partitionRequest.setOffset(offset);
                partitionRequest.setMaxBytes(partitionMaxBytes);
                if (header.getApiVersion() >= 5) {
                    partitionRequest.setLogStartOffset(logStartOffset);
                }
                partitionRequests.add(partitionRequest);
            }
        }
        fetchRequest.setPartitionRequests(partitionRequestMap);
        return fetchRequest;
    }

    public void encode(FetchResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        if (version >= 1) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        Map<String, List<FetchResponse.PartitionResponse>> partitionResponseMap = payload.getPartitionResponses();
        buffer.writeInt(partitionResponseMap.size());
        for (Map.Entry<String, List<FetchResponse.PartitionResponse>> entry : partitionResponseMap.entrySet()) {
            try {
                Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
            List<FetchResponse.PartitionResponse> partitionResponses = entry.getValue();
            buffer.writeInt(partitionResponses.size());
            for (FetchResponse.PartitionResponse partitionResponse : partitionResponses) {
                buffer.writeInt(partitionResponse.getPartition());
                buffer.writeShort((int)partitionResponse.getError());
                buffer.writeLong(partitionResponse.getHighWater());
                if (version >= 4) {
                    buffer.writeLong(partitionResponse.getLastStableOffset());
                    if (version >= 5) {
                        buffer.writeLong(partitionResponse.getLogStartOffset());
                    }
                    buffer.writeInt(0);
                }
                int startIndex = buffer.writerIndex();
                buffer.writeInt(0);
                KafkaMessageSerializer.writeMessages(buffer, partitionResponse.getMessages(), payload.getVersion());
                int length = buffer.writerIndex() - startIndex - 4;
                buffer.setInt(startIndex, length);
            }
        }
    }

    public int type() {
        return KafkaCommandType.FETCH.getCode();
    }
}

