/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.DescribeGroupsRequest;
import org.joyqueue.broker.kafka.command.DescribeGroupsResponse;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupDescribe;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.message.serializer.KafkaSyncGroupAssignmentSerializer;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;

public class DescribeGroupsCodec
implements KafkaPayloadCodec<DescribeGroupsResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        DescribeGroupsRequest request = new DescribeGroupsRequest();
        LinkedList groupIds = Lists.newLinkedList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            groupIds.add(Serializer.readString((ByteBuf)buffer, (int)2));
        }
        request.setGroupIds(groupIds);
        return request;
    }

    public void encode(DescribeGroupsResponse payload, ByteBuf buffer) throws Exception {
        DescribeGroupsResponse response = payload;
        short version = response.getVersion();
        if (version == 1) {
            buffer.writeInt(response.getThrottleTimeMs());
        }
        if (CollectionUtils.isEmpty(response.getGroups())) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(response.getGroups().size());
            for (GroupDescribe group : response.getGroups()) {
                buffer.writeShort((int)group.getErrCode());
                try {
                    Serializer.write((String)group.getGroupId(), (ByteBuf)buffer, (int)2);
                    Serializer.write((String)group.getState(), (ByteBuf)buffer, (int)2);
                    Serializer.write((String)group.getProtocolType(), (ByteBuf)buffer, (int)2);
                    Serializer.write((String)group.getProtocol(), (ByteBuf)buffer, (int)2);
                }
                catch (Exception e) {
                    throw new TransportException.CodecException((Throwable)e);
                }
                if (CollectionUtils.isEmpty(group.getMembers())) {
                    buffer.writeInt(0);
                    continue;
                }
                buffer.writeInt(group.getMembers().size());
                for (GroupMemberMetadata member : group.getMembers()) {
                    try {
                        Serializer.write((String)member.getId(), (ByteBuf)buffer, (int)2);
                        Serializer.write((String)member.getClientId(), (ByteBuf)buffer, (int)2);
                        Serializer.write((String)member.getConnectionHost(), (ByteBuf)buffer, (int)2);
                    }
                    catch (Exception e) {
                        throw new TransportException.CodecException((Throwable)e);
                    }
                    byte[] metadata = member.metadata(group.getProtocol());
                    buffer.writeInt(metadata.length);
                    buffer.writeBytes(metadata);
                    KafkaSyncGroupAssignmentSerializer.writeAssignment(buffer, member.getAssignment());
                }
            }
        }
    }

    public int type() {
        return KafkaCommandType.DESCRIBE_GROUP.getCode();
    }
}

