/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.helper;

import org.apache.commons.lang3.StringUtils;

public class KafkaClientHelper {
    private static final String SEPARATOR = "-";
    private static final String AUTH_SEPARATOR = "@";
    private static final String[] REPLACE = new String[]{"spark-executor-"};
    private static final String[] METADATA_FUZZY_SEARCH = new String[]{"MetadataFuzzySearch"};

    public static String parseClient(String clientId) {
        if (StringUtils.contains((CharSequence)(clientId = KafkaClientHelper.doParseClient(clientId)), (CharSequence)AUTH_SEPARATOR)) {
            String[] strings = StringUtils.splitByWholeSeparator((String)clientId, (String)AUTH_SEPARATOR);
            clientId = strings[0];
        }
        return clientId;
    }

    public static boolean isMetadataFuzzySearch(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return false;
        }
        String[] strings = StringUtils.splitByWholeSeparator((String)clientId, (String)SEPARATOR);
        for (String fuzzySearch : METADATA_FUZZY_SEARCH) {
            if (!strings[strings.length - 1].equals(fuzzySearch)) continue;
            return true;
        }
        return false;
    }

    public static String parseToken(String clientId) {
        if (StringUtils.contains((CharSequence)(clientId = KafkaClientHelper.doParseClient(clientId)), (CharSequence)AUTH_SEPARATOR)) {
            String[] strings = StringUtils.splitByWholeSeparator((String)clientId, (String)AUTH_SEPARATOR);
            return strings[1];
        }
        return null;
    }

    protected static String doParseClient(String clientId) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return clientId;
        }
        for (String replace : REPLACE) {
            clientId = StringUtils.replace((String)clientId, (String)replace, (String)"");
        }
        if (StringUtils.contains((CharSequence)clientId, (CharSequence)SEPARATOR)) {
            String[] strings = StringUtils.splitByWholeSeparator((String)clientId, (String)SEPARATOR);
            clientId = strings[0];
        }
        return clientId;
    }
}

