/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.ProduceRequest;
import org.joyqueue.broker.kafka.command.ProduceResponse;
import org.joyqueue.broker.kafka.model.ProducePartitionGroupRequest;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.session.Producer;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ProduceHandler.class);
    private Produce produce;

    public ProduceHandler(Produce produce) {
        this.produce = produce;
    }

    public void produceMessage(ProduceRequest request, QosLevel qosLevel, Producer producer, ProducePartitionGroupRequest partitionGroupRequest, EventListener<ProduceResponse.PartitionResponse> listener) {
        try {
            this.produce.putMessageAsync(producer, partitionGroupRequest.getMessages(), qosLevel, writeResult -> {
                if (!writeResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                    logger.error("produce message failed, topic: {}, code: {}", (Object)producer.getTopic(), (Object)writeResult.getCode());
                }
                short code = KafkaErrorCode.joyQueueCodeFor(writeResult.getCode().getCode());
                listener.onEvent((Object)new ProduceResponse.PartitionResponse(0L, code));
            });
        }
        catch (Exception e) {
            logger.error("produce message failed, topic: {}", (Object)producer.getTopic(), (Object)e);
            short code = KafkaErrorCode.exceptionFor(e);
            listener.onEvent((Object)new ProduceResponse.PartitionResponse(0L, code));
        }
    }
}

