/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.AddPartitionsToTxnRequest;
import org.joyqueue.broker.kafka.command.AddPartitionsToTxnResponse;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPartitionsToTxnRequestHandler
implements KafkaCommandHandler,
Type,
KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(AddPartitionsToTxnRequestHandler.class);
    private TransactionCoordinator transactionCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        AddPartitionsToTxnRequest addPartitionsToTxnRequest = (AddPartitionsToTxnRequest)command.getPayload();
        String clientId = KafkaClientHelper.parseClient(addPartitionsToTxnRequest.getClientId());
        AddPartitionsToTxnResponse response = null;
        try {
            Map<String, List<PartitionMetadataAndError>> errors = this.transactionCoordinator.handleAddPartitionsToTxn(clientId, addPartitionsToTxnRequest.getTransactionId(), addPartitionsToTxnRequest.getProducerId(), addPartitionsToTxnRequest.getProducerEpoch(), addPartitionsToTxnRequest.getPartitions());
            response = new AddPartitionsToTxnResponse(errors);
        }
        catch (TransactionException e) {
            logger.warn("add partitions to txn exception, code: {}, message: {}, request: {}", new Object[]{e.getCode(), e.getMessage(), addPartitionsToTxnRequest});
            response = new AddPartitionsToTxnResponse(this.buildPartitionError(e.getCode(), addPartitionsToTxnRequest.getPartitions()));
        }
        catch (Exception e) {
            logger.error("add partitions to txn exception, request: {}", (Object)addPartitionsToTxnRequest, (Object)e);
            response = new AddPartitionsToTxnResponse(this.buildPartitionError(KafkaErrorCode.exceptionFor(e), addPartitionsToTxnRequest.getPartitions()));
        }
        return new Command((Object)response);
    }

    protected Map<String, List<PartitionMetadataAndError>> buildPartitionError(int code, Map<String, List<Integer>> partitions) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)partitions.size());
        for (Map.Entry<String, List<Integer>> entry : partitions.entrySet()) {
            ArrayList partitionMetadataAndErrors = Lists.newArrayListWithCapacity((int)entry.getValue().size());
            for (Integer partition : entry.getValue()) {
                partitionMetadataAndErrors.add(new PartitionMetadataAndError(partition, (short)code));
            }
            result.put(entry.getKey(), partitionMetadataAndErrors);
        }
        return result;
    }

    public int type() {
        return KafkaCommandType.ADD_PARTITIONS_TO_TXN.getCode();
    }
}

