/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaCommandHandler;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.AddOffsetsToTxnRequest;
import org.joyqueue.broker.kafka.command.AddOffsetsToTxnResponse;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOffsetsToTxnRequestHandler
implements KafkaCommandHandler,
Type,
KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(AddOffsetsToTxnRequestHandler.class);
    private TransactionCoordinator transactionCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        String clientId;
        AddOffsetsToTxnRequest addOffsetsToTxnRequest = (AddOffsetsToTxnRequest)command.getPayload();
        String groupId = clientId = KafkaClientHelper.parseClient(addOffsetsToTxnRequest.getClientId());
        AddOffsetsToTxnResponse response = null;
        try {
            boolean isSuccess = this.transactionCoordinator.handleAddOffsetsToTxn(clientId, addOffsetsToTxnRequest.getTransactionId(), groupId, addOffsetsToTxnRequest.getProducerId(), addOffsetsToTxnRequest.getProducerEpoch());
            response = new AddOffsetsToTxnResponse(KafkaErrorCode.NONE.getCode());
        }
        catch (TransactionException e) {
            logger.warn("add offsets to txn exception, code: {}, message: {}, request: {}", new Object[]{e.getCode(), e.getMessage(), addOffsetsToTxnRequest});
            response = new AddOffsetsToTxnResponse((short)e.getCode());
        }
        catch (Exception e) {
            logger.error("add offsets to txn exception, request: {}", (Object)addOffsetsToTxnRequest, (Object)e);
            response = new AddOffsetsToTxnResponse(KafkaErrorCode.exceptionFor(e));
        }
        return new Command((Object)response);
    }

    public int type() {
        return KafkaCommandType.ADD_OFFSETS_TO_TXN.getCode();
    }
}

