/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.coordinator.Coordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionMetadataManager;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionMetadata;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionOffset;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.coordinator.transaction.synchronizer.TransactionSynchronizer;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOffsetHandler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionOffsetHandler.class);
    private Coordinator coordinator;
    private TransactionMetadataManager transactionMetadataManager;
    private TransactionSynchronizer transactionSynchronizer;

    public TransactionOffsetHandler(Coordinator coordinator, TransactionMetadataManager transactionMetadataManager, TransactionSynchronizer transactionSynchronizer) {
        this.coordinator = coordinator;
        this.transactionMetadataManager = transactionMetadataManager;
        this.transactionSynchronizer = transactionSynchronizer;
    }

    public boolean addOffsetsToTxn(String clientId, String transactionId, String groupId, long producerId, short producerEpoch) {
        this.checkCoordinatorState(clientId, transactionId);
        TransactionMetadata transactionMetadata = this.transactionMetadataManager.getTransaction(transactionId);
        if (transactionMetadata == null || transactionMetadata.getProducerId() != producerId || !StringUtils.equals((CharSequence)transactionMetadata.getApp(), (CharSequence)clientId)) {
            throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
        }
        if (transactionMetadata.getProducerEpoch() != producerEpoch) {
            throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
        }
        if (transactionMetadata.isPrepared()) {
            throw new TransactionException(KafkaErrorCode.CONCURRENT_TRANSACTIONS.getCode());
        }
        transactionMetadata.updateLastTime();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<PartitionMetadataAndError>> commitOffset(String clientId, String transactionId, String groupId, long producerId, short producerEpoch, Map<String, List<OffsetAndMetadata>> offsetts) {
        this.checkCoordinatorState(clientId, transactionId);
        TransactionMetadata transactionMetadata = this.transactionMetadataManager.getTransaction(transactionId);
        if (transactionMetadata == null) {
            throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
        }
        TransactionMetadata transactionMetadata2 = transactionMetadata;
        synchronized (transactionMetadata2) {
            if (transactionMetadata.getProducerId() != producerId || !StringUtils.equals((CharSequence)transactionMetadata.getApp(), (CharSequence)clientId)) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
            }
            if (transactionMetadata.getProducerEpoch() != producerEpoch) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            if (transactionMetadata.isPrepared()) {
                throw new TransactionException(KafkaErrorCode.CONCURRENT_TRANSACTIONS.getCode());
            }
            return this.doCommitOffset(transactionMetadata, offsetts);
        }
    }

    protected Map<String, List<PartitionMetadataAndError>> doCommitOffset(TransactionMetadata transactionMetadata, Map<String, List<OffsetAndMetadata>> offsets) {
        transactionMetadata.updateLastTime();
        HashSet transactionOffsets = Sets.newHashSet();
        for (Map.Entry<String, List<OffsetAndMetadata>> entry : offsets.entrySet()) {
            for (OffsetAndMetadata offsetAndMetadata : entry.getValue()) {
                transactionOffsets.add(new TransactionOffset(entry.getKey(), (short)offsetAndMetadata.getPartition(), offsetAndMetadata.getOffset(), transactionMetadata.getApp(), transactionMetadata.getId(), transactionMetadata.getProducerId(), transactionMetadata.getProducerEpoch(), transactionMetadata.getEpoch(), transactionMetadata.getTimeout(), SystemClock.now()));
            }
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)transactionOffsets)) {
                transactionMetadata.addOffsets(transactionOffsets);
                this.transactionSynchronizer.commitOffset(transactionMetadata, transactionOffsets);
            }
            return this.buildPartitionMetadataAndError(offsets, KafkaErrorCode.NONE.getCode());
        }
        catch (Exception e) {
            logger.error("commitOffset exception, metadata: {}, offsets: {}", new Object[]{transactionMetadata, offsets, e});
            throw new TransactionException(e, (int)KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode());
        }
    }

    protected Map<String, List<PartitionMetadataAndError>> buildPartitionMetadataAndError(Map<String, List<OffsetAndMetadata>> offsets, short code) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)offsets.size());
        for (Map.Entry<String, List<OffsetAndMetadata>> entry : offsets.entrySet()) {
            ArrayList partitionMetadataAndErrors = Lists.newArrayListWithCapacity((int)entry.getValue().size());
            for (OffsetAndMetadata offsetAndMetadata : entry.getValue()) {
                partitionMetadataAndErrors.add(new PartitionMetadataAndError(offsetAndMetadata.getPartition(), code));
            }
            result.put(entry.getKey(), partitionMetadataAndErrors);
        }
        return result;
    }

    protected void checkCoordinatorState(String clientId, String transactionId) {
        if (!this.isStarted()) {
            throw new TransactionException(KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode());
        }
        if (!this.coordinator.isCurrentTransaction(clientId)) {
            throw new TransactionException(KafkaErrorCode.NOT_COORDINATOR.getCode());
        }
    }
}

