/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.command;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.KafkaRequestOrResponse;
import org.joyqueue.broker.kafka.message.KafkaBrokerMessage;
import org.joyqueue.broker.network.traffic.FetchResponseTrafficPayload;
import org.joyqueue.broker.network.traffic.Traffic;

public class FetchResponse
extends KafkaRequestOrResponse
implements FetchResponseTrafficPayload {
    private Traffic traffic;
    private Map<String, List<PartitionResponse>> partitionResponses;

    public void setPartitionResponses(Map<String, List<PartitionResponse>> partitionResponses) {
        this.partitionResponses = partitionResponses;
    }

    public Map<String, List<PartitionResponse>> getPartitionResponses() {
        return this.partitionResponses;
    }

    public void setTraffic(Traffic traffic) {
        this.traffic = traffic;
    }

    public int type() {
        return KafkaCommandType.FETCH.getCode();
    }

    public Traffic getTraffic() {
        return this.traffic;
    }

    public String toString() {
        StringBuilder responseStringBuilder = new StringBuilder();
        responseStringBuilder.append("Name: " + this.getClass().getSimpleName());
        responseStringBuilder.append("fetchResponses: " + this.partitionResponses);
        return responseStringBuilder.toString();
    }

    public static class PartitionResponse {
        private int partition;
        private short error = KafkaErrorCode.NONE.getCode();
        private long highWater = -1L;
        private long lastStableOffset = -1L;
        private long logStartOffset = -1L;
        private List<KafkaBrokerMessage> messages;
        private int bytes;

        public PartitionResponse() {
        }

        public PartitionResponse(int partition, short error) {
            this.partition = partition;
            this.error = error;
        }

        public PartitionResponse(int partition, short error, List<KafkaBrokerMessage> messages) {
            this.partition = partition;
            this.error = error;
            this.messages = messages;
        }

        public void setHighWater(long highWater) {
            this.highWater = highWater;
        }

        public long getHighWater() {
            return this.highWater;
        }

        public void setLogStartOffset(long logStartOffset) {
            this.logStartOffset = logStartOffset;
        }

        public long getLogStartOffset() {
            return this.logStartOffset;
        }

        public void setLastStableOffset(long lastStableOffset) {
            this.lastStableOffset = lastStableOffset;
        }

        public long getLastStableOffset() {
            return this.lastStableOffset;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public int getPartition() {
            return this.partition;
        }

        public short getError() {
            return this.error;
        }

        public void setError(short error) {
            this.error = error;
        }

        public void setMessages(List<KafkaBrokerMessage> messages) {
            this.messages = messages;
        }

        public List<KafkaBrokerMessage> getMessages() {
            return this.messages;
        }

        public void setBytes(int bytes) {
            this.bytes = bytes;
        }

        public int getSize() {
            if (CollectionUtils.isEmpty(this.messages)) {
                return 0;
            }
            return this.messages.size();
        }

        public int getBytes() {
            return this.bytes;
        }
    }
}

