/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.protocol;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.command.KafkaRequestOrResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.protocol.KafkaHeaderCodec;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.DefaultDecoder;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDecoder
extends DefaultDecoder {
    private static Logger logger = LoggerFactory.getLogger(KafkaDecoder.class);

    public KafkaDecoder(KafkaHeaderCodec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        super((Codec)headerCodec, payloadCodecFactory);
    }

    public Object decode(ByteBuf buffer) throws TransportException.CodecException {
        Command command = (Command)super.decode(buffer);
        if (command != null) {
            this.fillHeader((KafkaHeader)command.getHeader(), (KafkaRequestOrResponse)command.getPayload());
        }
        return command;
    }

    private void fillHeader(KafkaHeader header, KafkaRequestOrResponse payload) throws TransportException.CodecException {
        payload.setVersion((short)header.getVersion());
        payload.setCorrelationId(header.getRequestId());
        payload.setClientId(header.getClientId());
        payload.setDirection(header.getDirection());
    }

    protected int readLength(ByteBuf buffer) {
        return buffer.readInt();
    }
}

