/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.ListOffsetsRequest;
import org.joyqueue.broker.kafka.command.ListOffsetsResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class ListOffsetsCodec
implements KafkaPayloadCodec<ListOffsetsResponse>,
Type {
    public ListOffsetsRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        ListOffsetsRequest offsetRequest = new ListOffsetsRequest();
        offsetRequest.setReplicaId(buffer.readInt());
        if (header.getVersion() >= 2) {
            offsetRequest.setIsolationLevel(buffer.readByte());
        }
        int topicSize = Math.max(buffer.readInt(), 0);
        HashMap partitionRequestMap = Maps.newHashMapWithExpectedSize((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = Math.max(buffer.readInt(), 0);
            ArrayList partitionRequests = Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                int partition = buffer.readInt();
                long time = buffer.readLong();
                int maxNumOffsets = header.getApiVersion() == 0 ? buffer.readInt() : 1;
                ListOffsetsRequest.PartitionOffsetRequest partitionOffsetRequest = new ListOffsetsRequest.PartitionOffsetRequest(partition, time, maxNumOffsets);
                partitionRequests.add(partitionOffsetRequest);
            }
            partitionRequestMap.put(topic, partitionRequests);
        }
        offsetRequest.setPartitionRequests(partitionRequestMap);
        return offsetRequest;
    }

    public void encode(ListOffsetsResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        if (version >= 2) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        Map<String, List<ListOffsetsResponse.PartitionOffsetResponse>> partitionResponse = payload.getPartitionResponses();
        buffer.writeInt(partitionResponse.size());
        for (Map.Entry<String, List<ListOffsetsResponse.PartitionOffsetResponse>> entry : partitionResponse.entrySet()) {
            String topic = entry.getKey();
            Serializer.write((String)topic, (ByteBuf)buffer, (int)2);
            buffer.writeInt(entry.getValue().size());
            for (ListOffsetsResponse.PartitionOffsetResponse partitionOffsetResponse : entry.getValue()) {
                buffer.writeInt(partitionOffsetResponse.getPartition());
                buffer.writeShort((int)partitionOffsetResponse.getErrorCode());
                if (version >= 1) {
                    buffer.writeLong(partitionOffsetResponse.getTimestamp());
                }
                long offset = partitionOffsetResponse.getOffset();
                if (version == 0) {
                    buffer.writeInt(1);
                    buffer.writeLong(offset);
                    continue;
                }
                buffer.writeLong(offset);
            }
        }
    }

    public int type() {
        return KafkaCommandType.LIST_OFFSETS.getCode();
    }
}

