/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network;

import org.joyqueue.domain.QosLevel;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;

public class KafkaHeader
implements Header {
    private short apiKey;
    private short apiVersion;
    private int correlationId;
    private String clientId;
    private Direction direction;
    private QosLevel qosLevel;

    public KafkaHeader() {
    }

    public KafkaHeader(short apiKey, short apiVersion, int correlationId) {
        this.apiKey = apiKey;
        this.apiVersion = apiVersion;
        this.correlationId = correlationId;
    }

    public KafkaHeader(short apiKey, short apiVersion, int correlationId, QosLevel qosLevel, Direction direction) {
        this.apiKey = apiKey;
        this.apiVersion = apiVersion;
        this.correlationId = correlationId;
        this.direction = direction;
        this.qosLevel = qosLevel;
    }

    public short getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(short apiKey) {
        this.apiKey = apiKey;
    }

    public short getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(short apiVersion) {
        this.apiVersion = apiVersion;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(int correlationId) {
        this.correlationId = correlationId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public int getRequestId() {
        return this.correlationId;
    }

    public void setRequestId(int requestId) {
        this.correlationId = requestId;
    }

    public int getType() {
        return this.apiKey;
    }

    public void setType(int type) {
        this.apiKey = (short)type;
    }

    public void setVersion(int version) {
        this.apiVersion = (short)version;
    }

    public int getVersion() {
        return this.apiVersion;
    }

    public QosLevel getQosLevel() {
        return this.qosLevel;
    }

    public void setQosLevel(QosLevel qosLevel) {
        this.qosLevel = qosLevel;
    }

    public void setStatus(int status) {
    }

    public int getStatus() {
        return 0;
    }

    public String getError() {
        return null;
    }

    public void setError(String msg) {
    }

    public String toString() {
        return String.format("KafkaHeader: {apiKey: %s. apiVersion: %s, correlationId: %s}", this.apiKey, this.apiVersion, this.correlationId);
    }

    public static class Builder {
        KafkaHeader header = new KafkaHeader();

        public static Builder create() {
            return new Builder();
        }

        public static KafkaHeader response() {
            return Builder.create().direction(Direction.RESPONSE).build();
        }

        public static KafkaHeader response(int correlationId) {
            return Builder.create().direction(Direction.RESPONSE).build();
        }

        public static KafkaHeader request() {
            return Builder.create().direction(Direction.REQUEST).build();
        }

        public Builder correlationId(int correlationId) {
            this.header.setCorrelationId(correlationId);
            return this;
        }

        public Builder direction(Direction direction) {
            this.header.setDirection(direction);
            return this;
        }

        public Builder qosLevel(QosLevel qosLevel) {
            this.header.setQosLevel(qosLevel);
            return this;
        }

        public KafkaHeader build() {
            return this.header;
        }
    }
}

