/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.message.converter;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.kafka.message.KafkaBrokerMessage;
import org.joyqueue.broker.kafka.message.KafkaMessageSerializer;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;

public class KafkaMessageConverter {
    public static List<KafkaBrokerMessage> toKafkaBrokerMessage(String topic, int partition, List<BrokerMessage> brokerMessages) {
        LinkedList result = Lists.newLinkedList();
        for (BrokerMessage message : brokerMessages) {
            KafkaBrokerMessage kafkaBrokerMessage = KafkaMessageConverter.toKafkaBrokerMessage(topic, partition, message);
            result.add(kafkaBrokerMessage);
        }
        return result;
    }

    public static KafkaBrokerMessage toKafkaBrokerMessage(String topic, int partition, BrokerMessage brokerMessage) {
        KafkaBrokerMessage kafkaBrokerMessage = new KafkaBrokerMessage();
        kafkaBrokerMessage.setOffset(brokerMessage.getMsgIndexNo());
        kafkaBrokerMessage.setKey(brokerMessage.getBusinessId() == null ? null : brokerMessage.getBusinessId().getBytes(Charsets.UTF_8));
        kafkaBrokerMessage.setValue(brokerMessage.getByteBody());
        kafkaBrokerMessage.setBatch(brokerMessage.isBatch());
        kafkaBrokerMessage.setFlag(brokerMessage.getFlag());
        KafkaMessageSerializer.readExtension(brokerMessage, kafkaBrokerMessage);
        return kafkaBrokerMessage;
    }

    public static List<BrokerMessage> toBrokerMessages(String topic, int partition, String clientId, InetSocketAddress clientAddress, List<KafkaBrokerMessage> kafkaBrokerMessages) {
        LinkedList result = Lists.newLinkedList();
        byte[] clientAddressBytes = IpUtil.toByte((InetSocketAddress)clientAddress);
        for (KafkaBrokerMessage message : kafkaBrokerMessages) {
            BrokerMessage brokerMessage = KafkaMessageConverter.toBrokerMessage(topic, partition, clientId, clientAddressBytes, message);
            result.add(brokerMessage);
        }
        return result;
    }

    public static BrokerMessage toBrokerMessage(String topic, int partition, String clientId, InetSocketAddress clientAddress, KafkaBrokerMessage kafkaBrokerMessage) {
        return KafkaMessageConverter.toBrokerMessage(topic, partition, clientId, IpUtil.toByte((InetSocketAddress)clientAddress), kafkaBrokerMessage);
    }

    public static BrokerMessage toBrokerMessage(String topic, int partition, String clientId, byte[] clientAddress, KafkaBrokerMessage kafkaBrokerMessage) {
        BrokerMessage brokerMessage = new BrokerMessage();
        brokerMessage.setTopic(topic);
        brokerMessage.setApp(clientId);
        brokerMessage.setPartition((short)partition);
        brokerMessage.setCompressed(false);
        brokerMessage.setClientIp(clientAddress);
        brokerMessage.setBusinessId(kafkaBrokerMessage.getKey() == null ? null : new String(kafkaBrokerMessage.getKey(), Charsets.UTF_8));
        brokerMessage.setBody(kafkaBrokerMessage.getValue());
        brokerMessage.setStartTime(SystemClock.now());
        brokerMessage.setSource(SourceType.KAFKA.getValue());
        brokerMessage.setBatch(kafkaBrokerMessage.isBatch());
        brokerMessage.setFlag(kafkaBrokerMessage.getFlag());
        KafkaMessageSerializer.writeExtension(brokerMessage, kafkaBrokerMessage);
        return brokerMessage;
    }
}

