/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.manage.support;

import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupJoinGroupResult;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.broker.kafka.manage.KafkaGroupManageService;

public class DefaultKafkaGroupManageService
implements KafkaGroupManageService {
    private GroupCoordinator groupCoordinator;

    public DefaultKafkaGroupManageService(GroupCoordinator groupCoordinator) {
        this.groupCoordinator = groupCoordinator;
    }

    @Override
    public boolean removeGroup(String groupId) {
        GroupMetadata group = this.groupCoordinator.getGroup(groupId);
        if (group == null) {
            return false;
        }
        group.reset();
        return true;
    }

    @Override
    public boolean rebalanceGroup(String groupId) {
        GroupMetadata group = this.groupCoordinator.getGroup(groupId);
        if (group == null) {
            return false;
        }
        group.reset();
        for (GroupMemberMetadata groupMemberMetadata : group.getAllMembers()) {
            if (groupMemberMetadata.getAwaitingJoinCallback() != null) {
                groupMemberMetadata.getAwaitingJoinCallback().sendResponseCallback(GroupJoinGroupResult.buildError(groupMemberMetadata.getId(), KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode()));
                groupMemberMetadata.setAwaitingJoinCallback(null);
            }
            if (groupMemberMetadata.getAwaitingSyncCallback() == null) continue;
            groupMemberMetadata.getAwaitingSyncCallback().sendResponseCallback(null, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode());
            groupMemberMetadata.setAwaitingSyncCallback(null);
        }
        return true;
    }
}

