/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.command.HeartbeatRequest;
import org.joyqueue.broker.kafka.command.HeartbeatResponse;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(HeartbeatRequestHandler.class);
    private GroupCoordinator groupCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        HeartbeatRequest heartbeatRequestRequest = (HeartbeatRequest)command.getPayload();
        short errorCode = this.groupCoordinator.handleHeartbeat(heartbeatRequestRequest.getGroupId(), heartbeatRequestRequest.getMemberId(), heartbeatRequestRequest.getGroupGenerationId());
        HeartbeatResponse heartbeatResponse = new HeartbeatResponse(errorCode);
        return new Command((Object)heartbeatResponse);
    }

    public int type() {
        return KafkaCommandType.HEARTBEAT.getCode();
    }
}

