/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import java.util.List;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.command.DescribeGroupsRequest;
import org.joyqueue.broker.kafka.command.DescribeGroupsResponse;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupDescribe;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;

public class DescribeGroupRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    private GroupCoordinator groupCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
    }

    public Command handle(Transport transport, Command command) {
        DescribeGroupsRequest request = (DescribeGroupsRequest)command.getPayload();
        List<String> groupIds = request.getGroupIds();
        List<GroupDescribe> groupDescribes = this.groupCoordinator.handleDescribeGroups(groupIds);
        DescribeGroupsResponse describeGroupsResponse = new DescribeGroupsResponse(groupDescribes);
        return new Command((Object)describeGroupsResponse);
    }

    public int type() {
        return KafkaCommandType.DESCRIBE_GROUP.getCode();
    }
}

