/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.ApiVersionsRequest;
import org.joyqueue.broker.kafka.command.ApiVersionsResponse;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.model.ApiVersion;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiVersionsRequestHandler
extends AbstractKafkaCommandHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ApiVersionsRequestHandler.class);
    private static final List<ApiVersion> APIS;
    private static final ApiVersionsResponse SUPPORTED_RESPONSE;

    public Command handle(Transport transport, Command command) {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)command.getPayload();
        if (logger.isDebugEnabled()) {
            logger.debug("fetch api version, transport: {}, version: {}", (Object)transport.remoteAddress(), (Object)apiVersionsRequest.getVersion());
        }
        if (apiVersionsRequest.getVersion() > KafkaCommandType.API_VERSIONS.getMaxVersion()) {
            return new Command((Object)new ApiVersionsResponse(KafkaErrorCode.UNSUPPORTED_VERSION.getCode(), APIS));
        }
        return new Command((Object)SUPPORTED_RESPONSE);
    }

    public int type() {
        return KafkaCommandType.API_VERSIONS.getCode();
    }

    static {
        LinkedList apis = Lists.newLinkedList();
        for (KafkaCommandType command : KafkaCommandType.values()) {
            if (!command.isExport()) continue;
            apis.add(new ApiVersion(command.getCode(), command.getMinVersion(), command.getMaxVersion()));
        }
        APIS = Collections.unmodifiableList(apis);
        SUPPORTED_RESPONSE = new ApiVersionsResponse(KafkaErrorCode.NONE.getCode(), APIS);
    }
}

