/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.broker.kafka.coordinator.group.callback.JoinCallback;
import org.joyqueue.broker.kafka.coordinator.group.callback.SyncCallback;

public class GroupMemberMetadata
extends org.joyqueue.broker.coordinator.group.domain.GroupMemberMetadata {
    private SyncGroupAssignment assignment;
    private JoinCallback awaitingJoinCallback;
    private SyncCallback awaitingSyncCallback;
    private boolean isLeaving = false;
    private String clientId;
    private int rebalanceTimeoutMs;
    private Map<String, byte[]> supportedProtocols;

    public GroupMemberMetadata(String memberId, String groupId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, Map<String, byte[]> supportedProtocols) {
        this.setId(memberId);
        this.setGroupId(groupId);
        this.setConnectionHost(clientHost);
        this.setSessionTimeout(sessionTimeoutMs);
        this.clientId = clientId;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs <= 0 ? sessionTimeoutMs : rebalanceTimeoutMs;
        this.supportedProtocols = supportedProtocols;
    }

    public int getRebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isLeaving() {
        return this.isLeaving;
    }

    public void setLeaving(boolean isLeaving) {
        this.isLeaving = isLeaving;
    }

    public Map<String, byte[]> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(Map<String, byte[]> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public SyncGroupAssignment getAssignment() {
        return this.assignment;
    }

    public void setAssignment(SyncGroupAssignment assignment) {
        this.assignment = assignment;
    }

    public JoinCallback getAwaitingJoinCallback() {
        return this.awaitingJoinCallback;
    }

    public void setAwaitingJoinCallback(JoinCallback awaitingJoinCallback) {
        this.awaitingJoinCallback = awaitingJoinCallback;
    }

    public void setAwaitingSyncCallback(SyncCallback awaitingSyncCallback) {
        this.awaitingSyncCallback = awaitingSyncCallback;
    }

    public SyncCallback getAwaitingSyncCallback() {
        return this.awaitingSyncCallback;
    }

    public boolean matches(Map<String, byte[]> protocols) {
        if (protocols != null && this.supportedProtocols != null) {
            if (protocols.size() != this.supportedProtocols.size()) {
                return false;
            }
            for (Map.Entry<String, byte[]> protocolsEntry : protocols.entrySet()) {
                byte[] supportedProtocolsvalue;
                byte[] protocolsValue = protocolsEntry.getValue() == null ? null : protocolsEntry.getValue();
                if (Arrays.equals(protocolsValue, supportedProtocolsvalue = this.supportedProtocols.get(protocolsEntry.getKey()) == null ? null : this.supportedProtocols.get(protocolsEntry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    public Set<String> protocols() {
        if (this.supportedProtocols != null && !this.supportedProtocols.isEmpty()) {
            return this.supportedProtocols.keySet();
        }
        return null;
    }

    public byte[] metadata(String protocol) {
        if (this.supportedProtocols != null && !this.supportedProtocols.isEmpty()) {
            Set<String> protocols = this.supportedProtocols.keySet();
            for (String supportProtocol : protocols) {
                if (!supportProtocol.equals(protocol)) continue;
                return this.supportedProtocols.get(supportProtocol);
            }
        }
        throw new IllegalArgumentException("Member does not support protocol");
    }

    public String vote(List<String> candidates) {
        if (CollectionUtils.isNotEmpty(candidates) && MapUtils.isNotEmpty(this.supportedProtocols)) {
            for (Map.Entry<String, byte[]> entry : this.supportedProtocols.entrySet()) {
                if (!candidates.contains(entry.getKey())) continue;
                return entry.getKey();
            }
        }
        throw new IllegalArgumentException("Member does not support any of the candidate protocols");
    }

    public String toString() {
        return String.format("[%s,%s,%s,%s,%d]", this.getId(), this.getGroupId(), this.clientId, this.getConnectionHost(), this.getSessionTimeout());
    }
}

