/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka;

import org.joyqueue.domain.QosLevel;

public enum KafkaAcknowledge {
    ACK_NO(0),
    ACK_RECEIVE(1),
    ACK_FLUSH(-1);

    private int value;

    private KafkaAcknowledge(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static KafkaAcknowledge valueOf(short value) {
        switch (value) {
            case 0: {
                return ACK_NO;
            }
            case 1: {
                return ACK_RECEIVE;
            }
            case -1: {
                return ACK_FLUSH;
            }
        }
        throw new UnsupportedOperationException("unsupported kafkaAcknowledge, value: " + value);
    }

    public static QosLevel convertToQosLevel(KafkaAcknowledge kafkaAcknowledge) {
        switch (kafkaAcknowledge) {
            case ACK_FLUSH: {
                return QosLevel.REPLICATION;
            }
            case ACK_RECEIVE: {
                return QosLevel.RECEIVE;
            }
            case ACK_NO: {
                return QosLevel.ONE_WAY;
            }
        }
        throw new UnsupportedOperationException("unsupported kafkaAcknowledge to acknowledge, value: " + (Object)((Object)kafkaAcknowledge));
    }
}

