/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group.delay;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.coordinator.group.GroupBalanceManager;
import org.joyqueue.broker.kafka.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupJoinGroupResult;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupState;
import org.joyqueue.toolkit.delay.DelayedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedJoin
extends DelayedOperation {
    protected static final Logger logger = LoggerFactory.getLogger(DelayedJoin.class);
    private GroupBalanceManager groupBalanceManager;
    private GroupMetadataManager groupMetadataManager;
    private GroupMetadata group;

    public DelayedJoin(GroupBalanceManager groupBalanceManager, GroupMetadataManager groupMetadataManager, GroupMetadata group, long rebalanceTimeout) {
        super(rebalanceTimeout);
        this.groupBalanceManager = groupBalanceManager;
        this.groupMetadataManager = groupMetadataManager;
        this.group = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryComplete() {
        GroupMetadata groupMetadata = this.group;
        synchronized (groupMetadata) {
            if (this.group.getNotYetRejoinedMembers().isEmpty()) {
                return this.forceComplete();
            }
            return false;
        }
    }

    protected void onExpiration() {
        logger.debug("group {} expire join.", (Object)this.group.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onComplete() {
        GroupMetadata groupMetadata = this.group;
        synchronized (groupMetadata) {
            this.doComplete();
        }
    }

    protected void doComplete() {
        logger.info("group {} delay join", (Object)this.group.getId());
        List<GroupMemberMetadata> failedMembers = this.group.getNotYetRejoinedMembers();
        if (CollectionUtils.isNotEmpty(failedMembers)) {
            for (GroupMemberMetadata memberMetadata : failedMembers) {
                logger.info("group {} complete join, member {} not join.", (Object)this.group.getId(), (Object)memberMetadata.getId());
                this.group.removeMember(memberMetadata.getId());
            }
        }
        if (this.group.isMemberEmpty()) {
            logger.info("group {} generation {} is dead and removed", (Object)this.group.getId(), (Object)this.group.getGenerationId());
            this.group.reset();
            return;
        }
        if (!this.group.stateIs(GroupState.DEAD)) {
            this.group.initNextGeneration();
            logger.info("stabilized group {} generation {}, member count is {}", new Object[]{this.group.getId(), this.group.getGenerationId(), this.group.getAllMemberIds().size()});
            for (GroupMemberMetadata memberMetadata : this.group.getAllMembers()) {
                Map<Object, Object> members = null;
                members = memberMetadata.getId().equals(this.group.getLeaderId()) ? this.group.currentMemberMetadata() : Collections.emptyMap();
                GroupJoinGroupResult groupJoinGroupResult = new GroupJoinGroupResult(members, memberMetadata.getId(), this.group.getGenerationId(), this.group.getProtocol(), this.group.getLeaderId(), KafkaErrorCode.NONE.getCode());
                memberMetadata.getAwaitingJoinCallback().sendResponseCallback(groupJoinGroupResult);
                memberMetadata.setAwaitingJoinCallback(null);
                this.groupBalanceManager.completeAndScheduleNextHeartbeatExpiration(this.group, memberMetadata);
            }
        }
    }
}

