/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.ApiVersionsRequest;
import org.joyqueue.broker.kafka.command.ApiVersionsResponse;
import org.joyqueue.broker.kafka.model.ApiVersion;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class ApiVersionsCodec
implements KafkaPayloadCodec<ApiVersionsResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        if (buffer.isReadable(4)) {
            buffer.skipBytes(4);
        }
        return new ApiVersionsRequest();
    }

    public void encode(ApiVersionsResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort((int)payload.getErrorCode());
        buffer.writeInt(payload.getApis().size());
        for (ApiVersion api : payload.getApis()) {
            buffer.writeShort((int)api.getCode());
            buffer.writeShort((int)api.getMinVersion());
            buffer.writeShort((int)api.getMaxVersion());
        }
        buffer.writeInt(payload.getThrottleTimeMs());
    }

    public int type() {
        return KafkaCommandType.API_VERSIONS.getCode();
    }
}

