/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group.delay;

import org.joyqueue.broker.kafka.coordinator.group.GroupBalanceManager;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.toolkit.delay.DelayedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedHeartbeat
extends DelayedOperation {
    protected static final Logger logger = LoggerFactory.getLogger(DelayedHeartbeat.class);
    private GroupBalanceManager groupBalanceManager;
    private GroupMetadata group;
    private GroupMemberMetadata member;
    private long heartbeatDeadline;

    public DelayedHeartbeat(GroupBalanceManager groupBalanceManager, GroupMetadata group, GroupMemberMetadata member, long heartbeatDeadline, long sessionTimeout) {
        super(sessionTimeout);
        this.groupBalanceManager = groupBalanceManager;
        this.group = group;
        this.member = member;
        this.heartbeatDeadline = heartbeatDeadline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryComplete() {
        GroupMetadata groupMetadata = this.group;
        synchronized (groupMetadata) {
            if (this.groupBalanceManager.shouldKeepMemberAlive(this.member, this.heartbeatDeadline) || this.member.isLeaving()) {
                return this.forceComplete();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExpiration() {
        GroupMetadata groupMetadata = this.group;
        synchronized (groupMetadata) {
            logger.info("group {} Member {} heartbeat expired, join callback = {}, sync callback = {}", new Object[]{this.group.getId(), this.member.getId(), this.member.getAwaitingJoinCallback(), this.member.getAwaitingSyncCallback()});
            if (!this.groupBalanceManager.shouldKeepMemberAlive(this.member, this.heartbeatDeadline)) {
                this.groupBalanceManager.removeMemberAndUpdateGroup(this.group, this.member);
                this.group.addExpiredMember(this.member);
            }
        }
    }

    protected void onComplete() {
    }
}

