/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.AddPartitionsToTxnRequest;
import org.joyqueue.broker.kafka.command.AddPartitionsToTxnResponse;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class AddPartitionsToTxnCodec
implements KafkaPayloadCodec<AddPartitionsToTxnResponse>,
Type {
    public AddPartitionsToTxnRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        String transactionId = Serializer.readString((ByteBuf)buffer, (int)2);
        long producerId = buffer.readLong();
        short producerEpoch = buffer.readShort();
        int topicSize = Math.max(buffer.readInt(), 0);
        HashMap partitions = Maps.newHashMapWithExpectedSize((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = Math.max(buffer.readInt(), 0);
            ArrayList partitionList = Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                partitionList.add(buffer.readInt());
            }
            partitions.put(topic, partitionList);
        }
        AddPartitionsToTxnRequest addPartitionsToTxnRequest = new AddPartitionsToTxnRequest();
        addPartitionsToTxnRequest.setTransactionId(transactionId);
        addPartitionsToTxnRequest.setProducerId(producerId);
        addPartitionsToTxnRequest.setProducerEpoch(producerEpoch);
        addPartitionsToTxnRequest.setPartitions(partitions);
        return addPartitionsToTxnRequest;
    }

    public void encode(AddPartitionsToTxnResponse payload, ByteBuf buffer) throws Exception {
        Map<String, List<PartitionMetadataAndError>> errors = payload.getErrors();
        buffer.writeInt(payload.getThrottleTimeMs());
        buffer.writeInt(errors.size());
        for (Map.Entry<String, List<PartitionMetadataAndError>> entry : errors.entrySet()) {
            Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            buffer.writeInt(entry.getValue().size());
            for (PartitionMetadataAndError partitionMetadataAndError : entry.getValue()) {
                buffer.writeInt(partitionMetadataAndError.getPartition());
                buffer.writeShort((int)partitionMetadataAndError.getError());
            }
        }
    }

    public int type() {
        return KafkaCommandType.ADD_PARTITIONS_TO_TXN.getCode();
    }
}

