/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction.domain;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionOffset;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionPrepare;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionState;
import org.joyqueue.toolkit.time.SystemClock;

public class TransactionMetadata
extends org.joyqueue.broker.coordinator.transaction.domain.TransactionMetadata {
    private String app;
    private int timeout;
    private long producerId;
    private short producerEpoch = 0;
    private short epoch = 0;
    private long createTime;
    private long lastTime;
    private TransactionState state = TransactionState.EMPTY;
    private Set<TransactionPrepare> prepare;
    private Set<TransactionOffset> offsets;

    public TransactionMetadata() {
    }

    public TransactionMetadata(String id) {
        super(id);
    }

    public TransactionMetadata(String id, String app, long producerId, int timeout, long createTime) {
        super(id);
        this.app = app;
        this.timeout = timeout;
        this.producerId = producerId;
        this.createTime = createTime;
        this.lastTime = createTime;
    }

    public void addPrepare(TransactionPrepare transactionPrepare) {
        if (this.prepare == null) {
            this.prepare = Sets.newHashSet();
        }
        this.prepare.add(transactionPrepare);
    }

    public void addPrepare(Set<TransactionPrepare> transactionPrepare) {
        if (this.prepare == null) {
            this.prepare = Sets.newHashSet();
        }
        this.prepare.addAll(transactionPrepare);
    }

    public boolean containsPrepare(String topic, short partition) {
        return this.getPrepare(topic, partition) != null;
    }

    public TransactionPrepare getPrepare(String topic, short partition) {
        if (this.prepare == null) {
            return null;
        }
        for (TransactionPrepare transactionPrepare : this.prepare) {
            if (!transactionPrepare.getTopic().equals(topic) || transactionPrepare.getPartition() != partition) continue;
            return transactionPrepare;
        }
        return null;
    }

    public void clearPrepare() {
        if (this.prepare == null) {
            return;
        }
        this.prepare.clear();
    }

    public void addOffsets(Set<TransactionOffset> offsets) {
        if (this.offsets == null) {
            this.offsets = Sets.newHashSet();
        }
        this.offsets.remove(offsets);
        this.offsets.addAll(offsets);
    }

    public void addOffset(TransactionOffset offset) {
        if (this.offsets == null) {
            this.offsets = Sets.newHashSet();
        }
        this.offsets.remove(offset);
        this.offsets.add(offset);
    }

    public boolean containsOffset(String topic, short partition) {
        return this.getOffest(topic, partition) != null;
    }

    public TransactionOffset getOffest(String topic, short partition) {
        if (this.offsets == null) {
            return null;
        }
        for (TransactionOffset offset : this.offsets) {
            if (!offset.getTopic().equals(topic) || offset.getPartition() != partition) continue;
            return offset;
        }
        return null;
    }

    public void clearOffsets() {
        if (this.offsets == null) {
            return;
        }
        this.offsets.clear();
    }

    public void clear() {
        this.clearPrepare();
        this.clearOffsets();
    }

    public void updateLastTime() {
        this.lastTime = SystemClock.now();
    }

    public void transitionStateTo(TransactionState state) {
        this.state = state;
    }

    public boolean isExpired(long timeout) {
        return this.isExpired(SystemClock.now(), timeout);
    }

    public boolean isExpired(long base, long timeout) {
        return base > this.lastTime + timeout;
    }

    public boolean isExpired() {
        return this.isExpired(this.timeout);
    }

    public void nextProducerEpoch() {
        this.producerEpoch = (short)(this.producerEpoch + 1);
    }

    public void nextEpoch() {
        this.epoch = (short)(this.epoch + 1);
    }

    public boolean isCompleted() {
        return this.state.equals((Object)TransactionState.COMPLETE_ABORT) || this.state.equals((Object)TransactionState.COMPLETE_COMMIT) || this.state.equals((Object)TransactionState.DEAD);
    }

    public boolean isPrepared() {
        return this.state.equals((Object)TransactionState.PREPARE_ABORT) || this.state.equals((Object)TransactionState.PREPARE_COMMIT);
    }

    public String getExtension() {
        return String.format("{timeout: '%s', producerId: '%s', producerEpoch: '%s', createTime: '%s', state: '%s', prepare: '%s'}", new Object[]{this.timeout, this.producerId, this.producerEpoch, this.createTime, this.state, this.prepare});
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public void setProducerId(long producerId) {
        this.producerId = producerId;
    }

    public short getProducerEpoch() {
        return this.producerEpoch;
    }

    public void setProducerEpoch(short producerEpoch) {
        this.producerEpoch = producerEpoch;
    }

    public void setEpoch(short epoch) {
        this.epoch = epoch;
    }

    public short getEpoch() {
        return this.epoch;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void setState(TransactionState state) {
        this.state = state;
    }

    public TransactionState getState() {
        return this.state;
    }

    public void setPrepare(Set<TransactionPrepare> prepare) {
        this.prepare = prepare;
    }

    public Set<TransactionPrepare> getPrepare() {
        return this.prepare;
    }

    public void setOffsets(Set<TransactionOffset> offsets) {
        this.offsets = offsets;
    }

    public Set<TransactionOffset> getOffsets() {
        return this.offsets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TransactionMetadata that = (TransactionMetadata)((Object)o);
        return this.timeout == that.timeout && this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && Objects.equals(this.app, that.app);
    }

    public int hashCode() {
        return Objects.hash(this.app, this.timeout, this.producerId, this.producerEpoch);
    }

    public String toString() {
        return "TransactionMetadata{app='" + this.app + '\'' + ", timeout=" + this.timeout + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", epoch=" + this.epoch + ", createTime=" + this.createTime + ", lastTime=" + this.lastTime + ", state=" + (Object)((Object)this.state) + ", prepare=" + this.prepare + ", offsets=" + this.offsets + '}';
    }
}

