/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.EndTxnRequest;
import org.joyqueue.broker.kafka.command.EndTxnResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class EndTxnCodec
implements KafkaPayloadCodec<EndTxnResponse>,
Type {
    public EndTxnRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        String transactionId = Serializer.readString((ByteBuf)buffer, (int)2);
        long producerId = buffer.readLong();
        short producerEpoch = buffer.readShort();
        boolean transactionResult = buffer.readByte() == 1;
        EndTxnRequest endTxnRequest = new EndTxnRequest();
        endTxnRequest.setTransactionId(transactionId);
        endTxnRequest.setProducerId(producerId);
        endTxnRequest.setProducerEpoch(producerEpoch);
        endTxnRequest.setTransactionResult(transactionResult);
        return endTxnRequest;
    }

    public void encode(EndTxnResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeInt(payload.getThrottleTimeMs());
        buffer.writeShort((int)payload.getCode());
    }

    public int type() {
        return KafkaCommandType.END_TXN.getCode();
    }
}

