/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.message.compressor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.joyqueue.broker.kafka.message.compressor.KafkaCompressionCodec;
import org.joyqueue.broker.kafka.message.compressor.lz4.KafkaLZ4BlockInputStream;
import org.joyqueue.broker.kafka.message.compressor.lz4.KafkaLZ4BlockOutputStream;
import org.joyqueue.broker.kafka.message.exception.UnknownCodecException;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public final class KafkaCompressionCodecFactory {
    public static OutputStream apply(KafkaCompressionCodec codec, OutputStream stream, byte messageMagic) throws IOException {
        switch (codec) {
            case GZIPCompressionCodec: {
                return new GZIPOutputStream(stream);
            }
            case SnappyCompressionCodec: {
                return new SnappyOutputStream(stream);
            }
            case LZ4CompressionCodec: {
                return new KafkaLZ4BlockOutputStream(stream);
            }
        }
        throw new UnknownCodecException(String.format("unknown codec: %s", new Object[]{codec}));
    }

    public static InputStream apply(KafkaCompressionCodec codec, InputStream stream, byte messageMagic) throws IOException {
        switch (codec) {
            case GZIPCompressionCodec: {
                return new GZIPInputStream(stream);
            }
            case SnappyCompressionCodec: {
                return new SnappyInputStream(stream);
            }
            case LZ4CompressionCodec: {
                return new KafkaLZ4BlockInputStream(stream, messageMagic == 0);
            }
        }
        throw new UnknownCodecException(String.format("unknown codec: %s", new Object[]{codec}));
    }
}

