/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group.delay;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.joyqueue.broker.kafka.coordinator.group.GroupBalanceManager;
import org.joyqueue.broker.kafka.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.kafka.coordinator.group.delay.DelayedJoin;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.toolkit.delay.DelayedOperation;
import org.joyqueue.toolkit.delay.DelayedOperationKey;
import org.joyqueue.toolkit.delay.DelayedOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedInitialJoin
extends DelayedJoin {
    private static Logger logger = LoggerFactory.getLogger(DelayedInitialJoin.class);
    private GroupBalanceManager groupBalanceManager;
    private GroupMetadataManager groupMetadataManager;
    private GroupMetadata group;
    private DelayedOperationManager<DelayedJoin> joinPurgatory;
    private long configurationRebalanceDelay;
    private long delayMs;
    private long remainingMs;

    public DelayedInitialJoin(GroupBalanceManager groupBalanceManager, GroupMetadataManager groupMetadataManager, GroupMetadata group, DelayedOperationManager<DelayedJoin> joinPurgatory, long configuredRebalanceDelay, long delayMs, long remainingMs) {
        super(groupBalanceManager, groupMetadataManager, group, delayMs);
        this.groupBalanceManager = groupBalanceManager;
        this.groupMetadataManager = groupMetadataManager;
        this.group = group;
        this.joinPurgatory = joinPurgatory;
        this.delayMs = delayMs;
        this.remainingMs = remainingMs;
        this.configurationRebalanceDelay = configuredRebalanceDelay;
    }

    @Override
    protected boolean tryComplete() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onComplete() {
        logger.info("delayed initial join onComplete, isNewMemberAdded = {}, remainingMs = {}, delayMs = {}, configurationRebalanceDelay = {}", new Object[]{this.group.isNewMemberAdded(), this.remainingMs, this.delayMs, this.configurationRebalanceDelay});
        GroupMetadata groupMetadata = this.group;
        synchronized (groupMetadata) {
            if (this.group.isNewMemberAdded() && this.remainingMs != 0L) {
                this.group.setNewMemberAdded(false);
                long delay = Math.min(this.configurationRebalanceDelay, this.remainingMs);
                long remaining = Math.max(this.remainingMs - this.delayMs, 0L);
                DelayedOperationKey groupKey = new DelayedOperationKey(new Object[]{this.group.getId()});
                HashSet delayedOperationKeys = Sets.newHashSet((Object[])new Object[]{groupKey});
                this.joinPurgatory.tryCompleteElseWatch((DelayedOperation)new DelayedInitialJoin(this.groupBalanceManager, this.groupMetadataManager, this.group, this.joinPurgatory, this.configurationRebalanceDelay, delay, remaining), (Set)delayedOperationKeys);
            } else {
                super.onComplete();
            }
        }
    }
}

