/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.List;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractGeneratorStrategy;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.Definition;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;

public class DefaultGeneratorStrategy
extends AbstractGeneratorStrategy {
    private String targetDirectory;
    private String targetPackage;
    private boolean instanceFields = true;

    @Override
    public final void setInstanceFields(boolean instanceFields) {
        this.instanceFields = instanceFields;
    }

    @Override
    public final boolean getInstanceFields() {
        return this.instanceFields;
    }

    @Override
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public final void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public final void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public String getFileHeader(Definition definition, GeneratorStrategy.Mode mode) {
        return "This file is generated by jOOQ.";
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        if (definition instanceof IdentityDefinition) {
            return "IDENTITY_" + this.getJavaIdentifier(((IdentityDefinition)definition).getColumn().getContainer());
        }
        if (definition instanceof CatalogDefinition && ((CatalogDefinition)definition).isDefaultCatalog()) {
            return "DEFAULT_CATALOG";
        }
        if (definition instanceof SchemaDefinition && ((SchemaDefinition)definition).isDefaultSchema()) {
            return "DEFAULT_SCHEMA";
        }
        return definition.getOutputName().toUpperCase();
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "set" + this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "get" + this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0LC(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        return null;
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        return new ArrayList<String>();
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof CatalogDefinition && ((CatalogDefinition)definition).isDefaultCatalog()) {
            return "DefaultCatalog";
        }
        if (definition instanceof SchemaDefinition && ((SchemaDefinition)definition).isDefaultSchema()) {
            return "DefaultSchema";
        }
        return this.getJavaClassName0(definition, mode);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (definition.getDatabase().getCatalogs().size() > 1) {
            sb.append(".");
            sb.append(this.getJavaIdentifier((Definition)definition.getCatalog()).toLowerCase());
        }
        if (!(definition instanceof CatalogDefinition)) {
            if (definition.getDatabase().getSchemata().size() > 1) {
                sb.append(".");
                sb.append(this.getJavaIdentifier((Definition)definition.getSchema()).toLowerCase());
            }
            if (!(definition instanceof SchemaDefinition)) {
                if (!StringUtils.isBlank((String)this.getSubPackage(definition))) {
                    sb.append(".");
                    sb.append(this.getSubPackage(definition));
                }
                if (mode == GeneratorStrategy.Mode.RECORD) {
                    sb.append(".records");
                } else if (mode == GeneratorStrategy.Mode.POJO) {
                    sb.append(".pojos");
                } else if (mode == GeneratorStrategy.Mode.DAO) {
                    sb.append(".daos");
                } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
                    sb.append(".interfaces");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0LC(definition, mode);
    }

    private String getJavaClassName0LC(Definition definition, GeneratorStrategy.Mode mode) {
        String result = this.getJavaClassName0(definition, mode);
        return result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    private String getJavaClassName0(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.toCamelCase((String)definition.getOutputName().replace(' ', '_').replace('-', '_').replace('.', '_')));
        if (mode == GeneratorStrategy.Mode.RECORD) {
            result.append("Record");
        } else if (mode == GeneratorStrategy.Mode.DAO) {
            result.append("Dao");
        } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
            result.insert(0, "I");
        }
        return result.toString();
    }

    private final String getSubPackage(Definition definition) {
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof UDTDefinition) {
            UDTDefinition udt = (UDTDefinition)definition;
            if (udt.getPackage() == null) {
                return "udt";
            }
            return "packages." + this.getJavaIdentifier((Definition)udt.getPackage()).toLowerCase();
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition routine = (RoutineDefinition)definition;
            if (routine.getPackage() instanceof UDTDefinition) {
                return "udt." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            if (routine.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)routine.getPackage()).toLowerCase();
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof DomainDefinition) {
            return "domains";
        }
        if (definition instanceof ArrayDefinition) {
            return "udt";
        }
        return "";
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return overloadIndex;
    }
}

